/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.inputmethod.keyboard.internal;

import android.content.Context;
import android.content.res.Resources;

import com.android.inputmethod.latin.CollectionUtils;
import com.android.inputmethod.latin.R;

import java.util.HashMap;

/**
 * !!!!! DO NOT EDIT THIS FILE !!!!!
 *
 * This file is generated by tools/maketext. The base template file is
 *   tools/maketext/res/com/android/inputmethod/keyboard/internal/KeyboardTextsSet.tmpl
 *
 * This file must be updated when any text resources in keyboard layout files have been changed.
 * These text resources are referred as "!text/<resource_name>" in keyboard XML definitions,
 * and should be defined in
 *   tools/maketext/res/values-<locale>/donottranslate-more-keys.xml
 *
 * To update this file, please run the following commands.
 *   $ cd $ANDROID_BUILD_TOP
 *   $ mmm packages/inputmethods/LatinIME/tools/maketext
 *   $ maketext -java packages/inputmethods/LatinIME/java/src
 *
 * The updated source file will be generated to the following path (this file).
 *   packages/inputmethods/LatinIME/java/src/com/android/inputmethod/keyboard/internal/
 *   KeyboardTextsSet.java
 */
public final class KeyboardTextsSet {
    // Language to texts map.
    private static final HashMap<String, String[]> sLocaleToTextsMap = CollectionUtils.newHashMap();
    private static final HashMap<String, Integer> sNameToIdsMap = CollectionUtils.newHashMap();

    private String[] mTexts;
    // Resource name to text map.
    private HashMap<String, String> mResourceNameToTextsMap = CollectionUtils.newHashMap();

    public void setLanguage(final String language) {
        mTexts = sLocaleToTextsMap.get(language);
        if (mTexts == null) {
            mTexts = LANGUAGE_DEFAULT;
        }
    }

    public void loadStringResources(Context context) {
        loadStringResourcesInternal(context, RESOURCE_NAMES, R.string.english_ime_name);
    }

    /* package for test */
    void loadStringResourcesInternal(Context context, final String[] resourceNames,
            int referenceId) {
        final Resources res = context.getResources();
        final String packageName = res.getResourcePackageName(referenceId);
        for (final String resName : resourceNames) {
            final int resId = res.getIdentifier(resName, "string", packageName);
            mResourceNameToTextsMap.put(resName, res.getString(resId));
        }
    }

    public String getText(final String name) {
        String text = mResourceNameToTextsMap.get(name);
        if (text != null) {
            return text;
        }
        final Integer id = sNameToIdsMap.get(name);
        if (id == null) throw new RuntimeException("Unknown label: " + name);
        text = (id < mTexts.length) ? mTexts[id] : null;
        return (text == null) ? LANGUAGE_DEFAULT[id] : text;
    }

    private static final String[] RESOURCE_NAMES = {
        // These texts' name should be aligned with the @string/<name> in values/strings.xml.
        // Labels for action.
        "label_go_key",
        // "label_search_key",
        "label_send_key",
        "label_next_key",
        "label_done_key",
        "label_previous_key",
        // Other labels.
        "label_to_alpha_key",
        "label_to_symbol_key",
        "label_to_symbol_with_microphone_key",
        "label_pause_key",
        "label_wait_key",
    };

    private static final String[] NAMES = {
        /*  0 */ "more_keys_for_a",
        /*  1 */ "more_keys_for_e",
        /*  2 */ "more_keys_for_i",
        /*  3 */ "more_keys_for_o",
        /*  4 */ "more_keys_for_u",
        /*  5 */ "more_keys_for_s",
        /*  6 */ "more_keys_for_n",
        /*  7 */ "more_keys_for_c",
        /*  8 */ "more_keys_for_y",
        /*  9 */ "more_keys_for_d",
        /* 10 */ "more_keys_for_r",
        /* 11 */ "more_keys_for_t",
        /* 12 */ "more_keys_for_z",
        /* 13 */ "more_keys_for_k",
        /* 14 */ "more_keys_for_l",
        /* 15 */ "more_keys_for_g",
        /* 16 */ "more_keys_for_v",
        /* 17 */ "more_keys_for_h",
        /* 18 */ "more_keys_for_j",
        /* 19 */ "more_keys_for_w",
        /* 20 */ "keylabel_for_nordic_row1_11",
        /* 21 */ "keylabel_for_nordic_row2_10",
        /* 22 */ "keylabel_for_nordic_row2_11",
        /* 23 */ "more_keys_for_nordic_row2_10",
        /* 24 */ "more_keys_for_nordic_row2_11",
        /* 25 */ "keylabel_for_east_slavic_row1_9",
        /* 26 */ "keylabel_for_east_slavic_row1_12",
        /* 27 */ "keylabel_for_east_slavic_row2_1",
        /* 28 */ "keylabel_for_east_slavic_row2_11",
        /* 29 */ "keylabel_for_east_slavic_row3_5",
        /* 30 */ "more_keys_for_cyrillic_u",
        /* 31 */ "more_keys_for_cyrillic_en",
        /* 32 */ "more_keys_for_cyrillic_ghe",
        /* 33 */ "more_keys_for_east_slavic_row2_1",
        /* 34 */ "more_keys_for_cyrillic_o",
        /* 35 */ "more_keys_for_cyrillic_soft_sign",
        /* 36 */ "keylabel_for_south_slavic_row1_6",
        /* 37 */ "keylabel_for_south_slavic_row2_11",
        /* 38 */ "keylabel_for_south_slavic_row3_1",
        /* 39 */ "keylabel_for_south_slavic_row3_8",
        /* 40 */ "more_keys_for_cyrillic_ie",
        /* 41 */ "more_keys_for_cyrillic_i",
        /* 42 */ "more_keys_for_single_quote",
        /* 43 */ "more_keys_for_double_quote",
        /* 44 */ "more_keys_for_tablet_double_quote",
        /* 45 */ "more_keys_for_currency_dollar",
        /* 46 */ "more_keys_for_currency_euro",
        /* 47 */ "more_keys_for_currency_pound",
        /* 48 */ "more_keys_for_currency_general",
        /* 49 */ "more_keys_for_punctuation",
        /* 50 */ "more_keys_for_star",
        /* 51 */ "more_keys_for_bullet",
        /* 52 */ "more_keys_for_plus",
        /* 53 */ "more_keys_for_left_parenthesis",
        /* 54 */ "more_keys_for_right_parenthesis",
        /* 55 */ "more_keys_for_less_than",
        /* 56 */ "more_keys_for_greater_than",
        /* 57 */ "more_keys_for_arabic_diacritics",
        /* 58 */ "keyhintlabel_for_arabic_diacritics",
        /* 59 */ "keylabel_for_symbols_1",
        /* 60 */ "keylabel_for_symbols_2",
        /* 61 */ "keylabel_for_symbols_3",
        /* 62 */ "keylabel_for_symbols_4",
        /* 63 */ "keylabel_for_symbols_5",
        /* 64 */ "keylabel_for_symbols_6",
        /* 65 */ "keylabel_for_symbols_7",
        /* 66 */ "keylabel_for_symbols_8",
        /* 67 */ "keylabel_for_symbols_9",
        /* 68 */ "keylabel_for_symbols_0",
        /* 69 */ "additional_more_keys_for_symbols_1",
        /* 70 */ "additional_more_keys_for_symbols_2",
        /* 71 */ "additional_more_keys_for_symbols_3",
        /* 72 */ "additional_more_keys_for_symbols_4",
        /* 73 */ "additional_more_keys_for_symbols_5",
        /* 74 */ "additional_more_keys_for_symbols_6",
        /* 75 */ "additional_more_keys_for_symbols_7",
        /* 76 */ "additional_more_keys_for_symbols_8",
        /* 77 */ "additional_more_keys_for_symbols_9",
        /* 78 */ "additional_more_keys_for_symbols_0",
        /* 79 */ "more_keys_for_symbols_1",
        /* 80 */ "more_keys_for_symbols_2",
        /* 81 */ "more_keys_for_symbols_3",
        /* 82 */ "more_keys_for_symbols_4",
        /* 83 */ "more_keys_for_symbols_5",
        /* 84 */ "more_keys_for_symbols_6",
        /* 85 */ "more_keys_for_symbols_7",
        /* 86 */ "more_keys_for_symbols_8",
        /* 87 */ "more_keys_for_symbols_9",
        /* 88 */ "more_keys_for_symbols_0",
        /* 89 */ "keylabel_for_comma",
        /* 90 */ "more_keys_for_comma",
        /* 91 */ "keylabel_for_symbols_question",
        /* 92 */ "keylabel_for_symbols_semicolon",
        /* 93 */ "keylabel_for_symbols_percent",
        /* 94 */ "more_keys_for_symbols_exclamation",
        /* 95 */ "more_keys_for_symbols_question",
        /* 96 */ "more_keys_for_symbols_semicolon",
        /* 97 */ "more_keys_for_symbols_percent",
        /* 98 */ "keylabel_for_tablet_comma",
        /* 99 */ "keyhintlabel_for_tablet_comma",
        /* 100 */ "more_keys_for_tablet_comma",
        /* 101 */ "keyhintlabel_for_tablet_period",
        /* 102 */ "more_keys_for_tablet_period",
        /* 103 */ "keylabel_for_apostrophe",
        /* 104 */ "keyhintlabel_for_apostrophe",
        /* 105 */ "more_keys_for_apostrophe",
        /* 106 */ "more_keys_for_q",
        /* 107 */ "more_keys_for_x",
        /* 108 */ "keylabel_for_q",
        /* 109 */ "keylabel_for_w",
        /* 110 */ "keylabel_for_y",
        /* 111 */ "keylabel_for_x",
        /* 112 */ "keylabel_for_spanish_row2_10",
        /* 113 */ "more_keys_for_am_pm",
        /* 114 */ "settings_as_more_key",
        /* 115 */ "shortcut_as_more_key",
        /* 116 */ "action_next_as_more_key",
        /* 117 */ "action_previous_as_more_key",
        /* 118 */ "label_to_more_symbol_key",
        /* 119 */ "label_to_more_symbol_for_tablet_key",
        /* 120 */ "label_tab_key",
        /* 121 */ "label_to_phone_numeric_key",
        /* 122 */ "label_to_phone_symbols_key",
        /* 123 */ "label_time_am",
        /* 124 */ "label_time_pm",
        /* 125 */ "label_to_symbol_key_pcqwerty",
        /* 126 */ "keylabel_for_popular_domain",
        /* 127 */ "more_keys_for_popular_domain",
        /* 128 */ "more_keys_for_smiley",
    };

    private static final String EMPTY = "";

    /* Default texts */
    private static final String[] LANGUAGE_DEFAULT = {
        /* 0~ */
        EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
        EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
        EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
        EMPTY, EMPTY, EMPTY,
        /* ~41 */
        /* 42 */ "!fixedColumnOrder!4,\u2018,\u2019,\u201A,\u201B",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;,&#x00BB;</string>
        /* 43 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB,\u00BB",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;,&#x00BB;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB,\u00BB,\u2018,\u2019,\u201A,\u201B",
        // U+00A2: "¢" CENT SIGN
        // U+00A3: "£" POUND SIGN
        // U+20AC: "€" EURO SIGN
        // U+00A5: "¥" YEN SIGN
        // U+20B1: "₱" PESO SIGN
        /* 45 */ "\u00A2,\u00A3,\u20AC,\u00A5,\u20B1",
        /* 46 */ "\u00A2,\u00A3,$,\u00A5,\u20B1",
        /* 47 */ "\u00A2,$,\u20AC,\u00A5,\u20B1",
        /* 48 */ "\u00A2,$,\u20AC,\u00A3,\u00A5,\u20B1",
        /* 49 */ "!fixedColumnOrder!8,\",\',#,-,:,!,\\,,?,@,&,\\%,+,;,/,(,)",
        // U+2020: "†" DAGGER
        // U+2021: "‡" DOUBLE DAGGER
        // U+2605: "★" BLACK STAR
        /* 50 */ "\u2020,\u2021,\u2605",
        // U+266A: "♪" EIGHTH NOTE
        // U+2665: "♥" BLACK HEART SUIT
        // U+2660: "♠" BLACK SPADE SUIT
        // U+2666: "♦" BLACK DIAMOND SUIT
        // U+2663: "♣" BLACK CLUB SUIT
        /* 51 */ "\u266A,\u2665,\u2660,\u2666,\u2663",
        // U+00B1: "±" PLUS-MINUS SIGN
        /* 52 */ "\u00B1",
        // The all letters need to be mirrored are found at
        // http://www.unicode.org/Public/6.1.0/ucd/BidiMirroring.txt
        /* 53 */ "!fixedColumnOrder!3,<,{,[",
        /* 54 */ "!fixedColumnOrder!3,>,},]",
        // U+2039: "‹" SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        // U+203A: "›" SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        // U+2264: "≤" LESS-THAN OR EQUAL TO
        // U+2265: "≥" GREATER-THAN EQUAL TO
        // U+00AB: "«" LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+00BB: "»" RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        // The following characters don't need BIDI mirroring.
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        /* 55 */ "!fixedColumnOrder!3,\u2039,\u2264,\u00AB",
        /* 56 */ "!fixedColumnOrder!3,\u203A,\u2265,\u00BB",
        /* 57 */ EMPTY,
        /* 58 */ EMPTY,
        /* 59 */ "1",
        /* 60 */ "2",
        /* 61 */ "3",
        /* 62 */ "4",
        /* 63 */ "5",
        /* 64 */ "6",
        /* 65 */ "7",
        /* 66 */ "8",
        /* 67 */ "9",
        /* 68 */ "0",
        /* 69~ */
        EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY,
        /* ~78 */
        // U+00B9: "¹" SUPERSCRIPT ONE
        // U+00BD: "½" VULGAR FRACTION ONE HALF
        // U+2153: "⅓" VULGAR FRACTION ONE THIRD
        // U+00BC: "¼" VULGAR FRACTION ONE QUARTER
        // U+215B: "⅛" VULGAR FRACTION ONE EIGHTH
        /* 79 */ "\u00B9,\u00BD,\u2153,\u00BC,\u215B",
        // U+00B2: "²" SUPERSCRIPT TWO
        // U+2154: "⅔" VULGAR FRACTION TWO THIRDS
        /* 80 */ "\u00B2,\u2154",
        // U+00B3: "³" SUPERSCRIPT THREE
        // U+00BE: "¾" VULGAR FRACTION THREE QUARTERS
        // U+215C: "⅜" VULGAR FRACTION THREE EIGHTHS
        /* 81 */ "\u00B3,\u00BE,\u215C",
        // U+2074: "⁴" SUPERSCRIPT FOUR
        /* 82 */ "\u2074",
        // U+215D: "⅝" VULGAR FRACTION FIVE EIGHTHS
        /* 83 */ "\u215D",
        /* 84 */ EMPTY,
        // U+215E: "⅞" VULGAR FRACTION SEVEN EIGHTHS
        /* 85 */ "\u215E",
        /* 86 */ EMPTY,
        /* 87 */ EMPTY,
        // U+207F: "ⁿ" SUPERSCRIPT LATIN SMALL LETTER N
        // U+2205: "∅" EMPTY SET
        /* 88 */ "\u207F,\u2205",
        /* 89 */ ",",
        /* 90 */ EMPTY,
        /* 91 */ "?",
        /* 92 */ ";",
        /* 93 */ "%",
        // U+00A1: "¡" INVERTED EXCLAMATION MARK
        /* 94 */ "\u00A1",
        // U+00BF: "¿" INVERTED QUESTION MARK
        /* 95 */ "\u00BF",
        /* 96 */ EMPTY,
        // U+2030: "‰" PER MILLE SIGN
        /* 97 */ "\u2030",
        /* 98 */ ",",
        /* 99 */ "!",
        /* 100 */ "!",
        /* 101 */ "?",
        /* 102 */ "?",
        /* 103 */ "\'",
        /* 104 */ "\"",
        /* 105 */ "\"",
        /* 106 */ EMPTY,
        /* 107 */ EMPTY,
        /* 108 */ "q",
        /* 109 */ "w",
        /* 110 */ "y",
        /* 111 */ "x",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        /* 112 */ "\u00F1",
        /* 113 */ "!fixedColumnOrder!2,!hasLabels!,!text/label_time_am,!text/label_time_pm",
        /* 114 */ "!icon/settings_key|!code/key_settings",
        /* 115 */ "!icon/shortcut_key|!code/key_shortcut",
        /* 116 */ "!hasLabels!,!text/label_next_key|!code/key_action_next",
        /* 117 */ "!hasLabels!,!text/label_previous_key|!code/key_action_previous",
        // Label for "switch to more symbol" modifier key.  Must be short to fit on key!
        /* 118 */ "= \\ <",
        // Label for "switch to more symbol" modifier key on tablets.  Must be short to fit on key!
        /* 119 */ "~ \\ {",
        // Label for "Tab" key.  Must be short to fit on key!
        /* 120 */ "Tab",
        // Label for "switch to phone numeric" key.  Must be short to fit on key!
        /* 121 */ "123",
        // Label for "switch to phone symbols" key.  Must be short to fit on key!
        // U+FF0A: "＊" FULLWIDTH ASTERISK
        // U+FF03: "＃" FULLWIDTH NUMBER SIGN
        /* 122 */ "\uFF0A\uFF03",
        // Key label for "ante meridiem"
        /* 123 */ "AM",
        // Key label for "post meridiem"
        /* 124 */ "PM",
        // Label for "switch to symbols" key on PC QWERTY layout
        /* 125 */ "Sym",
        /* 126 */ ".com",
        // popular web domains for the locale - most popular, displayed on the keyboard
        /* 127 */ "!hasLabels!,.net,.org,.gov,.edu",
        /* 128 */ "!fixedColumnOrder!5,!hasLabels!,=-O|=-O ,:-P|:-P ,;-)|;-) ,:-(|:-( ,:-)|:-) ,:-!|:-! ,:-$|:-$ ,B-)|B-) ,:O|:O ,:-*|:-* ,:-D|:-D ,:\'(|:\'( ,:-\\\\|:-\\\\ ,O:-)|O:-) ,:-[|:-[ ",
    };

    /* Language af: Afrikaans */
    private static final String[] LANGUAGE_af = {
        // This is the same as Dutch except more keys of y and demoting vowels with diaeresis.
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E2,\u00E4,\u00E0,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 2 */ "\u00ED,\u00EC,\u00EF,\u00EE,\u012F,\u012B,\u0133",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F4,\u00F6,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FB,\u00FC,\u00F9,\u016B",
        /* 5 */ null,
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        /* 7 */ null,
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 8 */ "\u00FD,\u0133",
    };

    /* Language ar: Arabic */
    private static final String[] LANGUAGE_ar = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~42 */
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_double_quote">&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB;|&#x00AB;</string>
        /* 43 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB|\u00BB,\u00BB|\u00AB",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB|&#x00AB;;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB|\u00BB,\u00BB|\u00AB,\u2018,\u2019,\u201A,\u201B",
        /* 45~ */
        null, null, null, null,
        /* ~48 */
        // U+061F: "؟" ARABIC QUESTION MARK
        // U+060C: "،" ARABIC COMMA
        // U+061B: "؛" ARABIC SEMICOLON
        /* 49 */ "!fixedColumnOrder!8,\",\',#,-,:,!,\u060C,\u061F,@,&,\\%,+,\u061B,/,(,)",
        // U+2605: "★" BLACK STAR
        // U+066D: "٭" ARABIC FIVE POINTED STAR
        /* 50 */ "\u2605,\u066D",
        // U+266A: "♪" EIGHTH NOTE
        /* 51 */ "\u266A",
        /* 52 */ null,
        // The all letters need to be mirrored are found at
        // http://www.unicode.org/Public/6.1.0/ucd/BidiMirroring.txt
        // U+FD3E: "﴾" ORNATE LEFT PARENTHESIS
        // U+FD3F: "﴿" ORNATE RIGHT PARENTHESIS
        /* 53 */ "!fixedColumnOrder!4,\uFD3E|\uFD3F,<|>,{|},[|]",
        /* 54 */ "!fixedColumnOrder!4,\uFD3F|\uFD3E,>|<,}|{,]|[",
        // U+2264: "≤" LESS-THAN OR EQUAL TO
        // U+2265: "≥" GREATER-THAN EQUAL TO
        // U+00AB: "«" LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+00BB: "»" RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+2039: "‹" SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        // U+203A: "›" SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        // The following characters don't need BIDI mirroring.
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        /* 55 */ "!fixedColumnOrder!3,\u2039|\u203A,\u2264|\u2265,\u00AB|\u00BB",
        /* 56 */ "!fixedColumnOrder!3,\u203A|\u2039,\u2265|\u2264,\u00BB|\u00AB",
        // U+0655: "ٕ" ARABIC HAMZA BELOW
        // U+0654: "ٔ" ARABIC HAMZA ABOVE
        // U+0652: "ْ" ARABIC SUKUN
        // U+064D: "ٍ" ARABIC KASRATAN
        // U+064C: "ٌ" ARABIC DAMMATAN
        // U+064B: "ً" ARABIC FATHATAN
        // U+0651: "ّ" ARABIC SHADDA
        // U+0656: "ٖ" ARABIC SUBSCRIPT ALEF
        // U+0670: "ٰ" ARABIC LETTER SUPERSCRIPT ALEF
        // U+0653: "ٓ" ARABIC MADDAH ABOVE
        // U+0650: "ِ" ARABIC KASRA
        // U+064F: "ُ" ARABIC DAMMA
        // U+064E: "َ" ARABIC FATHA
        // U+0640: "ـ" ARABIC TATWEEL
        // In order to make Tatweel easily distinguishable from other punctuations, we use consecutive Tatweels only for its displayed label.
        /* 57 */ "!fixedColumnOrder!7,\u0655,\u0654,\u0652,\u064D,\u064C,\u064B,\u0651,\u0656,\u0670,\u0653,\u0650,\u064F,\u064E,\u0640\u0640\u0640|\u0640",
        /* 58 */ "\u0651",
        // U+0661: "١" ARABIC-INDIC DIGIT ONE
        /* 59 */ "\u0661",
        // U+0662: "٢" ARABIC-INDIC DIGIT TWO
        /* 60 */ "\u0662",
        // U+0663: "٣" ARABIC-INDIC DIGIT THREE
        /* 61 */ "\u0663",
        // U+0664: "٤" ARABIC-INDIC DIGIT FOUR
        /* 62 */ "\u0664",
        // U+0665: "٥" ARABIC-INDIC DIGIT FIVE
        /* 63 */ "\u0665",
        // U+0666: "٦" ARABIC-INDIC DIGIT SIX
        /* 64 */ "\u0666",
        // U+0667: "٧" ARABIC-INDIC DIGIT SEVEN
        /* 65 */ "\u0667",
        // U+0668: "٨" ARABIC-INDIC DIGIT EIGHT
        /* 66 */ "\u0668",
        // U+0669: "٩" ARABIC-INDIC DIGIT NINE
        /* 67 */ "\u0669",
        // U+0660: "٠" ARABIC-INDIC DIGIT ZERO
        /* 68 */ "\u0660",
        /* 69 */ "1",
        /* 70 */ "2",
        /* 71 */ "3",
        /* 72 */ "4",
        /* 73 */ "5",
        /* 74 */ "6",
        /* 75 */ "7",
        /* 76 */ "8",
        /* 77 */ "9",
        // U+066B: "٫" ARABIC DECIMAL SEPARATOR
        // U+066C: "٬" ARABIC THOUSANDS SEPARATOR
        /* 78 */ "0,\u066B,\u066C",
        /* 79~ */
        null, null, null, null, null, null, null, null, null, null,
        /* ~88 */
        // U+060C: "،" ARABIC COMMA
        /* 89 */ "\u060C",
        /* 90 */ "\\,",
        /* 91 */ "\u061F",
        /* 92 */ "\u061B",
        // U+066A: "٪" ARABIC PERCENT SIGN
        /* 93 */ "\u066A",
        /* 94 */ null,
        /* 95 */ "?",
        /* 96 */ ";",
        // U+2030: "‰" PER MILLE SIGN
        /* 97 */ "\\%,\u2030",
        /* 98~ */
        null, null, null, null, null,
        /* ~102 */
        // U+060C: "،" ARABIC COMMA
        // U+061B: "؛" ARABIC SEMICOLON
        // U+061F: "؟" ARABIC QUESTION MARK
        /* 103 */ "\u060C",
        /* 104 */ "\u061F",
        /* 105 */ "\u061F,\u061B,!,:,-,/,\',\"",
    };

    /* Language be: Belarusian */
    private static final String[] LANGUAGE_be = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null,
        /* ~24 */
        // U+045E: "ў" CYRILLIC SMALL LETTER SHORT U
        /* 25 */ "\u045E",
        // U+0451: "ё" CYRILLIC SMALL LETTER IO
        /* 26 */ "\u0451",
        // U+044B: "ы" CYRILLIC SMALL LETTER YERU
        /* 27 */ "\u044B",
        // U+044D: "э" CYRILLIC SMALL LETTER E
        /* 28 */ "\u044D",
        // U+0456: "і" CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
        /* 29 */ "\u0456",
        /* 30~ */
        null, null, null, null, null,
        /* ~34 */
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 35 */ "\u044A",
        /* 36~ */
        null, null, null, null,
        /* ~39 */
        // U+0451: "ё" CYRILLIC SMALL LETTER IO
        /* 40 */ "\u0451",
    };

    /* Language ca: Catalan */
    private static final String[] LANGUAGE_ca = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E0,\u00E1,\u00E4,\u00E2,\u00E3,\u00E5,\u0105,\u00E6,\u0101,\u00AA",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E8,\u00E9,\u00EB,\u00EA,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EF,\u00EC,\u00EE,\u012F,\u012B",
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F2,\u00F3,\u00F6,\u00F4,\u00F5,\u00F8,\u0153,\u014D,\u00BA",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00F9,\u00FB,\u016B",
        /* 5 */ null,
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u010D",
        /* 8~ */
        null, null, null, null, null, null,
        /* ~13 */
        // U+0140: "ŀ" LATIN SMALL LETTER L WITH MIDDLE DOT
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u0140,\u0142",
    };

    /* Language cs: Czech */
    private static final String[] LANGUAGE_cs = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E0,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u011B,\u00E8,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EE,\u00EF,\u00EC,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F6,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u016F,\u00FB,\u00FC,\u00F9,\u016B",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        /* 5 */ "\u0161,\u00DF,\u015B",
        // U+0148: "ň" LATIN SMALL LETTER N WITH CARON
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u0148,\u00F1,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u00E7,\u0107",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        /* 9 */ "\u010F",
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        /* 10 */ "\u0159",
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        /* 11 */ "\u0165",
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        /* 12 */ "\u017E,\u017A,\u017C",
    };

    /* Language da: Danish */
    private static final String[] LANGUAGE_da = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E4,\u00E0,\u00E2,\u00E3,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        /* 1 */ "\u00E9,\u00EB",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        /* 2 */ "\u00ED,\u00EF",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F4,\u00F2,\u00F5,\u0153,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00FB,\u00F9,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u00DF,\u015B,\u0161",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        /* 7 */ null,
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+00F0: "ð" LATIN SMALL LETTER ETH
        /* 9 */ "\u00F0",
        /* 10~ */
        null, null, null, null,
        /* ~13 */
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u0142",
        /* 15~ */
        null, null, null, null, null,
        /* ~19 */
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        /* 20 */ "\u00E5",
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 21 */ "\u00E6",
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 22 */ "\u00F8",
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        /* 23 */ "\u00E4",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        /* 24 */ "\u00F6",
    };

    /* Language de: German */
    private static final String[] LANGUAGE_de = {
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E4,\u00E2,\u00E0,\u00E1,\u00E6,\u00E3,\u00E5,\u0101",
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        /* 1 */ "\u0117",
        /* 2 */ null,
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F6,\u00F4,\u00F2,\u00F3,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FC,\u00FB,\u00F9,\u00FA,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u00DF,\u015B,\u0161",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
    };

    /* Language en: English */
    private static final String[] LANGUAGE_en = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E0,\u00E1,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E8,\u00E9,\u00EA,\u00EB,\u0113",
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        /* 2 */ "\u00EE,\u00EF,\u00ED,\u012B,\u00EC",
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        /* 3 */ "\u00F4,\u00F6,\u00F2,\u00F3,\u0153,\u00F8,\u014D,\u00F5",
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FB,\u00FC,\u00F9,\u00FA,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        /* 5 */ "\u00DF",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        /* 6 */ "\u00F1",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        /* 7 */ "\u00E7",
    };

    /* Language eo: Esperanto */
    private static final String[] LANGUAGE_eo = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+0103: "ă" LATIN SMALL LETTER A WITH BREVE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E1,\u00E0,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101,\u0103,\u0105,\u00AA",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u011B,\u00E8,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0129: "ĩ" LATIN SMALL LETTER I WITH TILDE
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 2 */ "\u00ED,\u00EE,\u00EF,\u0129,\u00EC,\u012F,\u012B,\u0131,\u0133",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F3,\u00F6,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D,\u0151,\u00BA",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+0169: "ũ" LATIN SMALL LETTER U WITH TILDE
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        // U+00B5: "µ" MICRO SIGN
        /* 4 */ "\u00FA,\u016F,\u00FB,\u00FC,\u00F9,\u016B,\u0169,\u0171,\u0173,\u00B5",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0219: "ș" LATIN SMALL LETTER S WITH COMMA BELOW
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        /* 5 */ "\u00DF,\u0161,\u015B,\u0219,\u015F",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+0148: "ň" LATIN SMALL LETTER N WITH CARON
        // U+0149: "ŉ" LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
        // U+014B: "ŋ" LATIN SMALL LETTER ENG
        /* 6 */ "\u00F1,\u0144,\u0146,\u0148,\u0149,\u014B",
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+010B: "ċ" LATIN SMALL LETTER C WITH DOT ABOVE
        /* 7 */ "\u0107,\u010D,\u00E7,\u010B",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+0177: "ŷ" LATIN SMALL LETTER Y WITH CIRCUMFLEX
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        // U+00FE: "þ" LATIN SMALL LETTER THORN
        /* 8 */ "y,\u00FD,\u0177,\u00FF,\u00FE",
        // U+00F0: "ð" LATIN SMALL LETTER ETH
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        // U+0111: "đ" LATIN SMALL LETTER D WITH STROKE
        /* 9 */ "\u00F0,\u010F,\u0111",
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        /* 10 */ "\u0159,\u0155,\u0157",
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        // U+021B: "ț" LATIN SMALL LETTER T WITH COMMA BELOW
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        // U+0167: "ŧ" LATIN SMALL LETTER T WITH STROKE
        /* 11 */ "\u0165,\u021B,\u0163,\u0167",
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        /* 12 */ "\u017A,\u017C,\u017E",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        // U+0138: "ĸ" LATIN SMALL LETTER KRA
        /* 13 */ "\u0137,\u0138",
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        // U+0140: "ŀ" LATIN SMALL LETTER L WITH MIDDLE DOT
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u013A,\u013C,\u013E,\u0140,\u0142",
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        // U+0121: "ġ" LATIN SMALL LETTER G WITH DOT ABOVE
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        /* 15 */ "\u011F,\u0121,\u0123",
        // U+0175: "ŵ" LATIN SMALL LETTER W WITH CIRCUMFLEX
        /* 16 */ "w,\u0175",
        // U+0125: "ĥ" LATIN SMALL LETTER H WITH CIRCUMFLEX
        // U+0127: "ħ" LATIN SMALL LETTER H WITH STROKE
        /* 17 */ "\u0125,\u0127",
        /* 18 */ null,
        // U+0175: "ŵ" LATIN SMALL LETTER W WITH CIRCUMFLEX
        /* 19 */ "w,\u0175",
        /* 20~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null,
        /* ~105 */
        /* 106 */ "q",
        /* 107 */ "x",
        // U+015D: "ŝ" LATIN SMALL LETTER S WITH CIRCUMFLEX
        /* 108 */ "\u015D",
        // U+011D: "ĝ" LATIN SMALL LETTER G WITH CIRCUMFLEX
        /* 109 */ "\u011D",
        // U+016D: "ŭ" LATIN SMALL LETTER U WITH BREVE
        /* 110 */ "\u016D",
        // U+0109: "ĉ" LATIN SMALL LETTER C WITH CIRCUMFLEX
        /* 111 */ "\u0109",
        // U+0135: "ĵ" LATIN SMALL LETTER J WITH CIRCUMFLEX
        /* 112 */ "\u0135",
    };

    /* Language es: Spanish */
    private static final String[] LANGUAGE_es = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E1,\u00E0,\u00E4,\u00E2,\u00E3,\u00E5,\u0105,\u00E6,\u0101,\u00AA",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EB,\u00EA,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EF,\u00EC,\u00EE,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F3,\u00F2,\u00F6,\u00F4,\u00F5,\u00F8,\u0153,\u014D,\u00BA",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00F9,\u00FB,\u016B",
        /* 5 */ null,
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u010D",
        /* 8~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null,
        /* ~48 */
        // U+00A1: "¡" INVERTED EXCLAMATION MARK
        // U+00BF: "¿" INVERTED QUESTION MARK
        /* 49 */ "!fixedColumnOrder!9,\u00A1,\",\',#,-,:,!,\\,,?,\u00BF,@,&,\\%,+,;,/,(,)",
        /* 50~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null,
        /* ~99 */
        // U+00A1: "¡" INVERTED EXCLAMATION MARK
        /* 100 */ "!,\u00A1",
        /* 101 */ null,
        // U+00BF: "¿" INVERTED QUESTION MARK
        /* 102 */ "?,\u00BF",
    };

    /* Language et: Estonian */
    private static final String[] LANGUAGE_et = {
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        /* 0 */ "\u00E4,\u0101,\u00E0,\u00E1,\u00E2,\u00E3,\u00E5,\u00E6,\u0105",
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        /* 1 */ "\u0113,\u00E8,\u0117,\u00E9,\u00EA,\u00EB,\u0119,\u011B",
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        /* 2 */ "\u012B,\u00EC,\u012F,\u00ED,\u00EE,\u00EF,\u0131",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 3 */ "\u00F6,\u00F5,\u00F2,\u00F3,\u00F4,\u0153,\u0151,\u00F8",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        /* 4 */ "\u00FC,\u016B,\u0173,\u00F9,\u00FA,\u00FB,\u016F,\u0171",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        /* 5 */ "\u0161,\u00DF,\u015B,\u015F",
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u0146,\u00F1,\u0144,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u00E7,\u0107",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        /* 9 */ "\u010F",
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        /* 10 */ "\u0157,\u0159,\u0155",
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        /* 11 */ "\u0163,\u0165",
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        /* 12 */ "\u017E,\u017C,\u017A",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        /* 13 */ "\u0137",
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        /* 14 */ "\u013C,\u0142,\u013A,\u013E",
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        /* 15 */ "\u0123,\u011F",
        /* 16~ */
        null, null, null, null,
        /* ~19 */
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        /* 20 */ "\u00FC",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        /* 21 */ "\u00F6",
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        /* 22 */ "\u00E4",
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        /* 23 */ "\u00F5",
    };

    /* Language fa: Persian */
    private static final String[] LANGUAGE_fa = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~42 */
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_double_quote">&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB;|&#x00AB;</string>
        /* 43 */ "!fixedColumnOrder!4,\u201C,\u201D,\",\'",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB|&#x00AB;;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB|\u00BB,\u00BB|\u00AB,\u2018,\u2019,\u201A,\u201B",
        /* 45~ */
        null, null, null, null,
        /* ~48 */
        // U+061F: "؟" ARABIC QUESTION MARK
        // U+060C: "،" ARABIC COMMA
        // U+061B: "؛" ARABIC SEMICOLON
        /* 49 */ "!fixedColumnOrder!8,\",\',#,-,:,!,\u060C,\u061F,@,&,\\%,+,\u061B,/,(,)",
        // U+2605: "★" BLACK STAR
        // U+066D: "٭" ARABIC FIVE POINTED STAR
        /* 50 */ "\u2605,\u066D",
        // U+266A: "♪" EIGHTH NOTE
        /* 51 */ "\u266A",
        /* 52 */ null,
        // The all letters need to be mirrored are found at
        // http://www.unicode.org/Public/6.1.0/ucd/BidiMirroring.txt
        // U+FD3E: "﴾" ORNATE LEFT PARENTHESIS
        // U+FD3F: "﴿" ORNATE RIGHT PARENTHESIS
        /* 53 */ "!fixedColumnOrder!4,\uFD3E|\uFD3F,<|>,{|},[|]",
        /* 54 */ "!fixedColumnOrder!4,\uFD3F|\uFD3E,>|<,}|{,]|[",
        // U+2264: "≤" LESS-THAN OR EQUAL TO
        // U+2265: "≥" GREATER-THAN EQUAL TO
        // U+00AB: "«" LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+00BB: "»" RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+2039: "‹" SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        // U+203A: "›" SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        // The following characters don't need BIDI mirroring.
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        /* 55 */ "!fixedColumnOrder!3,\u2039|\u203A,\u2264|\u2265,<|>",
        /* 56 */ "!fixedColumnOrder!3,\u203A|\u2039,\u2265|\u2264,>|<",
        // U+0655: "ٕ" ARABIC HAMZA BELOW
        // U+0652: "ْ" ARABIC SUKUN
        // U+0651: "ّ" ARABIC SHADDA
        // U+064C: "ٌ" ARABIC DAMMATAN
        // U+064D: "ٍ" ARABIC KASRATAN
        // U+064B: "ً" ARABIC FATHATAN
        // U+0654: "ٔ" ARABIC HAMZA ABOVE
        // U+0656: "ٖ" ARABIC SUBSCRIPT ALEF
        // U+0670: "ٰ" ARABIC LETTER SUPERSCRIPT ALEF
        // U+0653: "ٓ" ARABIC MADDAH ABOVE
        // U+064F: "ُ" ARABIC DAMMA
        // U+0650: "ِ" ARABIC KASRA
        // U+064E: "َ" ARABIC FATHA
        // U+0640: "ـ" ARABIC TATWEEL
        // In order to make Tatweel easily distinguishable from other punctuations, we use consecutive Tatweels only for its displayed label.
        /* 57 */ "!fixedColumnOrder!7,\u0655,\u0652,\u0651,\u064C,\u064D,\u064B,\u0654,\u0656,\u0670,\u0653,\u064F,\u0650,\u064E,\u0640\u0640\u0640|\u0640",
        /* 58 */ "\u064B",
        // U+06F1: "۱" EXTENDED ARABIC-INDIC DIGIT ONE
        /* 59 */ "\u06F1",
        // U+06F2: "۲" EXTENDED ARABIC-INDIC DIGIT TWO
        /* 60 */ "\u06F2",
        // U+06F3: "۳" EXTENDED ARABIC-INDIC DIGIT THREE
        /* 61 */ "\u06F3",
        // U+06F4: "۴" EXTENDED ARABIC-INDIC DIGIT FOUR
        /* 62 */ "\u06F4",
        // U+06F5: "۵" EXTENDED ARABIC-INDIC DIGIT FIVE
        /* 63 */ "\u06F5",
        // U+06F6: "۶" EXTENDED ARABIC-INDIC DIGIT SIX
        /* 64 */ "\u06F6",
        // U+06F7: "۷" EXTENDED ARABIC-INDIC DIGIT SEVEN
        /* 65 */ "\u06F7",
        // U+06F8: "۸" EXTENDED ARABIC-INDIC DIGIT EIGHT
        /* 66 */ "\u06F8",
        // U+06F9: "۹" EXTENDED ARABIC-INDIC DIGIT NINE
        /* 67 */ "\u06F9",
        // U+06F0: "۰" EXTENDED ARABIC-INDIC DIGIT ZERO
        /* 68 */ "\u06F0",
        /* 69 */ "1",
        /* 70 */ "2",
        /* 71 */ "3",
        /* 72 */ "4",
        /* 73 */ "5",
        /* 74 */ "6",
        /* 75 */ "7",
        /* 76 */ "8",
        /* 77 */ "9",
        // U+066B: "٫" ARABIC DECIMAL SEPARATOR
        // U+066C: "٬" ARABIC THOUSANDS SEPARATOR
        /* 78 */ "0,\u066B,\u066C",
        /* 79~ */
        null, null, null, null, null, null, null, null, null, null,
        /* ~88 */
        // U+060C: "،" ARABIC COMMA
        /* 89 */ "\u060C",
        /* 90 */ "\\,",
        /* 91 */ "\u061F",
        /* 92 */ "\u061B",
        // U+066A: "٪" ARABIC PERCENT SIGN
        /* 93 */ "\u066A",
        /* 94 */ null,
        /* 95 */ "?",
        /* 96 */ ";",
        // U+2030: "‰" PER MILLE SIGN
        /* 97 */ "\\%,\u2030",
        // U+060C: "،" ARABIC COMMA
        // U+061B: "؛" ARABIC SEMICOLON
        // U+061F: "؟" ARABIC QUESTION MARK
        // U+00AB: "«" LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+00BB: "»" RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        /* 98 */ "\u060C",
        /* 99 */ "!",
        /* 100 */ "!,\\,",
        /* 101 */ "\u061F",
        /* 102 */ "\u061F,?",
        /* 103 */ "\u060C",
        /* 104 */ "\u061F",
        /* 105 */ "!fixedColumnOrder!4,:,!,\u061F,\u061B,-,/,\u00AB|\u00BB,\u00BB|\u00AB",
    };

    /* Language fi: Finnish */
    private static final String[] LANGUAGE_fi = {
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E6,\u00E0,\u00E1,\u00E2,\u00E3,\u0101",
        /* 1 */ null,
        /* 2 */ null,
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F8,\u00F4,\u00F2,\u00F3,\u00F5,\u0153,\u014D",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        /* 4 */ "\u00FC",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        /* 5 */ "\u0161,\u00DF,\u015B",
        /* 6~ */
        null, null, null, null, null, null,
        /* ~11 */
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        /* 12 */ "\u017E,\u017A,\u017C",
        /* 13~ */
        null, null, null, null, null, null, null,
        /* ~19 */
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        /* 20 */ "\u00E5",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        /* 21 */ "\u00F6",
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        /* 22 */ "\u00E4",
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 23 */ "\u00F8",
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 24 */ "\u00E6",
    };

    /* Language fr: French */
    private static final String[] LANGUAGE_fr = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E0,\u00E2,%,\u00E6,\u00E1,\u00E4,\u00E3,\u00E5,\u0101,\u00AA",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EA,\u00EB,%,\u0119,\u0117,\u0113",
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00EE,%,\u00EF,\u00EC,\u00ED,\u012F,\u012B",
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F4,\u0153,%,\u00F6,\u00F2,\u00F3,\u00F5,\u00F8,\u014D,\u00BA",
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00F9,\u00FB,%,\u00FC,\u00FA,\u016B",
        /* 5 */ null,
        /* 6 */ null,
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u010D",
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "%,\u00FF",
    };

    /* Language hi: Hindi */
    private static final String[] LANGUAGE_hi = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~58 */
        // U+0967: "१" DEVANAGARI DIGIT ONE
        /* 59 */ "\u0967",
        // U+0968: "२" DEVANAGARI DIGIT TWO
        /* 60 */ "\u0968",
        // U+0969: "३" DEVANAGARI DIGIT THREE
        /* 61 */ "\u0969",
        // U+096A: "४" DEVANAGARI DIGIT FOUR
        /* 62 */ "\u096A",
        // U+096B: "५" DEVANAGARI DIGIT FIVE
        /* 63 */ "\u096B",
        // U+096C: "६" DEVANAGARI DIGIT SIX
        /* 64 */ "\u096C",
        // U+096D: "७" DEVANAGARI DIGIT SEVEN
        /* 65 */ "\u096D",
        // U+096E: "८" DEVANAGARI DIGIT EIGHT
        /* 66 */ "\u096E",
        // U+096F: "९" DEVANAGARI DIGIT NINE
        /* 67 */ "\u096F",
        // U+0966: "०" DEVANAGARI DIGIT ZERO
        /* 68 */ "\u0966",
        /* 69 */ "1",
        /* 70 */ "2",
        /* 71 */ "3",
        /* 72 */ "4",
        /* 73 */ "5",
        /* 74 */ "6",
        /* 75 */ "7",
        /* 76 */ "8",
        /* 77 */ "9",
        /* 78 */ "0",
    };

    /* Language hr: Croatian */
    private static final String[] LANGUAGE_hr = {
        /* 0~ */
        null, null, null, null, null,
        /* ~4 */
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        /* 5 */ "\u0161,\u015B,\u00DF",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        /* 7 */ "\u010D,\u0107,\u00E7",
        /* 8 */ null,
        // U+0111: "đ" LATIN SMALL LETTER D WITH STROKE
        /* 9 */ "\u0111",
        /* 10 */ null,
        /* 11 */ null,
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        /* 12 */ "\u017E,\u017A,\u017C",
    };

    /* Language hu: Hungarian */
    private static final String[] LANGUAGE_hu = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E0,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EE,\u00EF,\u00EC,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F6,\u0151,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u0171,\u00FB,\u00F9,\u016B",
    };

    /* Language is: Icelandic */
    private static final String[] LANGUAGE_is = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E4,\u00E6,\u00E5,\u00E0,\u00E2,\u00E3,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00EB,\u00E8,\u00EA,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EF,\u00EE,\u00EC,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F6,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00FB,\u00F9,\u016B",
        /* 5~ */
        null, null, null,
        /* ~7 */
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+00F0: "ð" LATIN SMALL LETTER ETH
        /* 9 */ "\u00F0",
        /* 10 */ null,
        // U+00FE: "þ" LATIN SMALL LETTER THORN
        /* 11 */ "\u00FE",
        /* 12~ */
        null, null, null, null, null, null, null, null,
        /* ~19 */
        // U+00F0: "ð" LATIN SMALL LETTER ETH
        /* 20 */ "\u00F0",
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 21 */ "\u00E6",
        // U+00FE: "þ" LATIN SMALL LETTER THORN
        /* 22 */ "\u00FE",
    };

    /* Language it: Italian */
    private static final String[] LANGUAGE_it = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E0,\u00E1,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101,\u00AA",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E8,\u00E9,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00EC,\u00ED,\u00EE,\u00EF,\u012F,\u012B",
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F2,\u00F3,\u00F4,\u00F6,\u00F5,\u0153,\u00F8,\u014D,\u00BA",
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00F9,\u00FA,\u00FB,\u00FC,\u016B",
    };

    /* Language iw: Hebrew */
    private static final String[] LANGUAGE_iw = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~42 */
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_double_quote">&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB;|&#x00AB;</string>
        /* 43 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB|\u00BB,\u00BB|\u00AB",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;|&#x00BB;,&#x00BB|&#x00AB;;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!4,\u201C,\u201D,\u00AB|\u00BB,\u00BB|\u00AB,\u2018,\u2019,\u201A,\u201B",
        /* 45~ */
        null, null, null, null, null,
        /* ~49 */
        // U+2605: "★" BLACK STAR
        /* 50 */ "\u2605",
        /* 51 */ null,
        // U+00B1: "±" PLUS-MINUS SIGN
        // U+FB29: "﬩" HEBREW LETTER ALTERNATIVE PLUS SIGN
        /* 52 */ "\u00B1,\uFB29",
        // The all letters need to be mirrored are found at
        // http://www.unicode.org/Public/6.1.0/ucd/BidiMirroring.txt
        /* 53 */ "!fixedColumnOrder!3,<|>,{|},[|]",
        /* 54 */ "!fixedColumnOrder!3,>|<,}|{,]|[",
        // U+2264: "≤" LESS-THAN OR EQUAL TO
        // U+2265: "≥" GREATER-THAN EQUAL TO
        // U+00AB: "«" LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+00BB: "»" RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        // U+2039: "‹" SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        // U+203A: "›" SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        // The following characters don't need BIDI mirroring.
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        /* 55 */ "!fixedColumnOrder!3,\u2039|\u203A,\u2264|\u2265,\u00AB|\u00BB",
        /* 56 */ "!fixedColumnOrder!3,\u203A|\u2039,\u2265|\u2264,\u00BB|\u00AB",
    };

    /* Language ky: Kirghiz */
    private static final String[] LANGUAGE_ky = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null,
        /* ~24 */
        // U+0449: "щ" CYRILLIC SMALL LETTER SHCHA
        /* 25 */ "\u0449",
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 26 */ "\u044A",
        // U+044B: "ы" CYRILLIC SMALL LETTER YERU
        /* 27 */ "\u044B",
        // U+044D: "э" CYRILLIC SMALL LETTER E
        /* 28 */ "\u044D",
        // U+0438: "и" CYRILLIC SMALL LETTER I
        /* 29 */ "\u0438",
        // U+04AF: "ү" CYRILLIC SMALL LETTER STRAIGHT U
        /* 30 */ "\u04AF",
        // U+04A3: "ң" CYRILLIC SMALL LETTER EN WITH DESCENDER
        /* 31 */ "\u04A3",
        /* 32 */ null,
        /* 33 */ null,
        // U+04E9: "ө" CYRILLIC SMALL LETTER BARRED O
        /* 34 */ "\u04E9",
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 35 */ "\u044A",
        /* 36~ */
        null, null, null, null,
        /* ~39 */
        // U+0451: "ё" CYRILLIC SMALL LETTER IO
        /* 40 */ "\u0451",
    };

    /* Language lt: Lithuanian */
    private static final String[] LANGUAGE_lt = {
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 0 */ "\u0105,\u00E4,\u0101,\u00E0,\u00E1,\u00E2,\u00E3,\u00E5,\u00E6",
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        /* 1 */ "\u0117,\u0119,\u0113,\u00E8,\u00E9,\u00EA,\u00EB,\u011B",
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        /* 2 */ "\u012F,\u012B,\u00EC,\u00ED,\u00EE,\u00EF,\u0131",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 3 */ "\u00F6,\u00F5,\u00F2,\u00F3,\u00F4,\u0153,\u0151,\u00F8",
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        /* 4 */ "\u016B,\u0173,\u00FC,\u016B,\u00F9,\u00FA,\u00FB,\u016F,\u0171",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        /* 5 */ "\u0161,\u00DF,\u015B,\u015F",
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u0146,\u00F1,\u0144,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u00E7,\u0107",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        /* 9 */ "\u010F",
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        /* 10 */ "\u0157,\u0159,\u0155",
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        /* 11 */ "\u0163,\u0165",
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        /* 12 */ "\u017E,\u017C,\u017A",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        /* 13 */ "\u0137",
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        /* 14 */ "\u013C,\u0142,\u013A,\u013E",
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        /* 15 */ "\u0123,\u011F",
    };

    /* Language lv: Latvian */
    private static final String[] LANGUAGE_lv = {
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        /* 0 */ "\u0101,\u00E0,\u00E1,\u00E2,\u00E3,\u00E4,\u00E5,\u00E6,\u0105",
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        /* 1 */ "\u0113,\u0117,\u00E8,\u00E9,\u00EA,\u00EB,\u0119,\u011B",
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        /* 2 */ "\u012B,\u012F,\u00EC,\u00ED,\u00EE,\u00EF,\u0131",
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 3 */ "\u00F2,\u00F3,\u00F4,\u00F5,\u00F6,\u0153,\u0151,\u00F8",
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        /* 4 */ "\u016B,\u0173,\u00F9,\u00FA,\u00FB,\u00FC,\u016F,\u0171",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        /* 5 */ "\u0161,\u00DF,\u015B,\u015F",
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u0146,\u00F1,\u0144,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u00E7,\u0107",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        /* 9 */ "\u010F",
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        /* 10 */ "\u0157,\u0159,\u0155",
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        /* 11 */ "\u0163,\u0165",
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        /* 12 */ "\u017E,\u017C,\u017A",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        /* 13 */ "\u0137",
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        /* 14 */ "\u013C,\u0142,\u013A,\u013E",
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        /* 15 */ "\u0123,\u011F",
    };

    /* Language mk: Macedonian */
    private static final String[] LANGUAGE_mk = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null,
        /* ~35 */
        // U+0455: "ѕ" CYRILLIC SMALL LETTER DZE
        /* 36 */ "\u0455",
        // U+045C: "ќ" CYRILLIC SMALL LETTER KJE
        /* 37 */ "\u045C",
        // U+0437: "з" CYRILLIC SMALL LETTER ZE
        /* 38 */ "\u0437",
        // U+0453: "ѓ" CYRILLIC SMALL LETTER GJE
        /* 39 */ "\u0453",
        // U+0450: "ѐ" CYRILLIC SMALL LETTER IE WITH GRAVE
        /* 40 */ "\u0450",
        // U+045D: "ѝ" CYRILLIC SMALL LETTER I WITH GRAVE
        /* 41 */ "\u045D",
        /* 42 */ null,
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_double_quote">!fixedColumnOrder!6,&#x201E;,&#x201C;,&#x201D;,&#x201F;,&#x00AB;,&#x00BB;</string>
        /* 43 */ "!fixedColumnOrder!5,\u201E,\u201C,\u201D,\u00AB,\u00BB",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;,&#x00BB;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!5,\u201E,\u201C,\u201D,\u00AB,\u00BB,\u2018,\u2019,\u201A,\u201B",
    };

    /* Language nb: Norwegian Bokmål */
    private static final String[] LANGUAGE_nb = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E0,\u00E4,\u00E1,\u00E2,\u00E3,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EA,\u00EB,\u0119,\u0117,\u0113",
        /* 2 */ null,
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F4,\u00F2,\u00F3,\u00F6,\u00F5,\u0153,\u014D",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FC,\u00FB,\u00F9,\u00FA,\u016B",
        /* 5~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~19 */
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        /* 20 */ "\u00E5",
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 21 */ "\u00F8",
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 22 */ "\u00E6",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        /* 23 */ "\u00F6",
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        /* 24 */ "\u00E4",
    };

    /* Language nl: Dutch */
    private static final String[] LANGUAGE_nl = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E1,\u00E4,\u00E2,\u00E0,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00EB,\u00EA,\u00E8,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 2 */ "\u00ED,\u00EF,\u00EC,\u00EE,\u012F,\u012B,\u0133",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F6,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00FB,\u00F9,\u016B",
        /* 5 */ null,
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        /* 7 */ null,
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 8 */ "\u0133",
    };

    /* Language pl: Polish */
    private static final String[] LANGUAGE_pl = {
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u0105,\u00E1,\u00E0,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u0119,\u00E8,\u00E9,\u00EA,\u00EB,\u0117,\u0113",
        /* 2 */ null,
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F3,\u00F6,\u00F4,\u00F2,\u00F5,\u0153,\u00F8,\u014D",
        /* 4 */ null,
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u015B,\u00DF,\u0161",
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        /* 6 */ "\u0144,\u00F1",
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u0107,\u00E7,\u010D",
        /* 8~ */
        null, null, null, null,
        /* ~11 */
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        /* 12 */ "\u017C,\u017A,\u017E",
        /* 13 */ null,
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u0142",
    };

    /* Language pt: Portuguese */
    private static final String[] LANGUAGE_pt = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E1,\u00E3,\u00E0,\u00E2,\u00E4,\u00E5,\u00E6,\u00AA",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        /* 1 */ "\u00E9,\u00EA,\u00E8,\u0119,\u0117,\u0113,\u00EB",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EE,\u00EC,\u00EF,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F3,\u00F5,\u00F4,\u00F2,\u00F6,\u0153,\u00F8,\u014D,\u00BA",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00F9,\u00FB,\u016B",
        /* 5 */ null,
        /* 6 */ null,
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u00E7,\u010D,\u0107",
    };

    /* Language rm: Raeto-Romance */
    private static final String[] LANGUAGE_rm = {
        /* 0~ */
        null, null, null,
        /* ~2 */
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 3 */ "\u00F2,\u00F3,\u00F6,\u00F4,\u00F5,\u0153,\u00F8",
    };

    /* Language ro: Romanian */
    private static final String[] LANGUAGE_ro = {
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+0103: "ă" LATIN SMALL LETTER A WITH BREVE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E2,\u00E3,\u0103,\u00E0,\u00E1,\u00E4,\u00E6,\u00E5,\u0101",
        /* 1 */ null,
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00EE,\u00EF,\u00EC,\u00ED,\u012F,\u012B",
        /* 3 */ null,
        /* 4 */ null,
        // U+0219: "ș" LATIN SMALL LETTER S WITH COMMA BELOW
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u0219,\u00DF,\u015B,\u0161",
        /* 6~ */
        null, null, null, null, null,
        /* ~10 */
        // U+021B: "ț" LATIN SMALL LETTER T WITH COMMA BELOW
        /* 11 */ "\u021B",
    };

    /* Language ru: Russian */
    private static final String[] LANGUAGE_ru = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null,
        /* ~24 */
        // U+0449: "щ" CYRILLIC SMALL LETTER SHCHA
        /* 25 */ "\u0449",
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 26 */ "\u044A",
        // U+044B: "ы" CYRILLIC SMALL LETTER YERU
        /* 27 */ "\u044B",
        // U+044D: "э" CYRILLIC SMALL LETTER E
        /* 28 */ "\u044D",
        // U+0438: "и" CYRILLIC SMALL LETTER I
        /* 29 */ "\u0438",
        /* 30~ */
        null, null, null, null, null,
        /* ~34 */
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 35 */ "\u044A",
        /* 36~ */
        null, null, null, null,
        /* ~39 */
        // U+0451: "ё" CYRILLIC SMALL LETTER IO
        /* 40 */ "\u0451",
    };

    /* Language sk: Slovak */
    private static final String[] LANGUAGE_sk = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        /* 0 */ "\u00E1,\u00E4,\u0101,\u00E0,\u00E2,\u00E3,\u00E5,\u00E6,\u0105",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        /* 1 */ "\u00E9,\u011B,\u0113,\u0117,\u00E8,\u00EA,\u00EB,\u0119",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        /* 2 */ "\u00ED,\u012B,\u012F,\u00EC,\u00EE,\u00EF,\u0131",
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 3 */ "\u00F4,\u00F3,\u00F6,\u00F2,\u00F5,\u0153,\u0151,\u00F8",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        /* 4 */ "\u00FA,\u016F,\u00FC,\u016B,\u0173,\u00F9,\u00FB,\u0171",
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        /* 5 */ "\u0161,\u00DF,\u015B,\u015F",
        // U+0148: "ň" LATIN SMALL LETTER N WITH CARON
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u0148,\u0146,\u00F1,\u0144,\u0144",
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u00E7,\u0107",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        /* 8 */ "\u00FD,\u00FF",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        /* 9 */ "\u010F",
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        /* 10 */ "\u0155,\u0159,\u0157",
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        /* 11 */ "\u0165,\u0163",
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        /* 12 */ "\u017E,\u017C,\u017A",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        /* 13 */ "\u0137",
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u013E,\u013A,\u013C,\u0142",
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        /* 15 */ "\u0123,\u011F",
    };

    /* Language sl: Slovenian */
    private static final String[] LANGUAGE_sl = {
        /* 0~ */
        null, null, null, null, null,
        /* ~4 */
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u0161",
        /* 6 */ null,
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        /* 7 */ "\u010D,\u0107",
        /* 8 */ null,
        // U+0111: "đ" LATIN SMALL LETTER D WITH STROKE
        /* 9 */ "\u0111",
        /* 10 */ null,
        /* 11 */ null,
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        /* 12 */ "\u017E",
    };

    /* Language sr: Serbian */
    private static final String[] LANGUAGE_sr = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null,
        /* ~35 */
        // TODO: Move these to sr-Latn once we can handle IETF language tag with script name specified.
        // BEGIN: More keys definitions for Serbian (Latin)
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // <string name="more_keys_for_s">&#x0161;,&#x00DF;,&#x015B;</string>
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // <string name="more_keys_for_c">&#x010D;,&#x00E7;,&#x0107;</string>
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        // <string name="more_keys_for_d">&#x010F;</string>
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // <string name="more_keys_for_z">&#x017E;,&#x017A;,&#x017C;</string>
        // END: More keys definitions for Serbian (Latin)
        // BEGIN: More keys definitions for Serbian (Cyrillic)
        // U+0437: "з" CYRILLIC SMALL LETTER ZE
        /* 36 */ "\u0437",
        // U+045B: "ћ" CYRILLIC SMALL LETTER TSHE
        /* 37 */ "\u045B",
        // U+0455: "ѕ" CYRILLIC SMALL LETTER DZE
        /* 38 */ "\u0455",
        // U+0452: "ђ" CYRILLIC SMALL LETTER DJE
        /* 39 */ "\u0452",
        // U+0450: "ѐ" CYRILLIC SMALL LETTER IE WITH GRAVE
        /* 40 */ "\u0450",
        // U+045D: "ѝ" CYRILLIC SMALL LETTER I WITH GRAVE
        /* 41 */ "\u045D",
        /* 42 */ null,
        // END: More keys definitions for Serbian (Cyrillic)
        // U+2018: "‘" LEFT SINGLE QUOTATION MARK
        // U+2019: "’" RIGHT SINGLE QUOTATION MARK
        // U+201A: "‚" SINGLE LOW-9 QUOTATION MARK
        // U+201B: "‛" SINGLE HIGH-REVERSED-9 QUOTATION MARK
        // U+201C: "“" LEFT DOUBLE QUOTATION MARK
        // U+201D: "”" RIGHT DOUBLE QUOTATION MARK
        // U+201E: "„" DOUBLE LOW-9 QUOTATION MARK
        // U+201F: "‟" DOUBLE HIGH-REVERSED-9 QUOTATION MARK
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_double_quote">!fixedColumnOrder!6,&#x201E;,&#x201C;,&#x201D;,&#x201F;,&#x00AB;,&#x00BB;</string>
        /* 43 */ "!fixedColumnOrder!5,\u201E,\u201C,\u201D,\u00AB,\u00BB",
        // TODO: Neither DroidSans nor Roboto have the glyph for U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK.
        // <string name="more_keys_for_tablet_double_quote">!fixedColumnOrder!6,&#x201C;,&#x201D;,&#x201E;,&#x201F;,&#x00AB;,&#x00BB;,&#x2018;,&#x2019;,&#x201A;,&#x201B;</string>
        /* 44 */ "!fixedColumnOrder!5,\u201E,\u201C,\u201D,\u00AB,\u00BB,\u2018,\u2019,\u201A,\u201B",
    };

    /* Language sv: Swedish */
    private static final String[] LANGUAGE_sv = {
        /* 0 */ null,
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        /* 1 */ "\u00E9,\u00E8,\u00EA,\u00EB,\u0119",
        /* 2 */ null,
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u0153,\u00F4,\u00F2,\u00F3,\u00F5,\u014D",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FC,\u00FB,\u00F9,\u00FA,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u00DF,\u015B,\u0161",
        /* 6~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        /* ~19 */
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        /* 20 */ "\u00E5",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        /* 21 */ "\u00F6",
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        /* 22 */ "\u00E4",
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        /* 23 */ "\u00F8",
        // U+00E6: "æ" LATIN SMALL LETTER AE
        /* 24 */ "\u00E6",
    };

    /* Language sw: Swahili */
    private static final String[] LANGUAGE_sw = {
        // This is the same as English except more_keys_for_g.
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E0,\u00E1,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E8,\u00E9,\u00EA,\u00EB,\u0113",
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        /* 2 */ "\u00EE,\u00EF,\u00ED,\u012B,\u00EC",
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        /* 3 */ "\u00F4,\u00F6,\u00F2,\u00F3,\u0153,\u00F8,\u014D,\u00F5",
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FB,\u00FC,\u00F9,\u00FA,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        /* 5 */ "\u00DF",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        /* 6 */ "\u00F1",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        /* 7 */ "\u00E7",
        /* 8~ */
        null, null, null, null, null, null, null,
        /* ~14 */
        /* 15 */ "g\'",
    };

    /* Language tl: Tagalog */
    private static final String[] LANGUAGE_tl = {
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E1,\u00E0,\u00E4,\u00E2,\u00E3,\u00E5,\u0105,\u00E6,\u0101,\u00AA",
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E9,\u00E8,\u00EB,\u00EA,\u0119,\u0117,\u0113",
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u00ED,\u00EF,\u00EC,\u00EE,\u012F,\u012B",
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F3,\u00F2,\u00F6,\u00F4,\u00F5,\u00F8,\u0153,\u014D,\u00BA",
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FA,\u00FC,\u00F9,\u00FB,\u016B",
        /* 5 */ null,
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        /* 6 */ "\u00F1,\u0144",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u010D",
    };

    /* Language tr: Turkish */
    private static final String[] LANGUAGE_tr = {
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        /* 0 */ "\u00E2",
        /* 1 */ null,
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        /* 2 */ "\u0131,\u00EE,\u00EF,\u00EC,\u00ED,\u012F,\u012B",
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        /* 3 */ "\u00F6,\u00F4,\u0153,\u00F2,\u00F3,\u00F5,\u00F8,\u014D",
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FC,\u00FB,\u00F9,\u00FA,\u016B",
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        /* 5 */ "\u015F,\u00DF,\u015B,\u0161",
        /* 6 */ null,
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u010D",
        /* 8~ */
        null, null, null, null, null, null, null,
        /* ~14 */
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        /* 15 */ "\u011F",
    };

    /* Language uk: Ukrainian */
    private static final String[] LANGUAGE_uk = {
        /* 0~ */
        null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
        null, null, null, null, null, null, null, null, null, null,
        /* ~24 */
        // U+0449: "щ" CYRILLIC SMALL LETTER SHCHA
        /* 25 */ "\u0449",
        // U+0457: "ї" CYRILLIC SMALL LETTER YI
        /* 26 */ "\u0457",
        // U+0456: "і" CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
        /* 27 */ "\u0456",
        // U+0454: "є" CYRILLIC SMALL LETTER UKRAINIAN IE
        /* 28 */ "\u0454",
        // U+0438: "и" CYRILLIC SMALL LETTER I
        /* 29 */ "\u0438",
        /* 30 */ null,
        /* 31 */ null,
        // U+0491: "ґ" CYRILLIC SMALL LETTER GHE WITH UPTURN
        /* 32 */ "\u0491",
        // U+0457: "ї" CYRILLIC SMALL LETTER YI
        /* 33 */ "\u0457",
        /* 34 */ null,
        // U+044A: "ъ" CYRILLIC SMALL LETTER HARD SIGN
        /* 35 */ "\u044A",
    };

    /* Language vi: Vietnamese */
    private static final String[] LANGUAGE_vi = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+1EA3: "ả" LATIN SMALL LETTER A WITH HOOK ABOVE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+1EA1: "ạ" LATIN SMALL LETTER A WITH DOT BELOW
        // U+0103: "ă" LATIN SMALL LETTER A WITH BREVE
        // U+1EB1: "ằ" LATIN SMALL LETTER A WITH BREVE AND GRAVE
        // U+1EAF: "ắ" LATIN SMALL LETTER A WITH BREVE AND ACUTE
        // U+1EB3: "ẳ" LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
        // U+1EB5: "ẵ" LATIN SMALL LETTER A WITH BREVE AND TILDE
        // U+1EB7: "ặ" LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+1EA7: "ầ" LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
        // U+1EA5: "ấ" LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
        // U+1EA9: "ẩ" LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
        // U+1EAB: "ẫ" LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
        // U+1EAD: "ậ" LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
        /* 0 */ "\u00E0,\u00E1,\u1EA3,\u00E3,\u1EA1,\u0103,\u1EB1,\u1EAF,\u1EB3,\u1EB5,\u1EB7,\u00E2,\u1EA7,\u1EA5,\u1EA9,\u1EAB,\u1EAD",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+1EBB: "ẻ" LATIN SMALL LETTER E WITH HOOK ABOVE
        // U+1EBD: "ẽ" LATIN SMALL LETTER E WITH TILDE
        // U+1EB9: "ẹ" LATIN SMALL LETTER E WITH DOT BELOW
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+1EC1: "ề" LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
        // U+1EBF: "ế" LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
        // U+1EC3: "ể" LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
        // U+1EC5: "ễ" LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
        // U+1EC7: "ệ" LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
        /* 1 */ "\u00E8,\u00E9,\u1EBB,\u1EBD,\u1EB9,\u00EA,\u1EC1,\u1EBF,\u1EC3,\u1EC5,\u1EC7",
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+1EC9: "ỉ" LATIN SMALL LETTER I WITH HOOK ABOVE
        // U+0129: "ĩ" LATIN SMALL LETTER I WITH TILDE
        // U+1ECB: "ị" LATIN SMALL LETTER I WITH DOT BELOW
        /* 2 */ "\u00EC,\u00ED,\u1EC9,\u0129,\u1ECB",
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+1ECF: "ỏ" LATIN SMALL LETTER O WITH HOOK ABOVE
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+1ECD: "ọ" LATIN SMALL LETTER O WITH DOT BELOW
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+1ED3: "ồ" LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
        // U+1ED1: "ố" LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
        // U+1ED5: "ổ" LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
        // U+1ED7: "ỗ" LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
        // U+1ED9: "ộ" LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
        // U+01A1: "ơ" LATIN SMALL LETTER O WITH HORN
        // U+1EDD: "ờ" LATIN SMALL LETTER O WITH HORN AND GRAVE
        // U+1EDB: "ớ" LATIN SMALL LETTER O WITH HORN AND ACUTE
        // U+1EDF: "ở" LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
        // U+1EE1: "ỡ" LATIN SMALL LETTER O WITH HORN AND TILDE
        // U+1EE3: "ợ" LATIN SMALL LETTER O WITH HORN AND DOT BELOW
        /* 3 */ "\u00F2,\u00F3,\u1ECF,\u00F5,\u1ECD,\u00F4,\u1ED3,\u1ED1,\u1ED5,\u1ED7,\u1ED9,\u01A1,\u1EDD,\u1EDB,\u1EDF,\u1EE1,\u1EE3",
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+1EE7: "ủ" LATIN SMALL LETTER U WITH HOOK ABOVE
        // U+0169: "ũ" LATIN SMALL LETTER U WITH TILDE
        // U+1EE5: "ụ" LATIN SMALL LETTER U WITH DOT BELOW
        // U+01B0: "ư" LATIN SMALL LETTER U WITH HORN
        // U+1EEB: "ừ" LATIN SMALL LETTER U WITH HORN AND GRAVE
        // U+1EE9: "ứ" LATIN SMALL LETTER U WITH HORN AND ACUTE
        // U+1EED: "ử" LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
        // U+1EEF: "ữ" LATIN SMALL LETTER U WITH HORN AND TILDE
        // U+1EF1: "ự" LATIN SMALL LETTER U WITH HORN AND DOT BELOW
        /* 4 */ "\u00F9,\u00FA,\u1EE7,\u0169,\u1EE5,\u01B0,\u1EEB,\u1EE9,\u1EED,\u1EEF,\u1EF1",
        /* 5~ */
        null, null, null,
        /* ~7 */
        // U+1EF3: "ỳ" LATIN SMALL LETTER Y WITH GRAVE
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+1EF7: "ỷ" LATIN SMALL LETTER Y WITH HOOK ABOVE
        // U+1EF9: "ỹ" LATIN SMALL LETTER Y WITH TILDE
        // U+1EF5: "ỵ" LATIN SMALL LETTER Y WITH DOT BELOW
        /* 8 */ "\u1EF3,\u00FD,\u1EF7,\u1EF9,\u1EF5",
        // U+0111: "đ" LATIN SMALL LETTER D WITH STROKE
        /* 9 */ "\u0111",
    };

    /* Language zu: Zulu */
    private static final String[] LANGUAGE_zu = {
        // This is the same as English
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        /* 0 */ "\u00E0,\u00E1,\u00E2,\u00E4,\u00E6,\u00E3,\u00E5,\u0101",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        /* 1 */ "\u00E8,\u00E9,\u00EA,\u00EB,\u0113",
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        /* 2 */ "\u00EE,\u00EF,\u00ED,\u012B,\u00EC",
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        /* 3 */ "\u00F4,\u00F6,\u00F2,\u00F3,\u0153,\u00F8,\u014D,\u00F5",
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        /* 4 */ "\u00FB,\u00FC,\u00F9,\u00FA,\u016B",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        /* 5 */ "\u00DF",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        /* 6 */ "\u00F1",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        /* 7 */ "\u00E7",
    };

    /* Language zz: No language */
    private static final String[] LANGUAGE_zz = {
        // U+00E0: "à" LATIN SMALL LETTER A WITH GRAVE
        // U+00E1: "á" LATIN SMALL LETTER A WITH ACUTE
        // U+00E2: "â" LATIN SMALL LETTER A WITH CIRCUMFLEX
        // U+00E3: "ã" LATIN SMALL LETTER A WITH TILDE
        // U+00E4: "ä" LATIN SMALL LETTER A WITH DIAERESIS
        // U+00E5: "å" LATIN SMALL LETTER A WITH RING ABOVE
        // U+00E6: "æ" LATIN SMALL LETTER AE
        // U+0101: "ā" LATIN SMALL LETTER A WITH MACRON
        // U+0103: "ă" LATIN SMALL LETTER A WITH BREVE
        // U+0105: "ą" LATIN SMALL LETTER A WITH OGONEK
        // U+00AA: "ª" FEMININE ORDINAL INDICATOR
        /* 0 */ "\u00E0,\u00E1,\u00E2,\u00E3,\u00E4,\u00E5,\u00E6,\u00E3,\u00E5,\u0101,\u0103,\u0105,\u00AA",
        // U+00E8: "è" LATIN SMALL LETTER E WITH GRAVE
        // U+00E9: "é" LATIN SMALL LETTER E WITH ACUTE
        // U+00EA: "ê" LATIN SMALL LETTER E WITH CIRCUMFLEX
        // U+00EB: "ë" LATIN SMALL LETTER E WITH DIAERESIS
        // U+0113: "ē" LATIN SMALL LETTER E WITH MACRON
        // U+0115: "ĕ" LATIN SMALL LETTER E WITH BREVE
        // U+0117: "ė" LATIN SMALL LETTER E WITH DOT ABOVE
        // U+0119: "ę" LATIN SMALL LETTER E WITH OGONEK
        // U+011B: "ě" LATIN SMALL LETTER E WITH CARON
        /* 1 */ "\u00E8,\u00E9,\u00EA,\u00EB,\u0113,\u0115,\u0117,\u0119,\u011B",
        // U+00EC: "ì" LATIN SMALL LETTER I WITH GRAVE
        // U+00ED: "í" LATIN SMALL LETTER I WITH ACUTE
        // U+00EE: "î" LATIN SMALL LETTER I WITH CIRCUMFLEX
        // U+00EF: "ï" LATIN SMALL LETTER I WITH DIAERESIS
        // U+0129: "ĩ" LATIN SMALL LETTER I WITH TILDE
        // U+012B: "ī" LATIN SMALL LETTER I WITH MACRON
        // U+012D: "ĭ" LATIN SMALL LETTER I WITH BREVE
        // U+012F: "į" LATIN SMALL LETTER I WITH OGONEK
        // U+0131: "ı" LATIN SMALL LETTER DOTLESS I
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 2 */ "\u00EC,\u00ED,\u00EE,\u00EF,\u0129,\u012B,\u012D,\u012F,\u0131,\u0133",
        // U+00F2: "ò" LATIN SMALL LETTER O WITH GRAVE
        // U+00F3: "ó" LATIN SMALL LETTER O WITH ACUTE
        // U+00F4: "ô" LATIN SMALL LETTER O WITH CIRCUMFLEX
        // U+00F5: "õ" LATIN SMALL LETTER O WITH TILDE
        // U+00F6: "ö" LATIN SMALL LETTER O WITH DIAERESIS
        // U+00F8: "ø" LATIN SMALL LETTER O WITH STROKE
        // U+014D: "ō" LATIN SMALL LETTER O WITH MACRON
        // U+014F: "ŏ" LATIN SMALL LETTER O WITH BREVE
        // U+0151: "ő" LATIN SMALL LETTER O WITH DOUBLE ACUTE
        // U+0153: "œ" LATIN SMALL LIGATURE OE
        // U+00BA: "º" MASCULINE ORDINAL INDICATOR
        /* 3 */ "\u00F2,\u00F3,\u00F4,\u00F5,\u00F6,\u00F8,\u014D,\u014F,\u0151,\u0153,\u00BA",
        // U+00F9: "ù" LATIN SMALL LETTER U WITH GRAVE
        // U+00FA: "ú" LATIN SMALL LETTER U WITH ACUTE
        // U+00FB: "û" LATIN SMALL LETTER U WITH CIRCUMFLEX
        // U+00FC: "ü" LATIN SMALL LETTER U WITH DIAERESIS
        // U+0169: "ũ" LATIN SMALL LETTER U WITH TILDE
        // U+016B: "ū" LATIN SMALL LETTER U WITH MACRON
        // U+016D: "ŭ" LATIN SMALL LETTER U WITH BREVE
        // U+016F: "ů" LATIN SMALL LETTER U WITH RING ABOVE
        // U+0171: "ű" LATIN SMALL LETTER U WITH DOUBLE ACUTE
        // U+0173: "ų" LATIN SMALL LETTER U WITH OGONEK
        /* 4 */ "\u00F9,\u00FA,\u00FB,\u00FC,\u0169,\u016B,\u016D,\u016F,\u0171,\u0173",
        // U+00DF: "ß" LATIN SMALL LETTER SHARP S
        // U+015B: "ś" LATIN SMALL LETTER S WITH ACUTE
        // U+015D: "ŝ" LATIN SMALL LETTER S WITH CIRCUMFLEX
        // U+015F: "ş" LATIN SMALL LETTER S WITH CEDILLA
        // U+0161: "š" LATIN SMALL LETTER S WITH CARON
        // U+017F: "ſ" LATIN SMALL LETTER LONG S
        /* 5 */ "\u00DF,\u015B,\u015D,\u015F,\u0161,\u017F",
        // U+00F1: "ñ" LATIN SMALL LETTER N WITH TILDE
        // U+0144: "ń" LATIN SMALL LETTER N WITH ACUTE
        // U+0146: "ņ" LATIN SMALL LETTER N WITH CEDILLA
        // U+0148: "ň" LATIN SMALL LETTER N WITH CARON
        // U+0149: "ŉ" LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
        // U+014B: "ŋ" LATIN SMALL LETTER ENG
        /* 6 */ "\u00F1,\u0144,\u0146,\u0148,\u0149,\u014B",
        // U+00E7: "ç" LATIN SMALL LETTER C WITH CEDILLA
        // U+0107: "ć" LATIN SMALL LETTER C WITH ACUTE
        // U+0109: "ĉ" LATIN SMALL LETTER C WITH CIRCUMFLEX
        // U+010B: "ċ" LATIN SMALL LETTER C WITH DOT ABOVE
        // U+010D: "č" LATIN SMALL LETTER C WITH CARON
        /* 7 */ "\u00E7,\u0107,\u0109,\u010B,\u010D",
        // U+00FD: "ý" LATIN SMALL LETTER Y WITH ACUTE
        // U+0177: "ŷ" LATIN SMALL LETTER Y WITH CIRCUMFLEX
        // U+00FF: "ÿ" LATIN SMALL LETTER Y WITH DIAERESIS
        // U+0133: "ĳ" LATIN SMALL LIGATURE IJ
        /* 8 */ "\u00FD,\u0177,\u00FF,\u0133",
        // U+010F: "ď" LATIN SMALL LETTER D WITH CARON
        // U+0111: "đ" LATIN SMALL LETTER D WITH STROKE
        // U+00F0: "ð" LATIN SMALL LETTER ETH
        /* 9 */ "\u010F,\u0111,\u00F0",
        // U+0155: "ŕ" LATIN SMALL LETTER R WITH ACUTE
        // U+0157: "ŗ" LATIN SMALL LETTER R WITH CEDILLA
        // U+0159: "ř" LATIN SMALL LETTER R WITH CARON
        /* 10 */ "\u0155,\u0157,\u0159",
        // U+00FE: "þ" LATIN SMALL LETTER THORN
        // U+0163: "ţ" LATIN SMALL LETTER T WITH CEDILLA
        // U+0165: "ť" LATIN SMALL LETTER T WITH CARON
        // U+0167: "ŧ" LATIN SMALL LETTER T WITH STROKE
        /* 11 */ "\u00FE,\u0163,\u0165,\u0167",
        // U+017A: "ź" LATIN SMALL LETTER Z WITH ACUTE
        // U+017C: "ż" LATIN SMALL LETTER Z WITH DOT ABOVE
        // U+017E: "ž" LATIN SMALL LETTER Z WITH CARON
        /* 12 */ "\u017A,\u017C,\u017E",
        // U+0137: "ķ" LATIN SMALL LETTER K WITH CEDILLA
        // U+0138: "ĸ" LATIN SMALL LETTER KRA
        /* 13 */ "\u0137,\u0138",
        // U+013A: "ĺ" LATIN SMALL LETTER L WITH ACUTE
        // U+013C: "ļ" LATIN SMALL LETTER L WITH CEDILLA
        // U+013E: "ľ" LATIN SMALL LETTER L WITH CARON
        // U+0140: "ŀ" LATIN SMALL LETTER L WITH MIDDLE DOT
        // U+0142: "ł" LATIN SMALL LETTER L WITH STROKE
        /* 14 */ "\u013A,\u013C,\u013E,\u0140,\u0142",
        // U+011D: "ĝ" LATIN SMALL LETTER G WITH CIRCUMFLEX
        // U+011F: "ğ" LATIN SMALL LETTER G WITH BREVE
        // U+0121: "ġ" LATIN SMALL LETTER G WITH DOT ABOVE
        // U+0123: "ģ" LATIN SMALL LETTER G WITH CEDILLA
        /* 15 */ "\u011D,\u011F,\u0121,\u0123",
        /* 16 */ null,
        // U+0125: "ĥ" LATIN SMALL LETTER H WITH CIRCUMFLEX
        /* 17 */ "\u0125",
        // U+0135: "ĵ" LATIN SMALL LETTER J WITH CIRCUMFLEX
        /* 18 */ "\u0135",
        // U+0175: "ŵ" LATIN SMALL LETTER W WITH CIRCUMFLEX
        /* 19 */ "\u0175",
    };

    private static final Object[] LANGUAGES_AND_TEXTS = {
        "DEFAULT", LANGUAGE_DEFAULT, /* default */
        "af", LANGUAGE_af, /* Afrikaans */
        "ar", LANGUAGE_ar, /* Arabic */
        "be", LANGUAGE_be, /* Belarusian */
        "ca", LANGUAGE_ca, /* Catalan */
        "cs", LANGUAGE_cs, /* Czech */
        "da", LANGUAGE_da, /* Danish */
        "de", LANGUAGE_de, /* German */
        "en", LANGUAGE_en, /* English */
        "eo", LANGUAGE_eo, /* Esperanto */
        "es", LANGUAGE_es, /* Spanish */
        "et", LANGUAGE_et, /* Estonian */
        "fa", LANGUAGE_fa, /* Persian */
        "fi", LANGUAGE_fi, /* Finnish */
        "fr", LANGUAGE_fr, /* French */
        "hi", LANGUAGE_hi, /* Hindi */
        "hr", LANGUAGE_hr, /* Croatian */
        "hu", LANGUAGE_hu, /* Hungarian */
        "is", LANGUAGE_is, /* Icelandic */
        "it", LANGUAGE_it, /* Italian */
        "iw", LANGUAGE_iw, /* Hebrew */
        "ky", LANGUAGE_ky, /* Kirghiz */
        "lt", LANGUAGE_lt, /* Lithuanian */
        "lv", LANGUAGE_lv, /* Latvian */
        "mk", LANGUAGE_mk, /* Macedonian */
        "nb", LANGUAGE_nb, /* Norwegian Bokmål */
        "nl", LANGUAGE_nl, /* Dutch */
        "pl", LANGUAGE_pl, /* Polish */
        "pt", LANGUAGE_pt, /* Portuguese */
        "rm", LANGUAGE_rm, /* Raeto-Romance */
        "ro", LANGUAGE_ro, /* Romanian */
        "ru", LANGUAGE_ru, /* Russian */
        "sk", LANGUAGE_sk, /* Slovak */
        "sl", LANGUAGE_sl, /* Slovenian */
        "sr", LANGUAGE_sr, /* Serbian */
        "sv", LANGUAGE_sv, /* Swedish */
        "sw", LANGUAGE_sw, /* Swahili */
        "tl", LANGUAGE_tl, /* Tagalog */
        "tr", LANGUAGE_tr, /* Turkish */
        "uk", LANGUAGE_uk, /* Ukrainian */
        "vi", LANGUAGE_vi, /* Vietnamese */
        "zu", LANGUAGE_zu, /* Zulu */
        "zz", LANGUAGE_zz, /* No language */
    };

    static {
        int id = 0;
        for (final String name : NAMES) {
            sNameToIdsMap.put(name, id++);
        }

        for (int i = 0; i < LANGUAGES_AND_TEXTS.length; i += 2) {
            final String language = (String)LANGUAGES_AND_TEXTS[i];
            final String[] texts = (String[])LANGUAGES_AND_TEXTS[i + 1];
            sLocaleToTextsMap.put(language, texts);
        }
    }
}
