/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.inputmethod.latin.personalization;

import android.content.Context;

import com.android.inputmethod.annotations.UsedForTesting;
import com.android.inputmethod.latin.Dictionary;

import java.io.File;
import java.util.Locale;

public class PersonalizationDictionary extends DecayingExpandableBinaryDictionaryBase {
    /* package */ static final String NAME = PersonalizationDictionary.class.getSimpleName();

    // TODO: Make this constructor private
    /* package */ PersonalizationDictionary(final Context context, final Locale locale) {
        super(context, getDictName(NAME, locale, null /* dictFile */), locale,
                Dictionary.TYPE_PERSONALIZATION, null /* dictFile */);
    }

    @UsedForTesting
    public static PersonalizationDictionary getDictionary(final Context context,
            final Locale locale, final File dictFile) {
        return PersonalizationHelper.getPersonalizationDictionary(context, locale);
    }

    @Override
    public boolean isValidWord(final String word) {
        // Strings out of this dictionary should not be considered existing words.
        return false;
    }
}
