/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.inputmethod.compat;

import android.content.Intent;

public final class IntentCompatUtils {
    // Note that Intent.ACTION_USER_INITIALIZE have been introduced in API level 17
    // (Build.VERSION_CODE.JELLY_BEAN_MR1).
    private static final String ACTION_USER_INITIALIZE =
            (String)CompatUtils.getFieldValue(null /* receiver */, null /* defaultValue */,
                    CompatUtils.getField(Intent.class, "ACTION_USER_INITIALIZE"));

    private IntentCompatUtils() {
        // This utility class is not publicly instantiable.
    }

    public static boolean is_ACTION_USER_INITIALIZE(final String action) {
        return ACTION_USER_INITIALIZE != null && ACTION_USER_INITIALIZE.equals(action);
    }
}
