/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.gui;

/**
 * This mirrors aidl::android::hardware::graphics::composer3::LutProperties definition.
 * @hide
 */
parcelable LutProperties {
    @Backing(type="int")
    enum Dimension { ONE_D = 1, THREE_D = 3 }
    Dimension dimension;

    int size;
    @Backing(type="int")
    enum SamplingKey { RGB, MAX_RGB, CIE_Y }
    SamplingKey[] samplingKeys;
}