#!/usr/bin/python
# -*- coding: utf-8 -*-

#
# Copyright 2011, The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import os

def generate_egl_entries(output, lines, i):
    for line in lines:
        if line.find("EGL_ENTRY(") >= 0:
            line = line.split(",")[1].strip() #extract EGL function name
            output.write("        %s = %d;\n" % (line, i))
            i += 1
    return i


def generate_gl_entries(output,lines,i):
    for line in lines:
        if line.find("API_ENTRY(") >= 0:
            line = line[line.find("(") + 1: line.find(")")] #extract GL function name
            output.write("        %s = %d;\n" % (line, i))
            i += 1
    return i


if __name__ == "__main__":
    output = open("debugger_message.proto",'w')
    output.write("""\
/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// do not edit; auto generated by generate_debugger_message_proto.py

package com.android.glesv2debugger;

option optimize_for = LITE_RUNTIME;

message Message
{
    required int32 context_id = 1; // GL context id
    enum Function
    {
""")

    i = 0;

    lines = open("gl2_api_annotated.in").readlines()
    i = generate_gl_entries(output, lines, i)
    output.write("        // end of GL functions\n")

    #lines = open("gl2ext_api.in").readlines()
    #i = generate_gl_entries(output, lines, i)
    #output.write("        // end of GL EXT functions\n")

    lines = open("../EGL/egl_entries.in").readlines()
    i = generate_egl_entries(output, lines, i)
    output.write("        // end of GL EXT functions\n")

    output.write("        ACK = %d;\n" % (i))
    i += 1

    output.write("        NEG = %d;\n" % (i))
    i += 1

    output.write("        CONTINUE = %d;\n" % (i))
    i += 1

    output.write("        SKIP = %d;\n" % (i))
    i += 1

    output.write("        SETPROP = %d;\n" % (i))
    i += 1

    output.write("""    }
    required Function function = 2 [default = NEG]; // type/function of message
    enum Type
    {
        BeforeCall = 0;
        AfterCall = 1;
        AfterGeneratedCall = 2;
        Response = 3; // currently used for misc messages
        CompleteCall = 4; // BeforeCall and AfterCall merged
    }
    required Type type = 3;
    required bool expect_response = 4;
    optional int32 ret = 5; // return value from previous GL call
    optional int32 arg0 = 6; // args to GL call
    optional int32 arg1 = 7;
    optional int32 arg2 = 8;
    optional int32 arg3 = 9;
    optional int32 arg4 = 16;
    optional int32 arg5 = 17;
    optional int32 arg6 = 18;
    optional int32 arg7 = 19; // glDrawArrays/Elements sets this to active number of attributes
    optional int32 arg8 = 20;

    optional bytes data = 10; // variable length data used for GL call
    enum DataType
    {
        ReferencedImage = 0; // for image sourced from ReadPixels
        NonreferencedImage = 1; // for image sourced from ReadPixels
    };
    // most data types can be inferred from function
    optional DataType data_type = 23;
    // these are used for image data when they cannot be determined from args
    optional int32 pixel_format = 24;
    optional int32 pixel_type = 25;
    optional int32 image_width = 26;
    optional int32 image_height = 27;

    optional float time = 11; // duration of previous GL call (ms)
    enum Prop
    {
        CaptureDraw = 0; // arg0 = number of glDrawArrays/Elements to glReadPixels
        TimeMode = 1; // arg0 = SYSTEM_TIME_* in utils/Timers.h
        ExpectResponse = 2; // arg0 = enum Function, arg1 = true/false
        CaptureSwap = 3; // arg0 = number of eglSwapBuffers to glReadPixels
        GLConstant = 4; // arg0 = GLenum, arg1 = constant; send GL impl. constants
    };
    optional Prop prop = 21; // used with SETPROP, value in arg0
    optional float clock = 22; // wall clock in seconds
}
""")

    output.close()

    os.system("aprotoc --cpp_out=src --java_out=../../../../../development/tools/glesv2debugger/src debugger_message.proto")
    os.system('mv -f "src/debugger_message.pb.cc" "src/debugger_message.pb.cpp"')
