/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <gmock/gmock.h>

#include "Scheduler/PhaseOffsets.h"

namespace android::scheduler {

struct FakePhaseOffsets : PhaseOffsets {
    static constexpr nsecs_t FAKE_PHASE_OFFSET_NS = 0;

    Offsets getOffsetsForRefreshRate(RefreshRateType) const override { return getCurrentOffsets(); }

    Offsets getCurrentOffsets() const override {
        return {{RefreshRateType::DEFAULT, FAKE_PHASE_OFFSET_NS, FAKE_PHASE_OFFSET_NS},
                {RefreshRateType::DEFAULT, FAKE_PHASE_OFFSET_NS, FAKE_PHASE_OFFSET_NS},
                {RefreshRateType::DEFAULT, FAKE_PHASE_OFFSET_NS, FAKE_PHASE_OFFSET_NS},
                FAKE_PHASE_OFFSET_NS};
    }

    void setRefreshRateType(RefreshRateType) override {}
    void dump(std::string&) const override {}
};

} // namespace android::scheduler
