/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <inttypes.h>

#define BPF_FS_PATH "/sys/fs/bpf/"

#define FREQS_PER_ENTRY 32
#define CPUS_PER_ENTRY 8

struct time_key_t {
    uint32_t uid;
    uint32_t bucket;
};

struct tis_val_t {
    uint64_t ar[FREQS_PER_ENTRY];
};

struct concurrent_val_t {
    uint64_t active[CPUS_PER_ENTRY];
    uint64_t policy[CPUS_PER_ENTRY];
};

struct freq_idx_key_t {
    uint32_t policy;
    uint32_t freq;
};
