/*
 * Copyright 2011, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * THIS FILE WAS GENERATED BY A SCRIPT. DO NOT EDIT.
 */

#include <cutils/log.h>
#include <utils/Timers.h>

#include "gltrace.pb.h"
#include "gltrace_context.h"
#include "gltrace_fixup.h"
#include "gltrace_transport.h"

namespace android {
namespace gltrace {

// Definitions for GL2 APIs

void GLTrace_glActiveTexture(GLenum texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glActiveTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glActiveTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAttachShader(GLuint program, GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAttachShader);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAttachShader(program, shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindAttribLocation(GLuint program, GLuint index, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindAttribLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindAttribLocation(program, index, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindBuffer(GLenum target, GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindBuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindBuffer(target, buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindFramebuffer(GLenum target, GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindFramebuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindFramebuffer(target, framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindRenderbuffer(GLenum target, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindRenderbuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindRenderbuffer(target, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindTexture(GLenum target, GLuint texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindTexture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindTexture(target, texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendColor);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendColor(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquation(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquation);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquation(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationSeparate);

    // copy argument modeRGB
    GLMessage_DataType *arg_modeRGB = glmsg.add_args();
    arg_modeRGB->set_isarray(false);
    arg_modeRGB->set_type(GLMessage::DataType::ENUM);
    arg_modeRGB->add_intvalue((int)modeRGB);

    // copy argument modeAlpha
    GLMessage_DataType *arg_modeAlpha = glmsg.add_args();
    arg_modeAlpha->set_isarray(false);
    arg_modeAlpha->set_type(GLMessage::DataType::ENUM);
    arg_modeAlpha->add_intvalue((int)modeAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationSeparate(modeRGB, modeAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFunc(GLenum sfactor, GLenum dfactor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFunc);

    // copy argument sfactor
    GLMessage_DataType *arg_sfactor = glmsg.add_args();
    arg_sfactor->set_isarray(false);
    arg_sfactor->set_type(GLMessage::DataType::ENUM);
    arg_sfactor->add_intvalue((int)sfactor);

    // copy argument dfactor
    GLMessage_DataType *arg_dfactor = glmsg.add_args();
    arg_dfactor->set_isarray(false);
    arg_dfactor->set_type(GLMessage::DataType::ENUM);
    arg_dfactor->add_intvalue((int)dfactor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFunc(sfactor, dfactor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFuncSeparate);

    // copy argument sfactorRGB
    GLMessage_DataType *arg_sfactorRGB = glmsg.add_args();
    arg_sfactorRGB->set_isarray(false);
    arg_sfactorRGB->set_type(GLMessage::DataType::ENUM);
    arg_sfactorRGB->add_intvalue((int)sfactorRGB);

    // copy argument dfactorRGB
    GLMessage_DataType *arg_dfactorRGB = glmsg.add_args();
    arg_dfactorRGB->set_isarray(false);
    arg_dfactorRGB->set_type(GLMessage::DataType::ENUM);
    arg_dfactorRGB->add_intvalue((int)dfactorRGB);

    // copy argument sfactorAlpha
    GLMessage_DataType *arg_sfactorAlpha = glmsg.add_args();
    arg_sfactorAlpha->set_isarray(false);
    arg_sfactorAlpha->set_type(GLMessage::DataType::ENUM);
    arg_sfactorAlpha->add_intvalue((int)sfactorAlpha);

    // copy argument dfactorAlpha
    GLMessage_DataType *arg_dfactorAlpha = glmsg.add_args();
    arg_dfactorAlpha->set_isarray(false);
    arg_dfactorAlpha->set_type(GLMessage::DataType::ENUM);
    arg_dfactorAlpha->add_intvalue((int)dfactorAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBufferData(GLenum target, GLsizeiptr size, const void * data, GLenum usage) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBufferData);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // copy argument usage
    GLMessage_DataType *arg_usage = glmsg.add_args();
    arg_usage->set_isarray(false);
    arg_usage->set_type(GLMessage::DataType::ENUM);
    arg_usage->add_intvalue((int)usage);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBufferData(target, size, data, usage);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBufferSubData);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBufferSubData(target, offset, size, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glCheckFramebufferStatus(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCheckFramebufferStatus);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glCheckFramebufferStatus(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glClear(GLbitfield mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClear);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClear(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearColor);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearColor(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthf(GLfloat d) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthf);

    // copy argument d
    GLMessage_DataType *arg_d = glmsg.add_args();
    arg_d->set_isarray(false);
    arg_d->set_type(GLMessage::DataType::FLOAT);
    arg_d->add_floatvalue(d);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthf(d);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearStencil(GLint s) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearStencil);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::INT);
    arg_s->add_intvalue(s);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearStencil(s);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColorMask);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::BOOL);
    arg_red->add_boolvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::BOOL);
    arg_green->add_boolvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::BOOL);
    arg_blue->add_boolvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::BOOL);
    arg_alpha->add_boolvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColorMask(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompileShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompileShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompileShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glCreateProgram(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateProgram);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateProgram();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLuint GLTrace_glCreateShader(GLenum type) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateShader);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateShader(type);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glCullFace(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCullFace);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCullFace(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteBuffers(GLsizei n, const GLuint * buffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteBuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT64);
    arg_buffers->add_int64value((uintptr_t)buffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteBuffers(n, buffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteFramebuffers(GLsizei n, const GLuint * framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteFramebuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT64);
    arg_framebuffers->add_int64value((uintptr_t)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteFramebuffers(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteRenderbuffers(GLsizei n, const GLuint * renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteRenderbuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT64);
    arg_renderbuffers->add_int64value((uintptr_t)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteRenderbuffers(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteTextures(GLsizei n, const GLuint * textures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteTextures);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT64);
    arg_textures->add_int64value((uintptr_t)textures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteTextures(n, textures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthFunc(GLenum func) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthFunc(func);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthMask(GLboolean flag) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthMask);

    // copy argument flag
    GLMessage_DataType *arg_flag = glmsg.add_args();
    arg_flag->set_isarray(false);
    arg_flag->set_type(GLMessage::DataType::BOOL);
    arg_flag->add_boolvalue(flag);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthMask(flag);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthRangef(GLfloat n, GLfloat f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangef);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::FLOAT);
    arg_n->add_floatvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::FLOAT);
    arg_f->add_floatvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangef(n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDetachShader(GLuint program, GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDetachShader);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDetachShader(program, shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisable(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisable);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisable(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableVertexAttribArray(GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableVertexAttribArray);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableVertexAttribArray(index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArrays(GLenum mode, GLint first, GLsizei count) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArrays);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue(first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArrays(mode, first, count);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElements(GLenum mode, GLsizei count, GLenum type, const void * indices) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElements);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElements(mode, count, type, indices);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnable(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnable);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnable(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableVertexAttribArray(GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableVertexAttribArray);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableVertexAttribArray(index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFinish(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFinish);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFinish();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFlush(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFlush);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFlush();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferRenderbuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument renderbuffertarget
    GLMessage_DataType *arg_renderbuffertarget = glmsg.add_args();
    arg_renderbuffertarget->set_isarray(false);
    arg_renderbuffertarget->set_type(GLMessage::DataType::ENUM);
    arg_renderbuffertarget->add_intvalue((int)renderbuffertarget);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2D(target, attachment, textarget, texture, level);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrontFace(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrontFace);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrontFace(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenBuffers(GLsizei n, GLuint * buffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenBuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT64);
    arg_buffers->add_int64value((uintptr_t)buffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenBuffers(n, buffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenerateMipmap(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenerateMipmap);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenerateMipmap(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenFramebuffers(GLsizei n, GLuint * framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenFramebuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT64);
    arg_framebuffers->add_int64value((uintptr_t)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenFramebuffers(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenRenderbuffers(GLsizei n, GLuint * renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenRenderbuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT64);
    arg_renderbuffers->add_int64value((uintptr_t)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenRenderbuffers(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenTextures(GLsizei n, GLuint * textures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenTextures);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT64);
    arg_textures->add_int64value((uintptr_t)textures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenTextures(n, textures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveAttrib);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT64);
    arg_size->add_int64value((uintptr_t)size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::INT64);
    arg_type->add_int64value((uintptr_t)type);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveAttrib(program, index, bufSize, length, size, type, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) size,
        (void *) type,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveUniform);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT64);
    arg_size->add_int64value((uintptr_t)size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::INT64);
    arg_type->add_int64value((uintptr_t)type);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveUniform(program, index, bufSize, length, size, type, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) size,
        (void *) type,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetAttachedShaders);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument maxCount
    GLMessage_DataType *arg_maxCount = glmsg.add_args();
    arg_maxCount->set_isarray(false);
    arg_maxCount->set_type(GLMessage::DataType::INT);
    arg_maxCount->add_intvalue(maxCount);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT64);
    arg_count->add_int64value((uintptr_t)count);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT64);
    arg_shaders->add_int64value((uintptr_t)shaders);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetAttachedShaders(program, maxCount, count, shaders);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) count,
        (void *) shaders,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLint GLTrace_glGetAttribLocation(GLuint program, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetAttribLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLint retValue = glContext->hooks->gl.glGetAttribLocation(program, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetBooleanv(GLenum pname, GLboolean * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBooleanv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBooleanv(pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetBufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glGetError(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetError);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glGetError();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetFloatv(GLenum pname, GLfloat * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFloatv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFloatv(pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFramebufferAttachmentParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetIntegerv(GLenum pname, GLint * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetIntegerv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetIntegerv(pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramiv(GLuint program, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramiv(program, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramInfoLog);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument infoLog
    GLMessage_DataType *arg_infoLog = glmsg.add_args();
    arg_infoLog->set_isarray(false);
    arg_infoLog->set_type(GLMessage::DataType::INT64);
    arg_infoLog->add_int64value((uintptr_t)infoLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramInfoLog(program, bufSize, length, infoLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infoLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetRenderbufferParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetRenderbufferParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderiv(GLuint shader, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderiv);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderiv(shader, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderInfoLog);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument infoLog
    GLMessage_DataType *arg_infoLog = glmsg.add_args();
    arg_infoLog->set_isarray(false);
    arg_infoLog->set_type(GLMessage::DataType::INT64);
    arg_infoLog->add_int64value((uintptr_t)infoLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderInfoLog(shader, bufSize, length, infoLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infoLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderPrecisionFormat);

    // copy argument shadertype
    GLMessage_DataType *arg_shadertype = glmsg.add_args();
    arg_shadertype->set_isarray(false);
    arg_shadertype->set_type(GLMessage::DataType::ENUM);
    arg_shadertype->add_intvalue((int)shadertype);

    // copy argument precisiontype
    GLMessage_DataType *arg_precisiontype = glmsg.add_args();
    arg_precisiontype->set_isarray(false);
    arg_precisiontype->set_type(GLMessage::DataType::ENUM);
    arg_precisiontype->add_intvalue((int)precisiontype);

    // copy argument range
    GLMessage_DataType *arg_range = glmsg.add_args();
    arg_range->set_isarray(false);
    arg_range->set_type(GLMessage::DataType::INT64);
    arg_range->add_int64value((uintptr_t)range);

    // copy argument precision
    GLMessage_DataType *arg_precision = glmsg.add_args();
    arg_precision->set_isarray(false);
    arg_precision->set_type(GLMessage::DataType::INT64);
    arg_precision->add_int64value((uintptr_t)precision);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) range,
        (void *) precision,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderSource);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::INT64);
    arg_source->add_int64value((uintptr_t)source);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderSource(shader, bufSize, length, source);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) source,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

const GLubyte * GLTrace_glGetString(GLenum name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetString);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::ENUM);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    const GLubyte * retValue = glContext->hooks->gl.glGetString(name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameteriv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformfv(GLuint program, GLint location, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformfv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformfv(program, location, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformiv(GLuint program, GLint location, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformiv(program, location, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLint GLTrace_glGetUniformLocation(GLuint program, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLint retValue = glContext->hooks->gl.glGetUniformLocation(program, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribfv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribfv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribiv(GLuint index, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribiv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribiv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribPointerv(GLuint index, GLenum pname, void ** pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribPointerv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribPointerv(index, pname, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glHint(GLenum target, GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glHint);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glHint(target, mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsBuffer(GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsBuffer);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsBuffer(buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsEnabled(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsEnabled);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsEnabled(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsFramebuffer(GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsFramebuffer);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsFramebuffer(framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsRenderbuffer(GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsRenderbuffer);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsRenderbuffer(renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsTexture(GLuint texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glLineWidth(GLfloat width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLineWidth);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::FLOAT);
    arg_width->add_floatvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLineWidth(width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLinkProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLinkProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLinkProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPixelStorei(GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPixelStorei);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPixelStorei(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPolygonOffset(GLfloat factor, GLfloat units) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPolygonOffset);

    // copy argument factor
    GLMessage_DataType *arg_factor = glmsg.add_args();
    arg_factor->set_isarray(false);
    arg_factor->set_type(GLMessage::DataType::FLOAT);
    arg_factor->add_floatvalue(factor);

    // copy argument units
    GLMessage_DataType *arg_units = glmsg.add_args();
    arg_units->set_isarray(false);
    arg_units->set_type(GLMessage::DataType::FLOAT);
    arg_units->add_floatvalue(units);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPolygonOffset(factor, units);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadPixels);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadPixels(x, y, width, height, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReleaseShaderCompiler(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReleaseShaderCompiler);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReleaseShaderCompiler();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorage);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorage(target, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleCoverage(GLfloat value, GLboolean invert) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleCoverage);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::FLOAT);
    arg_value->add_floatvalue(value);

    // copy argument invert
    GLMessage_DataType *arg_invert = glmsg.add_args();
    arg_invert->set_isarray(false);
    arg_invert->set_type(GLMessage::DataType::BOOL);
    arg_invert->add_boolvalue(invert);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleCoverage(value, invert);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScissor(GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScissor);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScissor(x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShaderBinary(GLsizei count, const GLuint * shaders, GLenum binaryformat, const void * binary, GLsizei length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShaderBinary);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT64);
    arg_shaders->add_int64value((uintptr_t)shaders);

    // copy argument binaryformat
    GLMessage_DataType *arg_binaryformat = glmsg.add_args();
    arg_binaryformat->set_isarray(false);
    arg_binaryformat->set_type(GLMessage::DataType::ENUM);
    arg_binaryformat->add_intvalue((int)binaryformat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT64);
    arg_binary->add_int64value((uintptr_t)binary);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShaderBinary(count, shaders, binaryformat, binary, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) shaders,
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShaderSource(GLuint shader, GLsizei count, const GLchar *const* string, const GLint * length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShaderSource);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument string
    GLMessage_DataType *arg_string = glmsg.add_args();
    arg_string->set_isarray(false);
    arg_string->set_type(GLMessage::DataType::INT64);
    arg_string->add_int64value((uintptr_t)string);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShaderSource(shader, count, string, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) string,
        (void *) length,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilFunc(GLenum func, GLint ref, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilFunc(func, ref, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilFuncSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilFuncSeparate(face, func, ref, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilMask(GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilMask);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilMask(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilMaskSeparate(GLenum face, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilMaskSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilMaskSeparate(face, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilOp);

    // copy argument fail
    GLMessage_DataType *arg_fail = glmsg.add_args();
    arg_fail->set_isarray(false);
    arg_fail->set_type(GLMessage::DataType::ENUM);
    arg_fail->add_intvalue((int)fail);

    // copy argument zfail
    GLMessage_DataType *arg_zfail = glmsg.add_args();
    arg_zfail->set_isarray(false);
    arg_zfail->set_type(GLMessage::DataType::ENUM);
    arg_zfail->add_intvalue((int)zfail);

    // copy argument zpass
    GLMessage_DataType *arg_zpass = glmsg.add_args();
    arg_zpass->set_isarray(false);
    arg_zpass->set_type(GLMessage::DataType::ENUM);
    arg_zpass->add_intvalue((int)zpass);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilOp(fail, zfail, zpass);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilOpSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument sfail
    GLMessage_DataType *arg_sfail = glmsg.add_args();
    arg_sfail->set_isarray(false);
    arg_sfail->set_type(GLMessage::DataType::ENUM);
    arg_sfail->add_intvalue((int)sfail);

    // copy argument dpfail
    GLMessage_DataType *arg_dpfail = glmsg.add_args();
    arg_dpfail->set_isarray(false);
    arg_dpfail->set_type(GLMessage::DataType::ENUM);
    arg_dpfail->add_intvalue((int)dpfail);

    // copy argument dppass
    GLMessage_DataType *arg_dppass = glmsg.add_args();
    arg_dppass->set_isarray(false);
    arg_dppass->set_type(GLMessage::DataType::ENUM);
    arg_dppass->add_intvalue((int)dppass);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilOpSeparate(face, sfail, dpfail, dppass);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::INT);
    arg_internalformat->add_intvalue(internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterf(GLenum target, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterf);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterf(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterfv(GLenum target, GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameteri(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameteri);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameteri(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameteriv(GLenum target, GLenum pname, const GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1f(GLint location, GLfloat v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1f(location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1fv(GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1fv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1i(GLint location, GLint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1i(location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1iv(GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1iv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2f(GLint location, GLfloat v0, GLfloat v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2f(location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2fv(GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2fv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2i(GLint location, GLint v0, GLint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2i(location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2iv(GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2iv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3f(location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3fv(GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3fv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3i(GLint location, GLint v0, GLint v1, GLint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3i(location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3iv(GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3iv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::FLOAT);
    arg_v3->add_floatvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4f(location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4fv(GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4fv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4i(location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4iv(GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4iv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUseProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUseProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUseProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glValidateProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glValidateProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glValidateProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib1f(GLuint index, GLfloat x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib1f);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib1f(index, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib1fv(GLuint index, const GLfloat * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib1fv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib1fv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib2f);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib2f(index, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib2fv(GLuint index, const GLfloat * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib2fv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib2fv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib3f);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib3f(index, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib3fv(GLuint index, const GLfloat * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib3fv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib3fv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib4f);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::FLOAT);
    arg_w->add_floatvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib4f(index, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib4fv(GLuint index, const GLfloat * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib4fv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib4fv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribPointer);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument normalized
    GLMessage_DataType *arg_normalized = glmsg.add_args();
    arg_normalized->set_isarray(false);
    arg_normalized->set_type(GLMessage::DataType::BOOL);
    arg_normalized->add_boolvalue(normalized);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glViewport(GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glViewport);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glViewport(x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadBuffer(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadBuffer);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadBuffer(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawRangeElements);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument start
    GLMessage_DataType *arg_start = glmsg.add_args();
    arg_start->set_isarray(false);
    arg_start->set_type(GLMessage::DataType::INT);
    arg_start->add_intvalue(start);

    // copy argument end
    GLMessage_DataType *arg_end = glmsg.add_args();
    arg_end->set_isarray(false);
    arg_end->set_type(GLMessage::DataType::INT);
    arg_end->add_intvalue(end);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawRangeElements(mode, start, end, count, type, indices);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexImage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::INT);
    arg_internalformat->add_intvalue(internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexSubImage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexSubImage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexImage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexSubImage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenQueries(GLsizei n, GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenQueries);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenQueries(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteQueries(GLsizei n, const GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteQueries);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteQueries(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsQuery(GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsQuery);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsQuery(id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBeginQuery(GLenum target, GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginQuery);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginQuery(target, id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndQuery(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndQuery);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndQuery(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryiv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryiv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryiv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjectuiv);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjectuiv(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glUnmapBuffer(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUnmapBuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glUnmapBuffer(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetBufferPointerv(GLenum target, GLenum pname, void ** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferPointerv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferPointerv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawBuffers(GLsizei n, const GLenum * bufs) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawBuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument bufs
    GLMessage_DataType *arg_bufs = glmsg.add_args();
    arg_bufs->set_isarray(false);
    arg_bufs->set_type(GLMessage::DataType::INT64);
    arg_bufs->add_int64value((uintptr_t)bufs);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawBuffers(n, bufs);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) bufs,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2x3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2x3fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3x2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3x2fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2x4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2x4fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4x2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4x2fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3x4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3x4fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4x3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4x3fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlitFramebuffer);

    // copy argument srcX0
    GLMessage_DataType *arg_srcX0 = glmsg.add_args();
    arg_srcX0->set_isarray(false);
    arg_srcX0->set_type(GLMessage::DataType::INT);
    arg_srcX0->add_intvalue(srcX0);

    // copy argument srcY0
    GLMessage_DataType *arg_srcY0 = glmsg.add_args();
    arg_srcY0->set_isarray(false);
    arg_srcY0->set_type(GLMessage::DataType::INT);
    arg_srcY0->add_intvalue(srcY0);

    // copy argument srcX1
    GLMessage_DataType *arg_srcX1 = glmsg.add_args();
    arg_srcX1->set_isarray(false);
    arg_srcX1->set_type(GLMessage::DataType::INT);
    arg_srcX1->add_intvalue(srcX1);

    // copy argument srcY1
    GLMessage_DataType *arg_srcY1 = glmsg.add_args();
    arg_srcY1->set_isarray(false);
    arg_srcY1->set_type(GLMessage::DataType::INT);
    arg_srcY1->add_intvalue(srcY1);

    // copy argument dstX0
    GLMessage_DataType *arg_dstX0 = glmsg.add_args();
    arg_dstX0->set_isarray(false);
    arg_dstX0->set_type(GLMessage::DataType::INT);
    arg_dstX0->add_intvalue(dstX0);

    // copy argument dstY0
    GLMessage_DataType *arg_dstY0 = glmsg.add_args();
    arg_dstY0->set_isarray(false);
    arg_dstY0->set_type(GLMessage::DataType::INT);
    arg_dstY0->add_intvalue(dstY0);

    // copy argument dstX1
    GLMessage_DataType *arg_dstX1 = glmsg.add_args();
    arg_dstX1->set_isarray(false);
    arg_dstX1->set_type(GLMessage::DataType::INT);
    arg_dstX1->add_intvalue(dstX1);

    // copy argument dstY1
    GLMessage_DataType *arg_dstY1 = glmsg.add_args();
    arg_dstY1->set_isarray(false);
    arg_dstY1->set_type(GLMessage::DataType::INT);
    arg_dstY1->add_intvalue(dstY1);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // copy argument filter
    GLMessage_DataType *arg_filter = glmsg.add_args();
    arg_filter->set_isarray(false);
    arg_filter->set_type(GLMessage::DataType::ENUM);
    arg_filter->add_intvalue((int)filter);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisample);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisample(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTextureLayer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument layer
    GLMessage_DataType *arg_layer = glmsg.add_args();
    arg_layer->set_isarray(false);
    arg_layer->set_type(GLMessage::DataType::INT);
    arg_layer->add_intvalue(layer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTextureLayer(target, attachment, texture, level, layer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void * GLTrace_glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMapBufferRange);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument access
    GLMessage_DataType *arg_access = glmsg.add_args();
    arg_access->set_isarray(false);
    arg_access->set_type(GLMessage::DataType::INT);
    arg_access->add_intvalue(access);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    void * retValue = glContext->hooks->gl.glMapBufferRange(target, offset, length, access);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFlushMappedBufferRange);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFlushMappedBufferRange(target, offset, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindVertexArray(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindVertexArray);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindVertexArray(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteVertexArrays(GLsizei n, const GLuint * arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteVertexArrays);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT64);
    arg_arrays->add_int64value((uintptr_t)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteVertexArrays(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenVertexArrays(GLsizei n, GLuint * arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenVertexArrays);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT64);
    arg_arrays->add_int64value((uintptr_t)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenVertexArrays(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsVertexArray(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsVertexArray);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsVertexArray(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetIntegeri_v(GLenum target, GLuint index, GLint * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetIntegeri_v);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetIntegeri_v(target, index, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBeginTransformFeedback(GLenum primitiveMode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginTransformFeedback);

    // copy argument primitiveMode
    GLMessage_DataType *arg_primitiveMode = glmsg.add_args();
    arg_primitiveMode->set_isarray(false);
    arg_primitiveMode->set_type(GLMessage::DataType::ENUM);
    arg_primitiveMode->add_intvalue((int)primitiveMode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginTransformFeedback(primitiveMode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndTransformFeedback(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndTransformFeedback);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndTransformFeedback();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindBufferRange);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindBufferRange(target, index, buffer, offset, size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindBufferBase(GLenum target, GLuint index, GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindBufferBase);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindBufferBase(target, index, buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar *const* varyings, GLenum bufferMode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTransformFeedbackVaryings);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument varyings
    GLMessage_DataType *arg_varyings = glmsg.add_args();
    arg_varyings->set_isarray(false);
    arg_varyings->set_type(GLMessage::DataType::INT64);
    arg_varyings->add_int64value((uintptr_t)varyings);

    // copy argument bufferMode
    GLMessage_DataType *arg_bufferMode = glmsg.add_args();
    arg_bufferMode->set_isarray(false);
    arg_bufferMode->set_type(GLMessage::DataType::ENUM);
    arg_bufferMode->add_intvalue((int)bufferMode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTransformFeedbackVaryings(program, count, varyings, bufferMode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) varyings,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTransformFeedbackVarying);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT64);
    arg_size->add_int64value((uintptr_t)size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::INT64);
    arg_type->add_int64value((uintptr_t)type);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) size,
        (void *) type,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribIPointer);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribIPointer(index, size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribIiv(GLuint index, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribIiv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribIiv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribIuiv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribIuiv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribI4i);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::INT);
    arg_w->add_intvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribI4i(index, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribI4ui);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::INT);
    arg_w->add_intvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribI4ui(index, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribI4iv(GLuint index, const GLint * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribI4iv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribI4iv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribI4uiv(GLuint index, const GLuint * v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribI4uiv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT64);
    arg_v->add_int64value((uintptr_t)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribI4uiv(index, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformuiv(GLuint program, GLint location, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformuiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformuiv(program, location, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLint GLTrace_glGetFragDataLocation(GLuint program, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFragDataLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLint retValue = glContext->hooks->gl.glGetFragDataLocation(program, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glUniform1ui(GLint location, GLuint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1ui);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1ui(location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2ui(GLint location, GLuint v0, GLuint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2ui);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2ui(location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3ui);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3ui(location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4ui);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4ui(location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1uiv(GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1uiv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1uiv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2uiv(GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2uiv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2uiv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3uiv(GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3uiv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3uiv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4uiv(GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4uiv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4uiv(location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearBufferiv);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::ENUM);
    arg_buffer->add_intvalue((int)buffer);

    // copy argument drawbuffer
    GLMessage_DataType *arg_drawbuffer = glmsg.add_args();
    arg_drawbuffer->set_isarray(false);
    arg_drawbuffer->set_type(GLMessage::DataType::INT);
    arg_drawbuffer->add_intvalue(drawbuffer);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearBufferiv(buffer, drawbuffer, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearBufferuiv);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::ENUM);
    arg_buffer->add_intvalue((int)buffer);

    // copy argument drawbuffer
    GLMessage_DataType *arg_drawbuffer = glmsg.add_args();
    arg_drawbuffer->set_isarray(false);
    arg_drawbuffer->set_type(GLMessage::DataType::INT);
    arg_drawbuffer->add_intvalue(drawbuffer);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearBufferuiv(buffer, drawbuffer, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearBufferfv);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::ENUM);
    arg_buffer->add_intvalue((int)buffer);

    // copy argument drawbuffer
    GLMessage_DataType *arg_drawbuffer = glmsg.add_args();
    arg_drawbuffer->set_isarray(false);
    arg_drawbuffer->set_type(GLMessage::DataType::INT);
    arg_drawbuffer->add_intvalue(drawbuffer);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearBufferfv(buffer, drawbuffer, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearBufferfi);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::ENUM);
    arg_buffer->add_intvalue((int)buffer);

    // copy argument drawbuffer
    GLMessage_DataType *arg_drawbuffer = glmsg.add_args();
    arg_drawbuffer->set_isarray(false);
    arg_drawbuffer->set_type(GLMessage::DataType::INT);
    arg_drawbuffer->add_intvalue(drawbuffer);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::FLOAT);
    arg_depth->add_floatvalue(depth);

    // copy argument stencil
    GLMessage_DataType *arg_stencil = glmsg.add_args();
    arg_stencil->set_isarray(false);
    arg_stencil->set_type(GLMessage::DataType::INT);
    arg_stencil->add_intvalue(stencil);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearBufferfi(buffer, drawbuffer, depth, stencil);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

const GLubyte * GLTrace_glGetStringi(GLenum name, GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetStringi);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::ENUM);
    arg_name->add_intvalue((int)name);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    const GLubyte * retValue = glContext->hooks->gl.glGetStringi(name, index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyBufferSubData);

    // copy argument readTarget
    GLMessage_DataType *arg_readTarget = glmsg.add_args();
    arg_readTarget->set_isarray(false);
    arg_readTarget->set_type(GLMessage::DataType::ENUM);
    arg_readTarget->add_intvalue((int)readTarget);

    // copy argument writeTarget
    GLMessage_DataType *arg_writeTarget = glmsg.add_args();
    arg_writeTarget->set_isarray(false);
    arg_writeTarget->set_type(GLMessage::DataType::ENUM);
    arg_writeTarget->add_intvalue((int)writeTarget);

    // copy argument readOffset
    GLMessage_DataType *arg_readOffset = glmsg.add_args();
    arg_readOffset->set_isarray(false);
    arg_readOffset->set_type(GLMessage::DataType::INT);
    arg_readOffset->add_intvalue(readOffset);

    // copy argument writeOffset
    GLMessage_DataType *arg_writeOffset = glmsg.add_args();
    arg_writeOffset->set_isarray(false);
    arg_writeOffset->set_type(GLMessage::DataType::INT);
    arg_writeOffset->add_intvalue(writeOffset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar *const* uniformNames, GLuint * uniformIndices) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformIndices);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformCount
    GLMessage_DataType *arg_uniformCount = glmsg.add_args();
    arg_uniformCount->set_isarray(false);
    arg_uniformCount->set_type(GLMessage::DataType::INT);
    arg_uniformCount->add_intvalue(uniformCount);

    // copy argument uniformNames
    GLMessage_DataType *arg_uniformNames = glmsg.add_args();
    arg_uniformNames->set_isarray(false);
    arg_uniformNames->set_type(GLMessage::DataType::INT64);
    arg_uniformNames->add_int64value((uintptr_t)uniformNames);

    // copy argument uniformIndices
    GLMessage_DataType *arg_uniformIndices = glmsg.add_args();
    arg_uniformIndices->set_isarray(false);
    arg_uniformIndices->set_type(GLMessage::DataType::INT64);
    arg_uniformIndices->add_int64value((uintptr_t)uniformIndices);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) uniformNames,
        (void *) uniformIndices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveUniformsiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformCount
    GLMessage_DataType *arg_uniformCount = glmsg.add_args();
    arg_uniformCount->set_isarray(false);
    arg_uniformCount->set_type(GLMessage::DataType::INT);
    arg_uniformCount->add_intvalue(uniformCount);

    // copy argument uniformIndices
    GLMessage_DataType *arg_uniformIndices = glmsg.add_args();
    arg_uniformIndices->set_isarray(false);
    arg_uniformIndices->set_type(GLMessage::DataType::INT64);
    arg_uniformIndices->add_int64value((uintptr_t)uniformIndices);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) uniformIndices,
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glGetUniformBlockIndex(GLuint program, const GLchar * uniformBlockName) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformBlockIndex);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformBlockName
    GLMessage_DataType *arg_uniformBlockName = glmsg.add_args();
    arg_uniformBlockName->set_isarray(false);
    arg_uniformBlockName->set_type(GLMessage::DataType::INT64);
    arg_uniformBlockName->add_int64value((uintptr_t)uniformBlockName);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glGetUniformBlockIndex(program, uniformBlockName);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) uniformBlockName,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveUniformBlockiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformBlockIndex
    GLMessage_DataType *arg_uniformBlockIndex = glmsg.add_args();
    arg_uniformBlockIndex->set_isarray(false);
    arg_uniformBlockIndex->set_type(GLMessage::DataType::INT);
    arg_uniformBlockIndex->add_intvalue(uniformBlockIndex);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveUniformBlockName);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformBlockIndex
    GLMessage_DataType *arg_uniformBlockIndex = glmsg.add_args();
    arg_uniformBlockIndex->set_isarray(false);
    arg_uniformBlockIndex->set_type(GLMessage::DataType::INT);
    arg_uniformBlockIndex->add_intvalue(uniformBlockIndex);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument uniformBlockName
    GLMessage_DataType *arg_uniformBlockName = glmsg.add_args();
    arg_uniformBlockName->set_isarray(false);
    arg_uniformBlockName->set_type(GLMessage::DataType::INT64);
    arg_uniformBlockName->add_int64value((uintptr_t)uniformBlockName);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) uniformBlockName,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformBlockBinding);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument uniformBlockIndex
    GLMessage_DataType *arg_uniformBlockIndex = glmsg.add_args();
    arg_uniformBlockIndex->set_isarray(false);
    arg_uniformBlockIndex->set_type(GLMessage::DataType::INT);
    arg_uniformBlockIndex->add_intvalue(uniformBlockIndex);

    // copy argument uniformBlockBinding
    GLMessage_DataType *arg_uniformBlockBinding = glmsg.add_args();
    arg_uniformBlockBinding->set_isarray(false);
    arg_uniformBlockBinding->set_type(GLMessage::DataType::INT);
    arg_uniformBlockBinding->add_intvalue(uniformBlockBinding);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArraysInstanced);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue(first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument instancecount
    GLMessage_DataType *arg_instancecount = glmsg.add_args();
    arg_instancecount->set_isarray(false);
    arg_instancecount->set_type(GLMessage::DataType::INT);
    arg_instancecount->add_intvalue(instancecount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArraysInstanced(mode, first, count, instancecount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElementsInstanced);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // copy argument instancecount
    GLMessage_DataType *arg_instancecount = glmsg.add_args();
    arg_instancecount->set_isarray(false);
    arg_instancecount->set_type(GLMessage::DataType::INT);
    arg_instancecount->add_intvalue(instancecount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElementsInstanced(mode, count, type, indices, instancecount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLsync GLTrace_glFenceSync(GLenum condition, GLbitfield flags) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFenceSync);

    // copy argument condition
    GLMessage_DataType *arg_condition = glmsg.add_args();
    arg_condition->set_isarray(false);
    arg_condition->set_type(GLMessage::DataType::ENUM);
    arg_condition->add_intvalue((int)condition);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLsync retValue = glContext->hooks->gl.glFenceSync(condition, flags);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsSync(GLsync sync) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsSync);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsSync(sync);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glDeleteSync(GLsync sync) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteSync);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteSync(sync);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClientWaitSync);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // copy argument timeout
    GLMessage_DataType *arg_timeout = glmsg.add_args();
    arg_timeout->set_isarray(false);
    arg_timeout->set_type(GLMessage::DataType::INT64);
    arg_timeout->add_int64value(timeout);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glClientWaitSync(sync, flags, timeout);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glWaitSync);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // copy argument timeout
    GLMessage_DataType *arg_timeout = glmsg.add_args();
    arg_timeout->set_isarray(false);
    arg_timeout->set_type(GLMessage::DataType::INT64);
    arg_timeout->add_int64value(timeout);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glWaitSync(sync, flags, timeout);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetInteger64v(GLenum pname, GLint64 * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetInteger64v);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetInteger64v(pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSynciv);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT64);
    arg_values->add_int64value((uintptr_t)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSynciv(sync, pname, bufSize, length, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
        (void *) length,
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetInteger64i_v(GLenum target, GLuint index, GLint64 * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetInteger64i_v);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetInteger64i_v(target, index, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferParameteri64v);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferParameteri64v(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenSamplers(GLsizei count, GLuint * samplers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenSamplers);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument samplers
    GLMessage_DataType *arg_samplers = glmsg.add_args();
    arg_samplers->set_isarray(false);
    arg_samplers->set_type(GLMessage::DataType::INT64);
    arg_samplers->add_int64value((uintptr_t)samplers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenSamplers(count, samplers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) samplers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteSamplers(GLsizei count, const GLuint * samplers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteSamplers);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument samplers
    GLMessage_DataType *arg_samplers = glmsg.add_args();
    arg_samplers->set_isarray(false);
    arg_samplers->set_type(GLMessage::DataType::INT64);
    arg_samplers->add_int64value((uintptr_t)samplers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteSamplers(count, samplers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) samplers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsSampler(GLuint sampler) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsSampler);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsSampler(sampler);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBindSampler(GLuint unit, GLuint sampler) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindSampler);

    // copy argument unit
    GLMessage_DataType *arg_unit = glmsg.add_args();
    arg_unit->set_isarray(false);
    arg_unit->set_type(GLMessage::DataType::INT);
    arg_unit->add_intvalue(unit);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindSampler(unit, sampler);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameteri(GLuint sampler, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameteri);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameteri(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameteriv);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameteriv(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameterf);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameterf(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameterfv);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameterfv(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSamplerParameteriv);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSamplerParameteriv(sampler, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSamplerParameterfv);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSamplerParameterfv(sampler, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribDivisor(GLuint index, GLuint divisor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribDivisor);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument divisor
    GLMessage_DataType *arg_divisor = glmsg.add_args();
    arg_divisor->set_isarray(false);
    arg_divisor->set_type(GLMessage::DataType::INT);
    arg_divisor->add_intvalue(divisor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribDivisor(index, divisor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindTransformFeedback(GLenum target, GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindTransformFeedback);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindTransformFeedback(target, id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteTransformFeedbacks(GLsizei n, const GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteTransformFeedbacks);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteTransformFeedbacks(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenTransformFeedbacks(GLsizei n, GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenTransformFeedbacks);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenTransformFeedbacks(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsTransformFeedback(GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsTransformFeedback);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsTransformFeedback(id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glPauseTransformFeedback(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPauseTransformFeedback);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPauseTransformFeedback();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glResumeTransformFeedback(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glResumeTransformFeedback);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glResumeTransformFeedback();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, void * binary) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramBinary);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::INT64);
    arg_binaryFormat->add_int64value((uintptr_t)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT64);
    arg_binary->add_int64value((uintptr_t)binary);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramBinary(program, bufSize, length, binaryFormat, binary);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) binaryFormat,
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramBinary(GLuint program, GLenum binaryFormat, const void * binary, GLsizei length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramBinary);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::ENUM);
    arg_binaryFormat->add_intvalue((int)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT64);
    arg_binary->add_int64value((uintptr_t)binary);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramBinary(program, binaryFormat, binary, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramParameteri(GLuint program, GLenum pname, GLint value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramParameteri);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramParameteri(program, pname, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glInvalidateFramebuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument numAttachments
    GLMessage_DataType *arg_numAttachments = glmsg.add_args();
    arg_numAttachments->set_isarray(false);
    arg_numAttachments->set_type(GLMessage::DataType::INT);
    arg_numAttachments->add_intvalue(numAttachments);

    // copy argument attachments
    GLMessage_DataType *arg_attachments = glmsg.add_args();
    arg_attachments->set_isarray(false);
    arg_attachments->set_type(GLMessage::DataType::INT64);
    arg_attachments->add_int64value((uintptr_t)attachments);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glInvalidateFramebuffer(target, numAttachments, attachments);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) attachments,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glInvalidateSubFramebuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument numAttachments
    GLMessage_DataType *arg_numAttachments = glmsg.add_args();
    arg_numAttachments->set_isarray(false);
    arg_numAttachments->set_type(GLMessage::DataType::INT);
    arg_numAttachments->add_intvalue(numAttachments);

    // copy argument attachments
    GLMessage_DataType *arg_attachments = glmsg.add_args();
    arg_attachments->set_isarray(false);
    arg_attachments->set_type(GLMessage::DataType::INT64);
    arg_attachments->add_int64value((uintptr_t)attachments);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) attachments,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage2D(target, levels, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage3D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage3D(target, levels, internalformat, width, height, depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetInternalformativ);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetInternalformativ(target, internalformat, pname, bufSize, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDispatchCompute);

    // copy argument num_groups_x
    GLMessage_DataType *arg_num_groups_x = glmsg.add_args();
    arg_num_groups_x->set_isarray(false);
    arg_num_groups_x->set_type(GLMessage::DataType::INT);
    arg_num_groups_x->add_intvalue(num_groups_x);

    // copy argument num_groups_y
    GLMessage_DataType *arg_num_groups_y = glmsg.add_args();
    arg_num_groups_y->set_isarray(false);
    arg_num_groups_y->set_type(GLMessage::DataType::INT);
    arg_num_groups_y->add_intvalue(num_groups_y);

    // copy argument num_groups_z
    GLMessage_DataType *arg_num_groups_z = glmsg.add_args();
    arg_num_groups_z->set_isarray(false);
    arg_num_groups_z->set_type(GLMessage::DataType::INT);
    arg_num_groups_z->add_intvalue(num_groups_z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDispatchCompute(num_groups_x, num_groups_y, num_groups_z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDispatchComputeIndirect(GLintptr indirect) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDispatchComputeIndirect);

    // copy argument indirect
    GLMessage_DataType *arg_indirect = glmsg.add_args();
    arg_indirect->set_isarray(false);
    arg_indirect->set_type(GLMessage::DataType::INT);
    arg_indirect->add_intvalue(indirect);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDispatchComputeIndirect(indirect);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArraysIndirect(GLenum mode, const void * indirect) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArraysIndirect);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument indirect
    GLMessage_DataType *arg_indirect = glmsg.add_args();
    arg_indirect->set_isarray(false);
    arg_indirect->set_type(GLMessage::DataType::INT64);
    arg_indirect->add_int64value((uintptr_t)indirect);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArraysIndirect(mode, indirect);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indirect,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElementsIndirect(GLenum mode, GLenum type, const void * indirect) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElementsIndirect);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indirect
    GLMessage_DataType *arg_indirect = glmsg.add_args();
    arg_indirect->set_isarray(false);
    arg_indirect->set_type(GLMessage::DataType::INT64);
    arg_indirect->add_int64value((uintptr_t)indirect);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElementsIndirect(mode, type, indirect);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indirect,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferParameteri(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferParameteri);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferParameteri(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFramebufferParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFramebufferParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramInterfaceiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument programInterface
    GLMessage_DataType *arg_programInterface = glmsg.add_args();
    arg_programInterface->set_isarray(false);
    arg_programInterface->set_type(GLMessage::DataType::ENUM);
    arg_programInterface->add_intvalue((int)programInterface);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramInterfaceiv(program, programInterface, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramResourceIndex);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument programInterface
    GLMessage_DataType *arg_programInterface = glmsg.add_args();
    arg_programInterface->set_isarray(false);
    arg_programInterface->set_type(GLMessage::DataType::ENUM);
    arg_programInterface->add_intvalue((int)programInterface);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glGetProgramResourceIndex(program, programInterface, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei * length, GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramResourceName);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument programInterface
    GLMessage_DataType *arg_programInterface = glmsg.add_args();
    arg_programInterface->set_isarray(false);
    arg_programInterface->set_type(GLMessage::DataType::ENUM);
    arg_programInterface->add_intvalue((int)programInterface);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramResourceName(program, programInterface, index, bufSize, length, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum * props, GLsizei bufSize, GLsizei * length, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramResourceiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument programInterface
    GLMessage_DataType *arg_programInterface = glmsg.add_args();
    arg_programInterface->set_isarray(false);
    arg_programInterface->set_type(GLMessage::DataType::ENUM);
    arg_programInterface->add_intvalue((int)programInterface);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument propCount
    GLMessage_DataType *arg_propCount = glmsg.add_args();
    arg_propCount->set_isarray(false);
    arg_propCount->set_type(GLMessage::DataType::INT);
    arg_propCount->add_intvalue(propCount);

    // copy argument props
    GLMessage_DataType *arg_props = glmsg.add_args();
    arg_props->set_isarray(false);
    arg_props->set_type(GLMessage::DataType::INT64);
    arg_props->add_int64value((uintptr_t)props);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramResourceiv(program, programInterface, index, propCount, props, bufSize, length, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) props,
        (void *) length,
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLint GLTrace_glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar * name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramResourceLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument programInterface
    GLMessage_DataType *arg_programInterface = glmsg.add_args();
    arg_programInterface->set_isarray(false);
    arg_programInterface->set_type(GLMessage::DataType::ENUM);
    arg_programInterface->add_intvalue((int)programInterface);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT64);
    arg_name->add_int64value((uintptr_t)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLint retValue = glContext->hooks->gl.glGetProgramResourceLocation(program, programInterface, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUseProgramStages);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument stages
    GLMessage_DataType *arg_stages = glmsg.add_args();
    arg_stages->set_isarray(false);
    arg_stages->set_type(GLMessage::DataType::INT);
    arg_stages->add_intvalue(stages);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUseProgramStages(pipeline, stages, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glActiveShaderProgram(GLuint pipeline, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glActiveShaderProgram);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glActiveShaderProgram(pipeline, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const* strings) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateShaderProgramv);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument strings
    GLMessage_DataType *arg_strings = glmsg.add_args();
    arg_strings->set_isarray(false);
    arg_strings->set_type(GLMessage::DataType::INT64);
    arg_strings->add_int64value((uintptr_t)strings);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateShaderProgramv(type, count, strings);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) strings,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBindProgramPipeline(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindProgramPipeline);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindProgramPipeline(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteProgramPipelines(GLsizei n, const GLuint * pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteProgramPipelines);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT64);
    arg_pipelines->add_int64value((uintptr_t)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteProgramPipelines(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenProgramPipelines(GLsizei n, GLuint * pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenProgramPipelines);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT64);
    arg_pipelines->add_int64value((uintptr_t)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenProgramPipelines(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsProgramPipeline(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsProgramPipeline);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsProgramPipeline(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineiv);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineiv(pipeline, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1i(GLuint program, GLint location, GLint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1i);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1i(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2i);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2i(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3i);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3i(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4i);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4i(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1ui(GLuint program, GLint location, GLuint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1ui);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1ui(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2ui);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2ui(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3ui);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3ui(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4ui);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4ui(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1f(GLuint program, GLint location, GLfloat v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1f);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1f(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2f);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2f(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3f);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3f(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4f);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::FLOAT);
    arg_v3->add_floatvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4f(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1iv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1iv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2iv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2iv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3iv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3iv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4iv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4iv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1uiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1uiv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2uiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2uiv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3uiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3uiv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4uiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4uiv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1fv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2fv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3fv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4fv(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2x3fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2x3fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3x2fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3x2fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2x4fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2x4fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4x2fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4x2fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3x4fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3x4fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4x3fv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4x3fv(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glValidateProgramPipeline(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glValidateProgramPipeline);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glValidateProgramPipeline(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineInfoLog);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument infoLog
    GLMessage_DataType *arg_infoLog = glmsg.add_args();
    arg_infoLog->set_isarray(false);
    arg_infoLog->set_type(GLMessage::DataType::INT64);
    arg_infoLog->add_int64value((uintptr_t)infoLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infoLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindImageTexture);

    // copy argument unit
    GLMessage_DataType *arg_unit = glmsg.add_args();
    arg_unit->set_isarray(false);
    arg_unit->set_type(GLMessage::DataType::INT);
    arg_unit->add_intvalue(unit);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument layered
    GLMessage_DataType *arg_layered = glmsg.add_args();
    arg_layered->set_isarray(false);
    arg_layered->set_type(GLMessage::DataType::BOOL);
    arg_layered->add_boolvalue(layered);

    // copy argument layer
    GLMessage_DataType *arg_layer = glmsg.add_args();
    arg_layer->set_isarray(false);
    arg_layer->set_type(GLMessage::DataType::INT);
    arg_layer->add_intvalue(layer);

    // copy argument access
    GLMessage_DataType *arg_access = glmsg.add_args();
    arg_access->set_isarray(false);
    arg_access->set_type(GLMessage::DataType::ENUM);
    arg_access->add_intvalue((int)access);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindImageTexture(unit, texture, level, layered, layer, access, format);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetBooleani_v(GLenum target, GLuint index, GLboolean * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBooleani_v);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBooleani_v(target, index, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMemoryBarrier(GLbitfield barriers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMemoryBarrier);

    // copy argument barriers
    GLMessage_DataType *arg_barriers = glmsg.add_args();
    arg_barriers->set_isarray(false);
    arg_barriers->set_type(GLMessage::DataType::INT);
    arg_barriers->add_intvalue(barriers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMemoryBarrier(barriers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMemoryBarrierByRegion(GLbitfield barriers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMemoryBarrierByRegion);

    // copy argument barriers
    GLMessage_DataType *arg_barriers = glmsg.add_args();
    arg_barriers->set_isarray(false);
    arg_barriers->set_type(GLMessage::DataType::INT);
    arg_barriers->add_intvalue(barriers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMemoryBarrierByRegion(barriers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage2DMultisample);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument fixedsamplelocations
    GLMessage_DataType *arg_fixedsamplelocations = glmsg.add_args();
    arg_fixedsamplelocations->set_isarray(false);
    arg_fixedsamplelocations->set_type(GLMessage::DataType::BOOL);
    arg_fixedsamplelocations->add_boolvalue(fixedsamplelocations);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMultisamplefv(GLenum pname, GLuint index, GLfloat * val) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMultisamplefv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument val
    GLMessage_DataType *arg_val = glmsg.add_args();
    arg_val->set_isarray(false);
    arg_val->set_type(GLMessage::DataType::INT64);
    arg_val->add_int64value((uintptr_t)val);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMultisamplefv(pname, index, val);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) val,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleMaski(GLuint maskNumber, GLbitfield mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleMaski);

    // copy argument maskNumber
    GLMessage_DataType *arg_maskNumber = glmsg.add_args();
    arg_maskNumber->set_isarray(false);
    arg_maskNumber->set_type(GLMessage::DataType::INT);
    arg_maskNumber->add_intvalue(maskNumber);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleMaski(maskNumber, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexLevelParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexLevelParameteriv(target, level, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexLevelParameterfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexLevelParameterfv(target, level, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindVertexBuffer);

    // copy argument bindingindex
    GLMessage_DataType *arg_bindingindex = glmsg.add_args();
    arg_bindingindex->set_isarray(false);
    arg_bindingindex->set_type(GLMessage::DataType::INT);
    arg_bindingindex->add_intvalue(bindingindex);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindVertexBuffer(bindingindex, buffer, offset, stride);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribFormat);

    // copy argument attribindex
    GLMessage_DataType *arg_attribindex = glmsg.add_args();
    arg_attribindex->set_isarray(false);
    arg_attribindex->set_type(GLMessage::DataType::INT);
    arg_attribindex->add_intvalue(attribindex);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument normalized
    GLMessage_DataType *arg_normalized = glmsg.add_args();
    arg_normalized->set_isarray(false);
    arg_normalized->set_type(GLMessage::DataType::BOOL);
    arg_normalized->add_boolvalue(normalized);

    // copy argument relativeoffset
    GLMessage_DataType *arg_relativeoffset = glmsg.add_args();
    arg_relativeoffset->set_isarray(false);
    arg_relativeoffset->set_type(GLMessage::DataType::INT);
    arg_relativeoffset->add_intvalue(relativeoffset);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribIFormat);

    // copy argument attribindex
    GLMessage_DataType *arg_attribindex = glmsg.add_args();
    arg_attribindex->set_isarray(false);
    arg_attribindex->set_type(GLMessage::DataType::INT);
    arg_attribindex->add_intvalue(attribindex);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument relativeoffset
    GLMessage_DataType *arg_relativeoffset = glmsg.add_args();
    arg_relativeoffset->set_isarray(false);
    arg_relativeoffset->set_type(GLMessage::DataType::INT);
    arg_relativeoffset->add_intvalue(relativeoffset);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribIFormat(attribindex, size, type, relativeoffset);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribBinding(GLuint attribindex, GLuint bindingindex) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribBinding);

    // copy argument attribindex
    GLMessage_DataType *arg_attribindex = glmsg.add_args();
    arg_attribindex->set_isarray(false);
    arg_attribindex->set_type(GLMessage::DataType::INT);
    arg_attribindex->add_intvalue(attribindex);

    // copy argument bindingindex
    GLMessage_DataType *arg_bindingindex = glmsg.add_args();
    arg_bindingindex->set_isarray(false);
    arg_bindingindex->set_type(GLMessage::DataType::INT);
    arg_bindingindex->add_intvalue(bindingindex);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribBinding(attribindex, bindingindex);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexBindingDivisor(GLuint bindingindex, GLuint divisor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexBindingDivisor);

    // copy argument bindingindex
    GLMessage_DataType *arg_bindingindex = glmsg.add_args();
    arg_bindingindex->set_isarray(false);
    arg_bindingindex->set_type(GLMessage::DataType::INT);
    arg_bindingindex->add_intvalue(bindingindex);

    // copy argument divisor
    GLMessage_DataType *arg_divisor = glmsg.add_args();
    arg_divisor->set_isarray(false);
    arg_divisor->set_type(GLMessage::DataType::INT);
    arg_divisor->add_intvalue(divisor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexBindingDivisor(bindingindex, divisor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL2Ext APIs

void GLTrace_glBlendBarrierKHR(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendBarrierKHR);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendBarrierKHR();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDebugMessageControlKHR(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDebugMessageControlKHR);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::ENUM);
    arg_source->add_intvalue((int)source);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument severity
    GLMessage_DataType *arg_severity = glmsg.add_args();
    arg_severity->set_isarray(false);
    arg_severity->set_type(GLMessage::DataType::ENUM);
    arg_severity->add_intvalue((int)severity);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // copy argument enabled
    GLMessage_DataType *arg_enabled = glmsg.add_args();
    arg_enabled->set_isarray(false);
    arg_enabled->set_type(GLMessage::DataType::BOOL);
    arg_enabled->add_boolvalue(enabled);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDebugMessageControlKHR(source, type, severity, count, ids, enabled);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDebugMessageInsertKHR(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDebugMessageInsertKHR);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::ENUM);
    arg_source->add_intvalue((int)source);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument severity
    GLMessage_DataType *arg_severity = glmsg.add_args();
    arg_severity->set_isarray(false);
    arg_severity->set_type(GLMessage::DataType::ENUM);
    arg_severity->add_intvalue((int)severity);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument buf
    GLMessage_DataType *arg_buf = glmsg.add_args();
    arg_buf->set_isarray(false);
    arg_buf->set_type(GLMessage::DataType::INT64);
    arg_buf->add_int64value((uintptr_t)buf);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDebugMessageInsertKHR(source, type, id, severity, length, buf);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buf,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void * userParam) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDebugMessageCallbackKHR);

    // copy argument callback
    GLMessage_DataType *arg_callback = glmsg.add_args();
    arg_callback->set_isarray(false);
    arg_callback->set_type(GLMessage::DataType::INT64);
    arg_callback->add_int64value((uintptr_t)callback);

    // copy argument userParam
    GLMessage_DataType *arg_userParam = glmsg.add_args();
    arg_userParam->set_isarray(false);
    arg_userParam->set_type(GLMessage::DataType::INT64);
    arg_userParam->add_int64value((uintptr_t)userParam);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDebugMessageCallbackKHR(callback, userParam);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) callback,
        (void *) userParam,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glGetDebugMessageLogKHR(GLuint count, GLsizei bufSize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetDebugMessageLogKHR);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument sources
    GLMessage_DataType *arg_sources = glmsg.add_args();
    arg_sources->set_isarray(false);
    arg_sources->set_type(GLMessage::DataType::INT64);
    arg_sources->add_int64value((uintptr_t)sources);

    // copy argument types
    GLMessage_DataType *arg_types = glmsg.add_args();
    arg_types->set_isarray(false);
    arg_types->set_type(GLMessage::DataType::INT64);
    arg_types->add_int64value((uintptr_t)types);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // copy argument severities
    GLMessage_DataType *arg_severities = glmsg.add_args();
    arg_severities->set_isarray(false);
    arg_severities->set_type(GLMessage::DataType::INT64);
    arg_severities->add_int64value((uintptr_t)severities);

    // copy argument lengths
    GLMessage_DataType *arg_lengths = glmsg.add_args();
    arg_lengths->set_isarray(false);
    arg_lengths->set_type(GLMessage::DataType::INT64);
    arg_lengths->add_int64value((uintptr_t)lengths);

    // copy argument messageLog
    GLMessage_DataType *arg_messageLog = glmsg.add_args();
    arg_messageLog->set_isarray(false);
    arg_messageLog->set_type(GLMessage::DataType::INT64);
    arg_messageLog->add_int64value((uintptr_t)messageLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glGetDebugMessageLogKHR(count, bufSize, sources, types, ids, severities, lengths, messageLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) sources,
        (void *) types,
        (void *) ids,
        (void *) severities,
        (void *) lengths,
        (void *) messageLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glPushDebugGroupKHR(GLenum source, GLuint id, GLsizei length, const GLchar * message) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPushDebugGroupKHR);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::ENUM);
    arg_source->add_intvalue((int)source);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument message
    GLMessage_DataType *arg_message = glmsg.add_args();
    arg_message->set_isarray(false);
    arg_message->set_type(GLMessage::DataType::INT64);
    arg_message->add_int64value((uintptr_t)message);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPushDebugGroupKHR(source, id, length, message);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) message,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPopDebugGroupKHR(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPopDebugGroupKHR);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPopDebugGroupKHR();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glObjectLabelKHR(GLenum identifier, GLuint name, GLsizei length, const GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glObjectLabelKHR);

    // copy argument identifier
    GLMessage_DataType *arg_identifier = glmsg.add_args();
    arg_identifier->set_isarray(false);
    arg_identifier->set_type(GLMessage::DataType::ENUM);
    arg_identifier->add_intvalue((int)identifier);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue(name);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glObjectLabelKHR(identifier, name, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei * length, GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetObjectLabelKHR);

    // copy argument identifier
    GLMessage_DataType *arg_identifier = glmsg.add_args();
    arg_identifier->set_isarray(false);
    arg_identifier->set_type(GLMessage::DataType::ENUM);
    arg_identifier->add_intvalue((int)identifier);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue(name);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetObjectLabelKHR(identifier, name, bufSize, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glObjectPtrLabelKHR(const void * ptr, GLsizei length, const GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glObjectPtrLabelKHR);

    // copy argument ptr
    GLMessage_DataType *arg_ptr = glmsg.add_args();
    arg_ptr->set_isarray(false);
    arg_ptr->set_type(GLMessage::DataType::INT64);
    arg_ptr->add_int64value((uintptr_t)ptr);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glObjectPtrLabelKHR(ptr, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ptr,
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetObjectPtrLabelKHR(const void * ptr, GLsizei bufSize, GLsizei * length, GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetObjectPtrLabelKHR);

    // copy argument ptr
    GLMessage_DataType *arg_ptr = glmsg.add_args();
    arg_ptr->set_isarray(false);
    arg_ptr->set_type(GLMessage::DataType::INT64);
    arg_ptr->add_int64value((uintptr_t)ptr);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetObjectPtrLabelKHR(ptr, bufSize, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ptr,
        (void *) length,
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPointervKHR(GLenum pname, void ** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPointervKHR);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPointervKHR(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEGLImageTargetTexture2DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument image
    GLMessage_DataType *arg_image = glmsg.add_args();
    arg_image->set_isarray(false);
    arg_image->set_type(GLMessage::DataType::INT64);
    arg_image->add_int64value((uintptr_t)image);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEGLImageTargetTexture2DOES(target, image);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) image,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEGLImageTargetRenderbufferStorageOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument image
    GLMessage_DataType *arg_image = glmsg.add_args();
    arg_image->set_isarray(false);
    arg_image->set_type(GLMessage::DataType::INT64);
    arg_image->add_int64value((uintptr_t)image);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEGLImageTargetRenderbufferStorageOES(target, image);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) image,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramBinaryOES(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, void * binary) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramBinaryOES);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::INT64);
    arg_binaryFormat->add_int64value((uintptr_t)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT64);
    arg_binary->add_int64value((uintptr_t)binary);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramBinaryOES(program, bufSize, length, binaryFormat, binary);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) binaryFormat,
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramBinaryOES(GLuint program, GLenum binaryFormat, const void * binary, GLint length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramBinaryOES);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::ENUM);
    arg_binaryFormat->add_intvalue((int)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT64);
    arg_binary->add_int64value((uintptr_t)binary);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramBinaryOES(program, binaryFormat, binary, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void * GLTrace_glMapBufferOES(GLenum target, GLenum access) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMapBufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument access
    GLMessage_DataType *arg_access = glmsg.add_args();
    arg_access->set_isarray(false);
    arg_access->set_type(GLMessage::DataType::ENUM);
    arg_access->add_intvalue((int)access);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    void * retValue = glContext->hooks->gl.glMapBufferOES(target, access);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glUnmapBufferOES(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUnmapBufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glUnmapBufferOES(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetBufferPointervOES(GLenum target, GLenum pname, void ** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferPointervOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferPointervOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMinSampleShadingOES(GLfloat value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMinSampleShadingOES);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::FLOAT);
    arg_value->add_floatvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMinSampleShadingOES(value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT64);
    arg_pixels->add_int64value((uintptr_t)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage3DMultisampleOES(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage3DMultisampleOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument fixedsamplelocations
    GLMessage_DataType *arg_fixedsamplelocations = glmsg.add_args();
    arg_fixedsamplelocations->set_isarray(false);
    arg_fixedsamplelocations->set_type(GLMessage::DataType::BOOL);
    arg_fixedsamplelocations->add_boolvalue(fixedsamplelocations);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage3DMultisampleOES(target, samples, internalformat, width, height, depth, fixedsamplelocations);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindVertexArrayOES(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindVertexArrayOES);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindVertexArrayOES(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteVertexArraysOES(GLsizei n, const GLuint * arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteVertexArraysOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT64);
    arg_arrays->add_int64value((uintptr_t)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteVertexArraysOES(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenVertexArraysOES(GLsizei n, GLuint * arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenVertexArraysOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT64);
    arg_arrays->add_int64value((uintptr_t)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenVertexArraysOES(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsVertexArrayOES(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsVertexArrayOES);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsVertexArrayOES(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetPerfMonitorGroupsAMD(GLint * numGroups, GLsizei groupsSize, GLuint * groups) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorGroupsAMD);

    // copy argument numGroups
    GLMessage_DataType *arg_numGroups = glmsg.add_args();
    arg_numGroups->set_isarray(false);
    arg_numGroups->set_type(GLMessage::DataType::INT64);
    arg_numGroups->add_int64value((uintptr_t)numGroups);

    // copy argument groupsSize
    GLMessage_DataType *arg_groupsSize = glmsg.add_args();
    arg_groupsSize->set_isarray(false);
    arg_groupsSize->set_type(GLMessage::DataType::INT);
    arg_groupsSize->add_intvalue(groupsSize);

    // copy argument groups
    GLMessage_DataType *arg_groups = glmsg.add_args();
    arg_groups->set_isarray(false);
    arg_groups->set_type(GLMessage::DataType::INT64);
    arg_groups->add_int64value((uintptr_t)groups);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) numGroups,
        (void *) groups,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCountersAMD(GLuint group, GLint * numCounters, GLint * maxActiveCounters, GLsizei counterSize, GLuint * counters) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCountersAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument numCounters
    GLMessage_DataType *arg_numCounters = glmsg.add_args();
    arg_numCounters->set_isarray(false);
    arg_numCounters->set_type(GLMessage::DataType::INT64);
    arg_numCounters->add_int64value((uintptr_t)numCounters);

    // copy argument maxActiveCounters
    GLMessage_DataType *arg_maxActiveCounters = glmsg.add_args();
    arg_maxActiveCounters->set_isarray(false);
    arg_maxActiveCounters->set_type(GLMessage::DataType::INT64);
    arg_maxActiveCounters->add_int64value((uintptr_t)maxActiveCounters);

    // copy argument counterSize
    GLMessage_DataType *arg_counterSize = glmsg.add_args();
    arg_counterSize->set_isarray(false);
    arg_counterSize->set_type(GLMessage::DataType::INT);
    arg_counterSize->add_intvalue(counterSize);

    // copy argument counters
    GLMessage_DataType *arg_counters = glmsg.add_args();
    arg_counters->set_isarray(false);
    arg_counters->set_type(GLMessage::DataType::INT64);
    arg_counters->add_int64value((uintptr_t)counters);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) numCounters,
        (void *) maxActiveCounters,
        (void *) counters,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei * length, GLchar * groupString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorGroupStringAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument groupString
    GLMessage_DataType *arg_groupString = glmsg.add_args();
    arg_groupString->set_isarray(false);
    arg_groupString->set_type(GLMessage::DataType::INT64);
    arg_groupString->add_int64value((uintptr_t)groupString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) groupString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei * length, GLchar * counterString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterStringAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument counter
    GLMessage_DataType *arg_counter = glmsg.add_args();
    arg_counter->set_isarray(false);
    arg_counter->set_type(GLMessage::DataType::INT);
    arg_counter->add_intvalue(counter);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument counterString
    GLMessage_DataType *arg_counterString = glmsg.add_args();
    arg_counterString->set_isarray(false);
    arg_counterString->set_type(GLMessage::DataType::INT64);
    arg_counterString->add_int64value((uintptr_t)counterString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) counterString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterInfoAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument counter
    GLMessage_DataType *arg_counter = glmsg.add_args();
    arg_counter->set_isarray(false);
    arg_counter->set_type(GLMessage::DataType::INT);
    arg_counter->add_intvalue(counter);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterInfoAMD(group, counter, pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenPerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenPerfMonitorsAMD);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument monitors
    GLMessage_DataType *arg_monitors = glmsg.add_args();
    arg_monitors->set_isarray(false);
    arg_monitors->set_type(GLMessage::DataType::INT64);
    arg_monitors->add_int64value((uintptr_t)monitors);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenPerfMonitorsAMD(n, monitors);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) monitors,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeletePerfMonitorsAMD(GLsizei n, GLuint * monitors) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeletePerfMonitorsAMD);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument monitors
    GLMessage_DataType *arg_monitors = glmsg.add_args();
    arg_monitors->set_isarray(false);
    arg_monitors->set_type(GLMessage::DataType::INT64);
    arg_monitors->add_int64value((uintptr_t)monitors);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeletePerfMonitorsAMD(n, monitors);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) monitors,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint * counterList) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSelectPerfMonitorCountersAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // copy argument enable
    GLMessage_DataType *arg_enable = glmsg.add_args();
    arg_enable->set_isarray(false);
    arg_enable->set_type(GLMessage::DataType::BOOL);
    arg_enable->add_boolvalue(enable);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument numCounters
    GLMessage_DataType *arg_numCounters = glmsg.add_args();
    arg_numCounters->set_isarray(false);
    arg_numCounters->set_type(GLMessage::DataType::INT);
    arg_numCounters->add_intvalue(numCounters);

    // copy argument counterList
    GLMessage_DataType *arg_counterList = glmsg.add_args();
    arg_counterList->set_isarray(false);
    arg_counterList->set_type(GLMessage::DataType::INT64);
    arg_counterList->add_int64value((uintptr_t)counterList);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) counterList,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBeginPerfMonitorAMD(GLuint monitor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginPerfMonitorAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginPerfMonitorAMD(monitor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndPerfMonitorAMD(GLuint monitor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndPerfMonitorAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndPerfMonitorAMD(monitor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint * data, GLint * bytesWritten) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterDataAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument dataSize
    GLMessage_DataType *arg_dataSize = glmsg.add_args();
    arg_dataSize->set_isarray(false);
    arg_dataSize->set_type(GLMessage::DataType::INT);
    arg_dataSize->add_intvalue(dataSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // copy argument bytesWritten
    GLMessage_DataType *arg_bytesWritten = glmsg.add_args();
    arg_bytesWritten->set_isarray(false);
    arg_bytesWritten->set_type(GLMessage::DataType::INT64);
    arg_bytesWritten->add_int64value((uintptr_t)bytesWritten);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
        (void *) bytesWritten,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlitFramebufferANGLE);

    // copy argument srcX0
    GLMessage_DataType *arg_srcX0 = glmsg.add_args();
    arg_srcX0->set_isarray(false);
    arg_srcX0->set_type(GLMessage::DataType::INT);
    arg_srcX0->add_intvalue(srcX0);

    // copy argument srcY0
    GLMessage_DataType *arg_srcY0 = glmsg.add_args();
    arg_srcY0->set_isarray(false);
    arg_srcY0->set_type(GLMessage::DataType::INT);
    arg_srcY0->add_intvalue(srcY0);

    // copy argument srcX1
    GLMessage_DataType *arg_srcX1 = glmsg.add_args();
    arg_srcX1->set_isarray(false);
    arg_srcX1->set_type(GLMessage::DataType::INT);
    arg_srcX1->add_intvalue(srcX1);

    // copy argument srcY1
    GLMessage_DataType *arg_srcY1 = glmsg.add_args();
    arg_srcY1->set_isarray(false);
    arg_srcY1->set_type(GLMessage::DataType::INT);
    arg_srcY1->add_intvalue(srcY1);

    // copy argument dstX0
    GLMessage_DataType *arg_dstX0 = glmsg.add_args();
    arg_dstX0->set_isarray(false);
    arg_dstX0->set_type(GLMessage::DataType::INT);
    arg_dstX0->add_intvalue(dstX0);

    // copy argument dstY0
    GLMessage_DataType *arg_dstY0 = glmsg.add_args();
    arg_dstY0->set_isarray(false);
    arg_dstY0->set_type(GLMessage::DataType::INT);
    arg_dstY0->add_intvalue(dstY0);

    // copy argument dstX1
    GLMessage_DataType *arg_dstX1 = glmsg.add_args();
    arg_dstX1->set_isarray(false);
    arg_dstX1->set_type(GLMessage::DataType::INT);
    arg_dstX1->add_intvalue(dstX1);

    // copy argument dstY1
    GLMessage_DataType *arg_dstY1 = glmsg.add_args();
    arg_dstY1->set_isarray(false);
    arg_dstY1->set_type(GLMessage::DataType::INT);
    arg_dstY1->add_intvalue(dstY1);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // copy argument filter
    GLMessage_DataType *arg_filter = glmsg.add_args();
    arg_filter->set_isarray(false);
    arg_filter->set_type(GLMessage::DataType::ENUM);
    arg_filter->add_intvalue((int)filter);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleANGLE);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArraysInstancedANGLE(GLenum mode, GLint first, GLsizei count, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArraysInstancedANGLE);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue(first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArraysInstancedANGLE(mode, first, count, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElementsInstancedANGLE(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElementsInstancedANGLE);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElementsInstancedANGLE(mode, count, type, indices, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribDivisorANGLE(GLuint index, GLuint divisor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribDivisorANGLE);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument divisor
    GLMessage_DataType *arg_divisor = glmsg.add_args();
    arg_divisor->set_isarray(false);
    arg_divisor->set_type(GLMessage::DataType::INT);
    arg_divisor->add_intvalue(divisor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribDivisorANGLE(index, divisor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTranslatedShaderSourceANGLE(GLuint shader, GLsizei bufsize, GLsizei * length, GLchar * source) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTranslatedShaderSourceANGLE);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::INT64);
    arg_source->add_int64value((uintptr_t)source);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTranslatedShaderSourceANGLE(shader, bufsize, length, source);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) source,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTextureLevelsAPPLE(GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTextureLevelsAPPLE);

    // copy argument destinationTexture
    GLMessage_DataType *arg_destinationTexture = glmsg.add_args();
    arg_destinationTexture->set_isarray(false);
    arg_destinationTexture->set_type(GLMessage::DataType::INT);
    arg_destinationTexture->add_intvalue(destinationTexture);

    // copy argument sourceTexture
    GLMessage_DataType *arg_sourceTexture = glmsg.add_args();
    arg_sourceTexture->set_isarray(false);
    arg_sourceTexture->set_type(GLMessage::DataType::INT);
    arg_sourceTexture->add_intvalue(sourceTexture);

    // copy argument sourceBaseLevel
    GLMessage_DataType *arg_sourceBaseLevel = glmsg.add_args();
    arg_sourceBaseLevel->set_isarray(false);
    arg_sourceBaseLevel->set_type(GLMessage::DataType::INT);
    arg_sourceBaseLevel->add_intvalue(sourceBaseLevel);

    // copy argument sourceLevelCount
    GLMessage_DataType *arg_sourceLevelCount = glmsg.add_args();
    arg_sourceLevelCount->set_isarray(false);
    arg_sourceLevelCount->set_type(GLMessage::DataType::INT);
    arg_sourceLevelCount->add_intvalue(sourceLevelCount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleAPPLE);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glResolveMultisampleFramebufferAPPLE(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glResolveMultisampleFramebufferAPPLE);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glResolveMultisampleFramebufferAPPLE();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLsync GLTrace_glFenceSyncAPPLE(GLenum condition, GLbitfield flags) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFenceSyncAPPLE);

    // copy argument condition
    GLMessage_DataType *arg_condition = glmsg.add_args();
    arg_condition->set_isarray(false);
    arg_condition->set_type(GLMessage::DataType::ENUM);
    arg_condition->add_intvalue((int)condition);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLsync retValue = glContext->hooks->gl.glFenceSyncAPPLE(condition, flags);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsSyncAPPLE(GLsync sync) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsSyncAPPLE);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsSyncAPPLE(sync);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glDeleteSyncAPPLE(GLsync sync) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteSyncAPPLE);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteSyncAPPLE(sync);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glClientWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClientWaitSyncAPPLE);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // copy argument timeout
    GLMessage_DataType *arg_timeout = glmsg.add_args();
    arg_timeout->set_isarray(false);
    arg_timeout->set_type(GLMessage::DataType::INT64);
    arg_timeout->add_int64value(timeout);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glClientWaitSyncAPPLE(sync, flags, timeout);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glWaitSyncAPPLE(GLsync sync, GLbitfield flags, GLuint64 timeout) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glWaitSyncAPPLE);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // copy argument timeout
    GLMessage_DataType *arg_timeout = glmsg.add_args();
    arg_timeout->set_isarray(false);
    arg_timeout->set_type(GLMessage::DataType::INT64);
    arg_timeout->add_int64value(timeout);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glWaitSyncAPPLE(sync, flags, timeout);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetInteger64vAPPLE(GLenum pname, GLint64 * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetInteger64vAPPLE);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetInteger64vAPPLE(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSyncivAPPLE(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSyncivAPPLE);

    // copy argument sync
    GLMessage_DataType *arg_sync = glmsg.add_args();
    arg_sync->set_isarray(false);
    arg_sync->set_type(GLMessage::DataType::INT64);
    arg_sync->add_int64value((uintptr_t)sync);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT64);
    arg_values->add_int64value((uintptr_t)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSyncivAPPLE(sync, pname, bufSize, length, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) sync,
        (void *) length,
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyImageSubDataEXT(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyImageSubDataEXT);

    // copy argument srcName
    GLMessage_DataType *arg_srcName = glmsg.add_args();
    arg_srcName->set_isarray(false);
    arg_srcName->set_type(GLMessage::DataType::INT);
    arg_srcName->add_intvalue(srcName);

    // copy argument srcTarget
    GLMessage_DataType *arg_srcTarget = glmsg.add_args();
    arg_srcTarget->set_isarray(false);
    arg_srcTarget->set_type(GLMessage::DataType::ENUM);
    arg_srcTarget->add_intvalue((int)srcTarget);

    // copy argument srcLevel
    GLMessage_DataType *arg_srcLevel = glmsg.add_args();
    arg_srcLevel->set_isarray(false);
    arg_srcLevel->set_type(GLMessage::DataType::INT);
    arg_srcLevel->add_intvalue(srcLevel);

    // copy argument srcX
    GLMessage_DataType *arg_srcX = glmsg.add_args();
    arg_srcX->set_isarray(false);
    arg_srcX->set_type(GLMessage::DataType::INT);
    arg_srcX->add_intvalue(srcX);

    // copy argument srcY
    GLMessage_DataType *arg_srcY = glmsg.add_args();
    arg_srcY->set_isarray(false);
    arg_srcY->set_type(GLMessage::DataType::INT);
    arg_srcY->add_intvalue(srcY);

    // copy argument srcZ
    GLMessage_DataType *arg_srcZ = glmsg.add_args();
    arg_srcZ->set_isarray(false);
    arg_srcZ->set_type(GLMessage::DataType::INT);
    arg_srcZ->add_intvalue(srcZ);

    // copy argument dstName
    GLMessage_DataType *arg_dstName = glmsg.add_args();
    arg_dstName->set_isarray(false);
    arg_dstName->set_type(GLMessage::DataType::INT);
    arg_dstName->add_intvalue(dstName);

    // copy argument dstTarget
    GLMessage_DataType *arg_dstTarget = glmsg.add_args();
    arg_dstTarget->set_isarray(false);
    arg_dstTarget->set_type(GLMessage::DataType::ENUM);
    arg_dstTarget->add_intvalue((int)dstTarget);

    // copy argument dstLevel
    GLMessage_DataType *arg_dstLevel = glmsg.add_args();
    arg_dstLevel->set_isarray(false);
    arg_dstLevel->set_type(GLMessage::DataType::INT);
    arg_dstLevel->add_intvalue(dstLevel);

    // copy argument dstX
    GLMessage_DataType *arg_dstX = glmsg.add_args();
    arg_dstX->set_isarray(false);
    arg_dstX->set_type(GLMessage::DataType::INT);
    arg_dstX->add_intvalue(dstX);

    // copy argument dstY
    GLMessage_DataType *arg_dstY = glmsg.add_args();
    arg_dstY->set_isarray(false);
    arg_dstY->set_type(GLMessage::DataType::INT);
    arg_dstY->add_intvalue(dstY);

    // copy argument dstZ
    GLMessage_DataType *arg_dstZ = glmsg.add_args();
    arg_dstZ->set_isarray(false);
    arg_dstZ->set_type(GLMessage::DataType::INT);
    arg_dstZ->add_intvalue(dstZ);

    // copy argument srcWidth
    GLMessage_DataType *arg_srcWidth = glmsg.add_args();
    arg_srcWidth->set_isarray(false);
    arg_srcWidth->set_type(GLMessage::DataType::INT);
    arg_srcWidth->add_intvalue(srcWidth);

    // copy argument srcHeight
    GLMessage_DataType *arg_srcHeight = glmsg.add_args();
    arg_srcHeight->set_isarray(false);
    arg_srcHeight->set_type(GLMessage::DataType::INT);
    arg_srcHeight->add_intvalue(srcHeight);

    // copy argument srcDepth
    GLMessage_DataType *arg_srcDepth = glmsg.add_args();
    arg_srcDepth->set_isarray(false);
    arg_srcDepth->set_type(GLMessage::DataType::INT);
    arg_srcDepth->add_intvalue(srcDepth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyImageSubDataEXT(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLabelObjectEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument object
    GLMessage_DataType *arg_object = glmsg.add_args();
    arg_object->set_isarray(false);
    arg_object->set_type(GLMessage::DataType::INT);
    arg_object->add_intvalue(object);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLabelObjectEXT(type, object, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei * length, GLchar * label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetObjectLabelEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument object
    GLMessage_DataType *arg_object = glmsg.add_args();
    arg_object->set_isarray(false);
    arg_object->set_type(GLMessage::DataType::INT);
    arg_object->add_intvalue(object);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT64);
    arg_label->add_int64value((uintptr_t)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetObjectLabelEXT(type, object, bufSize, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glInsertEventMarkerEXT(GLsizei length, const GLchar * marker) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glInsertEventMarkerEXT);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument marker
    GLMessage_DataType *arg_marker = glmsg.add_args();
    arg_marker->set_isarray(false);
    arg_marker->set_type(GLMessage::DataType::INT64);
    arg_marker->add_int64value((uintptr_t)marker);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glInsertEventMarkerEXT(length, marker);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) marker,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPushGroupMarkerEXT(GLsizei length, const GLchar * marker) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPushGroupMarkerEXT);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument marker
    GLMessage_DataType *arg_marker = glmsg.add_args();
    arg_marker->set_isarray(false);
    arg_marker->set_type(GLMessage::DataType::INT64);
    arg_marker->add_int64value((uintptr_t)marker);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPushGroupMarkerEXT(length, marker);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) marker,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPopGroupMarkerEXT(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPopGroupMarkerEXT);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPopGroupMarkerEXT();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum * attachments) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDiscardFramebufferEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument numAttachments
    GLMessage_DataType *arg_numAttachments = glmsg.add_args();
    arg_numAttachments->set_isarray(false);
    arg_numAttachments->set_type(GLMessage::DataType::INT);
    arg_numAttachments->add_intvalue(numAttachments);

    // copy argument attachments
    GLMessage_DataType *arg_attachments = glmsg.add_args();
    arg_attachments->set_isarray(false);
    arg_attachments->set_type(GLMessage::DataType::INT64);
    arg_attachments->add_int64value((uintptr_t)attachments);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDiscardFramebufferEXT(target, numAttachments, attachments);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) attachments,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenQueriesEXT(GLsizei n, GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenQueriesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenQueriesEXT(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteQueriesEXT(GLsizei n, const GLuint * ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteQueriesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT64);
    arg_ids->add_int64value((uintptr_t)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteQueriesEXT(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsQueryEXT(GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsQueryEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsQueryEXT(id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBeginQueryEXT(GLenum target, GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginQueryEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginQueryEXT(target, id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndQueryEXT(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndQueryEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndQueryEXT(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glQueryCounterEXT(GLuint id, GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glQueryCounterEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glQueryCounterEXT(id, target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryivEXT(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjectivEXT(GLuint id, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjectivEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjectivEXT(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjectuivEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjectuivEXT(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjecti64vEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjecti64vEXT(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjectui64vEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjectui64vEXT(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawBuffersEXT(GLsizei n, const GLenum * bufs) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawBuffersEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument bufs
    GLMessage_DataType *arg_bufs = glmsg.add_args();
    arg_bufs->set_isarray(false);
    arg_bufs->set_type(GLMessage::DataType::INT64);
    arg_bufs->add_int64value((uintptr_t)bufs);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawBuffersEXT(n, bufs);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) bufs,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableiEXT(GLenum target, GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableiEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableiEXT(target, index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableiEXT(GLenum target, GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableiEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableiEXT(target, index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationiEXT(GLuint buf, GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationiEXT);

    // copy argument buf
    GLMessage_DataType *arg_buf = glmsg.add_args();
    arg_buf->set_isarray(false);
    arg_buf->set_type(GLMessage::DataType::INT);
    arg_buf->add_intvalue(buf);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationiEXT(buf, mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationSeparateiEXT(GLuint buf, GLenum modeRGB, GLenum modeAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationSeparateiEXT);

    // copy argument buf
    GLMessage_DataType *arg_buf = glmsg.add_args();
    arg_buf->set_isarray(false);
    arg_buf->set_type(GLMessage::DataType::INT);
    arg_buf->add_intvalue(buf);

    // copy argument modeRGB
    GLMessage_DataType *arg_modeRGB = glmsg.add_args();
    arg_modeRGB->set_isarray(false);
    arg_modeRGB->set_type(GLMessage::DataType::ENUM);
    arg_modeRGB->add_intvalue((int)modeRGB);

    // copy argument modeAlpha
    GLMessage_DataType *arg_modeAlpha = glmsg.add_args();
    arg_modeAlpha->set_isarray(false);
    arg_modeAlpha->set_type(GLMessage::DataType::ENUM);
    arg_modeAlpha->add_intvalue((int)modeAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationSeparateiEXT(buf, modeRGB, modeAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFunciEXT(GLuint buf, GLenum src, GLenum dst) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFunciEXT);

    // copy argument buf
    GLMessage_DataType *arg_buf = glmsg.add_args();
    arg_buf->set_isarray(false);
    arg_buf->set_type(GLMessage::DataType::INT);
    arg_buf->add_intvalue(buf);

    // copy argument src
    GLMessage_DataType *arg_src = glmsg.add_args();
    arg_src->set_isarray(false);
    arg_src->set_type(GLMessage::DataType::ENUM);
    arg_src->add_intvalue((int)src);

    // copy argument dst
    GLMessage_DataType *arg_dst = glmsg.add_args();
    arg_dst->set_isarray(false);
    arg_dst->set_type(GLMessage::DataType::ENUM);
    arg_dst->add_intvalue((int)dst);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFunciEXT(buf, src, dst);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFuncSeparateiEXT(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFuncSeparateiEXT);

    // copy argument buf
    GLMessage_DataType *arg_buf = glmsg.add_args();
    arg_buf->set_isarray(false);
    arg_buf->set_type(GLMessage::DataType::INT);
    arg_buf->add_intvalue(buf);

    // copy argument srcRGB
    GLMessage_DataType *arg_srcRGB = glmsg.add_args();
    arg_srcRGB->set_isarray(false);
    arg_srcRGB->set_type(GLMessage::DataType::ENUM);
    arg_srcRGB->add_intvalue((int)srcRGB);

    // copy argument dstRGB
    GLMessage_DataType *arg_dstRGB = glmsg.add_args();
    arg_dstRGB->set_isarray(false);
    arg_dstRGB->set_type(GLMessage::DataType::ENUM);
    arg_dstRGB->add_intvalue((int)dstRGB);

    // copy argument srcAlpha
    GLMessage_DataType *arg_srcAlpha = glmsg.add_args();
    arg_srcAlpha->set_isarray(false);
    arg_srcAlpha->set_type(GLMessage::DataType::ENUM);
    arg_srcAlpha->add_intvalue((int)srcAlpha);

    // copy argument dstAlpha
    GLMessage_DataType *arg_dstAlpha = glmsg.add_args();
    arg_dstAlpha->set_isarray(false);
    arg_dstAlpha->set_type(GLMessage::DataType::ENUM);
    arg_dstAlpha->add_intvalue((int)dstAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFuncSeparateiEXT(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColorMaskiEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColorMaskiEXT);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::BOOL);
    arg_r->add_boolvalue(r);

    // copy argument g
    GLMessage_DataType *arg_g = glmsg.add_args();
    arg_g->set_isarray(false);
    arg_g->set_type(GLMessage::DataType::BOOL);
    arg_g->add_boolvalue(g);

    // copy argument b
    GLMessage_DataType *arg_b = glmsg.add_args();
    arg_b->set_isarray(false);
    arg_b->set_type(GLMessage::DataType::BOOL);
    arg_b->add_boolvalue(b);

    // copy argument a
    GLMessage_DataType *arg_a = glmsg.add_args();
    arg_a->set_isarray(false);
    arg_a->set_type(GLMessage::DataType::BOOL);
    arg_a->add_boolvalue(a);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColorMaskiEXT(index, r, g, b, a);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsEnablediEXT(GLenum target, GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsEnablediEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsEnablediEXT(target, index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glDrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArraysInstancedEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument start
    GLMessage_DataType *arg_start = glmsg.add_args();
    arg_start->set_isarray(false);
    arg_start->set_type(GLMessage::DataType::INT);
    arg_start->add_intvalue(start);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArraysInstancedEXT(mode, start, count, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElementsInstancedEXT(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElementsInstancedEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElementsInstancedEXT(mode, count, type, indices, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTextureEXT(GLenum target, GLenum attachment, GLuint texture, GLint level) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTextureEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTextureEXT(target, attachment, texture, level);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribDivisorEXT(GLuint index, GLuint divisor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribDivisorEXT);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument divisor
    GLMessage_DataType *arg_divisor = glmsg.add_args();
    arg_divisor->set_isarray(false);
    arg_divisor->set_type(GLMessage::DataType::INT);
    arg_divisor->add_intvalue(divisor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribDivisorEXT(index, divisor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void * GLTrace_glMapBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMapBufferRangeEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument access
    GLMessage_DataType *arg_access = glmsg.add_args();
    arg_access->set_isarray(false);
    arg_access->set_type(GLMessage::DataType::INT);
    arg_access->add_intvalue(access);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    void * retValue = glContext->hooks->gl.glMapBufferRangeEXT(target, offset, length, access);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT64);
    rt->add_int64value((uintptr_t)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glFlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFlushMappedBufferRangeEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFlushMappedBufferRangeEXT(target, offset, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiDrawArraysEXT(GLenum mode, const GLint * first, const GLsizei * count, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiDrawArraysEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT64);
    arg_first->add_int64value((uintptr_t)first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT64);
    arg_count->add_int64value((uintptr_t)count);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiDrawArraysEXT(mode, first, count, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) first,
        (void *) count,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiDrawElementsEXT(GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiDrawElementsEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT64);
    arg_count->add_int64value((uintptr_t)count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiDrawElementsEXT(mode, count, type, indices, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) count,
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2DMultisampleEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadBufferIndexedEXT(GLenum src, GLint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadBufferIndexedEXT);

    // copy argument src
    GLMessage_DataType *arg_src = glmsg.add_args();
    arg_src->set_isarray(false);
    arg_src->set_type(GLMessage::DataType::ENUM);
    arg_src->add_intvalue((int)src);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadBufferIndexedEXT(src, index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawBuffersIndexedEXT(GLint n, const GLenum * location, const GLint * indices) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawBuffersIndexedEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT64);
    arg_location->add_int64value((uintptr_t)location);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawBuffersIndexedEXT(n, location, indices);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) location,
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetIntegeri_vEXT(GLenum target, GLuint index, GLint * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetIntegeri_vEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetIntegeri_vEXT(target, index, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPrimitiveBoundingBoxEXT(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPrimitiveBoundingBoxEXT);

    // copy argument minX
    GLMessage_DataType *arg_minX = glmsg.add_args();
    arg_minX->set_isarray(false);
    arg_minX->set_type(GLMessage::DataType::FLOAT);
    arg_minX->add_floatvalue(minX);

    // copy argument minY
    GLMessage_DataType *arg_minY = glmsg.add_args();
    arg_minY->set_isarray(false);
    arg_minY->set_type(GLMessage::DataType::FLOAT);
    arg_minY->add_floatvalue(minY);

    // copy argument minZ
    GLMessage_DataType *arg_minZ = glmsg.add_args();
    arg_minZ->set_isarray(false);
    arg_minZ->set_type(GLMessage::DataType::FLOAT);
    arg_minZ->add_floatvalue(minZ);

    // copy argument minW
    GLMessage_DataType *arg_minW = glmsg.add_args();
    arg_minW->set_isarray(false);
    arg_minW->set_type(GLMessage::DataType::FLOAT);
    arg_minW->add_floatvalue(minW);

    // copy argument maxX
    GLMessage_DataType *arg_maxX = glmsg.add_args();
    arg_maxX->set_isarray(false);
    arg_maxX->set_type(GLMessage::DataType::FLOAT);
    arg_maxX->add_floatvalue(maxX);

    // copy argument maxY
    GLMessage_DataType *arg_maxY = glmsg.add_args();
    arg_maxY->set_isarray(false);
    arg_maxY->set_type(GLMessage::DataType::FLOAT);
    arg_maxY->add_floatvalue(maxY);

    // copy argument maxZ
    GLMessage_DataType *arg_maxZ = glmsg.add_args();
    arg_maxZ->set_isarray(false);
    arg_maxZ->set_type(GLMessage::DataType::FLOAT);
    arg_maxZ->add_floatvalue(maxZ);

    // copy argument maxW
    GLMessage_DataType *arg_maxW = glmsg.add_args();
    arg_maxW->set_isarray(false);
    arg_maxW->set_type(GLMessage::DataType::FLOAT);
    arg_maxW->add_floatvalue(maxW);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPrimitiveBoundingBoxEXT(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glGetGraphicsResetStatusEXT(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetGraphicsResetStatusEXT);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glGetGraphicsResetStatusEXT();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void * data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadnPixelsEXT);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetnUniformfvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetnUniformfvEXT(program, location, bufSize, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetnUniformivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetnUniformivEXT(program, location, bufSize, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glActiveShaderProgramEXT(GLuint pipeline, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glActiveShaderProgramEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glActiveShaderProgramEXT(pipeline, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar ** strings) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateShaderProgramvEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument strings
    GLMessage_DataType *arg_strings = glmsg.add_args();
    arg_strings->set_isarray(false);
    arg_strings->set_type(GLMessage::DataType::INT64);
    arg_strings->add_int64value((uintptr_t)strings);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateShaderProgramvEXT(type, count, strings);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) strings,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glDeleteProgramPipelinesEXT(GLsizei n, const GLuint * pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteProgramPipelinesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT64);
    arg_pipelines->add_int64value((uintptr_t)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteProgramPipelinesEXT(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenProgramPipelinesEXT(GLsizei n, GLuint * pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenProgramPipelinesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT64);
    arg_pipelines->add_int64value((uintptr_t)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenProgramPipelinesEXT(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramPipelineInfoLogEXT(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineInfoLogEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument infoLog
    GLMessage_DataType *arg_infoLog = glmsg.add_args();
    arg_infoLog->set_isarray(false);
    arg_infoLog->set_type(GLMessage::DataType::INT64);
    arg_infoLog->add_int64value((uintptr_t)infoLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infoLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineivEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineivEXT(pipeline, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glProgramParameteriEXT(GLuint program, GLenum pname, GLint value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramParameteriEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramParameteriEXT(program, pname, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1fEXT(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1iEXT(GLuint program, GLint location, GLint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1iEXT(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2fEXT(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2iEXT(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3fEXT(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3iEXT(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::FLOAT);
    arg_v0->add_floatvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::FLOAT);
    arg_v1->add_floatvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::FLOAT);
    arg_v2->add_floatvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::FLOAT);
    arg_v3->add_floatvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4fEXT(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4iEXT(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUseProgramStagesEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument stages
    GLMessage_DataType *arg_stages = glmsg.add_args();
    arg_stages->set_isarray(false);
    arg_stages->set_type(GLMessage::DataType::INT);
    arg_stages->add_intvalue(stages);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUseProgramStagesEXT(pipeline, stages, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glValidateProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glValidateProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glValidateProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1uiEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1uiEXT(program, location, v0);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2uiEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2uiEXT(program, location, v0, v1);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3uiEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3uiEXT(program, location, v0, v1, v2);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4uiEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument v0
    GLMessage_DataType *arg_v0 = glmsg.add_args();
    arg_v0->set_isarray(false);
    arg_v0->set_type(GLMessage::DataType::INT);
    arg_v0->add_intvalue(v0);

    // copy argument v1
    GLMessage_DataType *arg_v1 = glmsg.add_args();
    arg_v1->set_isarray(false);
    arg_v1->set_type(GLMessage::DataType::INT);
    arg_v1->add_intvalue(v1);

    // copy argument v2
    GLMessage_DataType *arg_v2 = glmsg.add_args();
    arg_v2->set_isarray(false);
    arg_v2->set_type(GLMessage::DataType::INT);
    arg_v2->add_intvalue(v2);

    // copy argument v3
    GLMessage_DataType *arg_v3 = glmsg.add_args();
    arg_v3->set_isarray(false);
    arg_v3->set_type(GLMessage::DataType::INT);
    arg_v3->add_intvalue(v3);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4uiEXT(program, location, v0, v1, v2, v3);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1uivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1uivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2uivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2uivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3uivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3uivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4uivEXT(GLuint program, GLint location, GLsizei count, const GLuint * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4uivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4uivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2x3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3x2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2x4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4x2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4x2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3x4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3x4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4x3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4x3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPatchParameteriEXT(GLenum pname, GLint value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPatchParameteriEXT);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPatchParameteriEXT(pname, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterIivEXT(GLenum target, GLenum pname, const GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterIivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterIivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterIuivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterIuivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterIivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterIivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterIuivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterIuivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameterIivEXT(GLuint sampler, GLenum pname, const GLint * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameterIivEXT);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameterIivEXT(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSamplerParameterIuivEXT(GLuint sampler, GLenum pname, const GLuint * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSamplerParameterIuivEXT);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSamplerParameterIuivEXT(sampler, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSamplerParameterIivEXT(GLuint sampler, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSamplerParameterIivEXT);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSamplerParameterIivEXT(sampler, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetSamplerParameterIuivEXT(GLuint sampler, GLenum pname, GLuint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetSamplerParameterIuivEXT);

    // copy argument sampler
    GLMessage_DataType *arg_sampler = glmsg.add_args();
    arg_sampler->set_isarray(false);
    arg_sampler->set_type(GLMessage::DataType::INT);
    arg_sampler->add_intvalue(sampler);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetSamplerParameterIuivEXT(sampler, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexBufferEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexBufferEXT(target, internalformat, buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexBufferRangeEXT(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexBufferRangeEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexBufferRangeEXT(target, internalformat, buffer, offset, size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage1DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage1DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage1DEXT(target, levels, internalformat, width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage2DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage2DEXT(target, levels, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage3DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage3DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage3DEXT(target, levels, internalformat, width, height, depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage1DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage1DEXT(texture, target, levels, internalformat, width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage2DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage2DEXT(texture, target, levels, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage3DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureViewEXT(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureViewEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument origtexture
    GLMessage_DataType *arg_origtexture = glmsg.add_args();
    arg_origtexture->set_isarray(false);
    arg_origtexture->set_type(GLMessage::DataType::INT);
    arg_origtexture->add_intvalue(origtexture);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument minlevel
    GLMessage_DataType *arg_minlevel = glmsg.add_args();
    arg_minlevel->set_isarray(false);
    arg_minlevel->set_type(GLMessage::DataType::INT);
    arg_minlevel->add_intvalue(minlevel);

    // copy argument numlevels
    GLMessage_DataType *arg_numlevels = glmsg.add_args();
    arg_numlevels->set_isarray(false);
    arg_numlevels->set_type(GLMessage::DataType::INT);
    arg_numlevels->add_intvalue(numlevels);

    // copy argument minlayer
    GLMessage_DataType *arg_minlayer = glmsg.add_args();
    arg_minlayer->set_isarray(false);
    arg_minlayer->set_type(GLMessage::DataType::INT);
    arg_minlayer->add_intvalue(minlayer);

    // copy argument numlayers
    GLMessage_DataType *arg_numlayers = glmsg.add_args();
    arg_numlayers->set_isarray(false);
    arg_numlayers->set_type(GLMessage::DataType::INT);
    arg_numlayers->add_intvalue(numlayers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureViewEXT(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleIMG(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleIMG);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2DMultisampleIMG(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2DMultisampleIMG);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBeginPerfQueryINTEL(GLuint queryHandle) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginPerfQueryINTEL);

    // copy argument queryHandle
    GLMessage_DataType *arg_queryHandle = glmsg.add_args();
    arg_queryHandle->set_isarray(false);
    arg_queryHandle->set_type(GLMessage::DataType::INT);
    arg_queryHandle->add_intvalue(queryHandle);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginPerfQueryINTEL(queryHandle);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCreatePerfQueryINTEL(GLuint queryId, GLuint * queryHandle) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreatePerfQueryINTEL);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT);
    arg_queryId->add_intvalue(queryId);

    // copy argument queryHandle
    GLMessage_DataType *arg_queryHandle = glmsg.add_args();
    arg_queryHandle->set_isarray(false);
    arg_queryHandle->set_type(GLMessage::DataType::INT64);
    arg_queryHandle->add_int64value((uintptr_t)queryHandle);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCreatePerfQueryINTEL(queryId, queryHandle);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) queryHandle,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeletePerfQueryINTEL(GLuint queryHandle) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeletePerfQueryINTEL);

    // copy argument queryHandle
    GLMessage_DataType *arg_queryHandle = glmsg.add_args();
    arg_queryHandle->set_isarray(false);
    arg_queryHandle->set_type(GLMessage::DataType::INT);
    arg_queryHandle->add_intvalue(queryHandle);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeletePerfQueryINTEL(queryHandle);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndPerfQueryINTEL(GLuint queryHandle) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndPerfQueryINTEL);

    // copy argument queryHandle
    GLMessage_DataType *arg_queryHandle = glmsg.add_args();
    arg_queryHandle->set_isarray(false);
    arg_queryHandle->set_type(GLMessage::DataType::INT);
    arg_queryHandle->add_intvalue(queryHandle);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndPerfQueryINTEL(queryHandle);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFirstPerfQueryIdINTEL(GLuint * queryId) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFirstPerfQueryIdINTEL);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT64);
    arg_queryId->add_int64value((uintptr_t)queryId);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFirstPerfQueryIdINTEL(queryId);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) queryId,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetNextPerfQueryIdINTEL(GLuint queryId, GLuint * nextQueryId) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetNextPerfQueryIdINTEL);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT);
    arg_queryId->add_intvalue(queryId);

    // copy argument nextQueryId
    GLMessage_DataType *arg_nextQueryId = glmsg.add_args();
    arg_nextQueryId->set_isarray(false);
    arg_nextQueryId->set_type(GLMessage::DataType::INT64);
    arg_nextQueryId->add_int64value((uintptr_t)nextQueryId);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetNextPerfQueryIdINTEL(queryId, nextQueryId);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) nextQueryId,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfCounterInfoINTEL(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar * counterName, GLuint counterDescLength, GLchar * counterDesc, GLuint * counterOffset, GLuint * counterDataSize, GLuint * counterTypeEnum, GLuint * counterDataTypeEnum, GLuint64 * rawCounterMaxValue) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfCounterInfoINTEL);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT);
    arg_queryId->add_intvalue(queryId);

    // copy argument counterId
    GLMessage_DataType *arg_counterId = glmsg.add_args();
    arg_counterId->set_isarray(false);
    arg_counterId->set_type(GLMessage::DataType::INT);
    arg_counterId->add_intvalue(counterId);

    // copy argument counterNameLength
    GLMessage_DataType *arg_counterNameLength = glmsg.add_args();
    arg_counterNameLength->set_isarray(false);
    arg_counterNameLength->set_type(GLMessage::DataType::INT);
    arg_counterNameLength->add_intvalue(counterNameLength);

    // copy argument counterName
    GLMessage_DataType *arg_counterName = glmsg.add_args();
    arg_counterName->set_isarray(false);
    arg_counterName->set_type(GLMessage::DataType::INT64);
    arg_counterName->add_int64value((uintptr_t)counterName);

    // copy argument counterDescLength
    GLMessage_DataType *arg_counterDescLength = glmsg.add_args();
    arg_counterDescLength->set_isarray(false);
    arg_counterDescLength->set_type(GLMessage::DataType::INT);
    arg_counterDescLength->add_intvalue(counterDescLength);

    // copy argument counterDesc
    GLMessage_DataType *arg_counterDesc = glmsg.add_args();
    arg_counterDesc->set_isarray(false);
    arg_counterDesc->set_type(GLMessage::DataType::INT64);
    arg_counterDesc->add_int64value((uintptr_t)counterDesc);

    // copy argument counterOffset
    GLMessage_DataType *arg_counterOffset = glmsg.add_args();
    arg_counterOffset->set_isarray(false);
    arg_counterOffset->set_type(GLMessage::DataType::INT64);
    arg_counterOffset->add_int64value((uintptr_t)counterOffset);

    // copy argument counterDataSize
    GLMessage_DataType *arg_counterDataSize = glmsg.add_args();
    arg_counterDataSize->set_isarray(false);
    arg_counterDataSize->set_type(GLMessage::DataType::INT64);
    arg_counterDataSize->add_int64value((uintptr_t)counterDataSize);

    // copy argument counterTypeEnum
    GLMessage_DataType *arg_counterTypeEnum = glmsg.add_args();
    arg_counterTypeEnum->set_isarray(false);
    arg_counterTypeEnum->set_type(GLMessage::DataType::INT64);
    arg_counterTypeEnum->add_int64value((uintptr_t)counterTypeEnum);

    // copy argument counterDataTypeEnum
    GLMessage_DataType *arg_counterDataTypeEnum = glmsg.add_args();
    arg_counterDataTypeEnum->set_isarray(false);
    arg_counterDataTypeEnum->set_type(GLMessage::DataType::INT64);
    arg_counterDataTypeEnum->add_int64value((uintptr_t)counterDataTypeEnum);

    // copy argument rawCounterMaxValue
    GLMessage_DataType *arg_rawCounterMaxValue = glmsg.add_args();
    arg_rawCounterMaxValue->set_isarray(false);
    arg_rawCounterMaxValue->set_type(GLMessage::DataType::INT64);
    arg_rawCounterMaxValue->add_int64value((uintptr_t)rawCounterMaxValue);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) counterName,
        (void *) counterDesc,
        (void *) counterOffset,
        (void *) counterDataSize,
        (void *) counterTypeEnum,
        (void *) counterDataTypeEnum,
        (void *) rawCounterMaxValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfQueryDataINTEL(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid * data, GLuint * bytesWritten) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfQueryDataINTEL);

    // copy argument queryHandle
    GLMessage_DataType *arg_queryHandle = glmsg.add_args();
    arg_queryHandle->set_isarray(false);
    arg_queryHandle->set_type(GLMessage::DataType::INT);
    arg_queryHandle->add_intvalue(queryHandle);

    // copy argument flags
    GLMessage_DataType *arg_flags = glmsg.add_args();
    arg_flags->set_isarray(false);
    arg_flags->set_type(GLMessage::DataType::INT);
    arg_flags->add_intvalue(flags);

    // copy argument dataSize
    GLMessage_DataType *arg_dataSize = glmsg.add_args();
    arg_dataSize->set_isarray(false);
    arg_dataSize->set_type(GLMessage::DataType::INT);
    arg_dataSize->add_intvalue(dataSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT64);
    arg_data->add_int64value((uintptr_t)data);

    // copy argument bytesWritten
    GLMessage_DataType *arg_bytesWritten = glmsg.add_args();
    arg_bytesWritten->set_isarray(false);
    arg_bytesWritten->set_type(GLMessage::DataType::INT64);
    arg_bytesWritten->add_int64value((uintptr_t)bytesWritten);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfQueryDataINTEL(queryHandle, flags, dataSize, data, bytesWritten);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
        (void *) bytesWritten,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfQueryIdByNameINTEL(GLchar * queryName, GLuint * queryId) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfQueryIdByNameINTEL);

    // copy argument queryName
    GLMessage_DataType *arg_queryName = glmsg.add_args();
    arg_queryName->set_isarray(false);
    arg_queryName->set_type(GLMessage::DataType::INT64);
    arg_queryName->add_int64value((uintptr_t)queryName);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT64);
    arg_queryId->add_int64value((uintptr_t)queryId);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfQueryIdByNameINTEL(queryName, queryId);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) queryName,
        (void *) queryId,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfQueryInfoINTEL(GLuint queryId, GLuint queryNameLength, GLchar * queryName, GLuint * dataSize, GLuint * noCounters, GLuint * noInstances, GLuint * capsMask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfQueryInfoINTEL);

    // copy argument queryId
    GLMessage_DataType *arg_queryId = glmsg.add_args();
    arg_queryId->set_isarray(false);
    arg_queryId->set_type(GLMessage::DataType::INT);
    arg_queryId->add_intvalue(queryId);

    // copy argument queryNameLength
    GLMessage_DataType *arg_queryNameLength = glmsg.add_args();
    arg_queryNameLength->set_isarray(false);
    arg_queryNameLength->set_type(GLMessage::DataType::INT);
    arg_queryNameLength->add_intvalue(queryNameLength);

    // copy argument queryName
    GLMessage_DataType *arg_queryName = glmsg.add_args();
    arg_queryName->set_isarray(false);
    arg_queryName->set_type(GLMessage::DataType::INT64);
    arg_queryName->add_int64value((uintptr_t)queryName);

    // copy argument dataSize
    GLMessage_DataType *arg_dataSize = glmsg.add_args();
    arg_dataSize->set_isarray(false);
    arg_dataSize->set_type(GLMessage::DataType::INT64);
    arg_dataSize->add_int64value((uintptr_t)dataSize);

    // copy argument noCounters
    GLMessage_DataType *arg_noCounters = glmsg.add_args();
    arg_noCounters->set_isarray(false);
    arg_noCounters->set_type(GLMessage::DataType::INT64);
    arg_noCounters->add_int64value((uintptr_t)noCounters);

    // copy argument noInstances
    GLMessage_DataType *arg_noInstances = glmsg.add_args();
    arg_noInstances->set_isarray(false);
    arg_noInstances->set_type(GLMessage::DataType::INT64);
    arg_noInstances->add_int64value((uintptr_t)noInstances);

    // copy argument capsMask
    GLMessage_DataType *arg_capsMask = glmsg.add_args();
    arg_capsMask->set_isarray(false);
    arg_capsMask->set_type(GLMessage::DataType::INT64);
    arg_capsMask->add_int64value((uintptr_t)capsMask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfQueryInfoINTEL(queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) queryName,
        (void *) dataSize,
        (void *) noCounters,
        (void *) noInstances,
        (void *) capsMask,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendParameteriNV(GLenum pname, GLint value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendParameteriNV);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendParameteriNV(pname, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendBarrierNV(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendBarrierNV);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendBarrierNV();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyBufferSubDataNV(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyBufferSubDataNV);

    // copy argument readTarget
    GLMessage_DataType *arg_readTarget = glmsg.add_args();
    arg_readTarget->set_isarray(false);
    arg_readTarget->set_type(GLMessage::DataType::ENUM);
    arg_readTarget->add_intvalue((int)readTarget);

    // copy argument writeTarget
    GLMessage_DataType *arg_writeTarget = glmsg.add_args();
    arg_writeTarget->set_isarray(false);
    arg_writeTarget->set_type(GLMessage::DataType::ENUM);
    arg_writeTarget->add_intvalue((int)writeTarget);

    // copy argument readOffset
    GLMessage_DataType *arg_readOffset = glmsg.add_args();
    arg_readOffset->set_isarray(false);
    arg_readOffset->set_type(GLMessage::DataType::INT);
    arg_readOffset->add_intvalue(readOffset);

    // copy argument writeOffset
    GLMessage_DataType *arg_writeOffset = glmsg.add_args();
    arg_writeOffset->set_isarray(false);
    arg_writeOffset->set_type(GLMessage::DataType::INT);
    arg_writeOffset->add_intvalue(writeOffset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyBufferSubDataNV(readTarget, writeTarget, readOffset, writeOffset, size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCoverageMaskNV(GLboolean mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCoverageMaskNV);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::BOOL);
    arg_mask->add_boolvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCoverageMaskNV(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCoverageOperationNV(GLenum operation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCoverageOperationNV);

    // copy argument operation
    GLMessage_DataType *arg_operation = glmsg.add_args();
    arg_operation->set_isarray(false);
    arg_operation->set_type(GLMessage::DataType::ENUM);
    arg_operation->add_intvalue((int)operation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCoverageOperationNV(operation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawBuffersNV(GLsizei n, const GLenum * bufs) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawBuffersNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument bufs
    GLMessage_DataType *arg_bufs = glmsg.add_args();
    arg_bufs->set_isarray(false);
    arg_bufs->set_type(GLMessage::DataType::INT64);
    arg_bufs->add_int64value((uintptr_t)bufs);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawBuffersNV(n, bufs);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) bufs,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArraysInstancedNV(GLenum mode, GLint first, GLsizei count, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArraysInstancedNV);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue(first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArraysInstancedNV(mode, first, count, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElementsInstancedNV(GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElementsInstancedNV);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT64);
    arg_indices->add_int64value((uintptr_t)indices);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElementsInstancedNV(mode, count, type, indices, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteFencesNV(GLsizei n, const GLuint * fences) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteFencesNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument fences
    GLMessage_DataType *arg_fences = glmsg.add_args();
    arg_fences->set_isarray(false);
    arg_fences->set_type(GLMessage::DataType::INT64);
    arg_fences->add_int64value((uintptr_t)fences);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteFencesNV(n, fences);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) fences,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenFencesNV(GLsizei n, GLuint * fences) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenFencesNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument fences
    GLMessage_DataType *arg_fences = glmsg.add_args();
    arg_fences->set_isarray(false);
    arg_fences->set_type(GLMessage::DataType::INT64);
    arg_fences->add_int64value((uintptr_t)fences);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenFencesNV(n, fences);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) fences,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glTestFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTestFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glTestFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetFenceivNV(GLuint fence, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFenceivNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFenceivNV(fence, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFinishFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFinishFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFinishFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSetFenceNV(GLuint fence, GLenum condition) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSetFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // copy argument condition
    GLMessage_DataType *arg_condition = glmsg.add_args();
    arg_condition->set_isarray(false);
    arg_condition->set_type(GLMessage::DataType::ENUM);
    arg_condition->add_intvalue((int)condition);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSetFenceNV(fence, condition);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlitFramebufferNV(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlitFramebufferNV);

    // copy argument srcX0
    GLMessage_DataType *arg_srcX0 = glmsg.add_args();
    arg_srcX0->set_isarray(false);
    arg_srcX0->set_type(GLMessage::DataType::INT);
    arg_srcX0->add_intvalue(srcX0);

    // copy argument srcY0
    GLMessage_DataType *arg_srcY0 = glmsg.add_args();
    arg_srcY0->set_isarray(false);
    arg_srcY0->set_type(GLMessage::DataType::INT);
    arg_srcY0->add_intvalue(srcY0);

    // copy argument srcX1
    GLMessage_DataType *arg_srcX1 = glmsg.add_args();
    arg_srcX1->set_isarray(false);
    arg_srcX1->set_type(GLMessage::DataType::INT);
    arg_srcX1->add_intvalue(srcX1);

    // copy argument srcY1
    GLMessage_DataType *arg_srcY1 = glmsg.add_args();
    arg_srcY1->set_isarray(false);
    arg_srcY1->set_type(GLMessage::DataType::INT);
    arg_srcY1->add_intvalue(srcY1);

    // copy argument dstX0
    GLMessage_DataType *arg_dstX0 = glmsg.add_args();
    arg_dstX0->set_isarray(false);
    arg_dstX0->set_type(GLMessage::DataType::INT);
    arg_dstX0->add_intvalue(dstX0);

    // copy argument dstY0
    GLMessage_DataType *arg_dstY0 = glmsg.add_args();
    arg_dstY0->set_isarray(false);
    arg_dstY0->set_type(GLMessage::DataType::INT);
    arg_dstY0->add_intvalue(dstY0);

    // copy argument dstX1
    GLMessage_DataType *arg_dstX1 = glmsg.add_args();
    arg_dstX1->set_isarray(false);
    arg_dstX1->set_type(GLMessage::DataType::INT);
    arg_dstX1->add_intvalue(dstX1);

    // copy argument dstY1
    GLMessage_DataType *arg_dstY1 = glmsg.add_args();
    arg_dstY1->set_isarray(false);
    arg_dstY1->set_type(GLMessage::DataType::INT);
    arg_dstY1->add_intvalue(dstY1);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // copy argument filter
    GLMessage_DataType *arg_filter = glmsg.add_args();
    arg_filter->set_isarray(false);
    arg_filter->set_type(GLMessage::DataType::ENUM);
    arg_filter->add_intvalue((int)filter);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleNV(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleNV);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleNV(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribDivisorNV(GLuint index, GLuint divisor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribDivisorNV);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument divisor
    GLMessage_DataType *arg_divisor = glmsg.add_args();
    arg_divisor->set_isarray(false);
    arg_divisor->set_type(GLMessage::DataType::INT);
    arg_divisor->add_intvalue(divisor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribDivisorNV(index, divisor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2x3fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2x3fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2x3fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3x2fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3x2fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3x2fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2x4fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2x4fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2x4fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4x2fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4x2fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4x2fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3x4fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3x4fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3x4fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4x3fvNV(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4x3fvNV);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT64);
    arg_value->add_int64value((uintptr_t)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4x3fvNV(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadBufferNV(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadBufferNV);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadBufferNV(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAlphaFuncQCOM(GLenum func, GLclampf ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFuncQCOM);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::FLOAT);
    arg_ref->add_floatvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFuncQCOM(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetDriverControlsQCOM(GLint * num, GLsizei size, GLuint * driverControls) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetDriverControlsQCOM);

    // copy argument num
    GLMessage_DataType *arg_num = glmsg.add_args();
    arg_num->set_isarray(false);
    arg_num->set_type(GLMessage::DataType::INT64);
    arg_num->add_int64value((uintptr_t)num);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument driverControls
    GLMessage_DataType *arg_driverControls = glmsg.add_args();
    arg_driverControls->set_isarray(false);
    arg_driverControls->set_type(GLMessage::DataType::INT64);
    arg_driverControls->add_int64value((uintptr_t)driverControls);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetDriverControlsQCOM(num, size, driverControls);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) num,
        (void *) driverControls,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetDriverControlStringQCOM(GLuint driverControl, GLsizei bufSize, GLsizei * length, GLchar * driverControlString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetDriverControlStringQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // copy argument driverControlString
    GLMessage_DataType *arg_driverControlString = glmsg.add_args();
    arg_driverControlString->set_isarray(false);
    arg_driverControlString->set_type(GLMessage::DataType::INT64);
    arg_driverControlString->add_int64value((uintptr_t)driverControlString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) driverControlString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableDriverControlQCOM(GLuint driverControl) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableDriverControlQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableDriverControlQCOM(driverControl);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableDriverControlQCOM(GLuint driverControl) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableDriverControlQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableDriverControlQCOM(driverControl);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexturesQCOM(GLuint * textures, GLint maxTextures, GLint * numTextures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexturesQCOM);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT64);
    arg_textures->add_int64value((uintptr_t)textures);

    // copy argument maxTextures
    GLMessage_DataType *arg_maxTextures = glmsg.add_args();
    arg_maxTextures->set_isarray(false);
    arg_maxTextures->set_type(GLMessage::DataType::INT);
    arg_maxTextures->add_intvalue(maxTextures);

    // copy argument numTextures
    GLMessage_DataType *arg_numTextures = glmsg.add_args();
    arg_numTextures->set_isarray(false);
    arg_numTextures->set_type(GLMessage::DataType::INT64);
    arg_numTextures->add_int64value((uintptr_t)numTextures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexturesQCOM(textures, maxTextures, numTextures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
        (void *) numTextures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetBuffersQCOM(GLuint * buffers, GLint maxBuffers, GLint * numBuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetBuffersQCOM);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT64);
    arg_buffers->add_int64value((uintptr_t)buffers);

    // copy argument maxBuffers
    GLMessage_DataType *arg_maxBuffers = glmsg.add_args();
    arg_maxBuffers->set_isarray(false);
    arg_maxBuffers->set_type(GLMessage::DataType::INT);
    arg_maxBuffers->add_intvalue(maxBuffers);

    // copy argument numBuffers
    GLMessage_DataType *arg_numBuffers = glmsg.add_args();
    arg_numBuffers->set_isarray(false);
    arg_numBuffers->set_type(GLMessage::DataType::INT64);
    arg_numBuffers->add_int64value((uintptr_t)numBuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetBuffersQCOM(buffers, maxBuffers, numBuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
        (void *) numBuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetRenderbuffersQCOM(GLuint * renderbuffers, GLint maxRenderbuffers, GLint * numRenderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetRenderbuffersQCOM);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT64);
    arg_renderbuffers->add_int64value((uintptr_t)renderbuffers);

    // copy argument maxRenderbuffers
    GLMessage_DataType *arg_maxRenderbuffers = glmsg.add_args();
    arg_maxRenderbuffers->set_isarray(false);
    arg_maxRenderbuffers->set_type(GLMessage::DataType::INT);
    arg_maxRenderbuffers->add_intvalue(maxRenderbuffers);

    // copy argument numRenderbuffers
    GLMessage_DataType *arg_numRenderbuffers = glmsg.add_args();
    arg_numRenderbuffers->set_isarray(false);
    arg_numRenderbuffers->set_type(GLMessage::DataType::INT64);
    arg_numRenderbuffers->add_int64value((uintptr_t)numRenderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
        (void *) numRenderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetFramebuffersQCOM(GLuint * framebuffers, GLint maxFramebuffers, GLint * numFramebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetFramebuffersQCOM);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT64);
    arg_framebuffers->add_int64value((uintptr_t)framebuffers);

    // copy argument maxFramebuffers
    GLMessage_DataType *arg_maxFramebuffers = glmsg.add_args();
    arg_maxFramebuffers->set_isarray(false);
    arg_maxFramebuffers->set_type(GLMessage::DataType::INT);
    arg_maxFramebuffers->add_intvalue(maxFramebuffers);

    // copy argument numFramebuffers
    GLMessage_DataType *arg_numFramebuffers = glmsg.add_args();
    arg_numFramebuffers->set_isarray(false);
    arg_numFramebuffers->set_type(GLMessage::DataType::INT64);
    arg_numFramebuffers->add_int64value((uintptr_t)numFramebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
        (void *) numFramebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexLevelParameterivQCOM(GLuint texture, GLenum face, GLint level, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexLevelParameterivQCOM);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexLevelParameterivQCOM(texture, face, level, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtTexObjectStateOverrideiQCOM(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtTexObjectStateOverrideiQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtTexObjectStateOverrideiQCOM(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexSubImageQCOM(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void * texels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexSubImageQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument texels
    GLMessage_DataType *arg_texels = glmsg.add_args();
    arg_texels->set_isarray(false);
    arg_texels->set_type(GLMessage::DataType::INT64);
    arg_texels->add_int64value((uintptr_t)texels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) texels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetBufferPointervQCOM(GLenum target, void ** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetBufferPointervQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetBufferPointervQCOM(target, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetShadersQCOM(GLuint * shaders, GLint maxShaders, GLint * numShaders) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetShadersQCOM);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT64);
    arg_shaders->add_int64value((uintptr_t)shaders);

    // copy argument maxShaders
    GLMessage_DataType *arg_maxShaders = glmsg.add_args();
    arg_maxShaders->set_isarray(false);
    arg_maxShaders->set_type(GLMessage::DataType::INT);
    arg_maxShaders->add_intvalue(maxShaders);

    // copy argument numShaders
    GLMessage_DataType *arg_numShaders = glmsg.add_args();
    arg_numShaders->set_isarray(false);
    arg_numShaders->set_type(GLMessage::DataType::INT64);
    arg_numShaders->add_int64value((uintptr_t)numShaders);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetShadersQCOM(shaders, maxShaders, numShaders);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) shaders,
        (void *) numShaders,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetProgramsQCOM(GLuint * programs, GLint maxPrograms, GLint * numPrograms) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetProgramsQCOM);

    // copy argument programs
    GLMessage_DataType *arg_programs = glmsg.add_args();
    arg_programs->set_isarray(false);
    arg_programs->set_type(GLMessage::DataType::INT64);
    arg_programs->add_int64value((uintptr_t)programs);

    // copy argument maxPrograms
    GLMessage_DataType *arg_maxPrograms = glmsg.add_args();
    arg_maxPrograms->set_isarray(false);
    arg_maxPrograms->set_type(GLMessage::DataType::INT);
    arg_maxPrograms->add_intvalue(maxPrograms);

    // copy argument numPrograms
    GLMessage_DataType *arg_numPrograms = glmsg.add_args();
    arg_numPrograms->set_isarray(false);
    arg_numPrograms->set_type(GLMessage::DataType::INT64);
    arg_numPrograms->add_int64value((uintptr_t)numPrograms);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetProgramsQCOM(programs, maxPrograms, numPrograms);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) programs,
        (void *) numPrograms,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glExtIsProgramBinaryQCOM(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtIsProgramBinaryQCOM);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glExtIsProgramBinaryQCOM(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glExtGetProgramBinarySourceQCOM(GLuint program, GLenum shadertype, GLchar * source, GLint * length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetProgramBinarySourceQCOM);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shadertype
    GLMessage_DataType *arg_shadertype = glmsg.add_args();
    arg_shadertype->set_isarray(false);
    arg_shadertype->set_type(GLMessage::DataType::ENUM);
    arg_shadertype->add_intvalue((int)shadertype);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::INT64);
    arg_source->add_int64value((uintptr_t)source);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT64);
    arg_length->add_int64value((uintptr_t)length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetProgramBinarySourceQCOM(program, shadertype, source, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) source,
        (void *) length,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStartTilingQCOM);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument preserveMask
    GLMessage_DataType *arg_preserveMask = glmsg.add_args();
    arg_preserveMask->set_isarray(false);
    arg_preserveMask->set_type(GLMessage::DataType::INT);
    arg_preserveMask->add_intvalue(preserveMask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStartTilingQCOM(x, y, width, height, preserveMask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndTilingQCOM(GLbitfield preserveMask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndTilingQCOM);

    // copy argument preserveMask
    GLMessage_DataType *arg_preserveMask = glmsg.add_args();
    arg_preserveMask->set_isarray(false);
    arg_preserveMask->set_type(GLMessage::DataType::INT);
    arg_preserveMask->add_intvalue(preserveMask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndTilingQCOM(preserveMask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL1 APIs

void GLTrace_glAlphaFunc(GLenum func, GLfloat ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::FLOAT);
    arg_ref->add_floatvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFunc(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanef(GLenum p, const GLfloat * eqn) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanef);

    // copy argument p
    GLMessage_DataType *arg_p = glmsg.add_args();
    arg_p->set_isarray(false);
    arg_p->set_type(GLMessage::DataType::ENUM);
    arg_p->add_intvalue((int)p);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT64);
    arg_eqn->add_int64value((uintptr_t)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanef(p, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4f);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4f(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogfv(GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumf);

    // copy argument l
    GLMessage_DataType *arg_l = glmsg.add_args();
    arg_l->set_isarray(false);
    arg_l->set_type(GLMessage::DataType::FLOAT);
    arg_l->add_floatvalue(l);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::FLOAT);
    arg_r->add_floatvalue(r);

    // copy argument b
    GLMessage_DataType *arg_b = glmsg.add_args();
    arg_b->set_isarray(false);
    arg_b->set_type(GLMessage::DataType::FLOAT);
    arg_b->add_floatvalue(b);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::FLOAT);
    arg_t->add_floatvalue(t);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::FLOAT);
    arg_n->add_floatvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::FLOAT);
    arg_f->add_floatvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumf(l, r, b, t, n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanef(GLenum plane, GLfloat * equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanef);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT64);
    arg_equation->add_int64value((uintptr_t)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanef(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetLightfv(GLenum light, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetLightfv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetLightfv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMaterialfv(GLenum face, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMaterialfv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMaterialfv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnvfv(GLenum target, GLenum pname, GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnvfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnvfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelfv(GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightf(GLenum light, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightf);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightf(light, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightfv(GLenum light, GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightfv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightfv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadMatrixf(const GLfloat * m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadMatrixf);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT64);
    arg_m->add_int64value((uintptr_t)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadMatrixf(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialf(GLenum face, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialf);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialf(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialfv(GLenum face, GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialfv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialfv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultMatrixf(const GLfloat * m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultMatrixf);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT64);
    arg_m->add_int64value((uintptr_t)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultMatrixf(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4f);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::FLOAT);
    arg_s->add_floatvalue(s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::FLOAT);
    arg_t->add_floatvalue(t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::FLOAT);
    arg_r->add_floatvalue(r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::FLOAT);
    arg_q->add_floatvalue(q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4f(target, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormal3f);

    // copy argument nx
    GLMessage_DataType *arg_nx = glmsg.add_args();
    arg_nx->set_isarray(false);
    arg_nx->set_type(GLMessage::DataType::FLOAT);
    arg_nx->add_floatvalue(nx);

    // copy argument ny
    GLMessage_DataType *arg_ny = glmsg.add_args();
    arg_ny->set_isarray(false);
    arg_ny->set_type(GLMessage::DataType::FLOAT);
    arg_ny->add_floatvalue(ny);

    // copy argument nz
    GLMessage_DataType *arg_nz = glmsg.add_args();
    arg_nz->set_isarray(false);
    arg_nz->set_type(GLMessage::DataType::FLOAT);
    arg_nz->add_floatvalue(nz);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormal3f(nx, ny, nz);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthof);

    // copy argument l
    GLMessage_DataType *arg_l = glmsg.add_args();
    arg_l->set_isarray(false);
    arg_l->set_type(GLMessage::DataType::FLOAT);
    arg_l->add_floatvalue(l);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::FLOAT);
    arg_r->add_floatvalue(r);

    // copy argument b
    GLMessage_DataType *arg_b = glmsg.add_args();
    arg_b->set_isarray(false);
    arg_b->set_type(GLMessage::DataType::FLOAT);
    arg_b->add_floatvalue(b);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::FLOAT);
    arg_t->add_floatvalue(t);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::FLOAT);
    arg_n->add_floatvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::FLOAT);
    arg_f->add_floatvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthof(l, r, b, t, n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterfv(GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSize(GLfloat size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSize);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::FLOAT);
    arg_size->add_floatvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSize(size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRotatef);

    // copy argument angle
    GLMessage_DataType *arg_angle = glmsg.add_args();
    arg_angle->set_isarray(false);
    arg_angle->set_type(GLMessage::DataType::FLOAT);
    arg_angle->add_floatvalue(angle);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRotatef(angle, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScalef(GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScalef);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScalef(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvf(GLenum target, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvf);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvf(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvfv(GLenum target, GLenum pname, const GLfloat * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTranslatef(GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTranslatef);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTranslatef(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAlphaFuncx(GLenum func, GLfixed ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFuncx);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFuncx(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearColorx);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearColorx(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthx(GLfixed depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthx);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthx(depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClientActiveTexture(GLenum texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClientActiveTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClientActiveTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanex(GLenum plane, const GLfixed * equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanex);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT64);
    arg_equation->add_int64value((uintptr_t)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanex(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4ub);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::BYTE);
    arg_red->add_intvalue((int)red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::BYTE);
    arg_green->add_intvalue((int)green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::BYTE);
    arg_blue->add_intvalue((int)blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::BYTE);
    arg_alpha->add_intvalue((int)alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4ub(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4x);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4x(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColorPointer(GLint size, GLenum type, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColorPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColorPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthRangex(GLfixed n, GLfixed f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangex);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::INT);
    arg_f->add_intvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangex(n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableClientState(GLenum array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableClientState);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::ENUM);
    arg_array->add_intvalue((int)array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableClientState(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableClientState(GLenum array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableClientState);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::ENUM);
    arg_array->add_intvalue((int)array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableClientState(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogxv(GLenum pname, const GLfixed * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogxv(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumx);

    // copy argument l
    GLMessage_DataType *arg_l = glmsg.add_args();
    arg_l->set_isarray(false);
    arg_l->set_type(GLMessage::DataType::INT);
    arg_l->add_intvalue(l);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::INT);
    arg_r->add_intvalue(r);

    // copy argument b
    GLMessage_DataType *arg_b = glmsg.add_args();
    arg_b->set_isarray(false);
    arg_b->set_type(GLMessage::DataType::INT);
    arg_b->add_intvalue(b);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::INT);
    arg_t->add_intvalue(t);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::INT);
    arg_f->add_intvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumx(l, r, b, t, n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanex(GLenum plane, GLfixed * equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanex);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT64);
    arg_equation->add_int64value((uintptr_t)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanex(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFixedv(GLenum pname, GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFixedv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFixedv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetLightxv(GLenum light, GLenum pname, GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetLightxv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetLightxv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMaterialxv(GLenum face, GLenum pname, GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMaterialxv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMaterialxv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPointerv(GLenum pname, void ** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPointerv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPointerv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnviv(GLenum target, GLenum pname, GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnviv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnviv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnvxv(GLenum target, GLenum pname, GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnvxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnvxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameterxv(GLenum target, GLenum pname, GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelxv(GLenum pname, const GLfixed * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelxv(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightx(GLenum light, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightx);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightx(light, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightxv(GLenum light, GLenum pname, const GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightxv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightxv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLineWidthx(GLfixed width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLineWidthx);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLineWidthx(width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadIdentity(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadIdentity);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadIdentity();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadMatrixx(const GLfixed * m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadMatrixx);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT64);
    arg_m->add_int64value((uintptr_t)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadMatrixx(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLogicOp(GLenum opcode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLogicOp);

    // copy argument opcode
    GLMessage_DataType *arg_opcode = glmsg.add_args();
    arg_opcode->set_isarray(false);
    arg_opcode->set_type(GLMessage::DataType::ENUM);
    arg_opcode->add_intvalue((int)opcode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLogicOp(opcode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialx(GLenum face, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialx);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialx(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialxv(GLenum face, GLenum pname, const GLfixed * param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialxv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT64);
    arg_param->add_int64value((uintptr_t)param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialxv(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) param,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMatrixMode(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMatrixMode);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMatrixMode(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultMatrixx(const GLfixed * m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultMatrixx);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT64);
    arg_m->add_int64value((uintptr_t)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultMatrixx(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4x);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::INT);
    arg_s->add_intvalue(s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::INT);
    arg_t->add_intvalue(t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::INT);
    arg_r->add_intvalue(r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::INT);
    arg_q->add_intvalue(q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4x(texture, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormal3x);

    // copy argument nx
    GLMessage_DataType *arg_nx = glmsg.add_args();
    arg_nx->set_isarray(false);
    arg_nx->set_type(GLMessage::DataType::INT);
    arg_nx->add_intvalue(nx);

    // copy argument ny
    GLMessage_DataType *arg_ny = glmsg.add_args();
    arg_ny->set_isarray(false);
    arg_ny->set_type(GLMessage::DataType::INT);
    arg_ny->add_intvalue(ny);

    // copy argument nz
    GLMessage_DataType *arg_nz = glmsg.add_args();
    arg_nz->set_isarray(false);
    arg_nz->set_type(GLMessage::DataType::INT);
    arg_nz->add_intvalue(nz);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormal3x(nx, ny, nz);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormalPointer(GLenum type, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormalPointer);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormalPointer(type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthox);

    // copy argument l
    GLMessage_DataType *arg_l = glmsg.add_args();
    arg_l->set_isarray(false);
    arg_l->set_type(GLMessage::DataType::INT);
    arg_l->add_intvalue(l);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::INT);
    arg_r->add_intvalue(r);

    // copy argument b
    GLMessage_DataType *arg_b = glmsg.add_args();
    arg_b->set_isarray(false);
    arg_b->set_type(GLMessage::DataType::INT);
    arg_b->add_intvalue(b);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::INT);
    arg_t->add_intvalue(t);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument f
    GLMessage_DataType *arg_f = glmsg.add_args();
    arg_f->set_isarray(false);
    arg_f->set_type(GLMessage::DataType::INT);
    arg_f->add_intvalue(f);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthox(l, r, b, t, n, f);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterxv(GLenum pname, const GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterxv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSizex(GLfixed size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSizex);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSizex(size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPolygonOffsetx(GLfixed factor, GLfixed units) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPolygonOffsetx);

    // copy argument factor
    GLMessage_DataType *arg_factor = glmsg.add_args();
    arg_factor->set_isarray(false);
    arg_factor->set_type(GLMessage::DataType::INT);
    arg_factor->add_intvalue(factor);

    // copy argument units
    GLMessage_DataType *arg_units = glmsg.add_args();
    arg_units->set_isarray(false);
    arg_units->set_type(GLMessage::DataType::INT);
    arg_units->add_intvalue(units);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPolygonOffsetx(factor, units);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPopMatrix(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPopMatrix);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPopMatrix();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPushMatrix(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPushMatrix);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPushMatrix();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRotatex);

    // copy argument angle
    GLMessage_DataType *arg_angle = glmsg.add_args();
    arg_angle->set_isarray(false);
    arg_angle->set_type(GLMessage::DataType::INT);
    arg_angle->add_intvalue(angle);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRotatex(angle, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleCoveragex(GLclampx value, GLboolean invert) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleCoveragex);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // copy argument invert
    GLMessage_DataType *arg_invert = glmsg.add_args();
    arg_invert->set_isarray(false);
    arg_invert->set_type(GLMessage::DataType::BOOL);
    arg_invert->add_boolvalue(invert);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleCoveragex(value, invert);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScalex(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScalex);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScalex(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShadeModel(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShadeModel);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShadeModel(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoordPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoordPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvi(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvi);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvi(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvx(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvx);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvx(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnviv(GLenum target, GLenum pname, const GLint * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnviv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnviv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvxv(GLenum target, GLenum pname, const GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterx(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterx);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterx(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterxv(GLenum target, GLenum pname, const GLfixed * params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT64);
    arg_params->add_int64value((uintptr_t)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTranslatex(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTranslatex);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTranslatex(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexPointer(GLint size, GLenum type, GLsizei stride, const void * pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT64);
    arg_pointer->add_int64value((uintptr_t)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL1Ext APIs

void GLTrace_glBlendEquationSeparateOES(GLenum modeRGB, GLenum modeAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationSeparateOES);

    // copy argument modeRGB
    GLMessage_DataType *arg_modeRGB = glmsg.add_args();
    arg_modeRGB->set_isarray(false);
    arg_modeRGB->set_type(GLMessage::DataType::ENUM);
    arg_modeRGB->add_intvalue((int)modeRGB);

    // copy argument modeAlpha
    GLMessage_DataType *arg_modeAlpha = glmsg.add_args();
    arg_modeAlpha->set_isarray(false);
    arg_modeAlpha->set_type(GLMessage::DataType::ENUM);
    arg_modeAlpha->add_intvalue((int)modeAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationSeparateOES(modeRGB, modeAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFuncSeparateOES(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFuncSeparateOES);

    // copy argument srcRGB
    GLMessage_DataType *arg_srcRGB = glmsg.add_args();
    arg_srcRGB->set_isarray(false);
    arg_srcRGB->set_type(GLMessage::DataType::ENUM);
    arg_srcRGB->add_intvalue((int)srcRGB);

    // copy argument dstRGB
    GLMessage_DataType *arg_dstRGB = glmsg.add_args();
    arg_dstRGB->set_isarray(false);
    arg_dstRGB->set_type(GLMessage::DataType::ENUM);
    arg_dstRGB->add_intvalue((int)dstRGB);

    // copy argument srcAlpha
    GLMessage_DataType *arg_srcAlpha = glmsg.add_args();
    arg_srcAlpha->set_isarray(false);
    arg_srcAlpha->set_type(GLMessage::DataType::ENUM);
    arg_srcAlpha->add_intvalue((int)srcAlpha);

    // copy argument dstAlpha
    GLMessage_DataType *arg_dstAlpha = glmsg.add_args();
    arg_dstAlpha->set_isarray(false);
    arg_dstAlpha->set_type(GLMessage::DataType::ENUM);
    arg_dstAlpha->add_intvalue((int)dstAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFuncSeparateOES(srcRGB, dstRGB, srcAlpha, dstAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationOES(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationOES);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationOES(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord1bOES(GLenum texture, GLbyte s) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord1bOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord1bOES(texture, s);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord1bvOES(GLenum texture, const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord1bvOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord1bvOES(texture, coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord2bOES(GLenum texture, GLbyte s, GLbyte t) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord2bOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord2bOES(texture, s, t);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord2bvOES(GLenum texture, const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord2bvOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord2bvOES(texture, coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord3bOES(GLenum texture, GLbyte s, GLbyte t, GLbyte r) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord3bOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::BYTE);
    arg_r->add_intvalue((int)r);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord3bOES(texture, s, t, r);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord3bvOES(GLenum texture, const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord3bvOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord3bvOES(texture, coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4bOES(GLenum texture, GLbyte s, GLbyte t, GLbyte r, GLbyte q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4bOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::BYTE);
    arg_r->add_intvalue((int)r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::BYTE);
    arg_q->add_intvalue((int)q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4bOES(texture, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4bvOES(GLenum texture, const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4bvOES);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4bvOES(texture, coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord1bOES(GLbyte s) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord1bOES);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord1bOES(s);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord1bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord1bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord1bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord2bOES(GLbyte s, GLbyte t) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord2bOES);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord2bOES(s, t);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord2bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord2bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord2bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord3bOES(GLbyte s, GLbyte t, GLbyte r) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord3bOES);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::BYTE);
    arg_r->add_intvalue((int)r);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord3bOES(s, t, r);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord3bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord3bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord3bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord4bOES(GLbyte s, GLbyte t, GLbyte r, GLbyte q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord4bOES);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::BYTE);
    arg_s->add_intvalue((int)s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::BYTE);
    arg_t->add_intvalue((int)t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::BYTE);
    arg_r->add_intvalue((int)r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::BYTE);
    arg_q->add_intvalue((int)q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord4bOES(s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoord4bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoord4bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoord4bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex2bOES(GLbyte x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex2bOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::BYTE);
    arg_x->add_intvalue((int)x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex2bOES(x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex2bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex2bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex2bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex3bOES(GLbyte x, GLbyte y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex3bOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::BYTE);
    arg_x->add_intvalue((int)x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::BYTE);
    arg_y->add_intvalue((int)y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex3bOES(x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex3bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex3bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex3bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex4bOES(GLbyte x, GLbyte y, GLbyte z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex4bOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::BYTE);
    arg_x->add_intvalue((int)x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::BYTE);
    arg_y->add_intvalue((int)y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::BYTE);
    arg_z->add_intvalue((int)z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex4bOES(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertex4bvOES(const GLbyte * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertex4bvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertex4bvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexsOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexsOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexiOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexiOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexxOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexxOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexsvOES(const GLshort * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexsvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexsvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexivOES(const GLint * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexivOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexivOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexxvOES(const GLfixed * coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexxvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT64);
    arg_coords->add_int64value((uintptr_t)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexxvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexfOES);

    // copy argument x
    GLMessag