/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <gmock/gmock.h>
#include <scheduler/Time.h>

#include <powermanager/PowerHalController.h>

namespace android {
namespace hardware {
namespace power {
class IPower;
}
} // namespace hardware
} // namespace android

namespace android::Hwc2::mock {

using android::hardware::power::Boost;
using android::hardware::power::Mode;
using android::power::HalResult;

class MockPowerHalController : public power::PowerHalController {
public:
    MockPowerHalController();
    ~MockPowerHalController() override;
    MOCK_METHOD(HalResult<void>, setBoost, (Boost, int32_t), (override));
    MOCK_METHOD(HalResult<void>, setMode, (Mode, bool), (override));
    MOCK_METHOD(HalResult<sp<hardware::power::IPowerHintSession>>, createHintSession,
                (int32_t, int32_t, const std::vector<int32_t>&, int64_t), (override));
    MOCK_METHOD(HalResult<int64_t>, getHintSessionPreferredRate, (), (override));
};

} // namespace android::Hwc2::mock