/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.im;

/**
 * @hide
 * Defines the IDs of branding resources.
 */
public interface BrandingResourceIDs {
    /**
     * The logo icon of the provider which is displayed in the landing page.
     */
    public static final int DRAWABLE_LOGO                = 100;
    /**
     * The icon of online presence status.
     */
    public static final int DRAWABLE_PRESENCE_ONLINE     = 102;
    /**
     * The icon of busy presence status.
     */
    public static final int DRAWABLE_PRESENCE_BUSY       = 103;
    /**
     * The icon of away presence status.
     */
    public static final int DRAWABLE_PRESENCE_AWAY       = 104;
    /**
     * The icon of invisible presence status.
     */
    public static final int DRAWABLE_PRESENCE_INVISIBLE  = 105;
    /**
     * The icon of offline presence status.
     */
    public static final int DRAWABLE_PRESENCE_OFFLINE    = 106;
    /**
     * The label of the menu to go to the contact list screen.
     */
    public static final int STRING_MENU_CONTACT_LIST     = 107;

}
