/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.android.systemui.communal.data.repository

import android.appwidget.AppWidgetHost
import android.appwidget.AppWidgetManager
import android.content.Context
import com.android.systemui.dagger.SysUISingleton
import com.android.systemui.dagger.qualifiers.Application
import dagger.Binds
import dagger.Module
import dagger.Provides

@Module
interface CommunalWidgetRepositoryModule {
    companion object {
        private const val APP_WIDGET_HOST_ID = 116

        @SysUISingleton
        @Provides
        fun provideAppWidgetManager(@Application context: Context): AppWidgetManager {
            return AppWidgetManager.getInstance(context)
        }

        @SysUISingleton
        @Provides
        fun provideAppWidgetHost(@Application context: Context): AppWidgetHost {
            return AppWidgetHost(context, APP_WIDGET_HOST_ID)
        }
    }

    @Binds
    fun communalWidgetRepository(impl: CommunalWidgetRepositoryImpl): CommunalWidgetRepository
}
