/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;

import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DataClass;
import com.android.internal.util.Parcelling;

/**
 * A {@link android.R.styleable#AndroidManifestUsesPermission
 * &lt;uses-permission&gt;} tag parsed from the manifest.
 *
 * @hide
 */
@DataClass(genGetters = true, genSetters = true, genBuilder = false, genParcelable = true,
        genAidl = false)
@VisibleForTesting(visibility = VisibleForTesting.Visibility.PACKAGE)
public class ParsedUsesPermissionImpl implements ParsedUsesPermission, Parcelable {

    @DataClass.ParcelWith(Parcelling.BuiltIn.ForInternedString.class)
    @NonNull
    private String name;

    @ParsedUsesPermission.UsesPermissionFlags
    private int usesPermissionFlags;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/com/android/internal/pm/pkg/component/ParsedUsesPermissionImpl.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    public ParsedUsesPermissionImpl(
            @NonNull String name,
            @ParsedUsesPermission.UsesPermissionFlags int usesPermissionFlags) {
        this.name = name;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, name);
        this.usesPermissionFlags = usesPermissionFlags;
        com.android.internal.util.AnnotationValidations.validate(
                ParsedUsesPermission.UsesPermissionFlags.class, null, usesPermissionFlags);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull String getName() {
        return name;
    }

    @DataClass.Generated.Member
    public @ParsedUsesPermission.UsesPermissionFlags int getUsesPermissionFlags() {
        return usesPermissionFlags;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedUsesPermissionImpl setName(@NonNull String value) {
        name = value;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, name);
        return this;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedUsesPermissionImpl setUsesPermissionFlags(@ParsedUsesPermission.UsesPermissionFlags int value) {
        usesPermissionFlags = value;
        com.android.internal.util.AnnotationValidations.validate(
                ParsedUsesPermission.UsesPermissionFlags.class, null, usesPermissionFlags);
        return this;
    }

    @DataClass.Generated.Member
    static Parcelling<String> sParcellingForName =
            Parcelling.Cache.get(
                    Parcelling.BuiltIn.ForInternedString.class);
    static {
        if (sParcellingForName == null) {
            sParcellingForName = Parcelling.Cache.put(
                    new Parcelling.BuiltIn.ForInternedString());
        }
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        sParcellingForName.parcel(name, dest, flags);
        dest.writeInt(usesPermissionFlags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected ParsedUsesPermissionImpl(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        String _name = sParcellingForName.unparcel(in);
        int _usesPermissionFlags = in.readInt();

        this.name = _name;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, name);
        this.usesPermissionFlags = _usesPermissionFlags;
        com.android.internal.util.AnnotationValidations.validate(
                ParsedUsesPermission.UsesPermissionFlags.class, null, usesPermissionFlags);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ParsedUsesPermissionImpl> CREATOR
            = new Parcelable.Creator<ParsedUsesPermissionImpl>() {
        @Override
        public ParsedUsesPermissionImpl[] newArray(int size) {
            return new ParsedUsesPermissionImpl[size];
        }

        @Override
        public ParsedUsesPermissionImpl createFromParcel(@NonNull Parcel in) {
            return new ParsedUsesPermissionImpl(in);
        }
    };

    @DataClass.Generated(
            time = 1701445626268L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/com/android/internal/pm/pkg/component/ParsedUsesPermissionImpl.java",
            inputSignatures = "private @com.android.internal.util.DataClass.ParcelWith(com.android.internal.util.Parcelling.BuiltIn.ForInternedString.class) @android.annotation.NonNull java.lang.String name\nprivate @com.android.internal.pm.pkg.component.ParsedUsesPermission.UsesPermissionFlags int usesPermissionFlags\nclass ParsedUsesPermissionImpl extends java.lang.Object implements [com.android.internal.pm.pkg.component.ParsedUsesPermission, android.os.Parcelable]\n@com.android.internal.util.DataClass(genGetters=true, genSetters=true, genBuilder=false, genParcelable=true, genAidl=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
