/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.input;

import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Provides information about the supported Universal Stylus Initiative (USI) version of the
 * host device.
 *
 * This holds version information about the host device (e.g. the touchscreen/display), not
 * the USI version of a stylus.
 *
 * @see InputManager#getHostUsiVersion(android.view.Display)
 * @see <a href="https://universalstylus.org">Universal Stylus Initiative</a>
 */
@DataClass(genParcelable = true, genHiddenConstructor = true, genToString = true,
        genEqualsHashCode = true)
public final class HostUsiVersion implements Parcelable {
    /**
     * The major USI version supported by the input device.
     * For example, if the device supports USI 2.0, this will return 2.
     */
    private final int mMajorVersion;

    /**
     * The minor USI version supported by the input device.
     * For example, if the device supports USI 2.0, this will return 0.
     */
    private final int mMinorVersion;

    /** @hide */
    public boolean isValid() {
        return mMajorVersion >= 0 && mMinorVersion >= 0;
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/hardware/input/HostUsiVersion.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new HostUsiVersion.
     *
     * @param majorVersion
     *   The major USI version supported by the input device.
     *   For example, if the device supports USI 2.0, this will return 2.
     * @param minorVersion
     *   The minor USI version supported by the input device.
     *   For example, if the device supports USI 2.0, this will return 0.
     * @hide
     */
    @DataClass.Generated.Member
    public HostUsiVersion(
            int majorVersion,
            int minorVersion) {
        this.mMajorVersion = majorVersion;
        this.mMinorVersion = minorVersion;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The major USI version supported by the input device.
     * For example, if the device supports USI 2.0, this will return 2.
     */
    @DataClass.Generated.Member
    public int getMajorVersion() {
        return mMajorVersion;
    }

    /**
     * The minor USI version supported by the input device.
     * For example, if the device supports USI 2.0, this will return 0.
     */
    @DataClass.Generated.Member
    public int getMinorVersion() {
        return mMinorVersion;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "HostUsiVersion { " +
                "majorVersion = " + mMajorVersion + ", " +
                "minorVersion = " + mMinorVersion +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(HostUsiVersion other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        HostUsiVersion that = (HostUsiVersion) o;
        //noinspection PointlessBooleanExpression
        return true
                && mMajorVersion == that.mMajorVersion
                && mMinorVersion == that.mMinorVersion;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mMajorVersion;
        _hash = 31 * _hash + mMinorVersion;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mMajorVersion);
        dest.writeInt(mMinorVersion);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ HostUsiVersion(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int majorVersion = in.readInt();
        int minorVersion = in.readInt();

        this.mMajorVersion = majorVersion;
        this.mMinorVersion = minorVersion;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<HostUsiVersion> CREATOR
            = new Parcelable.Creator<HostUsiVersion>() {
        @Override
        public HostUsiVersion[] newArray(int size) {
            return new HostUsiVersion[size];
        }

        @Override
        public HostUsiVersion createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new HostUsiVersion(in);
        }
    };

    @DataClass.Generated(
            time = 1673884256908L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/hardware/input/HostUsiVersion.java",
            inputSignatures = "private final  int mMajorVersion\nprivate final  int mMinorVersion\npublic  boolean isValid()\nclass HostUsiVersion extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genHiddenConstructor=true, genToString=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
