/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.face;

import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Additional options when requesting Face enrollment.
 *
 * @hide
 */
@DataClass(
        genParcelable = true,
        genAidl = true,
        genBuilder = true,
        genSetters = true,
        genEqualsHashCode = true
)
public class FaceEnrollOptions implements Parcelable {
    public static final int ENROLL_REASON_UNKNOWN = 0;
    public static final int ENROLL_REASON_RE_ENROLL_NOTIFICATION = 1;
    public static final int ENROLL_REASON_SETTINGS = 2;
    public static final int ENROLL_REASON_SUW = 3;

    /**
     * The reason for enrollment.
     */
    @EnrollReason
    private final int mEnrollReason;
    private static int defaultEnrollReason() {
        return ENROLL_REASON_UNKNOWN;
    }




    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/hardware/face/FaceEnrollOptions.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @android.annotation.IntDef(prefix = "ENROLL_REASON_", value = {
        ENROLL_REASON_UNKNOWN,
        ENROLL_REASON_RE_ENROLL_NOTIFICATION,
        ENROLL_REASON_SETTINGS,
        ENROLL_REASON_SUW
    })
    @java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface EnrollReason {}

    @DataClass.Generated.Member
    public static String enrollReasonToString(@EnrollReason int value) {
        switch (value) {
            case ENROLL_REASON_UNKNOWN:
                    return "ENROLL_REASON_UNKNOWN";
            case ENROLL_REASON_RE_ENROLL_NOTIFICATION:
                    return "ENROLL_REASON_RE_ENROLL_NOTIFICATION";
            case ENROLL_REASON_SETTINGS:
                    return "ENROLL_REASON_SETTINGS";
            case ENROLL_REASON_SUW:
                    return "ENROLL_REASON_SUW";
            default: return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    /* package-private */ FaceEnrollOptions(
            @EnrollReason int enrollReason) {
        this.mEnrollReason = enrollReason;

        if (!(mEnrollReason == ENROLL_REASON_UNKNOWN)
                && !(mEnrollReason == ENROLL_REASON_RE_ENROLL_NOTIFICATION)
                && !(mEnrollReason == ENROLL_REASON_SETTINGS)
                && !(mEnrollReason == ENROLL_REASON_SUW)) {
            throw new java.lang.IllegalArgumentException(
                    "enrollReason was " + mEnrollReason + " but must be one of: "
                            + "ENROLL_REASON_UNKNOWN(" + ENROLL_REASON_UNKNOWN + "), "
                            + "ENROLL_REASON_RE_ENROLL_NOTIFICATION(" + ENROLL_REASON_RE_ENROLL_NOTIFICATION + "), "
                            + "ENROLL_REASON_SETTINGS(" + ENROLL_REASON_SETTINGS + "), "
                            + "ENROLL_REASON_SUW(" + ENROLL_REASON_SUW + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The reason for enrollment.
     */
    @DataClass.Generated.Member
    public @EnrollReason int getEnrollReason() {
        return mEnrollReason;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(FaceEnrollOptions other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        FaceEnrollOptions that = (FaceEnrollOptions) o;
        //noinspection PointlessBooleanExpression
        return true
                && mEnrollReason == that.mEnrollReason;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mEnrollReason;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mEnrollReason);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected FaceEnrollOptions(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int enrollReason = in.readInt();

        this.mEnrollReason = enrollReason;

        if (!(mEnrollReason == ENROLL_REASON_UNKNOWN)
                && !(mEnrollReason == ENROLL_REASON_RE_ENROLL_NOTIFICATION)
                && !(mEnrollReason == ENROLL_REASON_SETTINGS)
                && !(mEnrollReason == ENROLL_REASON_SUW)) {
            throw new java.lang.IllegalArgumentException(
                    "enrollReason was " + mEnrollReason + " but must be one of: "
                            + "ENROLL_REASON_UNKNOWN(" + ENROLL_REASON_UNKNOWN + "), "
                            + "ENROLL_REASON_RE_ENROLL_NOTIFICATION(" + ENROLL_REASON_RE_ENROLL_NOTIFICATION + "), "
                            + "ENROLL_REASON_SETTINGS(" + ENROLL_REASON_SETTINGS + "), "
                            + "ENROLL_REASON_SUW(" + ENROLL_REASON_SUW + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<FaceEnrollOptions> CREATOR
            = new Parcelable.Creator<FaceEnrollOptions>() {
        @Override
        public FaceEnrollOptions[] newArray(int size) {
            return new FaceEnrollOptions[size];
        }

        @Override
        public FaceEnrollOptions createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new FaceEnrollOptions(in);
        }
    };

    /**
     * A builder for {@link FaceEnrollOptions}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @EnrollReason int mEnrollReason;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The reason for enrollment.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setEnrollReason(@EnrollReason int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mEnrollReason = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull FaceEnrollOptions build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mEnrollReason = defaultEnrollReason();
            }
            FaceEnrollOptions o = new FaceEnrollOptions(
                    mEnrollReason);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1707949032303L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/hardware/face/FaceEnrollOptions.java",
            inputSignatures = "public static final  int ENROLL_REASON_UNKNOWN\npublic static final  int ENROLL_REASON_RE_ENROLL_NOTIFICATION\npublic static final  int ENROLL_REASON_SETTINGS\npublic static final  int ENROLL_REASON_SUW\nprivate final @android.hardware.face.FaceEnrollOptions.EnrollReason int mEnrollReason\nprivate static  int defaultEnrollReason()\nclass FaceEnrollOptions extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genAidl=true, genBuilder=true, genSetters=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
