/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.server.companion;

import android.companion.AssociationInfo;

import com.android.server.companion.datatransfer.contextsync.CrossDeviceCall;
import com.android.server.companion.datatransfer.contextsync.CrossDeviceSyncControllerCallback;

import java.util.Collection;

/**
 * Companion Device Manager Local System Service Interface.
 */
public interface CompanionDeviceManagerServiceInternal {
    /**
     * @see CompanionDeviceManagerService#removeInactiveSelfManagedAssociations
     */
    void removeInactiveSelfManagedAssociations();

    /**
     * Registers a callback from an InCallService / ConnectionService to CDM to process sync
     * requests and perform call control actions.
     */
    void registerCallMetadataSyncCallback(CrossDeviceSyncControllerCallback callback);

    /**
     * Requests a sync from an InCallService / ConnectionService to CDM, for the given association
     * and message.
     */
    void sendCrossDeviceSyncMessage(int associationId, byte[] message);

    /**
     * Requests a sync from an InCallService to CDM, for the given user and call metadata.
     */
    void crossDeviceSync(int userId, Collection<CrossDeviceCall> calls);

    /**
     * Requests a sync from an InCallService to CDM, for the given association and call metadata.
     */
    void crossDeviceSync(AssociationInfo associationInfo, Collection<CrossDeviceCall> calls);
}
