/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemfeatures;

import static com.google.common.truth.Truth.assertThat;

import com.android.internal.pm.SystemFeaturesMetadata;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class SystemFeaturesMetadataProcessorTest {

    @Test
    public void testSdkFeatureCount() {
        // See the fake PackageManager definition in this directory.
        // It defines 5 annotated features, and any/all other constants should be ignored.
        assertThat(SystemFeaturesMetadata.SDK_FEATURE_COUNT).isEqualTo(5);
    }
}
