/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.systemui.statusbar.phone;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import android.testing.AndroidTestingRunner;
import android.testing.TestableLooper;

import androidx.test.filters.SmallTest;

import com.android.systemui.SysuiTestCase;
import com.android.systemui.demomode.DemoModeController;
import com.android.systemui.plugins.DarkIconDispatcher;
import com.android.systemui.plugins.statusbar.StatusBarStateController;
import com.android.systemui.statusbar.NotificationListener;
import com.android.systemui.statusbar.NotificationMediaManager;
import com.android.systemui.statusbar.notification.NotificationWakeUpCoordinator;
import com.android.systemui.statusbar.notification.collection.notifcollection.CommonNotifCollection;
import com.android.wm.shell.bubbles.Bubbles;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Optional;

@SmallTest
@RunWith(AndroidTestingRunner.class)
@TestableLooper.RunWithLooper
public class NotificationIconAreaControllerTest extends SysuiTestCase {

    @Mock
    private NotificationListener mListener;
    @Mock
    StatusBarStateController mStatusBarStateController;
    @Mock
    NotificationWakeUpCoordinator mWakeUpCoordinator;
    @Mock
    KeyguardBypassController mKeyguardBypassController;
    @Mock
    NotificationMediaManager mNotificationMediaManager;
    @Mock
    DozeParameters mDozeParameters;
    @Mock
    CommonNotifCollection mNotifCollection;
    @Mock
    DarkIconDispatcher mDarkIconDispatcher;
    @Mock
    StatusBarWindowController mStatusBarWindowController;
    @Mock
    UnlockedScreenOffAnimationController mUnlockedScreenOffAnimationController;
    private NotificationIconAreaController mController;
    @Mock
    private Bubbles mBubbles;
    @Mock private DemoModeController mDemoModeController;
    @Mock
    private NotificationIconContainer mAodIcons;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);
        mController = new NotificationIconAreaController(
                mContext,
                mStatusBarStateController,
                mWakeUpCoordinator,
                mKeyguardBypassController,
                mNotificationMediaManager,
                mListener,
                mDozeParameters,
                Optional.of(mBubbles),
                mDemoModeController,
                mDarkIconDispatcher,
                mStatusBarWindowController,
                mUnlockedScreenOffAnimationController);
    }

    @Test
    public void testNotificationIcons_settingHideIcons() {
        mController.mSettingsListener.onStatusBarIconsBehaviorChanged(true);

        assertFalse(mController.shouldShouldLowPriorityIcons());
    }

    @Test
    public void testNotificationIcons_settingShowIcons() {
        mController.mSettingsListener.onStatusBarIconsBehaviorChanged(false);

        assertTrue(mController.shouldShouldLowPriorityIcons());
    }

    @Test
    public void testAppearResetsTranslation() {
        mController.setupAodIcons(mAodIcons);
        when(mDozeParameters.shouldControlScreenOff()).thenReturn(false);
        mController.appearAodIcons();
        verify(mAodIcons).setTranslationY(0);
        verify(mAodIcons).setAlpha(1.0f);
    }
}
