/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.media.controls.shared.model

/** Models any type of media. */
sealed class MediaCommonModel {
    data class MediaControl(
        val mediaLoadedModel: MediaDataLoadingModel.Loaded,
        val canBeRemoved: Boolean = false,
        val isMediaFromRec: Boolean = false,
        val updateTime: Long = 0L,
    ) : MediaCommonModel()

    data class MediaRecommendations(val recsLoadingModel: SmartspaceMediaLoadingModel) :
        MediaCommonModel()
}
