/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.systemui.flags

import com.android.internal.statusbar.IStatusBarService
import dagger.Module
import dagger.Provides
import javax.inject.Named

/** Module containing shared code for all FeatureFlag implementations. */
@Module
interface FlagsCommonModule {
    companion object {
        const val ALL_FLAGS = "all_flags"

        @JvmStatic
        @Provides
        @Named(ALL_FLAGS)
        fun providesAllFlags(): Map<Int, Flag<*>> {
            return Flags.collectFlags()
        }

        @JvmStatic
        @Provides
        fun providesRestarter(barService: IStatusBarService): Restarter {
            return object : Restarter {
                override fun restart() {
                    barService.restart()
                }
            }
        }
    }
}
