/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.voice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcelable;

import com.android.internal.util.DataClass;
import com.android.internal.util.Preconditions;

/**
 * Details about the phrase used to generate a {@link HotwordDetectedResult}
 *
 * @hide
 */
@DataClass(
        genConstructor = false,
        genBuilder = true,
        genEqualsHashCode = true,
        genHiddenConstDefs = true,
        genParcelable = true,
        genToString = true
)
@SystemApi
public final class DetectedPhrase implements Parcelable {

    /**
     * An ID representing the keyphrase that triggered the successful detection.
     */
    private int mId = 0;

    static int defaultHotwordPhraseId() {
        return 0;
    }

    /**
     * A string representing exactly what was heard and interpreted by the service leading to
     * a successful detection.
     *
     * <p>Can be null if not set in {@link DetectedPhrase.Builder}
     */
    @Nullable
    private String mPhrase = null;

    /**
     * Provides an instance of {@link DetectedPhrase.Builder} with state corresponding to
     * this instance.
     * @hide
     */
    public DetectedPhrase.Builder buildUpon() {
        return new DetectedPhrase.Builder()
                .setId(mId)
                .setPhrase(mPhrase);
    }

    private void onConstructed() {
        Preconditions.checkArgumentNonnegative(mId, "hotwordPhraseId");
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/voice/DetectedPhrase.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ DetectedPhrase(
            int id,
            @Nullable String phrase) {
        this.mId = id;
        this.mPhrase = phrase;

        onConstructed();
    }

    /**
     * An ID representing the keyphrase that triggered the successful detection.
     */
    @DataClass.Generated.Member
    public int getId() {
        return mId;
    }

    /**
     * A string representing exactly what was heard and interpreted by the service leading to
     * a successful detection.
     *
     * <p>Can be null if not set in {@link DetectedPhrase.Builder}
     */
    @DataClass.Generated.Member
    public @Nullable String getPhrase() {
        return mPhrase;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "DetectedPhrase { " +
                "id = " + mId + ", " +
                "phrase = " + mPhrase +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(DetectedPhrase other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        DetectedPhrase that = (DetectedPhrase) o;
        //noinspection PointlessBooleanExpression
        return true
                && mId == that.mId
                && java.util.Objects.equals(mPhrase, that.mPhrase);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mId;
        _hash = 31 * _hash + java.util.Objects.hashCode(mPhrase);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mPhrase != null) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeInt(mId);
        if (mPhrase != null) dest.writeString(mPhrase);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ DetectedPhrase(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        int id = in.readInt();
        String phrase = (flg & 0x2) == 0 ? null : in.readString();

        this.mId = id;
        this.mPhrase = phrase;

        onConstructed();
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<DetectedPhrase> CREATOR
            = new Parcelable.Creator<DetectedPhrase>() {
        @Override
        public DetectedPhrase[] newArray(int size) {
            return new DetectedPhrase[size];
        }

        @Override
        public DetectedPhrase createFromParcel(@NonNull android.os.Parcel in) {
            return new DetectedPhrase(in);
        }
    };

    /**
     * A builder for {@link DetectedPhrase}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private int mId;
        private @Nullable String mPhrase;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * An ID representing the keyphrase that triggered the successful detection.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setId(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mId = value;
            return this;
        }

        /**
         * A string representing exactly what was heard and interpreted by the service leading to
         * a successful detection.
         *
         * <p>Can be null if not set in {@link DetectedPhrase.Builder}
         */
        @DataClass.Generated.Member
        public @NonNull Builder setPhrase(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mPhrase = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull DetectedPhrase build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mId = 0;
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mPhrase = null;
            }
            DetectedPhrase o = new DetectedPhrase(
                    mId,
                    mPhrase);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1676870329959L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/service/voice/DetectedPhrase.java",
            inputSignatures = "private  int mId\nprivate @android.annotation.Nullable java.lang.String mPhrase\nstatic  int defaultHotwordPhraseId()\npublic  android.service.voice.DetectedPhrase.Builder buildUpon()\nprivate  void onConstructed()\nclass DetectedPhrase extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genConstructor=false, genBuilder=true, genEqualsHashCode=true, genHiddenConstDefs=true, genParcelable=true, genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
