/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.server.display;

import static org.junit.Assert.assertEquals;


import androidx.test.filters.SmallTest;
import androidx.test.runner.AndroidJUnit4;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@SmallTest
@RunWith(AndroidJUnit4.class)
public final class HbmEventTest {
    private long mStartTimeMillis;
    private long mEndTimeMillis;
    private HbmEvent mHbmEvent;

    @Before
    public void setUp() {
        mStartTimeMillis = 10;
        mEndTimeMillis = 20;
        mHbmEvent = new HbmEvent(mStartTimeMillis, mEndTimeMillis);
    }

    @Test
    public void getCorrectValues() {
        assertEquals(mHbmEvent.getStartTimeMillis(), mStartTimeMillis);
        assertEquals(mHbmEvent.getEndTimeMillis(), mEndTimeMillis);
    }

    @Test
    public void toStringGeneratesExpectedString() {
        String actualString = mHbmEvent.toString();
        String expectedString = "HbmEvent: {startTimeMillis:" + mStartTimeMillis
                + ", endTimeMillis: " + mEndTimeMillis + "}, total: "
                + ((mEndTimeMillis - mStartTimeMillis) / 1000) + "]";
        assertEquals(actualString, expectedString);
    }
}
