/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.CrossProfileAppsInternal;

import com.android.server.SystemService;

public class CrossProfileAppsService extends SystemService {
    private final CrossProfileAppsServiceImpl mServiceImpl;

    public CrossProfileAppsService(Context context) {
        super(context);
        mServiceImpl = new CrossProfileAppsServiceImpl(context);
    }

    @Override
    public void onStart() {
        publishBinderService(Context.CROSS_PROFILE_APPS_SERVICE, mServiceImpl);
        publishLocalService(CrossProfileAppsInternal.class, mServiceImpl.getLocalService());
    }
}
