/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.autofill;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Response for a {@Link ConvertCredentialRequest}
 *
 * @hide
 */
@DataClass(
        genToString = true,
        genHiddenConstructor = true,
        genHiddenConstDefs = true)
public final class ConvertCredentialResponse implements Parcelable {
    private final @NonNull Dataset mDataset;
    private final @Nullable Bundle mClientState;




    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/autofill/ConvertCredentialResponse.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new ConvertCredentialResponse.
     *
     * @hide
     */
    @DataClass.Generated.Member
    public ConvertCredentialResponse(
            @NonNull Dataset dataset,
            @Nullable Bundle clientState) {
        this.mDataset = dataset;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mDataset);
        this.mClientState = clientState;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull Dataset getDataset() {
        return mDataset;
    }

    @DataClass.Generated.Member
    public @Nullable Bundle getClientState() {
        return mClientState;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "ConvertCredentialResponse { " +
                "dataset = " + mDataset + ", " +
                "clientState = " + mClientState +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mClientState != null) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeTypedObject(mDataset, flags);
        if (mClientState != null) dest.writeBundle(mClientState);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ ConvertCredentialResponse(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        Dataset dataset = (Dataset) in.readTypedObject(Dataset.CREATOR);
        Bundle clientState = (flg & 0x2) == 0 ? null : in.readBundle();

        this.mDataset = dataset;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mDataset);
        this.mClientState = clientState;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ConvertCredentialResponse> CREATOR
            = new Parcelable.Creator<ConvertCredentialResponse>() {
        @Override
        public ConvertCredentialResponse[] newArray(int size) {
            return new ConvertCredentialResponse[size];
        }

        @Override
        public ConvertCredentialResponse createFromParcel(@NonNull Parcel in) {
            return new ConvertCredentialResponse(in);
        }
    };

    @DataClass.Generated(
            time = 1706132669373L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/service/autofill/ConvertCredentialResponse.java",
            inputSignatures = "private final @android.annotation.NonNull android.service.autofill.Dataset mDataset\nprivate final @android.annotation.Nullable android.os.Bundle mClientState\nclass ConvertCredentialResponse extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genToString=true, genHiddenConstructor=true, genHiddenConstDefs=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
