/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.util.condition.dagger;

import com.android.systemui.util.condition.Condition;
import com.android.systemui.util.condition.Monitor;

import java.util.Set;

import dagger.BindsInstance;
import dagger.Subcomponent;

/**
 * Component for {@link Monitor}.
 */
@Subcomponent
public interface MonitorComponent {
    /**
     * Factory for {@link MonitorComponent}.
     */
    @Subcomponent.Factory
    interface Factory {
        MonitorComponent create(@BindsInstance Set<Condition> conditions);
    }

    /**
     * Provides {@link Monitor}.
     * @return
     */
    Monitor getMonitor();
}
