/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.systemui.biometrics

import com.android.systemui.broadcast.BroadcastSender
import com.android.systemui.dump.DumpManager
import com.android.systemui.plugins.statusbar.StatusBarStateController
import com.android.systemui.statusbar.phone.SystemUIDialogManager
import com.android.systemui.statusbar.phone.panelstate.PanelExpansionListener
import com.android.systemui.statusbar.phone.panelstate.PanelExpansionStateManager

/**
 * Class that coordinates non-HBM animations for biometric prompt.
 */
class UdfpsBpViewController(
    view: UdfpsBpView,
    statusBarStateController: StatusBarStateController,
    panelExpansionStateManager: PanelExpansionStateManager,
    systemUIDialogManager: SystemUIDialogManager,
    val broadcastSender: BroadcastSender,
    dumpManager: DumpManager
) : UdfpsAnimationViewController<UdfpsBpView>(
    view,
    statusBarStateController,
    panelExpansionStateManager,
    systemUIDialogManager,
    dumpManager
) {
    override val tag = "UdfpsBpViewController"
    private val bpPanelExpansionListener = PanelExpansionListener { event ->
        // Notification shade can be expanded but not visible (fraction: 0.0), for example
        // when a heads-up notification (HUN) is showing.
        notificationShadeVisible = event.expanded && event.fraction > 0f
        view.onExpansionChanged(event.fraction)
        cancelAuth()
    }

    fun cancelAuth() {
        if (shouldPauseAuth()) {
            broadcastSender.closeSystemDialogs()
        }
    }

    override fun onViewAttached() {
        super.onViewAttached()

        panelExpansionStateManager.addExpansionListener(bpPanelExpansionListener)
    }

    override fun onViewDetached() {
        super.onViewDetached()

        panelExpansionStateManager.removeExpansionListener(bpPanelExpansionListener)
    }
}
