/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Information related to a recoverable error encountered during biometric authentication.
 * @hide
 */
@DataClass(
        genParcelable = true,
        genAidl = true,
        genBuilder = true,
        genSetters = true,
        genEqualsHashCode = true
)
public final class AuthenticationHelpInfo implements Parcelable {
    /** Identifies {@link BiometricSourceType} of authentication. */
    @NonNull
    private final BiometricSourceType mBiometricSourceType;

    /** Indicates reason from {@link BiometricRequestConstants.RequestReason} for
     * requesting authentication. */
    @BiometricRequestConstants.RequestReason
    private final int mRequestReason;

    /**
     * Guidance help string shown on the UI for authentication help.
     */
    @Nullable
    private final String mHelpString;

    /**
     * An integer identifying the help message for authentication help.
     */
    private final int mHelpCode;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/hardware/biometrics/events/AuthenticationHelpInfo.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ AuthenticationHelpInfo(
            @NonNull BiometricSourceType biometricSourceType,
            @BiometricRequestConstants.RequestReason int requestReason,
            @Nullable String helpString,
            int helpCode) {
        this.mBiometricSourceType = biometricSourceType;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mBiometricSourceType);
        this.mRequestReason = requestReason;
        com.android.internal.util.AnnotationValidations.validate(
                BiometricRequestConstants.RequestReason.class, null, mRequestReason);
        this.mHelpString = helpString;
        this.mHelpCode = helpCode;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Identifies {@link BiometricSourceType} of authentication.
     */
    @DataClass.Generated.Member
    public @NonNull BiometricSourceType getBiometricSourceType() {
        return mBiometricSourceType;
    }

    /**
     * Indicates reason from {@link BiometricRequestConstants.RequestReason} for
     * requesting authentication.
     */
    @DataClass.Generated.Member
    public @BiometricRequestConstants.RequestReason int getRequestReason() {
        return mRequestReason;
    }

    /**
     * Guidance help string shown on the UI for authentication help.
     */
    @DataClass.Generated.Member
    public @Nullable String getHelpString() {
        return mHelpString;
    }

    /**
     * An integer identifying the help message for authentication help.
     */
    @DataClass.Generated.Member
    public int getHelpCode() {
        return mHelpCode;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(AuthenticationHelpInfo other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        AuthenticationHelpInfo that = (AuthenticationHelpInfo) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mBiometricSourceType, that.mBiometricSourceType)
                && mRequestReason == that.mRequestReason
                && java.util.Objects.equals(mHelpString, that.mHelpString)
                && mHelpCode == that.mHelpCode;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mBiometricSourceType);
        _hash = 31 * _hash + mRequestReason;
        _hash = 31 * _hash + java.util.Objects.hashCode(mHelpString);
        _hash = 31 * _hash + mHelpCode;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mHelpString != null) flg |= 0x4;
        dest.writeByte(flg);
        dest.writeTypedObject(mBiometricSourceType, flags);
        dest.writeInt(mRequestReason);
        if (mHelpString != null) dest.writeString(mHelpString);
        dest.writeInt(mHelpCode);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ AuthenticationHelpInfo(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        BiometricSourceType biometricSourceType = (BiometricSourceType) in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        String helpString = (flg & 0x4) == 0 ? null : in.readString();
        int helpCode = in.readInt();

        this.mBiometricSourceType = biometricSourceType;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mBiometricSourceType);
        this.mRequestReason = requestReason;
        com.android.internal.util.AnnotationValidations.validate(
                BiometricRequestConstants.RequestReason.class, null, mRequestReason);
        this.mHelpString = helpString;
        this.mHelpCode = helpCode;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<AuthenticationHelpInfo> CREATOR
            = new Parcelable.Creator<AuthenticationHelpInfo>() {
        @Override
        public AuthenticationHelpInfo[] newArray(int size) {
            return new AuthenticationHelpInfo[size];
        }

        @Override
        public AuthenticationHelpInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationHelpInfo(in);
        }
    };

    /**
     * A builder for {@link AuthenticationHelpInfo}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull BiometricSourceType mBiometricSourceType;
        private @BiometricRequestConstants.RequestReason int mRequestReason;
        private @Nullable String mHelpString;
        private int mHelpCode;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param biometricSourceType
         *   Identifies {@link BiometricSourceType} of authentication.
         * @param requestReason
         *   Indicates reason from {@link BiometricRequestConstants.RequestReason} for
         *   requesting authentication.
         * @param helpString
         *   Guidance help string shown on the UI for authentication help.
         * @param helpCode
         *   An integer identifying the help message for authentication help.
         */
        public Builder(
                @NonNull BiometricSourceType biometricSourceType,
                @BiometricRequestConstants.RequestReason int requestReason,
                @Nullable String helpString,
                int helpCode) {
            mBiometricSourceType = biometricSourceType;
            com.android.internal.util.AnnotationValidations.validate(
                    NonNull.class, null, mBiometricSourceType);
            mRequestReason = requestReason;
            com.android.internal.util.AnnotationValidations.validate(
                    BiometricRequestConstants.RequestReason.class, null, mRequestReason);
            mHelpString = helpString;
            mHelpCode = helpCode;
        }

        /**
         * Identifies {@link BiometricSourceType} of authentication.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mBiometricSourceType = value;
            return this;
        }

        /**
         * Indicates reason from {@link BiometricRequestConstants.RequestReason} for
         * requesting authentication.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setRequestReason(@BiometricRequestConstants.RequestReason int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mRequestReason = value;
            return this;
        }

        /**
         * Guidance help string shown on the UI for authentication help.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setHelpString(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mHelpString = value;
            return this;
        }

        /**
         * An integer identifying the help message for authentication help.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setHelpCode(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mHelpCode = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull AuthenticationHelpInfo build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            AuthenticationHelpInfo o = new AuthenticationHelpInfo(
                    mBiometricSourceType,
                    mRequestReason,
                    mHelpString,
                    mHelpCode);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1713305435226L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/hardware/biometrics/events/AuthenticationHelpInfo.java",
            inputSignatures = "private final @android.annotation.NonNull android.hardware.biometrics.BiometricSourceType mBiometricSourceType\nprivate final @android.hardware.biometrics.BiometricRequestConstants.RequestReason int mRequestReason\nprivate final @android.annotation.Nullable java.lang.String mHelpString\nprivate final  int mHelpCode\nclass AuthenticationHelpInfo extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genAidl=true, genBuilder=true, genSetters=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
