/*
 * Copyright (c) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony.ims.aidl;

import android.net.Uri;
import android.telephony.ims.stub.ImsFeatureConfiguration;

import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.SipDetails;

/**
 * See {@link ImsManager#RegistrationCallback} for more information.
 *
 * {@hide}
 */
oneway interface IImsRegistrationCallback {
   void onRegistered(in ImsRegistrationAttributes attr);
   void onRegistering(in ImsRegistrationAttributes attr);
   void onDeregistered(in ImsReasonInfo info, int suggestedAction, int imsRadioTech);
   void onDeregisteredWithDetails(in ImsReasonInfo info, int suggestedAction, int imsRadioTech, in SipDetails detail);
   void onTechnologyChangeFailed(int imsRadioTech, in ImsReasonInfo info);
   void onSubscriberAssociatedUriChanged(in Uri[] uris);
}
