/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.biometrics.events;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.BiometricRequestConstants;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Parcel;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

/**
 * Information about a successful biometric authentication.
 * @hide
 */
@DataClass(
        genParcelable = true,
        genAidl = true,
        genBuilder = true,
        genSetters = true,
        genEqualsHashCode = true
)
public final class AuthenticationSucceededInfo implements Parcelable {
    /** Identifies {@link BiometricSourceType} of authentication. */
    @NonNull
    private final BiometricSourceType mBiometricSourceType;

    /** Indicates reason from {@link BiometricRequestConstants.RequestReason} for
     * requesting authentication. */
    @BiometricRequestConstants.RequestReason
    private final int mRequestReason;

    /**
     * Indicates whether auth was from strong biometric.
     */
    private final boolean mIsStrongBiometric;

    /**
     * The user id for the requested authentication
     */
    private final int mUserId;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/hardware/biometrics/events/AuthenticationSucceededInfo.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ AuthenticationSucceededInfo(
            @NonNull BiometricSourceType biometricSourceType,
            @BiometricRequestConstants.RequestReason int requestReason,
            boolean isStrongBiometric,
            int userId) {
        this.mBiometricSourceType = biometricSourceType;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mBiometricSourceType);
        this.mRequestReason = requestReason;
        com.android.internal.util.AnnotationValidations.validate(
                BiometricRequestConstants.RequestReason.class, null, mRequestReason);
        this.mIsStrongBiometric = isStrongBiometric;
        this.mUserId = userId;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Identifies {@link BiometricSourceType} of authentication.
     */
    @DataClass.Generated.Member
    public @NonNull BiometricSourceType getBiometricSourceType() {
        return mBiometricSourceType;
    }

    /**
     * Indicates reason from {@link BiometricRequestConstants.RequestReason} for
     * requesting authentication.
     */
    @DataClass.Generated.Member
    public @BiometricRequestConstants.RequestReason int getRequestReason() {
        return mRequestReason;
    }

    /**
     * Indicates whether auth was from strong biometric.
     */
    @DataClass.Generated.Member
    public boolean isIsStrongBiometric() {
        return mIsStrongBiometric;
    }

    /**
     * The user id for the requested authentication
     */
    @DataClass.Generated.Member
    public int getUserId() {
        return mUserId;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(AuthenticationSucceededInfo other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        AuthenticationSucceededInfo that = (AuthenticationSucceededInfo) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mBiometricSourceType, that.mBiometricSourceType)
                && mRequestReason == that.mRequestReason
                && mIsStrongBiometric == that.mIsStrongBiometric
                && mUserId == that.mUserId;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mBiometricSourceType);
        _hash = 31 * _hash + mRequestReason;
        _hash = 31 * _hash + Boolean.hashCode(mIsStrongBiometric);
        _hash = 31 * _hash + mUserId;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mIsStrongBiometric) flg |= 0x4;
        dest.writeByte(flg);
        dest.writeTypedObject(mBiometricSourceType, flags);
        dest.writeInt(mRequestReason);
        dest.writeInt(mUserId);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ AuthenticationSucceededInfo(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        boolean isStrongBiometric = (flg & 0x4) != 0;
        BiometricSourceType biometricSourceType = (BiometricSourceType) in.readTypedObject(BiometricSourceType.CREATOR);
        int requestReason = in.readInt();
        int userId = in.readInt();

        this.mBiometricSourceType = biometricSourceType;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mBiometricSourceType);
        this.mRequestReason = requestReason;
        com.android.internal.util.AnnotationValidations.validate(
                BiometricRequestConstants.RequestReason.class, null, mRequestReason);
        this.mIsStrongBiometric = isStrongBiometric;
        this.mUserId = userId;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<AuthenticationSucceededInfo> CREATOR
            = new Parcelable.Creator<AuthenticationSucceededInfo>() {
        @Override
        public AuthenticationSucceededInfo[] newArray(int size) {
            return new AuthenticationSucceededInfo[size];
        }

        @Override
        public AuthenticationSucceededInfo createFromParcel(@NonNull Parcel in) {
            return new AuthenticationSucceededInfo(in);
        }
    };

    /**
     * A builder for {@link AuthenticationSucceededInfo}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull BiometricSourceType mBiometricSourceType;
        private @BiometricRequestConstants.RequestReason int mRequestReason;
        private boolean mIsStrongBiometric;
        private int mUserId;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param biometricSourceType
         *   Identifies {@link BiometricSourceType} of authentication.
         * @param requestReason
         *   Indicates reason from {@link BiometricRequestConstants.RequestReason} for
         *   requesting authentication.
         * @param isStrongBiometric
         *   Indicates whether auth was from strong biometric.
         * @param userId
         *   The user id for the requested authentication
         */
        public Builder(
                @NonNull BiometricSourceType biometricSourceType,
                @BiometricRequestConstants.RequestReason int requestReason,
                boolean isStrongBiometric,
                int userId) {
            mBiometricSourceType = biometricSourceType;
            com.android.internal.util.AnnotationValidations.validate(
                    NonNull.class, null, mBiometricSourceType);
            mRequestReason = requestReason;
            com.android.internal.util.AnnotationValidations.validate(
                    BiometricRequestConstants.RequestReason.class, null, mRequestReason);
            mIsStrongBiometric = isStrongBiometric;
            mUserId = userId;
        }

        /**
         * Identifies {@link BiometricSourceType} of authentication.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setBiometricSourceType(@NonNull BiometricSourceType value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mBiometricSourceType = value;
            return this;
        }

        /**
         * Indicates reason from {@link BiometricRequestConstants.RequestReason} for
         * requesting authentication.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setRequestReason(@BiometricRequestConstants.RequestReason int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mRequestReason = value;
            return this;
        }

        /**
         * Indicates whether auth was from strong biometric.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setIsStrongBiometric(boolean value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mIsStrongBiometric = value;
            return this;
        }

        /**
         * The user id for the requested authentication
         */
        @DataClass.Generated.Member
        public @NonNull Builder setUserId(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mUserId = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull AuthenticationSucceededInfo build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            AuthenticationSucceededInfo o = new AuthenticationSucceededInfo(
                    mBiometricSourceType,
                    mRequestReason,
                    mIsStrongBiometric,
                    mUserId);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1713305509212L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/hardware/biometrics/events/AuthenticationSucceededInfo.java",
            inputSignatures = "private final @android.annotation.NonNull android.hardware.biometrics.BiometricSourceType mBiometricSourceType\nprivate final @android.hardware.biometrics.BiometricRequestConstants.RequestReason int mRequestReason\nprivate final  boolean mIsStrongBiometric\nprivate final  int mUserId\nclass AuthenticationSucceededInfo extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genAidl=true, genBuilder=true, genSetters=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
