/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.android.lint.aidl

/**
 * The exemptAidlInterfaces set was generated by running ExemptAidlInterfacesGenerator on the
 * entire source tree. To reproduce the results, run generate-exempt-aidl-interfaces.sh
 * located in tools/lint/utils.
 */
val exemptAidlInterfaces = setOf(
    "android.accessibilityservice.IBrailleDisplayConnection",
    "android.accounts.IAccountAuthenticatorResponse",
    "android.accounts.IAccountManager",
    "android.accounts.IAccountManagerResponse",
    "android.adservices.adid.IAdIdProviderService",
    "android.adservices.adid.IAdIdService",
    "android.adservices.adid.IGetAdIdCallback",
    "android.adservices.adid.IGetAdIdProviderCallback",
    "android.adservices.adselection.AdSelectionCallback",
    "android.adservices.adselection.AdSelectionOverrideCallback",
    "android.adservices.adselection.AdSelectionService",
    "android.adservices.adselection.GetAdSelectionDataCallback",
    "android.adservices.adselection.PersistAdSelectionResultCallback",
    "android.adservices.adselection.ReportImpressionCallback",
    "android.adservices.adselection.ReportInteractionCallback",
    "android.adservices.adselection.SetAppInstallAdvertisersCallback",
    "android.adservices.adselection.UpdateAdCounterHistogramCallback",
    "android.adservices.appsetid.IAppSetIdProviderService",
    "android.adservices.appsetid.IAppSetIdService",
    "android.adservices.appsetid.IGetAppSetIdCallback",
    "android.adservices.appsetid.IGetAppSetIdProviderCallback",
    "android.adservices.cobalt.IAdServicesCobaltUploadService",
    "android.adservices.common.IAdServicesCommonCallback",
    "android.adservices.common.IAdServicesCommonService",
    "android.adservices.common.IAdServicesCommonStatesCallback",
    "android.adservices.common.IEnableAdServicesCallback",
    "android.adservices.common.IUpdateAdIdCallback",
    "android.adservices.customaudience.CustomAudienceOverrideCallback",
    "android.adservices.customaudience.FetchAndJoinCustomAudienceCallback",
    "android.adservices.customaudience.ICustomAudienceCallback",
    "android.adservices.customaudience.ICustomAudienceService",
    "android.adservices.customaudience.ScheduleCustomAudienceUpdateCallback",
    "android.adservices.extdata.IAdServicesExtDataStorageService",
    "android.adservices.extdata.IGetAdServicesExtDataCallback",
    "android.adservices.measurement.IMeasurementApiStatusCallback",
    "android.adservices.measurement.IMeasurementCallback",
    "android.adservices.measurement.IMeasurementService",
    "android.adservices.ondevicepersonalization.aidl.IDataAccessService",
    "android.adservices.ondevicepersonalization.aidl.IDataAccessServiceCallback",
    "android.adservices.ondevicepersonalization.aidl.IExecuteCallback",
    "android.adservices.ondevicepersonalization.aidl.IFederatedComputeCallback",
    "android.adservices.ondevicepersonalization.aidl.IFederatedComputeService",
    "android.adservices.ondevicepersonalization.aidl.IIsolatedModelService",
    "android.adservices.ondevicepersonalization.aidl.IIsolatedModelServiceCallback",
    "android.adservices.ondevicepersonalization.aidl.IIsolatedService",
    "android.adservices.ondevicepersonalization.aidl.IIsolatedServiceCallback",
    "android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationConfigService",
    "android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationConfigServiceCallback",
    "android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationDebugService",
    "android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationManagingService",
    "android.adservices.ondevicepersonalization.aidl.IRegisterMeasurementEventCallback",
    "android.adservices.ondevicepersonalization.aidl.IRequestSurfacePackageCallback",
    "android.adservices.shell.IShellCommand",
    "android.adservices.shell.IShellCommandCallback",
    "android.adservices.signals.IProtectedSignalsService",
    "android.adservices.signals.UpdateSignalsCallback",
    "android.adservices.topics.IGetTopicsCallback",
    "android.adservices.topics.ITopicsService",
    "android.app.admin.IDevicePolicyManager",
    "android.app.adservices.IAdServicesManager",
    "android.app.ambientcontext.IAmbientContextManager",
    "android.app.ambientcontext.IAmbientContextObserver",
    "android.app.appsearch.aidl.IAppFunctionService",
    "android.app.appsearch.aidl.IAppSearchBatchResultCallback",
    "android.app.appsearch.aidl.IAppSearchManager",
    "android.app.appsearch.aidl.IAppSearchObserverProxy",
    "android.app.appsearch.aidl.IAppSearchResultCallback",
    "android.app.backup.IBackupCallback",
    "android.app.backup.IBackupManager",
    "android.app.backup.IRestoreSession",
    "android.app.blob.IBlobCommitCallback",
    "android.app.blob.IBlobStoreManager",
    "android.app.blob.IBlobStoreSession",
    "android.app.contentsuggestions.IContentSuggestionsManager",
    "android.app.contextualsearch.IContextualSearchManager",
    "android.app.ecm.IEnhancedConfirmationManager",
    "android.apphibernation.IAppHibernationService",
    "android.app.IActivityClientController",
    "android.app.IActivityController",
    "android.app.IActivityTaskManager",
    "android.app.IAlarmCompleteListener",
    "android.app.IAlarmListener",
    "android.app.IAlarmManager",
    "android.app.IApplicationThread",
    "android.app.IAppTask",
    "android.app.IAppTraceRetriever",
    "android.app.IAssistDataReceiver",
    "android.app.IForegroundServiceObserver",
    "android.app.IGameManagerService",
    "android.app.IGrammaticalInflectionManager",
    "android.app.ILocaleManager",
    "android.app.INotificationManager",
    "android.app.IParcelFileDescriptorRetriever",
    "android.app.IProcessObserver",
    "android.app.ISearchManager",
    "android.app.IStopUserCallback",
    "android.app.ITaskStackListener",
    "android.app.IUiModeManager",
    "android.app.IUriGrantsManager",
    "android.app.IUserSwitchObserver",
    "android.app.IWallpaperManager",
    "android.app.job.IJobCallback",
    "android.app.job.IJobScheduler",
    "android.app.job.IJobService",
    "android.app.ondeviceintelligence.IDownloadCallback",
    "android.app.ondeviceintelligence.IFeatureCallback",
    "android.app.ondeviceintelligence.IFeatureDetailsCallback",
    "android.app.ondeviceintelligence.IListFeaturesCallback",
    "android.app.ondeviceintelligence.IOnDeviceIntelligenceManager",
    "android.app.ondeviceintelligence.IProcessingSignal",
    "android.app.ondeviceintelligence.IResponseCallback",
    "android.app.ondeviceintelligence.IStreamingResponseCallback",
    "android.app.ondeviceintelligence.ITokenInfoCallback",
    "android.app.people.IPeopleManager",
    "android.app.pinner.IPinnerService",
    "android.app.prediction.IPredictionManager",
    "android.app.role.IOnRoleHoldersChangedListener",
    "android.app.role.IRoleController",
    "android.app.role.IRoleManager",
    "android.app.sdksandbox.ILoadSdkCallback",
    "android.app.sdksandbox.IRequestSurfacePackageCallback",
    "android.app.sdksandbox.ISdkSandboxManager",
    "android.app.sdksandbox.ISdkSandboxProcessDeathCallback",
    "android.app.sdksandbox.ISdkToServiceCallback",
    "android.app.sdksandbox.ISharedPreferencesSyncCallback",
    "android.app.sdksandbox.IUnloadSdkCallback",
    "android.app.sdksandbox.testutils.testscenario.ISdkSandboxTestExecutor",
    "android.app.search.ISearchUiManager",
    "android.app.slice.ISliceManager",
    "android.app.smartspace.ISmartspaceManager",
    "android.app.timedetector.ITimeDetectorService",
    "android.app.timezonedetector.ITimeZoneDetectorService",
    "android.app.trust.ITrustManager",
    "android.app.usage.IStorageStatsManager",
    "android.app.usage.IUsageStatsManager",
    "android.app.wallpapereffectsgeneration.IWallpaperEffectsGenerationManager",
    "android.app.wearable.IWearableSensingCallback",
    "android.app.wearable.IWearableSensingManager",
    "android.bluetooth.IBluetooth",
    "android.bluetooth.IBluetoothA2dp",
    "android.bluetooth.IBluetoothA2dpSink",
    "android.bluetooth.IBluetoothActivityEnergyInfoListener",
    "android.bluetooth.IBluetoothAvrcpController",
    "android.bluetooth.IBluetoothCallback",
    "android.bluetooth.IBluetoothConnectionCallback",
    "android.bluetooth.IBluetoothCsipSetCoordinator",
    "android.bluetooth.IBluetoothCsipSetCoordinatorLockCallback",
    "android.bluetooth.IBluetoothGatt",
    "android.bluetooth.IBluetoothGattCallback",
    "android.bluetooth.IBluetoothGattServerCallback",
    "android.bluetooth.IBluetoothHapClient",
    "android.bluetooth.IBluetoothHapClientCallback",
    "android.bluetooth.IBluetoothHeadset",
    "android.bluetooth.IBluetoothHeadsetClient",
    "android.bluetooth.IBluetoothHearingAid",
    "android.bluetooth.IBluetoothHidDevice",
    "android.bluetooth.IBluetoothHidDeviceCallback",
    "android.bluetooth.IBluetoothHidHost",
    "android.bluetooth.IBluetoothLeAudio",
    "android.bluetooth.IBluetoothLeAudioCallback",
    "android.bluetooth.IBluetoothLeBroadcastAssistant",
    "android.bluetooth.IBluetoothLeBroadcastAssistantCallback",
    "android.bluetooth.IBluetoothLeBroadcastCallback",
    "android.bluetooth.IBluetoothLeCallControl",
    "android.bluetooth.IBluetoothLeCallControlCallback",
    "android.bluetooth.IBluetoothManager",
    "android.bluetooth.IBluetoothManagerCallback",
    "android.bluetooth.IBluetoothMap",
    "android.bluetooth.IBluetoothMapClient",
    "android.bluetooth.IBluetoothMcpServiceManager",
    "android.bluetooth.IBluetoothMetadataListener",
    "android.bluetooth.IBluetoothOobDataCallback",
    "android.bluetooth.IBluetoothPan",
    "android.bluetooth.IBluetoothPanCallback",
    "android.bluetooth.IBluetoothPbap",
    "android.bluetooth.IBluetoothPbapClient",
    "android.bluetooth.IBluetoothPreferredAudioProfilesCallback",
    "android.bluetooth.IBluetoothQualityReportReadyCallback",
    "android.bluetooth.IBluetoothSap",
    "android.bluetooth.IBluetoothScan",
    "android.bluetooth.IBluetoothSocketManager",
    "android.bluetooth.IBluetoothVolumeControl",
    "android.bluetooth.IBluetoothVolumeControlCallback",
    "android.bluetooth.le.IAdvertisingSetCallback",
    "android.bluetooth.le.IDistanceMeasurementCallback",
    "android.bluetooth.le.IPeriodicAdvertisingCallback",
    "android.bluetooth.le.IScannerCallback",
    "android.companion.ICompanionDeviceManager",
    "android.companion.IOnMessageReceivedListener",
    "android.companion.IOnTransportsChangedListener",
    "android.companion.virtualcamera.IVirtualCameraCallback",
    "android.companion.virtual.IVirtualDevice",
    "android.companion.virtual.IVirtualDeviceManager",
    "android.companion.virtualnative.IVirtualDeviceManagerNative",
    "android.content.IClipboard",
    "android.content.IContentService",
    "android.content.IIntentReceiver",
    "android.content.IIntentSender",
    "android.content.integrity.IAppIntegrityManager",
    "android.content.IRestrictionsManager",
    "android.content.ISyncAdapterUnsyncableAccountCallback",
    "android.content.ISyncContext",
    "android.content.om.IOverlayManager",
    "android.content.pm.dex.IArtManager",
    "android.content.pm.dex.ISnapshotRuntimeProfileCallback",
    "android.content.pm.IBackgroundInstallControlService",
    "android.content.pm.ICrossProfileApps",
    "android.content.pm.IDataLoaderManager",
    "android.content.pm.IDataLoaderStatusListener",
    "android.content.pm.ILauncherApps",
    "android.content.pm.IOnChecksumsReadyListener",
    "android.content.pm.IOtaDexopt",
    "android.content.pm.IPackageDataObserver",
    "android.content.pm.IPackageDeleteObserver",
    "android.content.pm.IPackageInstaller",
    "android.content.pm.IPackageInstallerSession",
    "android.content.pm.IPackageInstallerSessionFileSystemConnector",
    "android.content.pm.IPackageInstallObserver2",
    "android.content.pm.IPackageLoadingProgressCallback",
    "android.content.pm.IPackageManager",
    "android.content.pm.IPackageManagerNative",
    "android.content.pm.IPackageMoveObserver",
    "android.content.pm.IPinItemRequest",
    "android.content.pm.IShortcutService",
    "android.content.pm.IStagedApexObserver",
    "android.content.pm.verify.domain.IDomainVerificationManager",
    "android.content.res.IResourcesManager",
    "android.content.rollback.IRollbackManager",
    "android.credentials.ICredentialManager",
    "android.debug.IAdbTransport",
    "android.devicelock.IDeviceLockService",
    "android.devicelock.IGetDeviceIdCallback",
    "android.devicelock.IGetKioskAppsCallback",
    "android.devicelock.IIsDeviceLockedCallback",
    "android.devicelock.ILockUnlockDeviceCallback",
    "android.federatedcompute.aidl.IExampleStoreCallback",
    "android.federatedcompute.aidl.IExampleStoreIterator",
    "android.federatedcompute.aidl.IExampleStoreIteratorCallback",
    "android.federatedcompute.aidl.IExampleStoreService",
    "android.federatedcompute.aidl.IFederatedComputeCallback",
    "android.federatedcompute.aidl.IFederatedComputeService",
    "android.federatedcompute.aidl.IResultHandlingService",
    "android.flags.IFeatureFlags",
    "android.frameworks.location.altitude.IAltitudeService",
    "android.frameworks.vibrator.IVibratorController",
    "android.frameworks.vibrator.IVibratorControlService",
    "android.gsi.IGsiServiceCallback",
    "android.hardware.biometrics.AuthenticationStateListener",
    "android.hardware.biometrics.common.ICancellationSignal",
    "android.hardware.biometrics.face.IFace",
    "android.hardware.biometrics.face.ISession",
    "android.hardware.biometrics.face.ISessionCallback",
    "android.hardware.biometrics.fingerprint.IFingerprint",
    "android.hardware.biometrics.fingerprint.ISession",
    "android.hardware.biometrics.fingerprint.ISessionCallback",
    "android.hardware.biometrics.IAuthService",
    "android.hardware.biometrics.IBiometricAuthenticator",
    "android.hardware.biometrics.IBiometricContextListener",
    "android.hardware.biometrics.IBiometricSensorReceiver",
    "android.hardware.biometrics.IBiometricService",
    "android.hardware.biometrics.IBiometricStateListener",
    "android.hardware.biometrics.IBiometricSysuiReceiver",
    "android.hardware.biometrics.IInvalidationCallback",
    "android.hardware.biometrics.ITestSession",
    "android.hardware.broadcastradio.IAnnouncementListener",
    "android.hardware.broadcastradio.ITunerCallback",
    "android.hardware.contexthub.IContextHubCallback",
    "android.hardware.devicestate.IDeviceStateManager",
    "android.hardware.display.IColorDisplayManager",
    "android.hardware.display.IDisplayManager",
    "android.hardware.face.IFaceAuthenticatorsRegisteredCallback",
    "android.hardware.face.IFaceService",
    "android.hardware.face.IFaceServiceReceiver",
    "android.hardware.fingerprint.IFingerprintAuthenticatorsRegisteredCallback",
    "android.hardware.fingerprint.IFingerprintClientActiveCallback",
    "android.hardware.fingerprint.IFingerprintService",
    "android.hardware.fingerprint.IFingerprintServiceReceiver",
    "android.hardware.fingerprint.IUdfpsOverlayControllerCallback",
    "android.hardware.fingerprint.IUdfpsRefreshRateRequestCallback",
    "android.hardware.hdmi.IHdmiControlCallback",
    "android.hardware.hdmi.IHdmiControlService",
    "android.hardware.hdmi.IHdmiDeviceEventListener",
    "android.hardware.hdmi.IHdmiHotplugEventListener",
    "android.hardware.hdmi.IHdmiSystemAudioModeChangeListener",
    "android.hardware.health.IHealthInfoCallback",
    "android.hardware.ICameraServiceProxy",
    "android.hardware.IConsumerIrService",
    "android.hardware.input.IInputManager",
    "android.hardware.iris.IIrisService",
    "android.hardware.ISensorPrivacyManager",
    "android.hardware.ISerialManager",
    "android.hardware.lights.ILightsManager",
    "android.hardware.location.IContextHubClient",
    "android.hardware.location.IContextHubClientCallback",
    "android.hardware.location.IContextHubService",
    "android.hardware.location.IContextHubTransactionCallback",
    "android.hardware.location.ISignificantPlaceProviderManager",
    "android.hardware.radio.IAnnouncementListener",
    "android.hardware.radio.ICloseHandle",
    "android.hardware.radio.ims.media.IImsMedia",
    "android.hardware.radio.ims.media.IImsMediaListener",
    "android.hardware.radio.ims.media.IImsMediaSession",
    "android.hardware.radio.ims.media.IImsMediaSessionListener",
    "android.hardware.radio.IRadioService",
    "android.hardware.radio.ITuner",
    "android.hardware.radio.sap.ISapCallback",
    "android.hardware.soundtrigger3.ISoundTriggerHw",
    "android.hardware.soundtrigger3.ISoundTriggerHwCallback",
    "android.hardware.soundtrigger3.ISoundTriggerHwGlobalCallback",
    "android.hardware.soundtrigger.IRecognitionStatusCallback",
    "android.hardware.tetheroffload.ITetheringOffloadCallback",
    "android.hardware.thermal.IThermalChangedCallback",
    "android.hardware.tv.hdmi.cec.IHdmiCecCallback",
    "android.hardware.tv.hdmi.connection.IHdmiConnectionCallback",
    "android.hardware.tv.hdmi.earc.IEArcCallback",
    "android.hardware.usb.gadget.IUsbGadgetCallback",
    "android.hardware.usb.IUsbCallback",
    "android.hardware.usb.IUsbManager",
    "android.hardware.usb.IUsbSerialReader",
    "android.hardware.wifi.hostapd.IHostapdCallback",
    "android.hardware.wifi.IWifiChipEventCallback",
    "android.hardware.wifi.IWifiEventCallback",
    "android.hardware.wifi.IWifiNanIfaceEventCallback",
    "android.hardware.wifi.IWifiRttControllerEventCallback",
    "android.hardware.wifi.IWifiStaIfaceEventCallback",
    "android.hardware.wifi.supplicant.INonStandardCertCallback",
    "android.hardware.wifi.supplicant.ISupplicantP2pIfaceCallback",
    "android.hardware.wifi.supplicant.ISupplicantStaIfaceCallback",
    "android.hardware.wifi.supplicant.ISupplicantStaNetworkCallback",
    "android.health.connect.aidl.IAccessLogsResponseCallback",
    "android.health.connect.aidl.IActivityDatesResponseCallback",
    "android.health.connect.aidl.IAggregateRecordsResponseCallback",
    "android.health.connect.aidl.IApplicationInfoResponseCallback",
    "android.health.connect.aidl.IChangeLogsResponseCallback",
    "android.health.connect.aidl.IDataStagingFinishedCallback",
    "android.health.connect.aidl.IEmptyResponseCallback",
    "android.health.connect.aidl.IGetChangeLogTokenCallback",
    "android.health.connect.aidl.IGetHealthConnectDataStateCallback",
    "android.health.connect.aidl.IGetHealthConnectMigrationUiStateCallback",
    "android.health.connect.aidl.IGetPriorityResponseCallback",
    "android.health.connect.aidl.IHealthConnectService",
    "android.health.connect.aidl.IInsertRecordsResponseCallback",
    "android.health.connect.aidl.IMigrationCallback",
    "android.health.connect.aidl.IReadMedicalResourcesResponseCallback",
    "android.health.connect.aidl.IReadRecordsResponseCallback",
    "android.health.connect.aidl.IRecordTypeInfoResponseCallback",
    "android.health.connect.exportimport.IImportStatusCallback",
    "android.health.connect.exportimport.IQueryDocumentProvidersCallback",
    "android.health.connect.exportimport.IScheduledExportStatusCallback",
    "android.location.ICountryDetector",
    "android.location.IGpsGeofenceHardware",
    "android.location.ILocationManager",
    "android.location.provider.ILocationProviderManager",
    "android.media.IAudioRoutesObserver",
    "android.media.IMediaCommunicationService",
    "android.media.IMediaCommunicationServiceCallback",
    "android.media.IMediaController2",
    "android.media.IMediaRoute2ProviderServiceCallback",
    "android.media.IMediaRouterService",
    "android.media.IMediaSession2",
    "android.media.IMediaSession2Service",
    "android.media.INativeSpatializerCallback",
    "android.media.IPlaybackConfigDispatcher",
    "android.media.IRecordingConfigDispatcher",
    "android.media.IRemoteDisplayCallback",
    "android.media.ISoundDoseCallback",
    "android.media.ISpatializerHeadTrackingCallback",
    "android.media.ITranscodingClientCallback",
    "android.media.metrics.IMediaMetricsManager",
    "android.media.midi.IMidiManager",
    "android.media.musicrecognition.IMusicRecognitionAttributionTagCallback",
    "android.media.musicrecognition.IMusicRecognitionManager",
    "android.media.musicrecognition.IMusicRecognitionServiceCallback",
    "android.media.projection.IMediaProjection",
    "android.media.projection.IMediaProjectionCallback",
    "android.media.projection.IMediaProjectionManager",
    "android.media.projection.IMediaProjectionWatcherCallback",
    "android.media.session.ISession",
    "android.media.session.ISessionController",
    "android.media.session.ISessionManager",
    "android.media.soundtrigger.ISoundTriggerDetectionServiceClient",
    "android.media.soundtrigger_middleware.IInjectGlobalEvent",
    "android.media.soundtrigger_middleware.IInjectModelEvent",
    "android.media.soundtrigger_middleware.IInjectRecognitionEvent",
    "android.media.soundtrigger_middleware.ISoundTriggerMiddlewareService",
    "android.media.soundtrigger_middleware.ISoundTriggerModule",
    "android.media.tv.ad.ITvAdManager",
    "android.media.tv.ad.ITvAdSessionCallback",
    "android.media.tv.interactive.ITvInteractiveAppManager",
    "android.media.tv.interactive.ITvInteractiveAppServiceCallback",
    "android.media.tv.interactive.ITvInteractiveAppSessionCallback",
    "android.media.tv.ITvInputHardware",
    "android.media.tv.ITvInputManager",
    "android.media.tv.ITvInputServiceCallback",
    "android.media.tv.ITvInputSessionCallback",
    "android.media.tv.ITvRemoteServiceInput",
    "android.nearby.aidl.IOffloadCallback",
    "android.nearby.IBroadcastListener",
    "android.nearby.INearbyManager",
    "android.nearby.IScanListener",
    "android.net.connectivity.aidl.ConnectivityNative",
    "android.net.dhcp.IDhcpEventCallbacks",
    "android.net.dhcp.IDhcpServer",
    "android.net.dhcp.IDhcpServerCallbacks",
    "android.net.ICaptivePortal",
    "android.net.IConnectivityDiagnosticsCallback",
    "android.net.IConnectivityManager",
    "android.net.IEthernetManager",
    "android.net.IEthernetServiceListener",
    "android.net.IIntResultListener",
    "android.net.IIpConnectivityMetrics",
    "android.net.IIpMemoryStore",
    "android.net.IIpMemoryStoreCallbacks",
    "android.net.IIpSecService",
    "android.net.INetdEventCallback",
    "android.net.INetdUnsolicitedEventListener",
    "android.net.INetworkActivityListener",
    "android.net.INetworkAgent",
    "android.net.INetworkAgentRegistry",
    "android.net.INetworkInterfaceOutcomeReceiver",
    "android.net.INetworkManagementEventObserver",
    "android.net.INetworkMonitor",
    "android.net.INetworkMonitorCallbacks",
    "android.net.INetworkOfferCallback",
    "android.net.INetworkPolicyListener",
    "android.net.INetworkPolicyManager",
    "android.net.INetworkScoreService",
    "android.net.INetworkStackConnector",
    "android.net.INetworkStackStatusCallback",
    "android.net.INetworkStatsService",
    "android.net.INetworkStatsSession",
    "android.net.IOnCompleteListener",
    "android.net.IPacProxyManager",
    "android.net.ip.IIpClient",
    "android.net.ip.IIpClientCallbacks",
    "android.net.ipmemorystore.IOnBlobRetrievedListener",
    "android.net.ipmemorystore.IOnL2KeyResponseListener",
    "android.net.ipmemorystore.IOnNetworkAttributesRetrievedListener",
    "android.net.ipmemorystore.IOnNetworkEventCountRetrievedListener",
    "android.net.ipmemorystore.IOnSameL3NetworkResponseListener",
    "android.net.ipmemorystore.IOnStatusAndCountListener",
    "android.net.ipmemorystore.IOnStatusListener",
    "android.net.IQosCallback",
    "android.net.ISocketKeepaliveCallback",
    "android.net.ITestNetworkManager",
    "android.net.ITetheredInterfaceCallback",
    "android.net.ITetheringConnector",
    "android.net.ITetheringEventCallback",
    "android.net.IVpnManager",
    "android.net.mdns.aidl.IMDnsEventListener",
    "android.net.metrics.INetdEventListener",
    "android.net.netstats.IUsageCallback",
    "android.net.netstats.provider.INetworkStatsProvider",
    "android.net.netstats.provider.INetworkStatsProviderCallback",
    "android.net.nsd.INsdManager",
    "android.net.nsd.INsdManagerCallback",
    "android.net.nsd.INsdServiceConnector",
    "android.net.nsd.IOffloadEngine",
    "android.net.resolv.aidl.IDnsResolverUnsolicitedEventListener",
    "android.net.thread.IActiveOperationalDatasetReceiver",
    "android.net.thread.IConfigurationReceiver",
    "android.net.thread.IOperationalDatasetCallback",
    "android.net.thread.IOperationReceiver",
    "android.net.thread.IOutputReceiver",
    "android.net.thread.IStateCallback",
    "android.net.thread.IThreadNetworkController",
    "android.net.thread.IThreadNetworkManager",
    "android.net.vcn.IVcnManagementService",
    "android.net.wear.ICompanionDeviceManagerProxy",
    "android.net.wifi.aware.IWifiAwareDiscoverySessionCallback",
    "android.net.wifi.aware.IWifiAwareEventCallback",
    "android.net.wifi.aware.IWifiAwareMacAddressProvider",
    "android.net.wifi.aware.IWifiAwareManager",
    "android.net.wifi.hotspot2.IProvisioningCallback",
    "android.net.wifi.IActionListener",
    "android.net.wifi.IBooleanListener",
    "android.net.wifi.IByteArrayListener",
    "android.net.wifi.ICoexCallback",
    "android.net.wifi.IDppCallback",
    "android.net.wifi.IIntegerListener",
    "android.net.wifi.IInterfaceCreationInfoCallback",
    "android.net.wifi.ILastCallerListener",
    "android.net.wifi.IListListener",
    "android.net.wifi.ILocalOnlyConnectionStatusListener",
    "android.net.wifi.ILocalOnlyHotspotCallback",
    "android.net.wifi.IMacAddressListListener",
    "android.net.wifi.IMapListener",
    "android.net.wifi.INetworkRequestMatchCallback",
    "android.net.wifi.INetworkRequestUserSelectionCallback",
    "android.net.wifi.IOnWifiActivityEnergyInfoListener",
    "android.net.wifi.IOnWifiDriverCountryCodeChangedListener",
    "android.net.wifi.IOnWifiUsabilityStatsListener",
    "android.net.wifi.IPnoScanResultsCallback",
    "android.net.wifi.IScanDataListener",
    "android.net.wifi.IScanResultsCallback",
    "android.net.wifi.IScoreUpdateObserver",
    "android.net.wifi.ISoftApCallback",
    "android.net.wifi.IStringListener",
    "android.net.wifi.ISubsystemRestartCallback",
    "android.net.wifi.ISuggestionConnectionStatusListener",
    "android.net.wifi.ISuggestionUserApprovalStatusListener",
    "android.net.wifi.ITrafficStateCallback",
    "android.net.wifi.ITwtCallback",
    "android.net.wifi.ITwtCapabilitiesListener",
    "android.net.wifi.ITwtStatsListener",
    "android.net.wifi.IWifiBandsListener",
    "android.net.wifi.IWifiConnectedNetworkScorer",
    "android.net.wifi.IWifiLowLatencyLockListener",
    "android.net.wifi.IWifiManager",
    "android.net.wifi.IWifiNetworkSelectionConfigListener",
    "android.net.wifi.IWifiNetworkStateChangedListener",
    "android.net.wifi.IWifiScanner",
    "android.net.wifi.IWifiScannerListener",
    "android.net.wifi.IWifiVerboseLoggingStatusChangedListener",
    "android.net.wifi.p2p.IWifiP2pListener",
    "android.net.wifi.p2p.IWifiP2pManager",
    "android.net.wifi.rtt.IRttCallback",
    "android.net.wifi.rtt.IWifiRttManager",
    "android.ondevicepersonalization.IOnDevicePersonalizationSystemService",
    "android.ondevicepersonalization.IOnDevicePersonalizationSystemServiceCallback",
    "android.os.IBatteryPropertiesRegistrar",
    "android.os.ICancellationSignal",
    "android.os.IDeviceIdentifiersPolicyService",
    "android.os.IDeviceIdleController",
    "android.os.IDumpstate",
    "android.os.IDumpstateListener",
    "android.os.IExternalVibratorService",
    "android.os.IHardwarePropertiesManager",
    "android.os.IHintManager",
    "android.os.IHintSession",
    "android.os.IIncidentCompanion",
    "android.os.image.IDynamicSystemService",
    "android.os.incremental.IStorageHealthListener",
    "android.os.INetworkManagementService",
    "android.os.IPendingIntentRef",
    "android.os.IPowerStatsService",
    "android.os.IProfilingResultCallback",
    "android.os.IProfilingService",
    "android.os.IProgressListener",
    "android.os.IPullAtomCallback",
    "android.os.IRecoverySystem",
    "android.os.IRemoteCallback",
    "android.os.ISecurityStateManager",
    "android.os.IServiceCallback",
    "android.os.IStatsCompanionService",
    "android.os.IStatsManagerService",
    "android.os.IStatsQueryCallback",
    "android.os.ISystemConfig",
    "android.os.ISystemUpdateManager",
    "android.os.IThermalEventListener",
    "android.os.IUpdateLock",
    "android.os.IUserManager",
    "android.os.IUserRestrictionsListener",
    "android.os.IVibratorManagerService",
    "android.os.IVoldListener",
    "android.os.IVoldMountCallback",
    "android.os.IVoldTaskListener",
    "android.os.logcat.ILogcatManagerService",
    "android.permission.ILegacyPermissionManager",
    "android.permission.IPermissionChecker",
    "android.permission.IPermissionManager",
    "android.print.IPrintManager",
    "android.print.IPrintSpoolerCallbacks",
    "android.print.IPrintSpoolerClient",
    "android.printservice.IPrintServiceClient",
    "android.printservice.recommendation.IRecommendationServiceCallbacks",
    "android.provider.aidl.IDeviceConfigManager",
    "android.remoteauth.IDeviceDiscoveryListener",
    "android.safetycenter.IOnSafetyCenterDataChangedListener",
    "android.safetycenter.ISafetyCenterManager",
    "android.scheduling.IRebootReadinessManager",
    "android.scheduling.IRequestRebootReadinessStatusListener",
    "android.security.attestationverification.IAttestationVerificationManagerService",
    "android.security.IFileIntegrityService",
    "android.security.keystore.IKeyAttestationApplicationIdProvider",
    "android.security.rkp.IRegistration",
    "android.security.rkp.IRemoteProvisioning",
    "android.service.appprediction.IPredictionService",
    "android.service.assist.classification.IFieldClassificationCallback",
    "android.service.attention.IAttentionCallback",
    "android.service.attention.IProximityUpdateCallback",
    "android.service.autofill.augmented.IFillCallback",
    "android.service.autofill.IConvertCredentialCallback",
    "android.service.autofill.IFillCallback",
    "android.service.autofill.IInlineSuggestionUiCallback",
    "android.service.autofill.ISaveCallback",
    "android.service.autofill.ISurfacePackageResultCallback",
    "android.service.contentcapture.IContentCaptureServiceCallback",
    "android.service.contentcapture.IContentProtectionAllowlistCallback",
    "android.service.contentcapture.IDataShareCallback",
    "android.service.credentials.IBeginCreateCredentialCallback",
    "android.service.credentials.IBeginGetCredentialCallback",
    "android.service.credentials.IClearCredentialStateCallback",
    "android.service.dreams.IDreamManager",
    "android.service.games.IGameServiceController",
    "android.service.games.IGameSessionController",
    "android.service.notification.IStatusBarNotificationHolder",
    "android.service.oemlock.IOemLockService",
    "android.service.ondeviceintelligence.IProcessingUpdateStatusCallback",
    "android.service.ondeviceintelligence.IRemoteProcessingService",
    "android.service.ondeviceintelligence.IRemoteStorageService",
    "android.service.persistentdata.IPersistentDataBlockService",
    "android.service.resolver.IResolverRankerResult",
    "android.service.rotationresolver.IRotationResolverCallback",
    "android.service.textclassifier.ITextClassifierCallback",
    "android.service.textclassifier.ITextClassifierService",
    "android.service.timezone.ITimeZoneProviderManager",
    "android.service.trust.ITrustAgentServiceCallback",
    "android.service.voice.IDetectorSessionStorageService",
    "android.service.voice.IDetectorSessionVisualQueryDetectionCallback",
    "android.service.voice.IDspHotwordDetectionCallback",
    "android.service.wallpaper.IWallpaperConnection",
    "android.speech.IRecognitionListener",
    "android.speech.IRecognitionService",
    "android.speech.IRecognitionServiceManager",
    "android.speech.tts.ITextToSpeechManager",
    "android.speech.tts.ITextToSpeechSession",
    "android.system.composd.ICompilationTaskCallback",
    "android.system.virtualizationmaintenance.IVirtualizationReconciliationCallback",
    "android.system.virtualizationservice.IVirtualMachineCallback",
    "android.system.vmtethering.IVmTethering",
    "android.telephony.imsmedia.IImsAudioSession",
    "android.telephony.imsmedia.IImsAudioSessionCallback",
    "android.telephony.imsmedia.IImsMedia",
    "android.telephony.imsmedia.IImsMediaCallback",
    "android.telephony.imsmedia.IImsTextSession",
    "android.telephony.imsmedia.IImsTextSessionCallback",
    "android.telephony.imsmedia.IImsVideoSession",
    "android.telephony.imsmedia.IImsVideoSessionCallback",
    "android.tracing.ITracingServiceProxy",
    "android.uwb.IOnUwbActivityEnergyInfoListener",
    "android.uwb.IUwbAdapter",
    "android.uwb.IUwbAdapterStateCallbacks",
    "android.uwb.IUwbAdfProvisionStateCallbacks",
    "android.uwb.IUwbOemExtensionCallback",
    "android.uwb.IUwbRangingCallbacks",
    "android.uwb.IUwbVendorUciCallback",
    "android.view.autofill.IAutoFillManager",
    "android.view.autofill.IAutofillWindowPresenter",
    "android.view.contentcapture.IContentCaptureManager",
    "android.view.IDisplayChangeWindowCallback",
    "android.view.IDisplayWindowListener",
    "android.view.IInputFilter",
    "android.view.IInputFilterHost",
    "android.view.IInputMonitorHost",
    "android.view.IRecentsAnimationController",
    "android.view.IRemoteAnimationFinishedCallback",
    "android.view.ISensitiveContentProtectionManager",
    "android.view.IWindowId",
    "android.view.IWindowManager",
    "android.view.IWindowSession",
    "android.view.translation.ITranslationManager",
    "android.view.translation.ITranslationServiceCallback",
    "android.webkit.IWebViewUpdateService",
    "android.window.IBackAnimationFinishedCallback",
    "android.window.IDisplayAreaOrganizerController",
    "android.window.ITaskFragmentOrganizerController",
    "android.window.ITaskOrganizerController",
    "android.window.ITransitionMetricsReporter",
    "android.window.IUnhandledDragCallback",
    "android.window.IWindowContainerToken",
    "android.window.IWindowlessStartingSurfaceCallback",
    "android.window.IWindowOrganizerController",
    "androidx.core.uwb.backend.IUwb",
    "androidx.core.uwb.backend.IUwbClient",
    "com.android.clockwork.modes.IModeManager",
    "com.android.clockwork.modes.IStateChangeListener",
    "com.android.clockwork.power.IWearPowerService",
    "com.android.devicelockcontroller.IDeviceLockControllerService",
    "com.android.devicelockcontroller.storage.IGlobalParametersService",
    "com.android.devicelockcontroller.storage.ISetupParametersService",
    "com.android.federatedcompute.services.training.aidl.IIsolatedTrainingService",
    "com.android.federatedcompute.services.training.aidl.ITrainingResultCallback",
    "com.android.internal.app.IAppOpsActiveCallback",
    "com.android.internal.app.ILogAccessDialogCallback",
    "com.android.internal.app.ISoundTriggerService",
    "com.android.internal.app.ISoundTriggerSession",
    "com.android.internal.app.IVoiceInteractionAccessibilitySettingsListener",
    "com.android.internal.app.IVoiceInteractionManagerService",
    "com.android.internal.app.IVoiceInteractionSessionListener",
    "com.android.internal.app.IVoiceInteractionSessionShowCallback",
    "com.android.internal.app.IVoiceInteractionSoundTriggerSession",
    "com.android.internal.app.procstats.IProcessStats",
    "com.android.internal.appwidget.IAppWidgetService",
    "com.android.internal.backup.ITransportStatusCallback",
    "com.android.internal.compat.IOverrideValidator",
    "com.android.internal.compat.IPlatformCompat",
    "com.android.internal.compat.IPlatformCompatNative",
    "com.android.internal.graphics.fonts.IFontManager",
    "com.android.internal.inputmethod.IAccessibilityInputMethodSessionCallback",
    "com.android.internal.inputmethod.IConnectionlessHandwritingCallback",
    "com.android.internal.inputmethod.IImeTracker",
    "com.android.internal.inputmethod.IInlineSuggestionsRequestCallback",
    "com.android.internal.inputmethod.IInputContentUriToken",
    "com.android.internal.inputmethod.IInputMethodPrivilegedOperations",
    "com.android.internal.inputmethod.IInputMethodSessionCallback",
    "com.android.internal.net.INetworkWatchlistManager",
    "com.android.internal.os.IBinaryTransparencyService",
    "com.android.internal.os.IDropBoxManagerService",
    "com.android.internal.policy.IKeyguardDismissCallback",
    "com.android.internal.policy.IKeyguardDrawnCallback",
    "com.android.internal.policy.IKeyguardExitCallback",
    "com.android.internal.policy.IKeyguardStateCallback",
    "com.android.internal.statusbar.IAddTileResultCallback",
    "com.android.internal.statusbar.ISessionListener",
    "com.android.internal.statusbar.IStatusBarService",
    "com.android.internal.telecom.IDeviceIdleControllerAdapter",
    "com.android.internal.telecom.IInternalServiceRetriever",
    "com.android.internal.telephony.IMms",
    "com.android.internal.telephony.ITelephonyRegistry",
    "com.android.internal.textservice.ISpellCheckerServiceCallback",
    "com.android.internal.textservice.ITextServicesManager",
    "com.android.internal.view.IDragAndDropPermissions",
    "com.android.internal.view.IInputMethodManager",
    "com.android.internal.view.inline.IInlineContentProvider",
    "com.android.internal.widget.ILockSettings",
    "com.android.net.IProxyPortListener",
    "com.android.net.module.util.IRoutingCoordinator",
    "com.android.ondevicepersonalization.libraries.plugin.internal.IPluginCallback",
    "com.android.ondevicepersonalization.libraries.plugin.internal.IPluginExecutorService",
    "com.android.ondevicepersonalization.libraries.plugin.internal.IPluginStateCallback",
    "com.android.rkpdapp.IGetKeyCallback",
    "com.android.rkpdapp.IGetRegistrationCallback",
    "com.android.rkpdapp.IRegistration",
    "com.android.rkpdapp.IRemoteProvisioning",
    "com.android.rkpdapp.IStoreUpgradedKeyCallback",
    "com.android.sdksandbox.IComputeSdkStorageCallback",
    "com.android.sdksandbox.ILoadSdkInSandboxCallback",
    "com.android.sdksandbox.IRequestSurfacePackageFromSdkCallback",
    "com.android.sdksandbox.ISdkSandboxManagerToSdkSandboxCallback",
    "com.android.sdksandbox.ISdkSandboxService",
    "com.android.sdksandbox.IUnloadSdkInSandboxCallback",
    "com.android.server.profcollect.IProviderStatusCallback",
    "com.android.server.thread.openthread.IChannelMasksReceiver",
    "com.android.server.thread.openthread.INsdPublisher",
    "com.android.server.thread.openthread.IOtDaemonCallback",
    "com.android.server.thread.openthread.IOtOutputReceiver",
    "com.android.server.thread.openthread.IOtStatusReceiver",
    "com.google.android.clockwork.ambient.offload.IDisplayOffloadService",
    "com.google.android.clockwork.ambient.offload.IDisplayOffloadTransitionFinishedCallbacks",
    "com.google.android.clockwork.healthservices.IHealthService",
    "vendor.google_clockwork.healthservices.IHealthServicesCallback",
)
