/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.server.input;

import com.android.internal.util.DataClass;
import com.android.tools.r8.keepanno.annotations.KeepItemKind;
import com.android.tools.r8.keepanno.annotations.UsedByNative;

/**
 * This class represents the Touchpad Finger State of a single contact on the touchpad.
 * It is used for the touchpad visualizer project at TouchpadDebugActivity
 */
@DataClass(genToString = true)
@UsedByNative(
        description = "Called from JNI in jni/com_android_server_input_InputManagerService.cpp",
        kind = KeepItemKind.CLASS_AND_MEMBERS)
public final class TouchpadFingerState{
    /**
     * The large radius of the ellipse of the finger touching the pad.
     */
    private final float mTouchMajor;

    /**
     * The small radius of the ellipse of the finger touching the pad.
     */
    private final float mTouchMinor;

    /**
     * The large radius of the ellipse of the finger, including parts
     * that are hovering over the pad but not quite touching.
     */
    private final float mWidthMajor;

    /**
     * The small radius of the ellipse of the finger, including parts
     * that are hovering over the pad but not quite touching.
     */
    private final float mWidthMinor;

    /**
     * Pressure applied by a finger on the touchpad.
     */
    private final float mPressure;

    /**
     * Orientation of a finger on the touchpad. Measured in radians.
     */
    private final float mOrientation;

    /**
     * The X-coordinate of the center of the ellipse that represents a finger.
     */
    private final float mPositionX;

    /**
     * The Y-coordinate of the center of the ellipse that represents a finger.
     */
    private final float mPositionY;

    /**
     * A number that identifies a single physical finger across consecutive frames.
     * If a finger is the same physical finger across two consecutive frames, it
     * must have the same tracking ID; if it's a different finger, it should
     * have a different tracking ID.
     */
    private final int mTrackingId;


    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/services/core/java/com/android/server/input/
    // TouchpadFingerState.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off

    /**
     * Creates a new TouchpadFingerState.
     *
     * @param touchMajor
     *   The large radius of the ellipse of the finger touching the pad.
     * @param touchMinor
     *   The small radius of the ellipse of the finger touching the pad.
     * @param widthMajor
     *   The large radius of the ellipse of the finger, including parts
     *   that are hovering over the pad but not quite touching.
     * @param widthMinor
     *   The small radius of the ellipse of the finger, including parts
     *   that are hovering over the pad but not quite touching.
     * @param pressure
     *   Pressure applied by a finger on the touchpad.
     * @param orientation
     *   Orientation of a finger on the touchpad. Measured in radians.
     * @param positionX
     *   The X-coordinate of the center of the ellipse that represents a finger.
     * @param positionY
     *   The Y-coordinate of the center of the ellipse that represents a finger.
     * @param trackingId
     *   A number that identifies a single physical finger across consecutive frames.
     *   If a finger is the same physical finger across two consecutive frames, it
     *   must have the same tracking ID; if it's a different finger, it should
     *   have a different tracking ID.
     */
    @DataClass.Generated.Member
    public TouchpadFingerState(
            float touchMajor,
            float touchMinor,
            float widthMajor,
            float widthMinor,
            float pressure,
            float orientation,
            float positionX,
            float positionY,
            int trackingId) {
        this.mTouchMajor = touchMajor;
        this.mTouchMinor = touchMinor;
        this.mWidthMajor = widthMajor;
        this.mWidthMinor = widthMinor;
        this.mPressure = pressure;
        this.mOrientation = orientation;
        this.mPositionX = positionX;
        this.mPositionY = positionY;
        this.mTrackingId = trackingId;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The large radius of the ellipse of the finger touching the pad.
     */
    @DataClass.Generated.Member
    public float getTouchMajor() {
        return mTouchMajor;
    }

    /**
     * The small radius of the ellipse of the finger touching the pad.
     */
    @DataClass.Generated.Member
    public float getTouchMinor() {
        return mTouchMinor;
    }

    /**
     * The large radius of the ellipse of the finger, including parts
     * that are hovering over the pad but not quite touching.
     */
    @DataClass.Generated.Member
    public float getWidthMajor() {
        return mWidthMajor;
    }

    /**
     * The small radius of the ellipse of the finger, including parts
     * that are hovering over the pad but not quite touching.
     */
    @DataClass.Generated.Member
    public float getWidthMinor() {
        return mWidthMinor;
    }

    /**
     * Pressure applied by a finger on the touchpad.
     */
    @DataClass.Generated.Member
    public float getPressure() {
        return mPressure;
    }

    /**
     * Orientation of a finger on the touchpad. Measured in radians.
     */
    @DataClass.Generated.Member
    public float getOrientation() {
        return mOrientation;
    }

    /**
     * The X-coordinate of the center of the ellipse that represents a finger.
     */
    @DataClass.Generated.Member
    public float getPositionX() {
        return mPositionX;
    }

    /**
     * The Y-coordinate of the center of the ellipse that represents a finger.
     */
    @DataClass.Generated.Member
    public float getPositionY() {
        return mPositionY;
    }

    /**
     * A number that identifies a single physical finger across consecutive frames.
     * If a finger is the same physical finger across two consecutive frames, it
     * must have the same tracking ID; if it's a different finger, it should
     * have a different tracking ID.
     */
    @DataClass.Generated.Member
    public int getTrackingId() {
        return mTrackingId;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "TouchpadFingerState { " +
                "touchMajor = " + mTouchMajor + ", " +
                "touchMinor = " + mTouchMinor + ", " +
                "widthMajor = " + mWidthMajor + ", " +
                "widthMinor = " + mWidthMinor + ", " +
                "pressure = " + mPressure + ", " +
                "orientation = " + mOrientation + ", " +
                "positionX = " + mPositionX + ", " +
                "positionY = " + mPositionY + ", " +
                "trackingId = " + mTrackingId +
        " }";
    }

    @DataClass.Generated(
            time = 1724078820706L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/services/core/java/com/android/server/input/"
                    + "TouchpadFingerState.java",
            inputSignatures = "private final  float mTouchMajor\nprivate final  float mTouchMinor\n"
                    + "private final  float mWidthMajor\nprivate final  float mWidthMinor\nprivate"
                    + " final  float mPressure\nprivate final  float mOrientation\nprivate final  "
                    + "float mPositionX\nprivate final  float mPositionY\nprivate final  int "
                    + "mTrackingId\nclass TouchpadFingerState extends java.lang.Object implements"
                    + " []\n@com.android.internal.util.DataClass(genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
