/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.statusbar.chips.casttootherdevice.ui.viewmodel

import android.content.applicationContext
import com.android.systemui.animation.dialogTransitionAnimator
import com.android.systemui.animation.mockDialogTransitionAnimator
import com.android.systemui.kosmos.Kosmos
import com.android.systemui.kosmos.applicationCoroutineScope
import com.android.systemui.statusbar.chips.casttootherdevice.domain.interactor.mediaRouterChipInteractor
import com.android.systemui.statusbar.chips.mediaprojection.domain.interactor.mediaProjectionChipInteractor
import com.android.systemui.statusbar.chips.mediaprojection.ui.view.endMediaProjectionDialogHelper
import com.android.systemui.statusbar.chips.statusBarChipsLogger
import com.android.systemui.util.time.fakeSystemClock

val Kosmos.castToOtherDeviceChipViewModel: CastToOtherDeviceChipViewModel by
    Kosmos.Fixture {
        CastToOtherDeviceChipViewModel(
            scope = applicationCoroutineScope,
            context = applicationContext,
            mediaProjectionChipInteractor = mediaProjectionChipInteractor,
            mediaRouterChipInteractor = mediaRouterChipInteractor,
            systemClock = fakeSystemClock,
            endMediaProjectionDialogHelper = endMediaProjectionDialogHelper,
            dialogTransitionAnimator = mockDialogTransitionAnimator,
            logger = statusBarChipsLogger,
        )
    }
