/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.dreams.homecontrols.service

import com.android.systemui.dreams.homecontrols.dagger.HomeControlsRemoteServiceComponent
import com.android.systemui.dump.dumpManager
import com.android.systemui.kosmos.Kosmos
import com.android.systemui.kosmos.applicationCoroutineScope
import com.android.systemui.log.logcatLogBuffer
import org.mockito.kotlin.mock

val Kosmos.remoteHomeControlsDataSourceDelegator by
    Kosmos.Fixture {
        RemoteHomeControlsDataSourceDelegator(
            bgScope = applicationCoroutineScope,
            serviceFactory = homeControlsRemoteServiceFactory,
            logBuffer = logcatLogBuffer("HomeControlsDreamInteractor"),
            dumpManager = dumpManager,
        )
    }

var Kosmos.homeControlsRemoteServiceFactory by
    Kosmos.Fixture<HomeControlsRemoteServiceComponent.Factory> { mock() }
