/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.statusbar.notification.row;

import com.android.systemui.dagger.SysUISingleton;
import com.android.systemui.statusbar.notification.row.icon.AppIconProviderModule;
import com.android.systemui.statusbar.notification.row.icon.NotificationIconStyleProviderModule;
import com.android.systemui.statusbar.notification.row.shared.NotificationRowContentBinderRefactor;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

import javax.inject.Provider;

/**
 * Dagger Module containing notification row and view inflation implementations.
 */
@Module(includes = {AppIconProviderModule.class, NotificationIconStyleProviderModule.class})
public abstract class NotificationRowModule {

    /**
     * Provides notification row content binder instance.
     */
    @Provides
    @SysUISingleton
    public static NotificationRowContentBinder provideNotificationRowContentBinder(
            Provider<NotificationContentInflater> legacyImpl,
            Provider<NotificationRowContentBinderImpl> refactoredImpl
    ) {
        if (NotificationRowContentBinderRefactor.isEnabled()) {
            return refactoredImpl.get();
        } else {
            return legacyImpl.get();
        }
    }

    /**
     * Provides notification remote view cache instance.
     */
    @Binds
    @SysUISingleton
    public abstract NotifRemoteViewCache provideNotifRemoteViewCache(
            NotifRemoteViewCacheImpl cacheImpl);

    /**
     * Provides notification remote view factory container
     */
    @Binds
    @SysUISingleton
    public abstract NotifRemoteViewsFactoryContainer provideNotifRemoteViewsFactoryContainer(
            NotifRemoteViewsFactoryContainerImpl containerImpl);

    /**
     * Provides heads up style manager
     */
    @Binds
    @SysUISingleton
    public abstract HeadsUpStyleProvider provideHeadsUpStyleManager(
            HeadsUpStyleProviderImpl headsUpStyleManagerImpl);
}
