/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.android.systemui.plugins

/** Listener for events from proxy types generated by [ProtectedPluginProcessor]. */
interface ProtectedPluginListener {
    /**
     * Called when a method call produces a [LinkageError] before returning. This callback is
     * provided so that the host application can terminate the plugin or log the error as
     * appropriate.
     *
     * @return true to terminate all methods within this object; false if the error is recoverable
     *   and the proxied plugin should continue to operate as normal.
     */
    fun onFail(className: String, methodName: String, failure: LinkageError): Boolean
}
