/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.android.systemui.plugins

/**
 * Stub version of PluginProtector that is normally generated by [ProtectedPluginProcessor].
 * Intended for use in applications where kapt cannot be used, but disables the protection feature.
 */
class PluginProtector {
    companion object {
        @JvmStatic
        fun <T> tryProtect(target: T, listener: ProtectedPluginListener): T? {
            return null
        }

        @JvmStatic
        fun <T> protectIfAble(target: T, listener: ProtectedPluginListener): T {
            return target
        }
    }
}
