/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.wallpapers.data.repository

import android.app.WallpaperInfo
import android.view.View
import kotlinx.coroutines.flow.MutableStateFlow

/** Fake implementation of the wallpaper repository. */
class FakeWallpaperRepository : WallpaperRepository {
    override val wallpaperInfo = MutableStateFlow<WallpaperInfo?>(null)
    override val wallpaperSupportsAmbientMode = MutableStateFlow(false)
    override var rootView: View? = null
}
