/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.android.systemui.shared.quickaffordance.shared.model

object KeyguardPreviewConstants {
    const val MESSAGE_ID_DEFAULT_PREVIEW = 707
    const val MESSAGE_ID_HIDE_SMART_SPACE = 1111
    const val MESSAGE_ID_PREVIEW_QUICK_AFFORDANCE_SELECTED = 1988
    const val MESSAGE_ID_SLOT_SELECTED = 1337
    const val MESSAGE_ID_START_CUSTOMIZING_QUICK_AFFORDANCES = 214

    const val KEY_HIDE_SMART_SPACE = "hide_smart_space"
    const val KEY_HIGHLIGHT_QUICK_AFFORDANCES = "highlight_quick_affordances"
    const val KEY_INITIALLY_SELECTED_SLOT_ID = "initially_selected_slot_id"
    const val KEY_QUICK_AFFORDANCE_ID = "quick_affordance_id"
    const val KEY_SLOT_ID = "slot_id"

    const val KEYGUARD_QUICK_AFFORDANCE_ID_NONE = "none"
}
