/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.test.hwui

import android.app.Activity
import android.graphics.Color
import android.graphics.Paint
import android.os.Bundle
import android.view.SurfaceHolder
import android.view.SurfaceView

class ScrollingZAboveSurfaceView : Activity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.scrolling_zabove_surfaceview)

        findViewById<SurfaceView>(R.id.surfaceview).apply {
            setZOrderOnTop(true)
            holder.addCallback(object : SurfaceHolder.Callback {
                override fun surfaceCreated(p0: SurfaceHolder) {

                }

                override fun surfaceChanged(holder: SurfaceHolder, format: Int, width: Int, height: Int) {
                    holder.unlockCanvasAndPost(holder.lockCanvas().apply {
                        drawColor(Color.BLUE)
                        val paint = Paint()
                        paint.textSize = 16 * resources.displayMetrics.density
                        paint.textAlign = Paint.Align.CENTER
                        paint.color = Color.WHITE
                        drawText("I'm a setZOrderOnTop(true) SurfaceView!",
                            (width / 2).toFloat(), (height / 2).toFloat(), paint)
                    })
                }

                override fun surfaceDestroyed(p0: SurfaceHolder) {

                }

            })
        }
    }
}