/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.assist.classification;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;

import com.android.internal.util.DataClass;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;


/**
 * Represents a response from detection service.
 * @hide
 */
@SystemApi
@DataClass(
        genToString = true
)
public final class FieldClassificationResponse implements Parcelable {

    /**
     * List of classified fields
     */
    private final @NonNull Set<FieldClassification> mClassifications;

    static Set<FieldClassification> unparcelClassifications(Parcel in) {
        List<FieldClassification> detections = new java.util.ArrayList<>();
        in.readParcelableList(
                detections, FieldClassification.class.getClassLoader(), FieldClassification.class);
        return new ArraySet<>(detections);
    }

    void parcelClassifications(Parcel dest, int flags) {
        dest.writeParcelableList(new ArrayList<>(mClassifications), flags);
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/assist/classification/FieldClassificationResponse.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new FieldClassificationResponse.
     *
     * @param classifications
     *   List of classified fields
     */
    @DataClass.Generated.Member
    public FieldClassificationResponse(
            @NonNull Set<FieldClassification> classifications) {
        this.mClassifications = classifications;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mClassifications);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * List of classified fields
     */
    @DataClass.Generated.Member
    public @NonNull Set<FieldClassification> getClassifications() {
        return mClassifications;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "FieldClassificationResponse { " +
                "classifications = " + mClassifications +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        parcelClassifications(dest, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ FieldClassificationResponse(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        Set<FieldClassification> classifications = unparcelClassifications(in);

        this.mClassifications = classifications;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mClassifications);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<FieldClassificationResponse> CREATOR
            = new Parcelable.Creator<FieldClassificationResponse>() {
        @Override
        public FieldClassificationResponse[] newArray(int size) {
            return new FieldClassificationResponse[size];
        }

        @Override
        public FieldClassificationResponse createFromParcel(@NonNull Parcel in) {
            return new FieldClassificationResponse(in);
        }
    };

    @DataClass.Generated(
            time = 1675320458276L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/service/assist/classification/FieldClassificationResponse.java",
            inputSignatures = "private final @android.annotation.NonNull java.util.Set<android.service.assist.classification.FieldClassification> mClassifications\nstatic  java.util.Set<android.service.assist.classification.FieldClassification> unparcelClassifications(android.os.Parcel)\n  void parcelClassifications(android.os.Parcel,int)\nclass FieldClassificationResponse extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
