/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.input;

import android.annotation.IntDef;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcelable;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;

import com.android.internal.util.DataClass;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Provides information about the selected layout and the selection criteria when the caller calls
 * {@link InputManager#getKeyboardLayoutForInputDevice(InputDeviceIdentifier, int, InputMethodInfo,
 * InputMethodSubtype)}
 *
 * @hide
 */

@DataClass(genParcelable = true, genToString = true, genEqualsHashCode = true)
public final class KeyboardLayoutSelectionResult implements Parcelable {
    @Nullable
    private final String mLayoutDescriptor;

    /** Unspecified layout selection criteria */
    public static final int LAYOUT_SELECTION_CRITERIA_UNSPECIFIED = 0;

    /** Manual selection by user */
    public static final int LAYOUT_SELECTION_CRITERIA_USER = 1;

    /** Auto-detection based on device provided language tag and layout type */
    public static final int LAYOUT_SELECTION_CRITERIA_DEVICE = 2;

    /** Auto-detection based on IME provided language tag and layout type */
    public static final int LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD = 3;

    /** Default selection */
    public static final int LAYOUT_SELECTION_CRITERIA_DEFAULT = 4;

    /** Failed layout selection */
    public static final KeyboardLayoutSelectionResult FAILED = new KeyboardLayoutSelectionResult(
            null, LAYOUT_SELECTION_CRITERIA_UNSPECIFIED);

    @LayoutSelectionCriteria
    private final int mSelectionCriteria;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/hardware/input/KeyboardLayoutSelectionResult.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @IntDef(prefix = "LAYOUT_SELECTION_CRITERIA_", value = {
        LAYOUT_SELECTION_CRITERIA_UNSPECIFIED,
        LAYOUT_SELECTION_CRITERIA_USER,
        LAYOUT_SELECTION_CRITERIA_DEVICE,
        LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD,
        LAYOUT_SELECTION_CRITERIA_DEFAULT
    })
    @Retention(RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface LayoutSelectionCriteria {}

    @DataClass.Generated.Member
    public static String layoutSelectionCriteriaToString(@LayoutSelectionCriteria int value) {
        switch (value) {
            case LAYOUT_SELECTION_CRITERIA_UNSPECIFIED:
                    return "LAYOUT_SELECTION_CRITERIA_UNSPECIFIED";
            case LAYOUT_SELECTION_CRITERIA_USER:
                    return "LAYOUT_SELECTION_CRITERIA_USER";
            case LAYOUT_SELECTION_CRITERIA_DEVICE:
                    return "LAYOUT_SELECTION_CRITERIA_DEVICE";
            case LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD:
                    return "LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD";
            case LAYOUT_SELECTION_CRITERIA_DEFAULT:
                    return "LAYOUT_SELECTION_CRITERIA_DEFAULT";
            default: return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    public KeyboardLayoutSelectionResult(
            @Nullable String layoutDescriptor,
            @LayoutSelectionCriteria int selectionCriteria) {
        this.mLayoutDescriptor = layoutDescriptor;
        this.mSelectionCriteria = selectionCriteria;

        if (!(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_UNSPECIFIED)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_USER)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_DEVICE)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_DEFAULT)) {
            throw new java.lang.IllegalArgumentException(
                    "selectionCriteria was " + mSelectionCriteria + " but must be one of: "
                            + "LAYOUT_SELECTION_CRITERIA_UNSPECIFIED(" + LAYOUT_SELECTION_CRITERIA_UNSPECIFIED + "), "
                            + "LAYOUT_SELECTION_CRITERIA_USER(" + LAYOUT_SELECTION_CRITERIA_USER + "), "
                            + "LAYOUT_SELECTION_CRITERIA_DEVICE(" + LAYOUT_SELECTION_CRITERIA_DEVICE + "), "
                            + "LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD(" + LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD + "), "
                            + "LAYOUT_SELECTION_CRITERIA_DEFAULT(" + LAYOUT_SELECTION_CRITERIA_DEFAULT + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @Nullable String getLayoutDescriptor() {
        return mLayoutDescriptor;
    }

    @DataClass.Generated.Member
    public @LayoutSelectionCriteria int getSelectionCriteria() {
        return mSelectionCriteria;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "KeyboardLayoutSelectionResult { " +
                "layoutDescriptor = " + mLayoutDescriptor + ", " +
                "selectionCriteria = " + layoutSelectionCriteriaToString(mSelectionCriteria) +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(KeyboardLayoutSelectionResult other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        KeyboardLayoutSelectionResult that = (KeyboardLayoutSelectionResult) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mLayoutDescriptor, that.mLayoutDescriptor)
                && mSelectionCriteria == that.mSelectionCriteria;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mLayoutDescriptor);
        _hash = 31 * _hash + mSelectionCriteria;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mLayoutDescriptor != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mLayoutDescriptor != null) dest.writeString(mLayoutDescriptor);
        dest.writeInt(mSelectionCriteria);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ KeyboardLayoutSelectionResult(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        String layoutDescriptor = (flg & 0x1) == 0 ? null : in.readString();
        int selectionCriteria = in.readInt();

        this.mLayoutDescriptor = layoutDescriptor;
        this.mSelectionCriteria = selectionCriteria;

        if (!(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_UNSPECIFIED)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_USER)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_DEVICE)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD)
                && !(mSelectionCriteria == LAYOUT_SELECTION_CRITERIA_DEFAULT)) {
            throw new java.lang.IllegalArgumentException(
                    "selectionCriteria was " + mSelectionCriteria + " but must be one of: "
                            + "LAYOUT_SELECTION_CRITERIA_UNSPECIFIED(" + LAYOUT_SELECTION_CRITERIA_UNSPECIFIED + "), "
                            + "LAYOUT_SELECTION_CRITERIA_USER(" + LAYOUT_SELECTION_CRITERIA_USER + "), "
                            + "LAYOUT_SELECTION_CRITERIA_DEVICE(" + LAYOUT_SELECTION_CRITERIA_DEVICE + "), "
                            + "LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD(" + LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD + "), "
                            + "LAYOUT_SELECTION_CRITERIA_DEFAULT(" + LAYOUT_SELECTION_CRITERIA_DEFAULT + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<KeyboardLayoutSelectionResult> CREATOR
            = new Parcelable.Creator<KeyboardLayoutSelectionResult>() {
        @Override
        public KeyboardLayoutSelectionResult[] newArray(int size) {
            return new KeyboardLayoutSelectionResult[size];
        }

        @Override
        public KeyboardLayoutSelectionResult createFromParcel(@NonNull android.os.Parcel in) {
            return new KeyboardLayoutSelectionResult(in);
        }
    };

    @DataClass.Generated(
            time = 1709568115865L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/hardware/input/KeyboardLayoutSelectionResult.java",
            inputSignatures = "private final @android.annotation.Nullable java.lang.String mLayoutDescriptor\npublic static final  int LAYOUT_SELECTION_CRITERIA_UNSPECIFIED\npublic static final  int LAYOUT_SELECTION_CRITERIA_USER\npublic static final  int LAYOUT_SELECTION_CRITERIA_DEVICE\npublic static final  int LAYOUT_SELECTION_CRITERIA_VIRTUAL_KEYBOARD\npublic static final  int LAYOUT_SELECTION_CRITERIA_DEFAULT\npublic static final  android.hardware.input.KeyboardLayoutSelectionResult FAILED\nprivate final @android.hardware.input.KeyboardLayoutSelectionResult.LayoutSelectionCriteria int mSelectionCriteria\nclass KeyboardLayoutSelectionResult extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genToString=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
