/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.view.autofill;


import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.view.View;

import com.android.internal.util.DataClass;


/**
 * Information for the virtual view to the autofill framework.
 */
@DataClass(genBuilder = true)
public final class VirtualViewFillInfo {

    /**
     * Autofill hints of the virtual view.
     *
     * @see View#setAutofillHints(String...)
     */
    @Nullable
    @SuppressLint("NullableCollection")
    private String[] mAutofillHints;

    private static String[] defaultAutofillHints() {
        return null;
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/view/autofill/VirtualViewFillInfo.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ VirtualViewFillInfo(
            @Nullable @SuppressLint("NullableCollection") String[] autofillHints) {
        this.mAutofillHints = autofillHints;
        com.android.internal.util.AnnotationValidations.validate(
                SuppressLint.class, null, mAutofillHints,
                "value", "NullableCollection");

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Autofill hints of the virtual view.
     *
     * @see View#setAutofillHints(String...)
     */
    @DataClass.Generated.Member
    public @Nullable @SuppressLint("NullableCollection") String[] getAutofillHints() {
        return mAutofillHints;
    }

    /**
     * A builder for {@link VirtualViewFillInfo}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @Nullable @SuppressLint("NullableCollection") String[] mAutofillHints;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * Autofill hints of the virtual view.
         *
         * @see View#setAutofillHints(String...)
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setAutofillHints(@SuppressLint("NullableCollection") @android.annotation.NonNull String... value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mAutofillHints = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull VirtualViewFillInfo build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mAutofillHints = defaultAutofillHints();
            }
            VirtualViewFillInfo o = new VirtualViewFillInfo(
                    mAutofillHints);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1674023010954L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/view/autofill/VirtualViewFillInfo.java",
            inputSignatures = "private @android.annotation.Nullable @android.annotation.SuppressLint java.lang.String[] mAutofillHints\nprivate static  java.lang.String[] defaultAutofillHints()\nclass VirtualViewFillInfo extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genBuilder=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
