/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.robotests;

import androidx.test.filters.SmallTest;
import androidx.test.runner.AndroidJUnit4;
import static com.google.common.truth.Truth.assertThat;
import org.junit.Test;
import org.junit.runner.RunWith;

@SmallTest
@RunWith(AndroidJUnit4.class)
public class SysuiResourceLoadingTest extends SysuiRoboBase {
    @Test
    public void testResources() {
        assertThat(getContext().getString(com.android.systemui.R.string.app_label))
                .isEqualTo("System UI");
        assertThat(getContext().getString(com.android.systemui.tests.R.string.test_content))
                .isNotEmpty();
    }
}
