/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.internal.pm.permission;

import android.Manifest;
import android.annotation.NonNull;

import com.android.internal.util.DataClass;

/**
 * Implements compatibility support for permissions, and old applications
 * will be automatically granted it.
 *
 * Compatibility permissions are permissions that are automatically granted to
 * packages that target an SDK prior to when the permission was introduced.
 * Sometimes the platform makes breaking behaviour changes and hides the legacy
 * behaviour behind a permission. In these instances, we ensure applications
 * targeting older platform versions are implicitly granted the correct set of
 * permissions.
 *
 * @hide
 */
@DataClass(genGetters = true, genBuilder = false)
public class CompatibilityPermissionInfo {

    @NonNull
    private final String mName;
    private final int mSdkVersion;

    /**
     * List of new permissions that have been added since 1.0.
     *
     * NOTE: These must be declared in SDK version order, with permissions
     * added to newer SDKs appearing before those added to older SDKs.
     *
     * @hide
     */
    public static final CompatibilityPermissionInfo[] COMPAT_PERMS =
            new CompatibilityPermissionInfo[]{
                    new CompatibilityPermissionInfo(Manifest.permission.POST_NOTIFICATIONS,
                            android.os.Build.VERSION_CODES.TIRAMISU),
                    new CompatibilityPermissionInfo(Manifest.permission.WRITE_EXTERNAL_STORAGE,
                            android.os.Build.VERSION_CODES.DONUT),
                    new CompatibilityPermissionInfo(Manifest.permission.READ_PHONE_STATE,
                            android.os.Build.VERSION_CODES.DONUT)
            };



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/com/android/internal/pm/permission/CompatibilityPermissionInfo.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    public CompatibilityPermissionInfo(
            @NonNull String name,
            int sdkVersion) {
        this.mName = name;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mName);
        this.mSdkVersion = sdkVersion;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @NonNull String getName() {
        return mName;
    }

    @DataClass.Generated.Member
    public int getSdkVersion() {
        return mSdkVersion;
    }

    @DataClass.Generated(
            time = 1701338392152L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/com/android/internal/pm/permission/CompatibilityPermissionInfo.java",
            inputSignatures = "private final @android.annotation.NonNull java.lang.String mName\nprivate final  int mSdkVersion\npublic static final  com.android.internal.pm.permission.CompatibilityPermissionInfo[] COMPAT_PERMS\nclass CompatibilityPermissionInfo extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genGetters=true, genBuilder=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
