/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.IntentFilter;
import android.os.Parcel;
import android.os.Parcelable;

import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DataClass;

/**
 * @hide
 **/
@DataClass(genGetters = true, genSetters = true, genParcelable = true, genAidl = false,
        genBuilder = false, genConstructor = false)
@DataClass.Suppress({"setIntentFilter"})
@VisibleForTesting(visibility = VisibleForTesting.Visibility.PACKAGE)
public class ParsedIntentInfoImpl implements ParsedIntentInfo, Parcelable {

    private boolean mHasDefault;
    private int mLabelRes;
    @Nullable
    private CharSequence mNonLocalizedLabel;
    private int mIcon;

    @NonNull
    private IntentFilter mIntentFilter = new IntentFilter();

    public ParsedIntentInfoImpl() {}



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/com/android/internal/pm/pkg/component/ParsedIntentInfoImpl.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    public boolean isHasDefault() {
        return mHasDefault;
    }

    @DataClass.Generated.Member
    public int getLabelRes() {
        return mLabelRes;
    }

    @DataClass.Generated.Member
    public @Nullable CharSequence getNonLocalizedLabel() {
        return mNonLocalizedLabel;
    }

    @DataClass.Generated.Member
    public int getIcon() {
        return mIcon;
    }

    @DataClass.Generated.Member
    public @NonNull IntentFilter getIntentFilter() {
        return mIntentFilter;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedIntentInfoImpl setHasDefault( boolean value) {
        mHasDefault = value;
        return this;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedIntentInfoImpl setLabelRes( int value) {
        mLabelRes = value;
        return this;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedIntentInfoImpl setNonLocalizedLabel(@NonNull CharSequence value) {
        mNonLocalizedLabel = value;
        return this;
    }

    @DataClass.Generated.Member
    public @NonNull ParsedIntentInfoImpl setIcon( int value) {
        mIcon = value;
        return this;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mHasDefault) flg |= 0x1;
        if (mNonLocalizedLabel != null) flg |= 0x4;
        dest.writeByte(flg);
        dest.writeInt(mLabelRes);
        if (mNonLocalizedLabel != null) dest.writeCharSequence(mNonLocalizedLabel);
        dest.writeInt(mIcon);
        dest.writeTypedObject(mIntentFilter, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected ParsedIntentInfoImpl(@NonNull Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        boolean hasDefault = (flg & 0x1) != 0;
        int labelRes = in.readInt();
        CharSequence nonLocalizedLabel = (flg & 0x4) == 0 ? null : (CharSequence) in.readCharSequence();
        int icon = in.readInt();
        IntentFilter intentFilter = (IntentFilter) in.readTypedObject(IntentFilter.CREATOR);

        this.mHasDefault = hasDefault;
        this.mLabelRes = labelRes;
        this.mNonLocalizedLabel = nonLocalizedLabel;
        this.mIcon = icon;
        this.mIntentFilter = intentFilter;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mIntentFilter);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ParsedIntentInfoImpl> CREATOR
            = new Parcelable.Creator<ParsedIntentInfoImpl>() {
        @Override
        public ParsedIntentInfoImpl[] newArray(int size) {
            return new ParsedIntentInfoImpl[size];
        }

        @Override
        public ParsedIntentInfoImpl createFromParcel(@NonNull Parcel in) {
            return new ParsedIntentInfoImpl(in);
        }
    };

    @DataClass.Generated(
            time = 1701445800363L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/com/android/internal/pm/pkg/component/ParsedIntentInfoImpl.java",
            inputSignatures = "private  boolean mHasDefault\nprivate  int mLabelRes\nprivate @android.annotation.Nullable java.lang.CharSequence mNonLocalizedLabel\nprivate  int mIcon\nprivate @android.annotation.NonNull android.content.IntentFilter mIntentFilter\nclass ParsedIntentInfoImpl extends java.lang.Object implements [com.android.internal.pm.pkg.component.ParsedIntentInfo, android.os.Parcelable]\n@com.android.internal.util.DataClass(genGetters=true, genSetters=true, genParcelable=true, genAidl=false, genBuilder=false, genConstructor=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
