/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <android-base/logging.h>
#include <binder/IPCThreadState.h>
#include <binder/IServiceManager.h>
#include <utils/Log.h>

#include "TunerService.h"
#include "hidl/TunerHidlService.h"

using ::aidl::android::media::tv::tuner::TunerHidlService;
using ::aidl::android::media::tv::tuner::TunerService;

using namespace android;

int main() {
    ALOGD("Tuner service starting");

    sp<ProcessState> proc(ProcessState::self());
    sp<IServiceManager> sm = defaultServiceManager();

    // Check legacy HIDL HAL first. If it's not existed, use AIDL HAL.
    binder_status_t status = TunerHidlService::instantiate();
    if (status != STATUS_OK) {
        status = TunerService::instantiate();
        CHECK(status == STATUS_OK);
    }

    ProcessState::self()->startThreadPool();
    IPCThreadState::self()->joinThreadPool();
    return EXIT_FAILURE;  // should not reached
}
