// Copyright 2018 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.7
// source: metrics.proto

package metrics_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricsBase_BuildVariant int32

const (
	MetricsBase_USER      MetricsBase_BuildVariant = 0
	MetricsBase_USERDEBUG MetricsBase_BuildVariant = 1
	MetricsBase_ENG       MetricsBase_BuildVariant = 2
)

// Enum value maps for MetricsBase_BuildVariant.
var (
	MetricsBase_BuildVariant_name = map[int32]string{
		0: "USER",
		1: "USERDEBUG",
		2: "ENG",
	}
	MetricsBase_BuildVariant_value = map[string]int32{
		"USER":      0,
		"USERDEBUG": 1,
		"ENG":       2,
	}
)

func (x MetricsBase_BuildVariant) Enum() *MetricsBase_BuildVariant {
	p := new(MetricsBase_BuildVariant)
	*p = x
	return p
}

func (x MetricsBase_BuildVariant) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricsBase_BuildVariant) Descriptor() protoreflect.EnumDescriptor {
	return file_metrics_proto_enumTypes[0].Descriptor()
}

func (MetricsBase_BuildVariant) Type() protoreflect.EnumType {
	return &file_metrics_proto_enumTypes[0]
}

func (x MetricsBase_BuildVariant) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *MetricsBase_BuildVariant) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = MetricsBase_BuildVariant(num)
	return nil
}

// Deprecated: Use MetricsBase_BuildVariant.Descriptor instead.
func (MetricsBase_BuildVariant) EnumDescriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{0, 0}
}

type MetricsBase_Arch int32

const (
	MetricsBase_UNKNOWN MetricsBase_Arch = 0
	MetricsBase_ARM     MetricsBase_Arch = 1
	MetricsBase_ARM64   MetricsBase_Arch = 2
	MetricsBase_X86     MetricsBase_Arch = 3
	MetricsBase_X86_64  MetricsBase_Arch = 4
)

// Enum value maps for MetricsBase_Arch.
var (
	MetricsBase_Arch_name = map[int32]string{
		0: "UNKNOWN",
		1: "ARM",
		2: "ARM64",
		3: "X86",
		4: "X86_64",
	}
	MetricsBase_Arch_value = map[string]int32{
		"UNKNOWN": 0,
		"ARM":     1,
		"ARM64":   2,
		"X86":     3,
		"X86_64":  4,
	}
)

func (x MetricsBase_Arch) Enum() *MetricsBase_Arch {
	p := new(MetricsBase_Arch)
	*p = x
	return p
}

func (x MetricsBase_Arch) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricsBase_Arch) Descriptor() protoreflect.EnumDescriptor {
	return file_metrics_proto_enumTypes[1].Descriptor()
}

func (MetricsBase_Arch) Type() protoreflect.EnumType {
	return &file_metrics_proto_enumTypes[1]
}

func (x MetricsBase_Arch) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *MetricsBase_Arch) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = MetricsBase_Arch(num)
	return nil
}

// Deprecated: Use MetricsBase_Arch.Descriptor instead.
func (MetricsBase_Arch) EnumDescriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{0, 1}
}

type ModuleTypeInfo_BuildSystem int32

const (
	ModuleTypeInfo_UNKNOWN ModuleTypeInfo_BuildSystem = 0
	ModuleTypeInfo_SOONG   ModuleTypeInfo_BuildSystem = 1
	ModuleTypeInfo_MAKE    ModuleTypeInfo_BuildSystem = 2
)

// Enum value maps for ModuleTypeInfo_BuildSystem.
var (
	ModuleTypeInfo_BuildSystem_name = map[int32]string{
		0: "UNKNOWN",
		1: "SOONG",
		2: "MAKE",
	}
	ModuleTypeInfo_BuildSystem_value = map[string]int32{
		"UNKNOWN": 0,
		"SOONG":   1,
		"MAKE":    2,
	}
)

func (x ModuleTypeInfo_BuildSystem) Enum() *ModuleTypeInfo_BuildSystem {
	p := new(ModuleTypeInfo_BuildSystem)
	*p = x
	return p
}

func (x ModuleTypeInfo_BuildSystem) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ModuleTypeInfo_BuildSystem) Descriptor() protoreflect.EnumDescriptor {
	return file_metrics_proto_enumTypes[2].Descriptor()
}

func (ModuleTypeInfo_BuildSystem) Type() protoreflect.EnumType {
	return &file_metrics_proto_enumTypes[2]
}

func (x ModuleTypeInfo_BuildSystem) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ModuleTypeInfo_BuildSystem) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ModuleTypeInfo_BuildSystem(num)
	return nil
}

// Deprecated: Use ModuleTypeInfo_BuildSystem.Descriptor instead.
func (ModuleTypeInfo_BuildSystem) EnumDescriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{5, 0}
}

type ExpConfigFetcher_ConfigStatus int32

const (
	ExpConfigFetcher_NO_CONFIG     ExpConfigFetcher_ConfigStatus = 0
	ExpConfigFetcher_CONFIG        ExpConfigFetcher_ConfigStatus = 1
	ExpConfigFetcher_ERROR         ExpConfigFetcher_ConfigStatus = 2
	ExpConfigFetcher_MISSING_GCERT ExpConfigFetcher_ConfigStatus = 3
)

// Enum value maps for ExpConfigFetcher_ConfigStatus.
var (
	ExpConfigFetcher_ConfigStatus_name = map[int32]string{
		0: "NO_CONFIG",
		1: "CONFIG",
		2: "ERROR",
		3: "MISSING_GCERT",
	}
	ExpConfigFetcher_ConfigStatus_value = map[string]int32{
		"NO_CONFIG":     0,
		"CONFIG":        1,
		"ERROR":         2,
		"MISSING_GCERT": 3,
	}
)

func (x ExpConfigFetcher_ConfigStatus) Enum() *ExpConfigFetcher_ConfigStatus {
	p := new(ExpConfigFetcher_ConfigStatus)
	*p = x
	return p
}

func (x ExpConfigFetcher_ConfigStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExpConfigFetcher_ConfigStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_metrics_proto_enumTypes[3].Descriptor()
}

func (ExpConfigFetcher_ConfigStatus) Type() protoreflect.EnumType {
	return &file_metrics_proto_enumTypes[3]
}

func (x ExpConfigFetcher_ConfigStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ExpConfigFetcher_ConfigStatus) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ExpConfigFetcher_ConfigStatus(num)
	return nil
}

// Deprecated: Use ExpConfigFetcher_ConfigStatus.Descriptor instead.
func (ExpConfigFetcher_ConfigStatus) EnumDescriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{9, 0}
}

type MetricsBase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp generated when the build starts.
	BuildDateTimestamp *int64 `protobuf:"varint,1,opt,name=build_date_timestamp,json=buildDateTimestamp" json:"build_date_timestamp,omitempty"`
	// It is usually used to specify the branch name [and release candidate].
	BuildId *string `protobuf:"bytes,2,opt,name=build_id,json=buildId" json:"build_id,omitempty"`
	// The platform version codename, eg. P, Q, REL.
	PlatformVersionCodename *string `protobuf:"bytes,3,opt,name=platform_version_codename,json=platformVersionCodename" json:"platform_version_codename,omitempty"`
	// The target product information, eg. aosp_arm.
	TargetProduct *string `protobuf:"bytes,4,opt,name=target_product,json=targetProduct" json:"target_product,omitempty"`
	// The target build variant information, eg. eng.
	TargetBuildVariant *MetricsBase_BuildVariant `protobuf:"varint,5,opt,name=target_build_variant,json=targetBuildVariant,enum=soong_build_metrics.MetricsBase_BuildVariant,def=2" json:"target_build_variant,omitempty"`
	// The target arch information, eg. arm.
	TargetArch *MetricsBase_Arch `protobuf:"varint,6,opt,name=target_arch,json=targetArch,enum=soong_build_metrics.MetricsBase_Arch,def=0" json:"target_arch,omitempty"`
	// The target arch variant information, eg. armv7-a-neon.
	TargetArchVariant *string `protobuf:"bytes,7,opt,name=target_arch_variant,json=targetArchVariant" json:"target_arch_variant,omitempty"`
	// The target cpu variant information, eg. generic.
	TargetCpuVariant *string `protobuf:"bytes,8,opt,name=target_cpu_variant,json=targetCpuVariant" json:"target_cpu_variant,omitempty"`
	// The host arch information, eg. x86_64.
	HostArch *MetricsBase_Arch `protobuf:"varint,9,opt,name=host_arch,json=hostArch,enum=soong_build_metrics.MetricsBase_Arch,def=0" json:"host_arch,omitempty"`
	// The host 2nd arch information, eg. x86.
	Host_2NdArch *MetricsBase_Arch `protobuf:"varint,10,opt,name=host_2nd_arch,json=host2ndArch,enum=soong_build_metrics.MetricsBase_Arch,def=0" json:"host_2nd_arch,omitempty"`
	// The host os information, eg. linux.
	HostOs *string `protobuf:"bytes,11,opt,name=host_os,json=hostOs" json:"host_os,omitempty"`
	// The host os extra information, eg. Linux-4.17.0-3rodete2-amd64-x86_64-Debian-GNU.
	HostOsExtra *string `protobuf:"bytes,12,opt,name=host_os_extra,json=hostOsExtra" json:"host_os_extra,omitempty"`
	// The host cross os information, eg. windows.
	HostCrossOs *string `protobuf:"bytes,13,opt,name=host_cross_os,json=hostCrossOs" json:"host_cross_os,omitempty"`
	// The host cross arch information, eg. x86.
	HostCrossArch *string `protobuf:"bytes,14,opt,name=host_cross_arch,json=hostCrossArch" json:"host_cross_arch,omitempty"`
	// The host cross 2nd arch information, eg. x86_64.
	HostCross_2NdArch *string `protobuf:"bytes,15,opt,name=host_cross_2nd_arch,json=hostCross2ndArch" json:"host_cross_2nd_arch,omitempty"`
	// The directory for generated built artifacts installation, eg. out.
	OutDir *string `protobuf:"bytes,16,opt,name=out_dir,json=outDir" json:"out_dir,omitempty"`
	// The metrics for calling various tools (microfactory) before Soong_UI starts.
	SetupTools []*PerfInfo `protobuf:"bytes,17,rep,name=setup_tools,json=setupTools" json:"setup_tools,omitempty"`
	// The metrics for calling Kati by multiple times.
	KatiRuns []*PerfInfo `protobuf:"bytes,18,rep,name=kati_runs,json=katiRuns" json:"kati_runs,omitempty"`
	// The metrics for calling Soong.
	SoongRuns []*PerfInfo `protobuf:"bytes,19,rep,name=soong_runs,json=soongRuns" json:"soong_runs,omitempty"`
	// The metrics for calling Ninja.
	NinjaRuns []*PerfInfo `protobuf:"bytes,20,rep,name=ninja_runs,json=ninjaRuns" json:"ninja_runs,omitempty"`
	// The metrics for the whole build
	Total *PerfInfo `protobuf:"bytes,21,opt,name=total" json:"total,omitempty"`
	// Deprecated because instead of embedding in a MetricsBase, we keep
	// SoongBuildMetrics in its own file
	//
	// Deprecated: Do not use.
	SoongBuildMetrics *SoongBuildMetrics `protobuf:"bytes,22,opt,name=soong_build_metrics,json=soongBuildMetrics" json:"soong_build_metrics,omitempty"`
	BuildConfig       *BuildConfig       `protobuf:"bytes,23,opt,name=build_config,json=buildConfig" json:"build_config,omitempty"`
	// The hostname of the machine.
	Hostname *string `protobuf:"bytes,24,opt,name=hostname" json:"hostname,omitempty"`
	// The system resource information such as total physical memory.
	SystemResourceInfo *SystemResourceInfo `protobuf:"bytes,25,opt,name=system_resource_info,json=systemResourceInfo" json:"system_resource_info,omitempty"`
	// The build command that the user entered to the build system.
	BuildCommand *string `protobuf:"bytes,26,opt,name=build_command,json=buildCommand" json:"build_command,omitempty"`
	// The metrics for calling Bazel.
	BazelRuns []*PerfInfo `protobuf:"bytes,27,rep,name=bazel_runs,json=bazelRuns" json:"bazel_runs,omitempty"`
	// The metrics of the experiment config fetcher
	ExpConfigFetcher *ExpConfigFetcher `protobuf:"bytes,28,opt,name=exp_config_fetcher,json=expConfigFetcher" json:"exp_config_fetcher,omitempty"`
	// Whether the build exited with a panic or non-zero exit code, includes both
	// non-zero exits of recorded phases and non-recorded phases of the build.
	NonZeroExit *bool `protobuf:"varint,29,opt,name=non_zero_exit,json=nonZeroExit" json:"non_zero_exit,omitempty"`
	// The error message due to a non-zero exit _only_ if it did not occur in a
	// recorded phase of the build.
	ErrorMessage *string `protobuf:"bytes,30,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	// The Git Manifest for the user's branch.
	ManifestUrl *string `protobuf:"bytes,31,opt,name=manifest_url,json=manifestUrl" json:"manifest_url,omitempty"`
	// The branch on which the build occurred.
	// Example: refs/heads/master
	Branch *string `protobuf:"bytes,32,opt,name=branch" json:"branch,omitempty"`
}

// Default values for MetricsBase fields.
const (
	Default_MetricsBase_TargetBuildVariant = MetricsBase_ENG
	Default_MetricsBase_TargetArch         = MetricsBase_UNKNOWN
	Default_MetricsBase_HostArch           = MetricsBase_UNKNOWN
	Default_MetricsBase_Host_2NdArch       = MetricsBase_UNKNOWN
)

func (x *MetricsBase) Reset() {
	*x = MetricsBase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricsBase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricsBase) ProtoMessage() {}

func (x *MetricsBase) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricsBase.ProtoReflect.Descriptor instead.
func (*MetricsBase) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *MetricsBase) GetBuildDateTimestamp() int64 {
	if x != nil && x.BuildDateTimestamp != nil {
		return *x.BuildDateTimestamp
	}
	return 0
}

func (x *MetricsBase) GetBuildId() string {
	if x != nil && x.BuildId != nil {
		return *x.BuildId
	}
	return ""
}

func (x *MetricsBase) GetPlatformVersionCodename() string {
	if x != nil && x.PlatformVersionCodename != nil {
		return *x.PlatformVersionCodename
	}
	return ""
}

func (x *MetricsBase) GetTargetProduct() string {
	if x != nil && x.TargetProduct != nil {
		return *x.TargetProduct
	}
	return ""
}

func (x *MetricsBase) GetTargetBuildVariant() MetricsBase_BuildVariant {
	if x != nil && x.TargetBuildVariant != nil {
		return *x.TargetBuildVariant
	}
	return Default_MetricsBase_TargetBuildVariant
}

func (x *MetricsBase) GetTargetArch() MetricsBase_Arch {
	if x != nil && x.TargetArch != nil {
		return *x.TargetArch
	}
	return Default_MetricsBase_TargetArch
}

func (x *MetricsBase) GetTargetArchVariant() string {
	if x != nil && x.TargetArchVariant != nil {
		return *x.TargetArchVariant
	}
	return ""
}

func (x *MetricsBase) GetTargetCpuVariant() string {
	if x != nil && x.TargetCpuVariant != nil {
		return *x.TargetCpuVariant
	}
	return ""
}

func (x *MetricsBase) GetHostArch() MetricsBase_Arch {
	if x != nil && x.HostArch != nil {
		return *x.HostArch
	}
	return Default_MetricsBase_HostArch
}

func (x *MetricsBase) GetHost_2NdArch() MetricsBase_Arch {
	if x != nil && x.Host_2NdArch != nil {
		return *x.Host_2NdArch
	}
	return Default_MetricsBase_Host_2NdArch
}

func (x *MetricsBase) GetHostOs() string {
	if x != nil && x.HostOs != nil {
		return *x.HostOs
	}
	return ""
}

func (x *MetricsBase) GetHostOsExtra() string {
	if x != nil && x.HostOsExtra != nil {
		return *x.HostOsExtra
	}
	return ""
}

func (x *MetricsBase) GetHostCrossOs() string {
	if x != nil && x.HostCrossOs != nil {
		return *x.HostCrossOs
	}
	return ""
}

func (x *MetricsBase) GetHostCrossArch() string {
	if x != nil && x.HostCrossArch != nil {
		return *x.HostCrossArch
	}
	return ""
}

func (x *MetricsBase) GetHostCross_2NdArch() string {
	if x != nil && x.HostCross_2NdArch != nil {
		return *x.HostCross_2NdArch
	}
	return ""
}

func (x *MetricsBase) GetOutDir() string {
	if x != nil && x.OutDir != nil {
		return *x.OutDir
	}
	return ""
}

func (x *MetricsBase) GetSetupTools() []*PerfInfo {
	if x != nil {
		return x.SetupTools
	}
	return nil
}

func (x *MetricsBase) GetKatiRuns() []*PerfInfo {
	if x != nil {
		return x.KatiRuns
	}
	return nil
}

func (x *MetricsBase) GetSoongRuns() []*PerfInfo {
	if x != nil {
		return x.SoongRuns
	}
	return nil
}

func (x *MetricsBase) GetNinjaRuns() []*PerfInfo {
	if x != nil {
		return x.NinjaRuns
	}
	return nil
}

func (x *MetricsBase) GetTotal() *PerfInfo {
	if x != nil {
		return x.Total
	}
	return nil
}

// Deprecated: Do not use.
func (x *MetricsBase) GetSoongBuildMetrics() *SoongBuildMetrics {
	if x != nil {
		return x.SoongBuildMetrics
	}
	return nil
}

func (x *MetricsBase) GetBuildConfig() *BuildConfig {
	if x != nil {
		return x.BuildConfig
	}
	return nil
}

func (x *MetricsBase) GetHostname() string {
	if x != nil && x.Hostname != nil {
		return *x.Hostname
	}
	return ""
}

func (x *MetricsBase) GetSystemResourceInfo() *SystemResourceInfo {
	if x != nil {
		return x.SystemResourceInfo
	}
	return nil
}

func (x *MetricsBase) GetBuildCommand() string {
	if x != nil && x.BuildCommand != nil {
		return *x.BuildCommand
	}
	return ""
}

func (x *MetricsBase) GetBazelRuns() []*PerfInfo {
	if x != nil {
		return x.BazelRuns
	}
	return nil
}

func (x *MetricsBase) GetExpConfigFetcher() *ExpConfigFetcher {
	if x != nil {
		return x.ExpConfigFetcher
	}
	return nil
}

func (x *MetricsBase) GetNonZeroExit() bool {
	if x != nil && x.NonZeroExit != nil {
		return *x.NonZeroExit
	}
	return false
}

func (x *MetricsBase) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

func (x *MetricsBase) GetManifestUrl() string {
	if x != nil && x.ManifestUrl != nil {
		return *x.ManifestUrl
	}
	return ""
}

func (x *MetricsBase) GetBranch() string {
	if x != nil && x.Branch != nil {
		return *x.Branch
	}
	return ""
}

type BuildConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UseGoma      *bool `protobuf:"varint,1,opt,name=use_goma,json=useGoma" json:"use_goma,omitempty"`
	UseRbe       *bool `protobuf:"varint,2,opt,name=use_rbe,json=useRbe" json:"use_rbe,omitempty"`
	ForceUseGoma *bool `protobuf:"varint,3,opt,name=force_use_goma,json=forceUseGoma" json:"force_use_goma,omitempty"`
	// Whether the Bazel is acting as the Ninja executor for this build.
	BazelAsNinja *bool `protobuf:"varint,4,opt,name=bazel_as_ninja,json=bazelAsNinja" json:"bazel_as_ninja,omitempty"`
	// Whether build is occurring in a mixed build mode, where Bazel maintains the
	// definition and build of some modules in cooperation with Soong.
	BazelMixedBuild *bool `protobuf:"varint,5,opt,name=bazel_mixed_build,json=bazelMixedBuild" json:"bazel_mixed_build,omitempty"`
	// These are the targets soong passes to ninja, these targets include special
	// targets such as droid as well as the regular build targets.
	Targets []string `protobuf:"bytes,6,rep,name=targets" json:"targets,omitempty"`
	// Whether the user explicitly disabled bazel mixed builds for this build.
	ForceDisableBazelMixedBuild *bool `protobuf:"varint,7,opt,name=force_disable_bazel_mixed_build,json=forceDisableBazelMixedBuild" json:"force_disable_bazel_mixed_build,omitempty"`
}

func (x *BuildConfig) Reset() {
	*x = BuildConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildConfig) ProtoMessage() {}

func (x *BuildConfig) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildConfig.ProtoReflect.Descriptor instead.
func (*BuildConfig) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *BuildConfig) GetUseGoma() bool {
	if x != nil && x.UseGoma != nil {
		return *x.UseGoma
	}
	return false
}

func (x *BuildConfig) GetUseRbe() bool {
	if x != nil && x.UseRbe != nil {
		return *x.UseRbe
	}
	return false
}

func (x *BuildConfig) GetForceUseGoma() bool {
	if x != nil && x.ForceUseGoma != nil {
		return *x.ForceUseGoma
	}
	return false
}

func (x *BuildConfig) GetBazelAsNinja() bool {
	if x != nil && x.BazelAsNinja != nil {
		return *x.BazelAsNinja
	}
	return false
}

func (x *BuildConfig) GetBazelMixedBuild() bool {
	if x != nil && x.BazelMixedBuild != nil {
		return *x.BazelMixedBuild
	}
	return false
}

func (x *BuildConfig) GetTargets() []string {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *BuildConfig) GetForceDisableBazelMixedBuild() bool {
	if x != nil && x.ForceDisableBazelMixedBuild != nil {
		return *x.ForceDisableBazelMixedBuild
	}
	return false
}

type SystemResourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total physical memory in bytes.
	TotalPhysicalMemory *uint64 `protobuf:"varint,1,opt,name=total_physical_memory,json=totalPhysicalMemory" json:"total_physical_memory,omitempty"`
	// The total of available cores for building
	AvailableCpus *int32 `protobuf:"varint,2,opt,name=available_cpus,json=availableCpus" json:"available_cpus,omitempty"`
}

func (x *SystemResourceInfo) Reset() {
	*x = SystemResourceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystemResourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemResourceInfo) ProtoMessage() {}

func (x *SystemResourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemResourceInfo.ProtoReflect.Descriptor instead.
func (*SystemResourceInfo) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{2}
}

func (x *SystemResourceInfo) GetTotalPhysicalMemory() uint64 {
	if x != nil && x.TotalPhysicalMemory != nil {
		return *x.TotalPhysicalMemory
	}
	return 0
}

func (x *SystemResourceInfo) GetAvailableCpus() int32 {
	if x != nil && x.AvailableCpus != nil {
		return *x.AvailableCpus
	}
	return 0
}

type PerfInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The description for the phase/action/part while the tool running.
	Description *string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// The name for the running phase/action/part.
	Name *string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The absolute start time.
	// The number of nanoseconds elapsed since January 1, 1970 UTC.
	StartTime *uint64 `protobuf:"varint,3,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The real running time.
	// The number of nanoseconds elapsed since start_time.
	RealTime *uint64 `protobuf:"varint,4,opt,name=real_time,json=realTime" json:"real_time,omitempty"`
	// The number of MB for memory use (deprecated as it is too generic).
	//
	// Deprecated: Do not use.
	MemoryUse *uint64 `protobuf:"varint,5,opt,name=memory_use,json=memoryUse" json:"memory_use,omitempty"`
	// The resource information of each executed process.
	ProcessesResourceInfo []*ProcessResourceInfo `protobuf:"bytes,6,rep,name=processes_resource_info,json=processesResourceInfo" json:"processes_resource_info,omitempty"`
	// Whether the phase of tool running exited with a panic or non-zero exit
	// code.
	NonZeroExit *bool `protobuf:"varint,7,opt,name=non_zero_exit,json=nonZeroExit" json:"non_zero_exit,omitempty"`
	// The error message, if any, due to a non-zero exit.
	ErrorMessage *string `protobuf:"bytes,8,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
}

func (x *PerfInfo) Reset() {
	*x = PerfInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerfInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerfInfo) ProtoMessage() {}

func (x *PerfInfo) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerfInfo.ProtoReflect.Descriptor instead.
func (*PerfInfo) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *PerfInfo) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *PerfInfo) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *PerfInfo) GetStartTime() uint64 {
	if x != nil && x.StartTime != nil {
		return *x.StartTime
	}
	return 0
}

func (x *PerfInfo) GetRealTime() uint64 {
	if x != nil && x.RealTime != nil {
		return *x.RealTime
	}
	return 0
}

// Deprecated: Do not use.
func (x *PerfInfo) GetMemoryUse() uint64 {
	if x != nil && x.MemoryUse != nil {
		return *x.MemoryUse
	}
	return 0
}

func (x *PerfInfo) GetProcessesResourceInfo() []*ProcessResourceInfo {
	if x != nil {
		return x.ProcessesResourceInfo
	}
	return nil
}

func (x *PerfInfo) GetNonZeroExit() bool {
	if x != nil && x.NonZeroExit != nil {
		return *x.NonZeroExit
	}
	return false
}

func (x *PerfInfo) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

type ProcessResourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the process for identification.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The amount of time spent executing in user space in microseconds.
	UserTimeMicros *uint64 `protobuf:"varint,2,opt,name=user_time_micros,json=userTimeMicros" json:"user_time_micros,omitempty"`
	// The amount of time spent executing in kernel mode in microseconds.
	SystemTimeMicros *uint64 `protobuf:"varint,3,opt,name=system_time_micros,json=systemTimeMicros" json:"system_time_micros,omitempty"`
	// The maximum resident set size memory used in kilobytes.
	MaxRssKb *uint64 `protobuf:"varint,4,opt,name=max_rss_kb,json=maxRssKb" json:"max_rss_kb,omitempty"`
	// The number of minor page faults serviced without any I/O activity.
	MinorPageFaults *uint64 `protobuf:"varint,5,opt,name=minor_page_faults,json=minorPageFaults" json:"minor_page_faults,omitempty"`
	// The number of major page faults serviced that required I/O activity.
	MajorPageFaults *uint64 `protobuf:"varint,6,opt,name=major_page_faults,json=majorPageFaults" json:"major_page_faults,omitempty"`
	// Total IO input in kilobytes.
	IoInputKb *uint64 `protobuf:"varint,7,opt,name=io_input_kb,json=ioInputKb" json:"io_input_kb,omitempty"`
	// Total IO output in kilobytes.
	IoOutputKb *uint64 `protobuf:"varint,8,opt,name=io_output_kb,json=ioOutputKb" json:"io_output_kb,omitempty"`
	// The number of voluntary context switches
	VoluntaryContextSwitches *uint64 `protobuf:"varint,9,opt,name=voluntary_context_switches,json=voluntaryContextSwitches" json:"voluntary_context_switches,omitempty"`
	// The number of involuntary context switches
	InvoluntaryContextSwitches *uint64 `protobuf:"varint,10,opt,name=involuntary_context_switches,json=involuntaryContextSwitches" json:"involuntary_context_switches,omitempty"`
}

func (x *ProcessResourceInfo) Reset() {
	*x = ProcessResourceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessResourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessResourceInfo) ProtoMessage() {}

func (x *ProcessResourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessResourceInfo.ProtoReflect.Descriptor instead.
func (*ProcessResourceInfo) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{4}
}

func (x *ProcessResourceInfo) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ProcessResourceInfo) GetUserTimeMicros() uint64 {
	if x != nil && x.UserTimeMicros != nil {
		return *x.UserTimeMicros
	}
	return 0
}

func (x *ProcessResourceInfo) GetSystemTimeMicros() uint64 {
	if x != nil && x.SystemTimeMicros != nil {
		return *x.SystemTimeMicros
	}
	return 0
}

func (x *ProcessResourceInfo) GetMaxRssKb() uint64 {
	if x != nil && x.MaxRssKb != nil {
		return *x.MaxRssKb
	}
	return 0
}

func (x *ProcessResourceInfo) GetMinorPageFaults() uint64 {
	if x != nil && x.MinorPageFaults != nil {
		return *x.MinorPageFaults
	}
	return 0
}

func (x *ProcessResourceInfo) GetMajorPageFaults() uint64 {
	if x != nil && x.MajorPageFaults != nil {
		return *x.MajorPageFaults
	}
	return 0
}

func (x *ProcessResourceInfo) GetIoInputKb() uint64 {
	if x != nil && x.IoInputKb != nil {
		return *x.IoInputKb
	}
	return 0
}

func (x *ProcessResourceInfo) GetIoOutputKb() uint64 {
	if x != nil && x.IoOutputKb != nil {
		return *x.IoOutputKb
	}
	return 0
}

func (x *ProcessResourceInfo) GetVoluntaryContextSwitches() uint64 {
	if x != nil && x.VoluntaryContextSwitches != nil {
		return *x.VoluntaryContextSwitches
	}
	return 0
}

func (x *ProcessResourceInfo) GetInvoluntaryContextSwitches() uint64 {
	if x != nil && x.InvoluntaryContextSwitches != nil {
		return *x.InvoluntaryContextSwitches
	}
	return 0
}

type ModuleTypeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The build system, e.g. Soong or Make.
	BuildSystem *ModuleTypeInfo_BuildSystem `protobuf:"varint,1,opt,name=build_system,json=buildSystem,enum=soong_build_metrics.ModuleTypeInfo_BuildSystem,def=0" json:"build_system,omitempty"`
	// The module type, e.g. java_library, cc_binary, and etc.
	ModuleType *string `protobuf:"bytes,2,opt,name=module_type,json=moduleType" json:"module_type,omitempty"`
	// The number of logical modules.
	NumOfModules *uint32 `protobuf:"varint,3,opt,name=num_of_modules,json=numOfModules" json:"num_of_modules,omitempty"`
}

// Default values for ModuleTypeInfo fields.
const (
	Default_ModuleTypeInfo_BuildSystem = ModuleTypeInfo_UNKNOWN
)

func (x *ModuleTypeInfo) Reset() {
	*x = ModuleTypeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModuleTypeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleTypeInfo) ProtoMessage() {}

func (x *ModuleTypeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleTypeInfo.ProtoReflect.Descriptor instead.
func (*ModuleTypeInfo) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{5}
}

func (x *ModuleTypeInfo) GetBuildSystem() ModuleTypeInfo_BuildSystem {
	if x != nil && x.BuildSystem != nil {
		return *x.BuildSystem
	}
	return Default_ModuleTypeInfo_BuildSystem
}

func (x *ModuleTypeInfo) GetModuleType() string {
	if x != nil && x.ModuleType != nil {
		return *x.ModuleType
	}
	return ""
}

func (x *ModuleTypeInfo) GetNumOfModules() uint32 {
	if x != nil && x.NumOfModules != nil {
		return *x.NumOfModules
	}
	return 0
}

type CriticalUserJourneyMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a critical user journey test.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The metrics produced when running the critical user journey test.
	Metrics *MetricsBase `protobuf:"bytes,2,opt,name=metrics" json:"metrics,omitempty"`
}

func (x *CriticalUserJourneyMetrics) Reset() {
	*x = CriticalUserJourneyMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CriticalUserJourneyMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CriticalUserJourneyMetrics) ProtoMessage() {}

func (x *CriticalUserJourneyMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CriticalUserJourneyMetrics.ProtoReflect.Descriptor instead.
func (*CriticalUserJourneyMetrics) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{6}
}

func (x *CriticalUserJourneyMetrics) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *CriticalUserJourneyMetrics) GetMetrics() *MetricsBase {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type CriticalUserJourneysMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of metrics from a run of the critical user journey tests.
	Cujs []*CriticalUserJourneyMetrics `protobuf:"bytes,1,rep,name=cujs" json:"cujs,omitempty"`
}

func (x *CriticalUserJourneysMetrics) Reset() {
	*x = CriticalUserJourneysMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CriticalUserJourneysMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CriticalUserJourneysMetrics) ProtoMessage() {}

func (x *CriticalUserJourneysMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CriticalUserJourneysMetrics.ProtoReflect.Descriptor instead.
func (*CriticalUserJourneysMetrics) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{7}
}

func (x *CriticalUserJourneysMetrics) GetCujs() []*CriticalUserJourneyMetrics {
	if x != nil {
		return x.Cujs
	}
	return nil
}

type SoongBuildMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of modules handled by soong_build.
	Modules *uint32 `protobuf:"varint,1,opt,name=modules" json:"modules,omitempty"`
	// The total number of variants handled by soong_build.
	Variants *uint32 `protobuf:"varint,2,opt,name=variants" json:"variants,omitempty"`
	// The total number of allocations in soong_build.
	TotalAllocCount *uint64 `protobuf:"varint,3,opt,name=total_alloc_count,json=totalAllocCount" json:"total_alloc_count,omitempty"`
	// The total size of allocations in soong_build in bytes.
	TotalAllocSize *uint64 `protobuf:"varint,4,opt,name=total_alloc_size,json=totalAllocSize" json:"total_alloc_size,omitempty"`
	// The approximate maximum size of the heap in soong_build in bytes.
	MaxHeapSize *uint64 `protobuf:"varint,5,opt,name=max_heap_size,json=maxHeapSize" json:"max_heap_size,omitempty"`
	// Runtime metrics for soong_build execution.
	Events []*PerfInfo `protobuf:"bytes,6,rep,name=events" json:"events,omitempty"`
	// Mixed Builds information
	MixedBuildsInfo *MixedBuildsInfo `protobuf:"bytes,7,opt,name=mixed_builds_info,json=mixedBuildsInfo" json:"mixed_builds_info,omitempty"`
}

func (x *SoongBuildMetrics) Reset() {
	*x = SoongBuildMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoongBuildMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoongBuildMetrics) ProtoMessage() {}

func (x *SoongBuildMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoongBuildMetrics.ProtoReflect.Descriptor instead.
func (*SoongBuildMetrics) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{8}
}

func (x *SoongBuildMetrics) GetModules() uint32 {
	if x != nil && x.Modules != nil {
		return *x.Modules
	}
	return 0
}

func (x *SoongBuildMetrics) GetVariants() uint32 {
	if x != nil && x.Variants != nil {
		return *x.Variants
	}
	return 0
}

func (x *SoongBuildMetrics) GetTotalAllocCount() uint64 {
	if x != nil && x.TotalAllocCount != nil {
		return *x.TotalAllocCount
	}
	return 0
}

func (x *SoongBuildMetrics) GetTotalAllocSize() uint64 {
	if x != nil && x.TotalAllocSize != nil {
		return *x.TotalAllocSize
	}
	return 0
}

func (x *SoongBuildMetrics) GetMaxHeapSize() uint64 {
	if x != nil && x.MaxHeapSize != nil {
		return *x.MaxHeapSize
	}
	return 0
}

func (x *SoongBuildMetrics) GetEvents() []*PerfInfo {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *SoongBuildMetrics) GetMixedBuildsInfo() *MixedBuildsInfo {
	if x != nil {
		return x.MixedBuildsInfo
	}
	return nil
}

type ExpConfigFetcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the call to expconfigfetcher
	// NO_CONFIG - Not part of experiment
	// CONFIG - Part of experiment, config copied successfully
	// ERROR - expconfigfetcher failed
	Status *ExpConfigFetcher_ConfigStatus `protobuf:"varint,1,opt,name=status,enum=soong_build_metrics.ExpConfigFetcher_ConfigStatus" json:"status,omitempty"`
	// The output config filename
	Filename *string `protobuf:"bytes,2,opt,name=filename" json:"filename,omitempty"`
	// Time, in microseconds, taken by the expconfigfetcher
	Micros *uint64 `protobuf:"varint,3,opt,name=micros" json:"micros,omitempty"`
}

func (x *ExpConfigFetcher) Reset() {
	*x = ExpConfigFetcher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpConfigFetcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpConfigFetcher) ProtoMessage() {}

func (x *ExpConfigFetcher) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpConfigFetcher.ProtoReflect.Descriptor instead.
func (*ExpConfigFetcher) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{9}
}

func (x *ExpConfigFetcher) GetStatus() ExpConfigFetcher_ConfigStatus {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return ExpConfigFetcher_NO_CONFIG
}

func (x *ExpConfigFetcher) GetFilename() string {
	if x != nil && x.Filename != nil {
		return *x.Filename
	}
	return ""
}

func (x *ExpConfigFetcher) GetMicros() uint64 {
	if x != nil && x.Micros != nil {
		return *x.Micros
	}
	return 0
}

type MixedBuildsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Modules that are enabled for Mixed Builds.
	MixedBuildEnabledModules []string `protobuf:"bytes,1,rep,name=mixed_build_enabled_modules,json=mixedBuildEnabledModules" json:"mixed_build_enabled_modules,omitempty"`
	// Modules that are not enabled for MixedBuilds
	MixedBuildDisabledModules []string `protobuf:"bytes,2,rep,name=mixed_build_disabled_modules,json=mixedBuildDisabledModules" json:"mixed_build_disabled_modules,omitempty"`
}

func (x *MixedBuildsInfo) Reset() {
	*x = MixedBuildsInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metrics_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MixedBuildsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MixedBuildsInfo) ProtoMessage() {}

func (x *MixedBuildsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_metrics_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MixedBuildsInfo.ProtoReflect.Descriptor instead.
func (*MixedBuildsInfo) Descriptor() ([]byte, []int) {
	return file_metrics_proto_rawDescGZIP(), []int{10}
}

func (x *MixedBuildsInfo) GetMixedBuildEnabledModules() []string {
	if x != nil {
		return x.MixedBuildEnabledModules
	}
	return nil
}

func (x *MixedBuildsInfo) GetMixedBuildDisabledModules() []string {
	if x != nil {
		return x.MixedBuildDisabledModules
	}
	return nil
}

var File_metrics_proto protoreflect.FileDescriptor

var file_metrics_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x22, 0xb5, 0x0e, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x42, 0x61, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x12, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49,
	0x64, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x12, 0x64, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x42, 0x61, 0x73, 0x65, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x3a, 0x03, 0x45, 0x4e, 0x47, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x25, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x73,
	0x65, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x3a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x52,
	0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x63, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x41, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x70, 0x75, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x09, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x73,
	0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x73, 0x65, 0x2e, 0x41,
	0x72, 0x63, 0x68, 0x3a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x41, 0x72, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x32,
	0x6e, 0x64, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x73, 0x65, 0x2e,
	0x41, 0x72, 0x63, 0x68, 0x3a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x52, 0x0b, 0x68,
	0x6f, 0x73, 0x74, 0x32, 0x6e, 0x64, 0x41, 0x72, 0x63, 0x68, 0x12, 0x17, 0x0a, 0x07, 0x68, 0x6f,
	0x73, 0x74, 0x5f, 0x6f, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x6f, 0x73,
	0x74, 0x4f, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x73, 0x5f, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74,
	0x4f, 0x73, 0x45, 0x78, 0x74, 0x72, 0x61, 0x12, 0x22, 0x0a, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x6f, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x68, 0x6f, 0x73, 0x74, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x4f, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x41,
	0x72, 0x63, 0x68, 0x12, 0x2d, 0x0a, 0x13, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x72, 0x6f, 0x73,
	0x73, 0x5f, 0x32, 0x6e, 0x64, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x68, 0x6f, 0x73, 0x74, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x32, 0x6e, 0x64, 0x41, 0x72,
	0x63, 0x68, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x44, 0x69, 0x72, 0x12, 0x3e, 0x0a, 0x0b, 0x73,
	0x65, 0x74, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x73, 0x65, 0x74, 0x75, 0x70, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x6b,
	0x61, 0x74, 0x69, 0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x6b,
	0x61, 0x74, 0x69, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0a, 0x73, 0x6f, 0x6f, 0x6e, 0x67,
	0x5f, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x6f,
	0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x6f, 0x6f, 0x6e,
	0x67, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0a, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x5f, 0x72,
	0x75, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e,
	0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x52,
	0x75, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x5a, 0x0a, 0x13, 0x73, 0x6f, 0x6f, 0x6e,
	0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x6f, 0x6f, 0x6e,
	0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x11, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x43, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x6f, 0x6f,
	0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x14, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x23, 0x0a, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x3c, 0x0a, 0x0a, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x5f, 0x72,
	0x75, 0x6e, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e,
	0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x52,
	0x75, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x10, 0x65, 0x78, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x46, 0x65, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x6f, 0x6e, 0x5f,
	0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x6e, 0x6f, 0x6e, 0x5a, 0x65, 0x72, 0x6f, 0x45, 0x78, 0x69, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x55, 0x72, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x20,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x30, 0x0a, 0x0c,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x08, 0x0a, 0x04,
	0x55, 0x53, 0x45, 0x52, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x53, 0x45, 0x52, 0x44, 0x45,
	0x42, 0x55, 0x47, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x3c,
	0x0a, 0x04, 0x41, 0x72, 0x63, 0x68, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x52, 0x4d, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x52, 0x4d, 0x36, 0x34, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x58, 0x38, 0x36, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x58, 0x38, 0x36, 0x5f, 0x36, 0x34, 0x10, 0x04, 0x22, 0x99, 0x02, 0x0a,
	0x0b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x5f, 0x67, 0x6f, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x75, 0x73, 0x65, 0x47, 0x6f, 0x6d, 0x61, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x5f, 0x72,
	0x62, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x73, 0x65, 0x52, 0x62, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x67, 0x6f,
	0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x55,
	0x73, 0x65, 0x47, 0x6f, 0x6d, 0x61, 0x12, 0x24, 0x0a, 0x0e, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x5f,
	0x61, 0x73, 0x5f, 0x6e, 0x69, 0x6e, 0x6a, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x41, 0x73, 0x4e, 0x69, 0x6e, 0x6a, 0x61, 0x12, 0x2a, 0x0a, 0x11,
	0x62, 0x61, 0x7a, 0x65, 0x6c, 0x5f, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x4d, 0x69,
	0x78, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x12, 0x44, 0x0a, 0x1f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x62, 0x61, 0x7a, 0x65, 0x6c, 0x5f, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x5f,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x61, 0x7a, 0x65, 0x6c, 0x4d, 0x69,
	0x78, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x6f, 0x0a, 0x12, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32,
	0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x63, 0x70, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x70, 0x75, 0x73, 0x22, 0xca, 0x02, 0x0a, 0x08, 0x50, 0x65,
	0x72, 0x66, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x5f, 0x75, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x17, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x73,
	0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a,
	0x0d, 0x6e, 0x6f, 0x6e, 0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6e, 0x6f, 0x6e, 0x5a, 0x65, 0x72, 0x6f, 0x45, 0x78, 0x69,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xb9, 0x03, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x2c, 0x0a, 0x12,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x54, 0x69, 0x6d, 0x65, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x1c, 0x0a, 0x0a, 0x6d, 0x61,
	0x78, 0x5f, 0x72, 0x73, 0x73, 0x5f, 0x6b, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08,
	0x6d, 0x61, 0x78, 0x52, 0x73, 0x73, 0x4b, 0x62, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x6f,
	0x72, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x50, 0x61, 0x67, 0x65, 0x46, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0f, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x50, 0x61, 0x67, 0x65, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x1e, 0x0a, 0x0b, 0x69, 0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x62, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x62,
	0x12, 0x20, 0x0a, 0x0c, 0x69, 0x6f, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x62,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x4b, 0x62, 0x12, 0x3c, 0x0a, 0x1a, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x18, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x12, 0x40, 0x0a, 0x1c, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1a, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x22, 0xe5, 0x01, 0x0a, 0x0e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5b, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x73, 0x6f,
	0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x3a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x6e, 0x75, 0x6d,
	0x4f, 0x66, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x2f, 0x0a, 0x0b, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4f, 0x4f, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x4d, 0x41, 0x4b, 0x45, 0x10, 0x02, 0x22, 0x6c, 0x0a, 0x1a, 0x43, 0x72,
	0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x61, 0x73, 0x65, 0x52,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x62, 0x0a, 0x1b, 0x43, 0x72, 0x69, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x73,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x43, 0x0a, 0x04, 0x63, 0x75, 0x6a, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x72, 0x69, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x04, 0x63, 0x75, 0x6a, 0x73, 0x22, 0xcc, 0x02, 0x0a,
	0x11, 0x53, 0x6f, 0x6f, 0x6e, 0x67, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x65, 0x61, 0x70, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x48, 0x65, 0x61, 0x70, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x11, 0x6d, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x69, 0x78, 0x65, 0x64,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x6d, 0x69, 0x78, 0x65,
	0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xdb, 0x01, 0x0a, 0x10,
	0x45, 0x78, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x65, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x12, 0x4a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x69, 0x63, 0x72,
	0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x22, 0x47, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x5f, 0x47, 0x43, 0x45, 0x52, 0x54, 0x10, 0x03, 0x22, 0x91, 0x01, 0x0a, 0x0f, 0x4d, 0x69,
	0x78, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3d, 0x0a,
	0x1b, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x18, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x1c,
	0x6d, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x19, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x42, 0x28, 0x5a,
	0x26, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f, 0x75,
	0x69, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_metrics_proto_rawDescOnce sync.Once
	file_metrics_proto_rawDescData = file_metrics_proto_rawDesc
)

func file_metrics_proto_rawDescGZIP() []byte {
	file_metrics_proto_rawDescOnce.Do(func() {
		file_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_metrics_proto_rawDescData)
	})
	return file_metrics_proto_rawDescData
}

var file_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_metrics_proto_goTypes = []interface{}{
	(MetricsBase_BuildVariant)(0),       // 0: soong_build_metrics.MetricsBase.BuildVariant
	(MetricsBase_Arch)(0),               // 1: soong_build_metrics.MetricsBase.Arch
	(ModuleTypeInfo_BuildSystem)(0),     // 2: soong_build_metrics.ModuleTypeInfo.BuildSystem
	(ExpConfigFetcher_ConfigStatus)(0),  // 3: soong_build_metrics.ExpConfigFetcher.ConfigStatus
	(*MetricsBase)(nil),                 // 4: soong_build_metrics.MetricsBase
	(*BuildConfig)(nil),                 // 5: soong_build_metrics.BuildConfig
	(*SystemResourceInfo)(nil),          // 6: soong_build_metrics.SystemResourceInfo
	(*PerfInfo)(nil),                    // 7: soong_build_metrics.PerfInfo
	(*ProcessResourceInfo)(nil),         // 8: soong_build_metrics.ProcessResourceInfo
	(*ModuleTypeInfo)(nil),              // 9: soong_build_metrics.ModuleTypeInfo
	(*CriticalUserJourneyMetrics)(nil),  // 10: soong_build_metrics.CriticalUserJourneyMetrics
	(*CriticalUserJourneysMetrics)(nil), // 11: soong_build_metrics.CriticalUserJourneysMetrics
	(*SoongBuildMetrics)(nil),           // 12: soong_build_metrics.SoongBuildMetrics
	(*ExpConfigFetcher)(nil),            // 13: soong_build_metrics.ExpConfigFetcher
	(*MixedBuildsInfo)(nil),             // 14: soong_build_metrics.MixedBuildsInfo
}
var file_metrics_proto_depIdxs = []int32{
	0,  // 0: soong_build_metrics.MetricsBase.target_build_variant:type_name -> soong_build_metrics.MetricsBase.BuildVariant
	1,  // 1: soong_build_metrics.MetricsBase.target_arch:type_name -> soong_build_metrics.MetricsBase.Arch
	1,  // 2: soong_build_metrics.MetricsBase.host_arch:type_name -> soong_build_metrics.MetricsBase.Arch
	1,  // 3: soong_build_metrics.MetricsBase.host_2nd_arch:type_name -> soong_build_metrics.MetricsBase.Arch
	7,  // 4: soong_build_metrics.MetricsBase.setup_tools:type_name -> soong_build_metrics.PerfInfo
	7,  // 5: soong_build_metrics.MetricsBase.kati_runs:type_name -> soong_build_metrics.PerfInfo
	7,  // 6: soong_build_metrics.MetricsBase.soong_runs:type_name -> soong_build_metrics.PerfInfo
	7,  // 7: soong_build_metrics.MetricsBase.ninja_runs:type_name -> soong_build_metrics.PerfInfo
	7,  // 8: soong_build_metrics.MetricsBase.total:type_name -> soong_build_metrics.PerfInfo
	12, // 9: soong_build_metrics.MetricsBase.soong_build_metrics:type_name -> soong_build_metrics.SoongBuildMetrics
	5,  // 10: soong_build_metrics.MetricsBase.build_config:type_name -> soong_build_metrics.BuildConfig
	6,  // 11: soong_build_metrics.MetricsBase.system_resource_info:type_name -> soong_build_metrics.SystemResourceInfo
	7,  // 12: soong_build_metrics.MetricsBase.bazel_runs:type_name -> soong_build_metrics.PerfInfo
	13, // 13: soong_build_metrics.MetricsBase.exp_config_fetcher:type_name -> soong_build_metrics.ExpConfigFetcher
	8,  // 14: soong_build_metrics.PerfInfo.processes_resource_info:type_name -> soong_build_metrics.ProcessResourceInfo
	2,  // 15: soong_build_metrics.ModuleTypeInfo.build_system:type_name -> soong_build_metrics.ModuleTypeInfo.BuildSystem
	4,  // 16: soong_build_metrics.CriticalUserJourneyMetrics.metrics:type_name -> soong_build_metrics.MetricsBase
	10, // 17: soong_build_metrics.CriticalUserJourneysMetrics.cujs:type_name -> soong_build_metrics.CriticalUserJourneyMetrics
	7,  // 18: soong_build_metrics.SoongBuildMetrics.events:type_name -> soong_build_metrics.PerfInfo
	14, // 19: soong_build_metrics.SoongBuildMetrics.mixed_builds_info:type_name -> soong_build_metrics.MixedBuildsInfo
	3,  // 20: soong_build_metrics.ExpConfigFetcher.status:type_name -> soong_build_metrics.ExpConfigFetcher.ConfigStatus
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_metrics_proto_init() }
func file_metrics_proto_init() {
	if File_metrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricsBase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystemResourceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PerfInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessResourceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModuleTypeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CriticalUserJourneyMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CriticalUserJourneysMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoongBuildMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpConfigFetcher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metrics_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MixedBuildsInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_metrics_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metrics_proto_goTypes,
		DependencyIndexes: file_metrics_proto_depIdxs,
		EnumInfos:         file_metrics_proto_enumTypes,
		MessageInfos:      file_metrics_proto_msgTypes,
	}.Build()
	File_metrics_proto = out.File
	file_metrics_proto_rawDesc = nil
	file_metrics_proto_goTypes = nil
	file_metrics_proto_depIdxs = nil
}
