// Copyright 2020 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.9.1
// source: build_progress.proto

package build_progress_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BuildProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of actions in a build. The total actions will increase
	// and might decrease during the course of a build.
	TotalActions *uint64 `protobuf:"varint,1,opt,name=total_actions,json=totalActions" json:"total_actions,omitempty"`
	// Total number of completed build actions. This value will never decrease
	// and finished_actions <= total_actions. At one point of the build, the
	// finished_actions will be equal to total_actions. This may not represent
	// that the build is completed as the total_actions may be increased for
	// additional counted work or is doing non-counted work.
	FinishedActions *uint64 `protobuf:"varint,2,opt,name=finished_actions,json=finishedActions" json:"finished_actions,omitempty"`
	// Total number of current actions being executed during a course of a
	// build and current_actions + finished_actions <= total_actions.
	CurrentActions *uint64 `protobuf:"varint,3,opt,name=current_actions,json=currentActions" json:"current_actions,omitempty"`
	// Total number of actions that reported as a failure.
	FailedActions *uint64 `protobuf:"varint,4,opt,name=failed_actions,json=failedActions" json:"failed_actions,omitempty"`
}

func (x *BuildProgress) Reset() {
	*x = BuildProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_build_progress_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildProgress) ProtoMessage() {}

func (x *BuildProgress) ProtoReflect() protoreflect.Message {
	mi := &file_build_progress_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildProgress.ProtoReflect.Descriptor instead.
func (*BuildProgress) Descriptor() ([]byte, []int) {
	return file_build_progress_proto_rawDescGZIP(), []int{0}
}

func (x *BuildProgress) GetTotalActions() uint64 {
	if x != nil && x.TotalActions != nil {
		return *x.TotalActions
	}
	return 0
}

func (x *BuildProgress) GetFinishedActions() uint64 {
	if x != nil && x.FinishedActions != nil {
		return *x.FinishedActions
	}
	return 0
}

func (x *BuildProgress) GetCurrentActions() uint64 {
	if x != nil && x.CurrentActions != nil {
		return *x.CurrentActions
	}
	return 0
}

func (x *BuildProgress) GetFailedActions() uint64 {
	if x != nil && x.FailedActions != nil {
		return *x.FailedActions
	}
	return 0
}

var File_build_progress_proto protoreflect.FileDescriptor

var file_build_progress_proto_rawDesc = []byte{
	0x0a, 0x14, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xaf, 0x01, 0x0a,
	0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x66,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0d, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x2e,
	0x5a, 0x2c, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f,
	0x75, 0x69, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_build_progress_proto_rawDescOnce sync.Once
	file_build_progress_proto_rawDescData = file_build_progress_proto_rawDesc
)

func file_build_progress_proto_rawDescGZIP() []byte {
	file_build_progress_proto_rawDescOnce.Do(func() {
		file_build_progress_proto_rawDescData = protoimpl.X.CompressGZIP(file_build_progress_proto_rawDescData)
	})
	return file_build_progress_proto_rawDescData
}

var file_build_progress_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_build_progress_proto_goTypes = []interface{}{
	(*BuildProgress)(nil), // 0: soong_build_progress.BuildProgress
}
var file_build_progress_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_build_progress_proto_init() }
func file_build_progress_proto_init() {
	if File_build_progress_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_build_progress_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_build_progress_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_build_progress_proto_goTypes,
		DependencyIndexes: file_build_progress_proto_depIdxs,
		MessageInfos:      file_build_progress_proto_msgTypes,
	}.Build()
	File_build_progress_proto = out.File
	file_build_progress_proto_rawDesc = nil
	file_build_progress_proto_goTypes = nil
	file_build_progress_proto_depIdxs = nil
}
