// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// A proto definition used to parse METADATA file in third party projects.

// This proto will only contain fields and values used by android compliance.
// It is not intended to be the formal definition of METADATA file.

// See google3/third_party/metadata.proto if you need to add more stuff to
// match upstream. Do not add new fields and values here. Add them upstream
// when necessary, and copy them here.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.12.4
// source: project_metadata.proto

package project_metadata_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// License type that identifies how the packages may be used. See
// go/thirdpartylicenses for full explanation of each license type.
type LicenseType int32

const (
	LicenseType_BY_EXCEPTION_ONLY               LicenseType = 1
	LicenseType_NOTICE                          LicenseType = 2
	LicenseType_PERMISSIVE                      LicenseType = 3
	LicenseType_RECIPROCAL                      LicenseType = 4
	LicenseType_RESTRICTED_IF_STATICALLY_LINKED LicenseType = 5
	LicenseType_RESTRICTED                      LicenseType = 6
	LicenseType_UNENCUMBERED                    LicenseType = 7
)

// Enum value maps for LicenseType.
var (
	LicenseType_name = map[int32]string{
		1: "BY_EXCEPTION_ONLY",
		2: "NOTICE",
		3: "PERMISSIVE",
		4: "RECIPROCAL",
		5: "RESTRICTED_IF_STATICALLY_LINKED",
		6: "RESTRICTED",
		7: "UNENCUMBERED",
	}
	LicenseType_value = map[string]int32{
		"BY_EXCEPTION_ONLY":               1,
		"NOTICE":                          2,
		"PERMISSIVE":                      3,
		"RECIPROCAL":                      4,
		"RESTRICTED_IF_STATICALLY_LINKED": 5,
		"RESTRICTED":                      6,
		"UNENCUMBERED":                    7,
	}
)

func (x LicenseType) Enum() *LicenseType {
	p := new(LicenseType)
	*p = x
	return p
}

func (x LicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_project_metadata_proto_enumTypes[0].Descriptor()
}

func (LicenseType) Type() protoreflect.EnumType {
	return &file_project_metadata_proto_enumTypes[0]
}

func (x LicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *LicenseType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = LicenseType(num)
	return nil
}

// Deprecated: Use LicenseType.Descriptor instead.
func (LicenseType) EnumDescriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{0}
}

type URL_Type int32

const (
	// The homepage for the package. For example, "https://bazel.io/". This URL
	// is optional, but encouraged to help disambiguate similarly named packages
	// or to get more information about the package. This is especially helpful
	// when no other URLs provide human readable resources (such as git:// or
	// sso:// URLs).
	URL_HOMEPAGE URL_Type = 1
	// The URL of the archive containing the source code for the package, for
	// example a zip or tgz file.
	URL_ARCHIVE URL_Type = 2
	// The URL of the upstream git repository this package is retrieved from.
	// For example:
	//   - https://github.com/git/git.git
	//   - git://git.kernel.org/pub/scm/git/git.git
	//
	// Use of a git URL requires that the package "version" value must specify a
	// specific git tag or revision.
	URL_GIT URL_Type = 3
	// The URL of the upstream SVN repository this package is retrieved from.
	// For example:
	//   - http://llvm.org/svn/llvm-project/llvm/
	//
	// Use of an SVN URL requires that the package "version" value must specify
	// a specific SVN tag or revision.
	URL_SVN URL_Type = 7
	// The URL of the upstream mercurial repository this package is retrieved
	// from. For example:
	//   - https://mercurial-scm.org/repo/evolve
	//
	// Use of a mercurial URL requires that the package "version" value must
	// specify a specific tag or revision.
	URL_HG URL_Type = 8
	// The URL of the upstream darcs repository this package is retrieved
	// from. For example:
	//   - https://hub.darcs.net/hu.dwim/hu.dwim.util
	//
	// Use of a DARCS URL requires that the package "version" value must
	// specify a specific tag or revision.
	URL_DARCS URL_Type = 9
	// The URL of the upstream piper location.  This is primarily used when a
	// package is being migrated into third_party from elsewhere in piper, or
	// when a package is being newly developed in third_party.  For newly
	// developed packages, the PIPER URL should reference the package itself
	// (e.g. "http://google3/third_party/my/package")
	URL_PIPER URL_Type = 4
	// A URL that does not fit any other type. This may also indicate that the
	// source code was received via email or some other out-of-band way. This is
	// most commonly used with commercial software received directly from the
	// vendor. In the case of email, the URL value can be used to provide
	// additional information about how it was received.
	URL_OTHER URL_Type = 11
	// The URL identifying where the local copy of the package source code can
	// be found.
	//
	// Typically, the metadata files describing a package reside in the same
	// directory as the source code for the package. In a few rare cases where
	// they are separate, the LOCAL_SOURCE URL identifies where to find the
	// source code. This only describes where to find the local copy of the
	// source; there should always be an additional URL describing where the
	// package was retrieved from.
	//
	// Examples:
	//   - http://google3/third_party/java_src/gerritcodereview/gerrit/
	//   - https://android.googlesource.com/platform/external/apache-http/
	URL_LOCAL_SOURCE URL_Type = 6
)

// Enum value maps for URL_Type.
var (
	URL_Type_name = map[int32]string{
		1:  "HOMEPAGE",
		2:  "ARCHIVE",
		3:  "GIT",
		7:  "SVN",
		8:  "HG",
		9:  "DARCS",
		4:  "PIPER",
		11: "OTHER",
		6:  "LOCAL_SOURCE",
	}
	URL_Type_value = map[string]int32{
		"HOMEPAGE":     1,
		"ARCHIVE":      2,
		"GIT":          3,
		"SVN":          7,
		"HG":           8,
		"DARCS":        9,
		"PIPER":        4,
		"OTHER":        11,
		"LOCAL_SOURCE": 6,
	}
)

func (x URL_Type) Enum() *URL_Type {
	p := new(URL_Type)
	*p = x
	return p
}

func (x URL_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (URL_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_project_metadata_proto_enumTypes[1].Descriptor()
}

func (URL_Type) Type() protoreflect.EnumType {
	return &file_project_metadata_proto_enumTypes[1]
}

func (x URL_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *URL_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = URL_Type(num)
	return nil
}

// Deprecated: Use URL_Type.Descriptor instead.
func (URL_Type) EnumDescriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{2, 0}
}

type Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this API/package.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A short description (a few lines) of the package. It will be
	// included on the summary page.
	// Example: "Handles location lookups, throttling, batching, etc."
	Description *string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Specifies additional data about third-party packages.
	ThirdParty *ThirdParty `protobuf:"bytes,13,opt,name=third_party,json=thirdParty" json:"third_party,omitempty"`
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_project_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_project_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metadata.ProtoReflect.Descriptor instead.
func (*Metadata) Descriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *Metadata) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Metadata) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Metadata) GetThirdParty() *ThirdParty {
	if x != nil {
		return x.ThirdParty
	}
	return nil
}

type ThirdParty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL(s) associated with the package.
	//
	// At a minimum, all packages must specify a URL which identifies where it
	// came from, containing a type of: ARCHIVE, GIT, PIPER, or OTHER. Typically,
	// a package should contain only a single URL from these types.  Occasionally,
	// a package may be broken across multiple archive files for whatever reason,
	// in which case having multiple ARCHIVE URLs is okay.  However, this should
	// not be used to combine different logical packages that are versioned and
	// possibly licensed differently.
	Url []*URL `protobuf:"bytes,1,rep,name=url" json:"url,omitempty"`
	// The package version.  In order of preference, this should contain:
	//   - If the package comes from Git or another source control system,
	//     a specific tag or revision in source control, such as "r123" or
	//     "58e27d2".  This MUST NOT be a mutable ref such as a branch name.
	//   - a released package version such as "1.0", "2.3-beta", etc.
	//   - the date the package was retrieved, formatted as "As of YYYY-MM-DD".
	Version *string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// The date of the change in which the package was last upgraded from
	// upstream.
	// This should only identify package upgrades from upstream, not local
	// modifications. This may identify the date of either the original or
	// merged change.
	//
	// Note: this is NOT the date that this version of the package was released
	// externally.
	LastUpgradeDate *Date `protobuf:"bytes,10,opt,name=last_upgrade_date,json=lastUpgradeDate" json:"last_upgrade_date,omitempty"`
	// License type that identifies how the package may be used. See
	// go/thirdpartylicenses for instructions on selecting the appropriate type.
	LicenseType *LicenseType `protobuf:"varint,4,opt,name=license_type,json=licenseType,enum=project_metadata.LicenseType" json:"license_type,omitempty"`
	// Description of local changes that have been made to the package.  This does
	// not need to (and in most cases should not) attempt to include an exhaustive
	// list of all changes, but may instead direct readers to review the local
	// commit history, a collection of patch files, a separate README.md (or
	// similar) document, etc.
	// Note: Use of this field to store IDs of advisories fixed with a backported
	// patch is deprecated, use "security.mitigated_security_patch" instead.
	LocalModifications *string `protobuf:"bytes,6,opt,name=local_modifications,json=localModifications" json:"local_modifications,omitempty"`
	// The URL for any public mirror created for compliance purposes.
	// See go/thirdpartylicenses#reciprocal policy for more details.
	ComplianceMirrorUrl *string `protobuf:"bytes,12,opt,name=compliance_mirror_url,json=complianceMirrorUrl" json:"compliance_mirror_url,omitempty"`
	// The homepage for the package. This will eventually replace
	// `url { type: HOMEPAGE }`
	Homepage *string `protobuf:"bytes,14,opt,name=homepage" json:"homepage,omitempty"`
}

func (x *ThirdParty) Reset() {
	*x = ThirdParty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_project_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThirdParty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThirdParty) ProtoMessage() {}

func (x *ThirdParty) ProtoReflect() protoreflect.Message {
	mi := &file_project_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThirdParty.ProtoReflect.Descriptor instead.
func (*ThirdParty) Descriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *ThirdParty) GetUrl() []*URL {
	if x != nil {
		return x.Url
	}
	return nil
}

func (x *ThirdParty) GetVersion() string {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return ""
}

func (x *ThirdParty) GetLastUpgradeDate() *Date {
	if x != nil {
		return x.LastUpgradeDate
	}
	return nil
}

func (x *ThirdParty) GetLicenseType() LicenseType {
	if x != nil && x.LicenseType != nil {
		return *x.LicenseType
	}
	return LicenseType_BY_EXCEPTION_ONLY
}

func (x *ThirdParty) GetLocalModifications() string {
	if x != nil && x.LocalModifications != nil {
		return *x.LocalModifications
	}
	return ""
}

func (x *ThirdParty) GetComplianceMirrorUrl() string {
	if x != nil && x.ComplianceMirrorUrl != nil {
		return *x.ComplianceMirrorUrl
	}
	return ""
}

func (x *ThirdParty) GetHomepage() string {
	if x != nil && x.Homepage != nil {
		return *x.Homepage
	}
	return ""
}

// URL associated with a third-party package.
type URL struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of resource this URL identifies.
	Type *URL_Type `protobuf:"varint,1,opt,name=type,enum=project_metadata.URL_Type" json:"type,omitempty"`
	// The actual URL value.  URLs should be absolute and start with 'http://' or
	// 'https://' (or occasionally 'git://' or 'ftp://' where appropriate).
	Value *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (x *URL) Reset() {
	*x = URL{}
	if protoimpl.UnsafeEnabled {
		mi := &file_project_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *URL) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*URL) ProtoMessage() {}

func (x *URL) ProtoReflect() protoreflect.Message {
	mi := &file_project_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use URL.ProtoReflect.Descriptor instead.
func (*URL) Descriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *URL) GetType() URL_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return URL_HOMEPAGE
}

func (x *URL) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

// Represents a whole or partial calendar date, such as a birthday. The time of
// day and time zone are either specified elsewhere or are insignificant. The
// date is relative to the Gregorian Calendar. This can represent one of the
// following:
//
//   - A full date, with non-zero year, month, and day values.
//   - A month and day, with a zero year (for example, an anniversary).
//   - A year on its own, with a zero month and a zero day.
//   - A year and month, with a zero day (for example, a credit card expiration
//     date).
type Date struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Year of the date. Must be from 1 to 9999, or 0 to specify a date without
	// a year.
	Year *int32 `protobuf:"varint,1,opt,name=year" json:"year,omitempty"`
	// Month of a year. Must be from 1 to 12, or 0 to specify a year without a
	// month and day.
	Month *int32 `protobuf:"varint,2,opt,name=month" json:"month,omitempty"`
	// Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
	// to specify a year by itself or a year and month where the day isn't
	// significant.
	Day *int32 `protobuf:"varint,3,opt,name=day" json:"day,omitempty"`
}

func (x *Date) Reset() {
	*x = Date{}
	if protoimpl.UnsafeEnabled {
		mi := &file_project_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Date) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Date) ProtoMessage() {}

func (x *Date) ProtoReflect() protoreflect.Message {
	mi := &file_project_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Date.ProtoReflect.Descriptor instead.
func (*Date) Descriptor() ([]byte, []int) {
	return file_project_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *Date) GetYear() int32 {
	if x != nil && x.Year != nil {
		return *x.Year
	}
	return 0
}

func (x *Date) GetMonth() int32 {
	if x != nil && x.Month != nil {
		return *x.Month
	}
	return 0
}

func (x *Date) GetDay() int32 {
	if x != nil && x.Day != nil {
		return *x.Day
	}
	return 0
}

var File_project_metadata_proto protoreflect.FileDescriptor

var file_project_metadata_proto_rawDesc = []byte{
	0x0a, 0x16, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x7f, 0x0a, 0x08, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0b,
	0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x52,
	0x0a, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x22, 0xd6, 0x02, 0x0a, 0x0a,
	0x54, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x55, 0x52, 0x4c, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a,
	0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x44, 0x61, 0x74,
	0x65, 0x12, 0x40, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x6d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x69, 0x72, 0x72, 0x6f, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x6d, 0x65,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x6d, 0x65,
	0x70, 0x61, 0x67, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x03, 0x55, 0x52, 0x4c, 0x12, 0x2e, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x55, 0x52,
	0x4c, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0x6e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x48, 0x4f,
	0x4d, 0x45, 0x50, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x52, 0x43, 0x48,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x49, 0x54, 0x10, 0x03, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x56, 0x4e, 0x10, 0x07, 0x12, 0x06, 0x0a, 0x02, 0x48, 0x47, 0x10, 0x08, 0x12,
	0x09, 0x0a, 0x05, 0x44, 0x41, 0x52, 0x43, 0x53, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x49,
	0x50, 0x45, 0x52, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x0b,
	0x12, 0x10, 0x0a, 0x0c, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x10, 0x06, 0x22, 0x42, 0x0a, 0x04, 0x44, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x79, 0x65,
	0x61, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x79, 0x65, 0x61, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x03, 0x64, 0x61, 0x79, 0x2a, 0x97, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x59, 0x5f, 0x45, 0x58, 0x43,
	0x45, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x4e, 0x4f, 0x54, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x43,
	0x49, 0x50, 0x52, 0x4f, 0x43, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53,
	0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x49, 0x46, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49,
	0x43, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0e,
	0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x10,
	0x0a, 0x0c, 0x55, 0x4e, 0x45, 0x4e, 0x43, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x45, 0x44, 0x10, 0x07,
	0x42, 0x31, 0x5a, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x73, 0x6f, 0x6f, 0x6e,
	0x67, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f,
}

var (
	file_project_metadata_proto_rawDescOnce sync.Once
	file_project_metadata_proto_rawDescData = file_project_metadata_proto_rawDesc
)

func file_project_metadata_proto_rawDescGZIP() []byte {
	file_project_metadata_proto_rawDescOnce.Do(func() {
		file_project_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_project_metadata_proto_rawDescData)
	})
	return file_project_metadata_proto_rawDescData
}

var file_project_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_project_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_project_metadata_proto_goTypes = []interface{}{
	(LicenseType)(0),   // 0: project_metadata.LicenseType
	(URL_Type)(0),      // 1: project_metadata.URL.Type
	(*Metadata)(nil),   // 2: project_metadata.Metadata
	(*ThirdParty)(nil), // 3: project_metadata.ThirdParty
	(*URL)(nil),        // 4: project_metadata.URL
	(*Date)(nil),       // 5: project_metadata.Date
}
var file_project_metadata_proto_depIdxs = []int32{
	3, // 0: project_metadata.Metadata.third_party:type_name -> project_metadata.ThirdParty
	4, // 1: project_metadata.ThirdParty.url:type_name -> project_metadata.URL
	5, // 2: project_metadata.ThirdParty.last_upgrade_date:type_name -> project_metadata.Date
	0, // 3: project_metadata.ThirdParty.license_type:type_name -> project_metadata.LicenseType
	1, // 4: project_metadata.URL.type:type_name -> project_metadata.URL.Type
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_project_metadata_proto_init() }
func file_project_metadata_proto_init() {
	if File_project_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_project_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_project_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThirdParty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_project_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*URL); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_project_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Date); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_project_metadata_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_project_metadata_proto_goTypes,
		DependencyIndexes: file_project_metadata_proto_depIdxs,
		EnumInfos:         file_project_metadata_proto_enumTypes,
		MessageInfos:      file_project_metadata_proto_msgTypes,
	}.Build()
	File_project_metadata_proto = out.File
	file_project_metadata_proto_rawDesc = nil
	file_project_metadata_proto_goTypes = nil
	file_project_metadata_proto_depIdxs = nil
}
