// Copyright 2017 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cc

import (
	"android/soong/android"
)

type kernelHeadersDecorator struct {
	*libraryDecorator
}

func (stub *kernelHeadersDecorator) link(ctx ModuleContext, flags Flags, deps PathDeps, objs Objects) android.Path {
	if ctx.Device() {
		f := &stub.libraryDecorator.flagExporter
		for _, dir := range ctx.DeviceConfig().DeviceKernelHeaderDirs() {
			f.flags = append(f.flags, "-isystem "+dir)
		}
	}
	return stub.libraryDecorator.linkStatic(ctx, flags, deps, objs)
}

func kernelHeadersFactory() android.Module {
	module, library := NewLibrary(android.HostAndDeviceSupported)
	library.HeaderOnly()

	stub := &kernelHeadersDecorator{
		libraryDecorator: library,
	}

	module.linker = stub

	return module.Init()
}

func init() {
	android.RegisterModuleType("kernel_headers", kernelHeadersFactory)
}
