// Messages describing APK Set's table of contents (toc.pb entry).
// Please be advised that the ultimate source is at
// https://github.com/google/bundletool/tree/master/src/main/proto
// so you have been warned.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.9.1
// source: config.proto

package bundle_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BundleConfig_BundleType int32

const (
	BundleConfig_REGULAR    BundleConfig_BundleType = 0
	BundleConfig_APEX       BundleConfig_BundleType = 1
	BundleConfig_ASSET_ONLY BundleConfig_BundleType = 2
)

// Enum value maps for BundleConfig_BundleType.
var (
	BundleConfig_BundleType_name = map[int32]string{
		0: "REGULAR",
		1: "APEX",
		2: "ASSET_ONLY",
	}
	BundleConfig_BundleType_value = map[string]int32{
		"REGULAR":    0,
		"APEX":       1,
		"ASSET_ONLY": 2,
	}
)

func (x BundleConfig_BundleType) Enum() *BundleConfig_BundleType {
	p := new(BundleConfig_BundleType)
	*p = x
	return p
}

func (x BundleConfig_BundleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BundleConfig_BundleType) Descriptor() protoreflect.EnumDescriptor {
	return file_config_proto_enumTypes[0].Descriptor()
}

func (BundleConfig_BundleType) Type() protoreflect.EnumType {
	return &file_config_proto_enumTypes[0]
}

func (x BundleConfig_BundleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BundleConfig_BundleType.Descriptor instead.
func (BundleConfig_BundleType) EnumDescriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{0, 0}
}

type SplitDimension_Value int32

const (
	SplitDimension_UNSPECIFIED_VALUE          SplitDimension_Value = 0
	SplitDimension_ABI                        SplitDimension_Value = 1
	SplitDimension_SCREEN_DENSITY             SplitDimension_Value = 2
	SplitDimension_LANGUAGE                   SplitDimension_Value = 3
	SplitDimension_TEXTURE_COMPRESSION_FORMAT SplitDimension_Value = 4
	// BEGIN-INTERNAL
	SplitDimension_GRAPHICS_API SplitDimension_Value = 5 // END-INTERNAL
)

// Enum value maps for SplitDimension_Value.
var (
	SplitDimension_Value_name = map[int32]string{
		0: "UNSPECIFIED_VALUE",
		1: "ABI",
		2: "SCREEN_DENSITY",
		3: "LANGUAGE",
		4: "TEXTURE_COMPRESSION_FORMAT",
		5: "GRAPHICS_API",
	}
	SplitDimension_Value_value = map[string]int32{
		"UNSPECIFIED_VALUE":          0,
		"ABI":                        1,
		"SCREEN_DENSITY":             2,
		"LANGUAGE":                   3,
		"TEXTURE_COMPRESSION_FORMAT": 4,
		"GRAPHICS_API":               5,
	}
)

func (x SplitDimension_Value) Enum() *SplitDimension_Value {
	p := new(SplitDimension_Value)
	*p = x
	return p
}

func (x SplitDimension_Value) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SplitDimension_Value) Descriptor() protoreflect.EnumDescriptor {
	return file_config_proto_enumTypes[1].Descriptor()
}

func (SplitDimension_Value) Type() protoreflect.EnumType {
	return &file_config_proto_enumTypes[1]
}

func (x SplitDimension_Value) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SplitDimension_Value.Descriptor instead.
func (SplitDimension_Value) EnumDescriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{9, 0}
}

type BundleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Bundletool    *Bundletool    `protobuf:"bytes,1,opt,name=bundletool,proto3" json:"bundletool,omitempty"`
	Optimizations *Optimizations `protobuf:"bytes,2,opt,name=optimizations,proto3" json:"optimizations,omitempty"`
	Compression   *Compression   `protobuf:"bytes,3,opt,name=compression,proto3" json:"compression,omitempty"`
	// Resources to be always kept in the master split.
	MasterResources *MasterResources `protobuf:"bytes,4,opt,name=master_resources,json=masterResources,proto3" json:"master_resources,omitempty"`
	ApexConfig      *ApexConfig      `protobuf:"bytes,5,opt,name=apex_config,json=apexConfig,proto3" json:"apex_config,omitempty"`
	// APKs to be signed with the same key as generated APKs.
	UnsignedEmbeddedApkConfig []*UnsignedEmbeddedApkConfig `protobuf:"bytes,6,rep,name=unsigned_embedded_apk_config,json=unsignedEmbeddedApkConfig,proto3" json:"unsigned_embedded_apk_config,omitempty"`
	AssetModulesConfig        *AssetModulesConfig          `protobuf:"bytes,7,opt,name=asset_modules_config,json=assetModulesConfig,proto3" json:"asset_modules_config,omitempty"`
	Type                      BundleConfig_BundleType      `protobuf:"varint,8,opt,name=type,proto3,enum=android.bundle.BundleConfig_BundleType" json:"type,omitempty"`
}

func (x *BundleConfig) Reset() {
	*x = BundleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BundleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BundleConfig) ProtoMessage() {}

func (x *BundleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BundleConfig.ProtoReflect.Descriptor instead.
func (*BundleConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{0}
}

func (x *BundleConfig) GetBundletool() *Bundletool {
	if x != nil {
		return x.Bundletool
	}
	return nil
}

func (x *BundleConfig) GetOptimizations() *Optimizations {
	if x != nil {
		return x.Optimizations
	}
	return nil
}

func (x *BundleConfig) GetCompression() *Compression {
	if x != nil {
		return x.Compression
	}
	return nil
}

func (x *BundleConfig) GetMasterResources() *MasterResources {
	if x != nil {
		return x.MasterResources
	}
	return nil
}

func (x *BundleConfig) GetApexConfig() *ApexConfig {
	if x != nil {
		return x.ApexConfig
	}
	return nil
}

func (x *BundleConfig) GetUnsignedEmbeddedApkConfig() []*UnsignedEmbeddedApkConfig {
	if x != nil {
		return x.UnsignedEmbeddedApkConfig
	}
	return nil
}

func (x *BundleConfig) GetAssetModulesConfig() *AssetModulesConfig {
	if x != nil {
		return x.AssetModulesConfig
	}
	return nil
}

func (x *BundleConfig) GetType() BundleConfig_BundleType {
	if x != nil {
		return x.Type
	}
	return BundleConfig_REGULAR
}

type Bundletool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of BundleTool used to build the Bundle.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Bundletool) Reset() {
	*x = Bundletool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bundletool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bundletool) ProtoMessage() {}

func (x *Bundletool) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bundletool.ProtoReflect.Descriptor instead.
func (*Bundletool) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{1}
}

func (x *Bundletool) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type Compression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Glob matching the list of files to leave uncompressed in the APKs.
	// The matching is done against the path of files in the APK, thus excluding
	// the name of the modules, and using forward slash ("/") as a name separator.
	// Examples: "res/raw/**", "assets/**/*.uncompressed", etc.
	UncompressedGlob []string `protobuf:"bytes,1,rep,name=uncompressed_glob,json=uncompressedGlob,proto3" json:"uncompressed_glob,omitempty"`
}

func (x *Compression) Reset() {
	*x = Compression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Compression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Compression) ProtoMessage() {}

func (x *Compression) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Compression.ProtoReflect.Descriptor instead.
func (*Compression) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{2}
}

func (x *Compression) GetUncompressedGlob() []string {
	if x != nil {
		return x.UncompressedGlob
	}
	return nil
}

// Resources to keep in the master split.
type MasterResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource IDs to be kept in master split.
	ResourceIds []int32 `protobuf:"varint,1,rep,packed,name=resource_ids,json=resourceIds,proto3" json:"resource_ids,omitempty"`
	// Resource names to be kept in master split.
	ResourceNames []string `protobuf:"bytes,2,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
}

func (x *MasterResources) Reset() {
	*x = MasterResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterResources) ProtoMessage() {}

func (x *MasterResources) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterResources.ProtoReflect.Descriptor instead.
func (*MasterResources) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{3}
}

func (x *MasterResources) GetResourceIds() []int32 {
	if x != nil {
		return x.ResourceIds
	}
	return nil
}

func (x *MasterResources) GetResourceNames() []string {
	if x != nil {
		return x.ResourceNames
	}
	return nil
}

type Optimizations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SplitsConfig *SplitsConfig `protobuf:"bytes,1,opt,name=splits_config,json=splitsConfig,proto3" json:"splits_config,omitempty"`
	// This is for uncompressing native libraries on M+ devices (L+ devices on
	// instant apps).
	UncompressNativeLibraries *UncompressNativeLibraries `protobuf:"bytes,2,opt,name=uncompress_native_libraries,json=uncompressNativeLibraries,proto3" json:"uncompress_native_libraries,omitempty"`
	// This is for uncompressing dex files on P+ devices.
	UncompressDexFiles *UncompressDexFiles `protobuf:"bytes,3,opt,name=uncompress_dex_files,json=uncompressDexFiles,proto3" json:"uncompress_dex_files,omitempty"`
	// Configuration for the generation of standalone APKs.
	// If no StandaloneConfig is set, the configuration is inherited from
	// splits_config.
	StandaloneConfig *StandaloneConfig `protobuf:"bytes,4,opt,name=standalone_config,json=standaloneConfig,proto3" json:"standalone_config,omitempty"`
}

func (x *Optimizations) Reset() {
	*x = Optimizations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Optimizations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Optimizations) ProtoMessage() {}

func (x *Optimizations) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Optimizations.ProtoReflect.Descriptor instead.
func (*Optimizations) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{4}
}

func (x *Optimizations) GetSplitsConfig() *SplitsConfig {
	if x != nil {
		return x.SplitsConfig
	}
	return nil
}

func (x *Optimizations) GetUncompressNativeLibraries() *UncompressNativeLibraries {
	if x != nil {
		return x.UncompressNativeLibraries
	}
	return nil
}

func (x *Optimizations) GetUncompressDexFiles() *UncompressDexFiles {
	if x != nil {
		return x.UncompressDexFiles
	}
	return nil
}

func (x *Optimizations) GetStandaloneConfig() *StandaloneConfig {
	if x != nil {
		return x.StandaloneConfig
	}
	return nil
}

type UncompressNativeLibraries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *UncompressNativeLibraries) Reset() {
	*x = UncompressNativeLibraries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UncompressNativeLibraries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UncompressNativeLibraries) ProtoMessage() {}

func (x *UncompressNativeLibraries) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UncompressNativeLibraries.ProtoReflect.Descriptor instead.
func (*UncompressNativeLibraries) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{5}
}

func (x *UncompressNativeLibraries) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type UncompressDexFiles struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *UncompressDexFiles) Reset() {
	*x = UncompressDexFiles{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UncompressDexFiles) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UncompressDexFiles) ProtoMessage() {}

func (x *UncompressDexFiles) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UncompressDexFiles.ProtoReflect.Descriptor instead.
func (*UncompressDexFiles) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{6}
}

func (x *UncompressDexFiles) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Optimization configuration used to generate Split APKs.
type SplitsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SplitDimension []*SplitDimension `protobuf:"bytes,1,rep,name=split_dimension,json=splitDimension,proto3" json:"split_dimension,omitempty"`
}

func (x *SplitsConfig) Reset() {
	*x = SplitsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitsConfig) ProtoMessage() {}

func (x *SplitsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitsConfig.ProtoReflect.Descriptor instead.
func (*SplitsConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{7}
}

func (x *SplitsConfig) GetSplitDimension() []*SplitDimension {
	if x != nil {
		return x.SplitDimension
	}
	return nil
}

// Optimization configuration used to generate Standalone APKs.
type StandaloneConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device targeting dimensions to shard.
	SplitDimension []*SplitDimension `protobuf:"bytes,1,rep,name=split_dimension,json=splitDimension,proto3" json:"split_dimension,omitempty"`
	// Whether 64 bit libraries should be stripped from Standalone APKs.
	Strip_64BitLibraries bool `protobuf:"varint,2,opt,name=strip_64_bit_libraries,json=strip64BitLibraries,proto3" json:"strip_64_bit_libraries,omitempty"`
}

func (x *StandaloneConfig) Reset() {
	*x = StandaloneConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StandaloneConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandaloneConfig) ProtoMessage() {}

func (x *StandaloneConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandaloneConfig.ProtoReflect.Descriptor instead.
func (*StandaloneConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{8}
}

func (x *StandaloneConfig) GetSplitDimension() []*SplitDimension {
	if x != nil {
		return x.SplitDimension
	}
	return nil
}

func (x *StandaloneConfig) GetStrip_64BitLibraries() bool {
	if x != nil {
		return x.Strip_64BitLibraries
	}
	return false
}

type SplitDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value SplitDimension_Value `protobuf:"varint,1,opt,name=value,proto3,enum=android.bundle.SplitDimension_Value" json:"value,omitempty"`
	// If set to 'true', indicates that APKs should *not* be split by this
	// dimension.
	Negate bool `protobuf:"varint,2,opt,name=negate,proto3" json:"negate,omitempty"`
	// Optional transformation to be applied to asset directories where
	// the targeting is encoded in the directory name (e.g: assets/foo#tcf_etc1)
	SuffixStripping *SuffixStripping `protobuf:"bytes,3,opt,name=suffix_stripping,json=suffixStripping,proto3" json:"suffix_stripping,omitempty"`
}

func (x *SplitDimension) Reset() {
	*x = SplitDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitDimension) ProtoMessage() {}

func (x *SplitDimension) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitDimension.ProtoReflect.Descriptor instead.
func (*SplitDimension) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{9}
}

func (x *SplitDimension) GetValue() SplitDimension_Value {
	if x != nil {
		return x.Value
	}
	return SplitDimension_UNSPECIFIED_VALUE
}

func (x *SplitDimension) GetNegate() bool {
	if x != nil {
		return x.Negate
	}
	return false
}

func (x *SplitDimension) GetSuffixStripping() *SuffixStripping {
	if x != nil {
		return x.SuffixStripping
	}
	return nil
}

type SuffixStripping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to 'true', indicates that the targeting suffix should be removed
	// from assets paths for this dimension when splits (or asset slices) are
	// generated.
	// This only applies to assets.
	// For example a folder with path "assets/level1_textures#tcf_etc1"
	// would be outputted to "assets/level1_textures". File contents are
	// unchanged.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The default suffix to be used for the cases where separate slices can't
	// be generated for this dimension. In the case of standalone/universal APKs
	// generation, stripping the suffix can lead to file name collisions. This
	// default suffix defines the directories to retain. The others are
	// discarded: standalone/universal APKs will contain only directories
	// targeted at this value for the dimension.
	//
	// If not set or empty, the fallback directory in each directory group will be
	// used (for example, if both "assets/level1_textures#tcf_etc1" and
	// "assets/level1_textures" are present and the default suffix is empty,
	// then only "assets/level1_textures" will be used).
	DefaultSuffix string `protobuf:"bytes,2,opt,name=default_suffix,json=defaultSuffix,proto3" json:"default_suffix,omitempty"`
}

func (x *SuffixStripping) Reset() {
	*x = SuffixStripping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuffixStripping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuffixStripping) ProtoMessage() {}

func (x *SuffixStripping) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuffixStripping.ProtoReflect.Descriptor instead.
func (*SuffixStripping) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{10}
}

func (x *SuffixStripping) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SuffixStripping) GetDefaultSuffix() string {
	if x != nil {
		return x.DefaultSuffix
	}
	return ""
}

// Configuration for processing APEX bundles.
// https://source.android.com/devices/tech/ota/apex
type ApexConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for processing of APKs embedded in an APEX image.
	ApexEmbeddedApkConfig []*ApexEmbeddedApkConfig `protobuf:"bytes,1,rep,name=apex_embedded_apk_config,json=apexEmbeddedApkConfig,proto3" json:"apex_embedded_apk_config,omitempty"`
}

func (x *ApexConfig) Reset() {
	*x = ApexConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApexConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApexConfig) ProtoMessage() {}

func (x *ApexConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApexConfig.ProtoReflect.Descriptor instead.
func (*ApexConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{11}
}

func (x *ApexConfig) GetApexEmbeddedApkConfig() []*ApexEmbeddedApkConfig {
	if x != nil {
		return x.ApexEmbeddedApkConfig
	}
	return nil
}

type ApexEmbeddedApkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Android package name of the APK.
	PackageName string `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// Path to the APK within the APEX system image.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ApexEmbeddedApkConfig) Reset() {
	*x = ApexEmbeddedApkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApexEmbeddedApkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApexEmbeddedApkConfig) ProtoMessage() {}

func (x *ApexEmbeddedApkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApexEmbeddedApkConfig.ProtoReflect.Descriptor instead.
func (*ApexEmbeddedApkConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{12}
}

func (x *ApexEmbeddedApkConfig) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *ApexEmbeddedApkConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type UnsignedEmbeddedApkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the APK inside the module (e.g. if the path inside the bundle
	// is split/assets/example.apk, this will be assets/example.apk).
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *UnsignedEmbeddedApkConfig) Reset() {
	*x = UnsignedEmbeddedApkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnsignedEmbeddedApkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnsignedEmbeddedApkConfig) ProtoMessage() {}

func (x *UnsignedEmbeddedApkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnsignedEmbeddedApkConfig.ProtoReflect.Descriptor instead.
func (*UnsignedEmbeddedApkConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{13}
}

func (x *UnsignedEmbeddedApkConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type AssetModulesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// App versionCodes that will be updated with these asset modules.
	// Only relevant for asset-only bundles.
	AppVersion []int64 `protobuf:"varint,1,rep,packed,name=app_version,json=appVersion,proto3" json:"app_version,omitempty"`
	// Version tag for the asset upload.
	// Only relevant for asset-only bundles.
	AssetVersionTag string `protobuf:"bytes,2,opt,name=asset_version_tag,json=assetVersionTag,proto3" json:"asset_version_tag,omitempty"`
}

func (x *AssetModulesConfig) Reset() {
	*x = AssetModulesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_config_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetModulesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetModulesConfig) ProtoMessage() {}

func (x *AssetModulesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetModulesConfig.ProtoReflect.Descriptor instead.
func (*AssetModulesConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{14}
}

func (x *AssetModulesConfig) GetAppVersion() []int64 {
	if x != nil {
		return x.AppVersion
	}
	return nil
}

func (x *AssetModulesConfig) GetAssetVersionTag() string {
	if x != nil {
		return x.AssetVersionTag
	}
	return ""
}

var File_config_proto protoreflect.FileDescriptor

var file_config_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0x8b,
	0x05, 0x0a, 0x0c, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3a, 0x0a, 0x0a, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x52,
	0x0a, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x43, 0x0a, 0x0d, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x0d, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x3d, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x4a, 0x0a, 0x10, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x0f, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x61,
	0x70, 0x65, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x41, 0x70, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x61, 0x70,
	0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x1c, 0x75, 0x6e, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x70,
	0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e,
	0x55, 0x6e, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x41, 0x70, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x75, 0x6e, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x70, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x14, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x33, 0x0a, 0x0a, 0x42, 0x75, 0x6e, 0x64, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x47, 0x55, 0x4c, 0x41, 0x52,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x50, 0x45, 0x58, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a,
	0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x2c, 0x0a, 0x0a,
	0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0x3a, 0x0a, 0x0b, 0x43, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x75, 0x6e, 0x63,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x64, 0x47, 0x6c, 0x6f, 0x62, 0x22, 0x5b, 0x0a, 0x0f, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x22, 0xe2, 0x02, 0x0a, 0x0d, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x0d, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x70,
	0x6c, 0x69, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x1b, 0x75, 0x6e, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x55,
	0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x19, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x14, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x64, 0x65, 0x78, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x2e, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x78,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x12, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x44, 0x65, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x11, 0x73, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x6c, 0x6f, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x6c, 0x6f,
	0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x35, 0x0a, 0x19, 0x55, 0x6e, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x2e, 0x0a, 0x12, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x78,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x57, 0x0a, 0x0c, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x47, 0x0a, 0x0f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a,
	0x0f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x69, 0x70, 0x5f,
	0x36, 0x34, 0x5f, 0x62, 0x69, 0x74, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x74, 0x72, 0x69, 0x70, 0x36, 0x34, 0x42,
	0x69, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0xad, 0x02, 0x0a, 0x0e,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x12, 0x4a, 0x0a, 0x10, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x5f, 0x73, 0x74, 0x72,
	0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61,
	0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x53, 0x74, 0x72, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0f, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x53, 0x74, 0x72, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x22, 0x7b,
	0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x41, 0x42, 0x49, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x43, 0x52, 0x45, 0x45,
	0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4c,
	0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x45, 0x58,
	0x54, 0x55, 0x52, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x52, 0x41,
	0x50, 0x48, 0x49, 0x43, 0x53, 0x5f, 0x41, 0x50, 0x49, 0x10, 0x05, 0x22, 0x52, 0x0a, 0x0f, 0x53,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x53, 0x74, 0x72, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x22,
	0x6c, 0x0a, 0x0a, 0x41, 0x70, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a,
	0x18, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x61,
	0x70, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x2e, 0x41, 0x70, 0x65, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x70, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x61, 0x70, 0x65, 0x78, 0x45, 0x6d, 0x62, 0x65,
	0x64, 0x64, 0x65, 0x64, 0x41, 0x70, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4e, 0x0a,
	0x15, 0x41, 0x70, 0x65, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x70, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x2f, 0x0a,
	0x19, 0x55, 0x6e, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65,
	0x64, 0x41, 0x70, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x61,
	0x0a, 0x12, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61,
	0x67, 0x42, 0x41, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5a, 0x2b, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x2f, 0x73, 0x6f, 0x6f, 0x6e, 0x67, 0x2f, 0x63, 0x6d, 0x64, 0x2f, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x5f, 0x61, 0x70, 0x6b, 0x73, 0x2f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_config_proto_rawDescOnce sync.Once
	file_config_proto_rawDescData = file_config_proto_rawDesc
)

func file_config_proto_rawDescGZIP() []byte {
	file_config_proto_rawDescOnce.Do(func() {
		file_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_config_proto_rawDescData)
	})
	return file_config_proto_rawDescData
}

var file_config_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_config_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_config_proto_goTypes = []interface{}{
	(BundleConfig_BundleType)(0),      // 0: android.bundle.BundleConfig.BundleType
	(SplitDimension_Value)(0),         // 1: android.bundle.SplitDimension.Value
	(*BundleConfig)(nil),              // 2: android.bundle.BundleConfig
	(*Bundletool)(nil),                // 3: android.bundle.Bundletool
	(*Compression)(nil),               // 4: android.bundle.Compression
	(*MasterResources)(nil),           // 5: android.bundle.MasterResources
	(*Optimizations)(nil),             // 6: android.bundle.Optimizations
	(*UncompressNativeLibraries)(nil), // 7: android.bundle.UncompressNativeLibraries
	(*UncompressDexFiles)(nil),        // 8: android.bundle.UncompressDexFiles
	(*SplitsConfig)(nil),              // 9: android.bundle.SplitsConfig
	(*StandaloneConfig)(nil),          // 10: android.bundle.StandaloneConfig
	(*SplitDimension)(nil),            // 11: android.bundle.SplitDimension
	(*SuffixStripping)(nil),           // 12: android.bundle.SuffixStripping
	(*ApexConfig)(nil),                // 13: android.bundle.ApexConfig
	(*ApexEmbeddedApkConfig)(nil),     // 14: android.bundle.ApexEmbeddedApkConfig
	(*UnsignedEmbeddedApkConfig)(nil), // 15: android.bundle.UnsignedEmbeddedApkConfig
	(*AssetModulesConfig)(nil),        // 16: android.bundle.AssetModulesConfig
}
var file_config_proto_depIdxs = []int32{
	3,  // 0: android.bundle.BundleConfig.bundletool:type_name -> android.bundle.Bundletool
	6,  // 1: android.bundle.BundleConfig.optimizations:type_name -> android.bundle.Optimizations
	4,  // 2: android.bundle.BundleConfig.compression:type_name -> android.bundle.Compression
	5,  // 3: android.bundle.BundleConfig.master_resources:type_name -> android.bundle.MasterResources
	13, // 4: android.bundle.BundleConfig.apex_config:type_name -> android.bundle.ApexConfig
	15, // 5: android.bundle.BundleConfig.unsigned_embedded_apk_config:type_name -> android.bundle.UnsignedEmbeddedApkConfig
	16, // 6: android.bundle.BundleConfig.asset_modules_config:type_name -> android.bundle.AssetModulesConfig
	0,  // 7: android.bundle.BundleConfig.type:type_name -> android.bundle.BundleConfig.BundleType
	9,  // 8: android.bundle.Optimizations.splits_config:type_name -> android.bundle.SplitsConfig
	7,  // 9: android.bundle.Optimizations.uncompress_native_libraries:type_name -> android.bundle.UncompressNativeLibraries
	8,  // 10: android.bundle.Optimizations.uncompress_dex_files:type_name -> android.bundle.UncompressDexFiles
	10, // 11: android.bundle.Optimizations.standalone_config:type_name -> android.bundle.StandaloneConfig
	11, // 12: android.bundle.SplitsConfig.split_dimension:type_name -> android.bundle.SplitDimension
	11, // 13: android.bundle.StandaloneConfig.split_dimension:type_name -> android.bundle.SplitDimension
	1,  // 14: android.bundle.SplitDimension.value:type_name -> android.bundle.SplitDimension.Value
	12, // 15: android.bundle.SplitDimension.suffix_stripping:type_name -> android.bundle.SuffixStripping
	14, // 16: android.bundle.ApexConfig.apex_embedded_apk_config:type_name -> android.bundle.ApexEmbeddedApkConfig
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_config_proto_init() }
func file_config_proto_init() {
	if File_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BundleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bundletool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Compression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Optimizations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UncompressNativeLibraries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UncompressDexFiles); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StandaloneConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuffixStripping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApexConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApexEmbeddedApkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnsignedEmbeddedApkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_config_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetModulesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_config_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_config_proto_goTypes,
		DependencyIndexes: file_config_proto_depIdxs,
		EnumInfos:         file_config_proto_enumTypes,
		MessageInfos:      file_config_proto_msgTypes,
	}.Build()
	File_config_proto = out.File
	file_config_proto_rawDesc = nil
	file_config_proto_goTypes = nil
	file_config_proto_depIdxs = nil
}
